/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.alarms;

import de.desy.tine.server.alarms.TAlarm;
import de.desy.tine.server.alarms.TAlarmDefinition;
import de.desy.tine.server.equipment.TEquipmentModule;
import de.desy.tine.stringUtils.StringToBytes;
import de.desy.tine.structUtils.TStructBase;
import de.desy.tine.structUtils.TStructDescription;
import de.desy.tine.structUtils.TStructRegistry;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class TAlarmMessage5
extends TStructBase {
    public String deviceServer;
    public String deviceName;
    public String almTag;
    public int almCode;
    public int almTime;
    public int almMask;
    public byte[] almData = new byte[6];
    public byte almDataFormat;
    public byte almDataArraySize;
    public byte almSeverity;
    public byte almDescriptor;
    public short almSystem;
    public static final int sizeInBytes = 72;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(72);
    private static TStructDescription almStruct = null;

    private void pushByteArray(byte[] barray) {
        int i;
        for (i = 0; i < 6; ++i) {
            this.almData[i] = 0;
        }
        if (barray != null) {
            for (i = 0; i < barray.length; ++i) {
                this.almData[i] = barray[i];
            }
        }
    }

    public static void initStructDescription() {
        if (almStruct != null) {
            return;
        }
        almStruct = new TStructDescription("AMS");
        almStruct.beginDefinition();
        almStruct.addField((short)4, 16);
        almStruct.addField((short)4, 16);
        almStruct.addField((short)4, 16);
        almStruct.addField((short)3, 1);
        almStruct.addField((short)3, 1);
        almStruct.addField((short)3, 1);
        almStruct.addField((short)2, 6);
        almStruct.addField(4, (short)2, 1);
        almStruct.addField((short)1, 1);
        almStruct.setArraySize(100);
        almStruct.endDefinition();
        TStructRegistry.add(almStruct);
    }

    public TAlarmMessage5(TEquipmentModule eqm, String dev, TAlarm alm) {
        TAlarmMessage5.initStructDescription();
        this.deviceServer = eqm.getExportName();
        this.deviceName = dev == null ? "" : dev;
        TAlarmDefinition adef = alm.getAlmDef();
        if (adef != null) {
            this.almTag = adef.getAlarmTag();
            this.almMask = adef.getAlarmMask();
            this.almDataFormat = (byte)adef.getAlarmDataFormat();
            this.almDataArraySize = (byte)adef.getAlarmDataArraySize();
            this.almSeverity = (byte)adef.getAlarmSeverity();
            this.almSystem = (short)adef.getAlarmSystem();
        }
        this.almCode = alm.getCode();
        this.almTime = alm.getTimeStamp();
        this.pushByteArray(alm.getData());
        this.almDescriptor = alm.getDescriptor();
    }

    public void writeData(DataOutput dout) throws IOException {
        dout.write(StringToBytes.stringToFixedBytes(this.deviceServer, 16));
        dout.write(StringToBytes.stringToFixedBytes(this.deviceName, 16));
        dout.write(StringToBytes.stringToFixedBytes(this.almTag, 16));
        dout.writeInt(this.almCode);
        dout.writeInt(this.almTime);
        dout.writeInt(this.almMask);
        dout.write(this.almData);
        dout.writeByte(this.almDataFormat);
        dout.writeByte(this.almDataArraySize);
        dout.writeByte(this.almSeverity);
        dout.writeByte(this.almDescriptor);
        dout.writeShort(this.almSystem);
    }

    public void readData(DataInput din) throws IOException {
        this.deviceServer = StringToBytes.readFixedString(din, 16);
        this.deviceName = StringToBytes.readFixedString(din, 16);
        this.almTag = StringToBytes.readFixedString(din, 16);
        this.almCode = din.readInt();
        this.almTime = din.readInt();
        this.almMask = din.readInt();
        din.readFully(this.almData, 0, 6);
        this.almDataFormat = din.readByte();
        this.almDataArraySize = din.readByte();
        this.almSeverity = din.readByte();
        this.almDescriptor = din.readByte();
        this.almSystem = din.readShort();
    }
}

