/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.io;

import de.desy.tine.startup.TInitializer;
import de.desy.tine.startup.TInitializerFactory;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;

public class TPacket {
    private static final int defaultRcvBufSiz = 65536;
    private static final int defaultTtl = 16;
    public static final int MAX_DATAGRAM_SIZE = 64000;
    private TInitializer initializer = TInitializerFactory.getInstance().getInitializer();
    private MulticastSocket s;
    InetAddress hostAddress;
    private boolean isMCastListener = false;
    public DatagramPacket dpOut;
    byte[] bufIn = new byte[64000];
    public DatagramPacket dpIn = new DatagramPacket(this.bufIn, this.bufIn.length);

    public MulticastSocket getSocket() {
        return this.s;
    }

    public boolean isMulticastListener() {
        return this.isMCastListener;
    }

    public TPacket() {
        this(65536, 16);
    }

    public TPacket(int rcvBufferSize, int timeToLive) {
        boolean socketBound = false;
        int port = this.initializer.getClnPort();
        for (int i = 0; !socketBound && i < 1000; ++i) {
            try {
                InetSocketAddress addr = new InetSocketAddress(port + i);
                this.s = new MulticastSocket(null);
                this.s.setReuseAddress(false);
                this.s.bind(addr);
                this.s.setSoTimeout(0);
                this.s.setReceiveBufferSize(rcvBufferSize);
                this.s.setTimeToLive(timeToLive);
                socketBound = true;
                continue;
            }
            catch (SocketException e) {
                if (i != 999) continue;
                System.err.println("Can't open socket");
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public TPacket(int port) {
        this(port, 65536, 16);
    }

    public TPacket(int port, int rcvBufferSize, int timeToLive) {
        int clnport = this.initializer.getClnPort();
        boolean useNextPort = false;
        boolean socketBound = false;
        for (int i = 0; !socketBound && i < 1000; ++i) {
            try {
                InetAddress grp;
                InetSocketAddress addr;
                if (port == 0) {
                    useNextPort = true;
                    addr = new InetSocketAddress(clnport + i);
                    this.s = new MulticastSocket(null);
                    this.s.setReuseAddress(false);
                    this.s.bind(addr);
                    this.s.setSoTimeout(0);
                    this.s.setReceiveBufferSize(rcvBufferSize);
                    this.s.setTimeToLive(timeToLive);
                    socketBound = true;
                    continue;
                }
                if (port == this.initializer.getGCastPort()) {
                    grp = InetAddress.getByName(this.initializer.getGCastAddress());
                    this.s = new MulticastSocket(port);
                    this.s.joinGroup(grp);
                    this.s.setSoTimeout(0);
                    this.s.setTimeToLive(timeToLive);
                    socketBound = true;
                    this.isMCastListener = true;
                    continue;
                }
                if (port == this.initializer.getMCastPort()) {
                    grp = InetAddress.getByName(this.initializer.getMCastAddress());
                    this.s = new MulticastSocket(port);
                    this.s.joinGroup(grp);
                    this.s.setSoTimeout(0);
                    this.s.setReceiveBufferSize(rcvBufferSize);
                    this.s.setTimeToLive(timeToLive);
                    socketBound = true;
                    this.isMCastListener = true;
                    continue;
                }
                if (port == this.initializer.getNetCastPort()) {
                    grp = InetAddress.getByName(this.initializer.getNetCastAddress());
                    this.s = new MulticastSocket(port);
                    this.s.joinGroup(grp);
                    this.s.setSoTimeout(0);
                    this.s.setReceiveBufferSize(rcvBufferSize);
                    socketBound = true;
                    this.isMCastListener = true;
                    continue;
                }
                addr = new InetSocketAddress(port);
                this.s = new MulticastSocket(null);
                this.s.setReuseAddress(false);
                this.s.bind(addr);
                this.s.setSoTimeout(0);
                this.s.setReceiveBufferSize(rcvBufferSize);
                this.s.setTimeToLive(timeToLive);
                socketBound = true;
                continue;
            }
            catch (Exception e) {
                if (useNextPort) continue;
                System.err.println("Can't open socket");
                e.printStackTrace();
            }
        }
    }
}

