/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.io;

import de.desy.tine.endianUtils.SwapUtil;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TDataOutputStream
extends FilterOutputStream
implements DataOutput {
    private DataOutputStream stream = null;

    public TDataOutputStream(OutputStream out) {
        super(out);
        this.stream = new DataOutputStream(out);
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    public int size() {
        return this.stream.size();
    }

    public String toString() {
        return this.stream.toString();
    }

    public void write(byte[] b) throws IOException {
        this.stream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.stream.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.stream.write(b);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.stream.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.stream.writeByte(v);
    }

    public void writeBytes(String s) throws IOException {
        this.stream.writeBytes(s);
    }

    public void writeChar(int v) throws IOException {
        this.stream.writeChar(SwapUtil.swapShort((short)v));
    }

    public void writeChars(String s) throws IOException {
        this.stream.writeChars(s);
    }

    public void writeDouble(double v) throws IOException {
        this.stream.writeLong(SwapUtil.swapLong(Double.doubleToLongBits(v)));
    }

    public void writeFloat(float v) throws IOException {
        this.stream.writeInt(SwapUtil.swapInt(Float.floatToIntBits(v)));
    }

    public void writeInt(int v) throws IOException {
        this.stream.writeInt(SwapUtil.swapInt(v));
    }

    public void writeLong(long v) throws IOException {
        this.stream.writeLong(SwapUtil.swapLong(v));
    }

    public void writeShort(int v) throws IOException {
        this.stream.writeShort(SwapUtil.swapShort((short)v));
    }

    public void writeUTF(String str) throws IOException {
        this.stream.writeUTF(str);
    }
}

