/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.headers;

import de.desy.tine.client.TLink;
import de.desy.tine.definitions.TFormat;
import de.desy.tine.definitions.TMode;
import de.desy.tine.endianUtils.Swap;
import de.desy.tine.headers.TContract;
import de.desy.tine.headers.TContractP5;
import de.desy.tine.types.SPECTRUM;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public final class TSubscription {
    public short msgSizeInBytes;
    public short extSizeInBytes;
    public short mtu;
    public short numblks;
    public short blknum;
    public short id;
    public short mode;
    public short blkid;
    public int pollingRate;
    public int starttime;
    public TContract contract;
    public long linkStartTime;
    public long linkLastTime;
    public int dataSizeInBytes = 0;
    public int nextDataSizeInBytes = 0;
    public static final int hdrSizeInBytes = 24;
    public static final int hdrSizeInBytesLegacy = 20;
    private static short ensLinkId = 0;
    public boolean isLegacy = false;
    TLink link;
    Date date = new Date();

    public void resetCounters() {
        this.blknum = 1;
        this.nextDataSizeInBytes = this.dataSizeInBytes > this.mtu ? this.mtu : this.dataSizeInBytes % this.mtu;
    }

    public byte[] toByteArray() {
        try {
            short m = (short)(this.mode & 0xFFF);
            int hdrSize = this.isLegacy ? 20 : 24;
            int conSize = this.isLegacy ? 84 : 180;
            this.msgSizeInBytes = (short)(hdrSize + conSize);
            ByteArrayOutputStream db = new ByteArrayOutputStream(this.msgSizeInBytes);
            short payloadSizeInBytes = 0;
            if (this.link.dInput.blknum == this.link.dInput.numblks) {
                payloadSizeInBytes = (short)(this.dataSizeInBytes % this.mtu);
                this.link.dInput.blkid = this.link.dInput.blkid++ % 1000;
            } else {
                payloadSizeInBytes = this.mtu;
                ++this.link.dInput.blknum;
            }
            this.msgSizeInBytes = (short)(this.msgSizeInBytes + payloadSizeInBytes);
            DataOutputStream ds = new DataOutputStream(db);
            ds.writeShort(Swap.Short(this.msgSizeInBytes));
            if (!this.isLegacy) {
                ds.writeShort(Swap.Short(this.extSizeInBytes));
                ds.writeShort(Swap.Short(this.mtu));
                ds.writeShort(Swap.Short(this.numblks));
                ds.writeShort(Swap.Short(this.blknum));
                ds.writeShort(Swap.Short(this.id));
                ds.writeShort(Swap.Short(m));
                ds.writeShort(Swap.Short(this.blkid));
                ds.writeInt(Swap.Long(this.pollingRate));
                ds.writeInt(Swap.Long(this.starttime));
            } else {
                ds.writeShort(Swap.Short(this.mtu));
                ds.writeByte(this.numblks);
                ds.writeByte(this.blknum);
                ds.writeShort(Swap.Short(this.id));
                ds.writeShort(Swap.Short(m));
                ds.writeShort(Swap.Short(this.blkid));
                ds.writeInt(Swap.Long(this.pollingRate));
                ds.writeInt(Swap.Long(this.starttime));
            }
            ds.close();
            this.nextDataSizeInBytes = payloadSizeInBytes;
            this.blknum = (byte)this.link.dInput.blknum;
            return db.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public TSubscription(TContract c, TLink lnk) {
        if (c == null || lnk == null) {
            return;
        }
        this.contract = c;
        this.link = lnk;
        this.isLegacy = lnk.getTineProtocol() < 6;
        int hdrSize = this.isLegacy ? 20 : 24;
        int conSize = this.isLegacy ? 84 : 180;
        this.mtu = (short)lnk.dInput.mtu;
        this.numblks = (short)lnk.dInput.numblks;
        this.blknum = (short)lnk.dInput.blknum;
        this.extSizeInBytes = this.blknum == 1 ? (short)c.extStringSize : (short)0;
        int padding = this.extSizeInBytes % 2;
        this.msgSizeInBytes = (short)(hdrSize + conSize + this.extSizeInBytes + padding);
        this.id = (short)lnk.linkId;
        this.mode = (short)4;
        this.dataSizeInBytes = lnk.dInput.getSizeInBytes();
        this.nextDataSizeInBytes = this.blknum == this.numblks ? this.dataSizeInBytes : (int)this.mtu;
        this.blkid = (short)lnk.dInput.blkid;
        this.pollingRate = lnk.devTimeout;
        this.linkLastTime = this.linkStartTime = this.date.getTime();
        this.starttime = (int)(this.linkStartTime / 1000L);
        if (this.id == 0 && lnk.expName.startsWith("ENS")) {
            this.starttime = 4096;
            this.id = ensLinkId = (short)((ensLinkId + 1) % 10000);
        }
        if (this.isLegacy) {
            this.contract.setLegacy(lnk);
        }
    }

    public TSubscription(int protocol, byte[] data, int off, int len) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(data, off, len);
            DataInputStream ds = new DataInputStream(is);
            this.msgSizeInBytes = Swap.Short(ds.readShort());
            if (protocol < 6) {
                this.mtu = Swap.Short(ds.readShort());
                this.numblks = ds.readByte();
                this.blknum = ds.readByte();
                this.id = Swap.Short(ds.readShort());
                this.mode = Swap.Short(ds.readShort());
                this.blkid = Swap.Short(ds.readShort());
                this.pollingRate = Swap.Long(ds.readInt());
                this.starttime = Swap.Long(ds.readInt());
                this.extSizeInBytes = 0;
                this.contract = new TContract(new TContractP5(data, off + 20, 84));
            } else {
                this.extSizeInBytes = Swap.Short(ds.readShort());
                this.mtu = Swap.Short(ds.readShort());
                this.numblks = Swap.Short(ds.readShort());
                this.blknum = Swap.Short(ds.readShort());
                this.id = Swap.Short(ds.readShort());
                this.mode = Swap.Short(ds.readShort());
                this.blkid = Swap.Short(ds.readShort());
                this.pollingRate = Swap.Long(ds.readInt());
                this.starttime = Swap.Long(ds.readInt());
                this.contract = new TContract(data, off += 24, 180);
                if (this.extSizeInBytes > 0) {
                    this.contract.setExtendedStringSpace(data, off += 180, this.extSizeInBytes);
                }
            }
            ds.close();
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getInputDataSize() {
        int fmtsiz = 0;
        fmtsiz = TFormat.formatSizeOf(this.contract.dataFormatIn);
        if (fmtsiz > 0) {
            int datasize = fmtsiz * this.contract.dataSizeIn;
            if (datasize > this.mtu) {
                datasize = this.blknum < this.numblks ? this.mtu : datasize % this.mtu;
            }
            return datasize;
        }
        return 0;
    }

    public int getOutputDataSize() {
        int fmtsiz = 0;
        fmtsiz = TFormat.formatSizeOf(this.contract.dataFormatOut);
        if (fmtsiz > 0) {
            int datasize = fmtsiz * this.contract.dataSizeOut;
            if (this.contract.dataFormatOut == 28) {
                datasize += SPECTRUM.hdrSizeInBytes;
            }
            return datasize;
        }
        return 0;
    }

    public String toString() {
        String msg = new String("msg size = " + this.msgSizeInBytes);
        msg = msg.concat("\next size : " + this.extSizeInBytes);
        msg = msg.concat("\nmtu : " + this.mtu);
        msg = msg.concat("\nnumblks : " + this.numblks);
        msg = msg.concat("\nblknum : " + this.blknum);
        msg = msg.concat("\nid : " + this.id);
        msg = msg.concat("\nmode : " + TMode.toString(this.mode));
        msg = msg.concat("\nblkid : " + this.blkid);
        msg = msg.concat("\npollingRate : " + this.pollingRate + " ms");
        msg = msg.concat("\nstarttime : " + this.starttime);
        msg = msg.concat("\n" + this.contract.toString());
        return msg;
    }
}

