/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.definitions;

import de.desy.tine.server.logger.TFecLog;

public final class TStrings {
    public static final int STATUS_SHORTSIZE = 32;
    public static final int STATUS_SIZE = 192;
    public static final int FEC_NAME_SIZE = 16;
    public static final int FEC_DESC_SIZE = 64;
    public static final int FEC_LOCATION_SIZE = 48;
    public static final int FEC_VERSION_SIZE = 16;
    public static final int FEC_HDW_SIZE = 32;
    public static final int FEC_RESP_SIZE = 32;
    public static final int FEC_OS_SIZE = 16;
    public static final int EXPORT_NAME_SHORTSIZE = 16;
    public static final int EXPORT_NAME_SIZE = 32;
    public static final int PROPERTY_NAME_SIZE = 64;
    public static final int PROPERTY_NAME_SHORTSIZE = 32;
    public static final int PROPERTY_DESC_SIZE = 64;
    public static final int PROPERTY_REDIR_SIZE = 192;
    public static final int DEVICE_NAME_SIZE = 64;
    public static final int DEVICE_NAME_SHORTSIZE = 16;
    public static final int DEVICE_NAME_MAXSIZE = 1024;
    public static final int DEVICE_REDIR_SIZE = 192;
    public static final int EQM_NAME_SIZE = 8;
    public static final int EQM_NAME_SHORTSIZE = 6;
    public static final int TAG_NAME_SIZE = 16;
    public static final int TAG_NAME_SHORTSIZE = 8;
    public static final int CONTEXT_NAME_SHORTSIZE = 16;
    public static final int CONTEXT_NAME_SIZE = 32;
    public static final int SUBSYSTEM_NAME_SIZE = 16;
    public static final int SUBSYSTEM_NAME_SHORTSIZE = 5;
    public static final int SET_NAME_SIZE = 32;
    public static final int FORMAT_STR_SIZE = 64;
    public static final int ACCESS_STR_SIZE = 16;
    public static final int ADDR_SIZE = 16;
    public static final int UNITS_SIZE = 16;
    public static final int USERNAME_SIZE = 16;
    public static final int FIELD_NAME_SIZE = 16;
    public static final int HISTORY_HOME_SIZE = 128;
    public static final int FULL_NAME_MAXSIZE = 1152;
    public static final int ALARM_DATA_SHORTSIZE = 6;
    public static final int ALARM_DATA_SIZE = 64;
    public static final int ALARM_TAG_SIZE = 32;
    public static final int ALARM_TAG_SHORTSIZE = 16;
    public static final int ALARM_TEXT_SIZE = 64;
    public static final int ALARM_TEXT_SHORTSIZE = 40;
    public static final int ALARM_TEXT_LONGSIZE = 128;
    public static final int KEYWORD_NAME_SIZE = 64;
    public static final int KEYWORD_NAME_SHORTSIZE = 16;
    private static final String STRICTLY_ILLEGALCHARS = "[^\"*&]+";
    private static final String RUDECHARS = "[^\\\\/\n\t ]+";
    private static final String ALPHANUM = "[a-zA-Z0-9]+";

    public static void validateName(String name, int nameLen) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name has zero length");
        }
        if (!name.matches(STRICTLY_ILLEGALCHARS)) {
            throw new IllegalArgumentException("name \"" + name + "\" contains illegal characters");
        }
        if (name.length() > nameLen) {
            throw new IllegalArgumentException("length of name " + name + " (len: " + name.length() + ") exceeds limit " + nameLen);
        }
    }

    public static void validateDeviceName(String deviceName) {
        if (deviceName != null && deviceName.length() == 0) {
            return;
        }
        TStrings.validateName(deviceName, 64);
    }

    public static void validatePropertyName(String propertyName) {
        TStrings.validateName(propertyName, 64);
        if (!propertyName.matches(RUDECHARS)) {
            throw new IllegalArgumentException("property name \"" + propertyName + "\" contains illegal characters");
        }
    }

    public static void validateExportName(String exportName) {
        TStrings.validateName(exportName, 32);
        if (!exportName.matches(RUDECHARS)) {
            throw new IllegalArgumentException("export name \"" + exportName + "\" contains illegal characters");
        }
    }

    public static void validateContextName(String contextName) {
        TStrings.validateName(contextName, 32);
        if (!contextName.matches(RUDECHARS)) {
            throw new IllegalArgumentException("context name \"" + contextName + "\" contains illegal characters");
        }
    }

    public static void validateLocalName(String eqmName) {
        TStrings.validateName(eqmName, 6);
    }

    public static void validateTagName(String tagName) {
        TStrings.validateName(tagName, 16);
    }

    public static void validateSubSystemName(String subsystemName) {
        if (subsystemName == null || subsystemName.length() == 0) {
            TFecLog.log("Subsystem name not supplied (TEST?)!");
            return;
        }
        TStrings.validateName(subsystemName, 16);
        if (!subsystemName.matches(ALPHANUM)) {
            throw new IllegalArgumentException("subsystem name \"" + subsystemName + "\" contains illegal characters");
        }
    }

    public static void validateFecName(String fecName) {
        TStrings.validateName(fecName, 16);
        if (!fecName.matches(ALPHANUM)) {
            throw new IllegalArgumentException("fec name \"" + fecName + "\" contains illegal characters");
        }
    }
}

