/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.definitions;

import de.desy.tine.bitfieldUtils.TBitfield;
import de.desy.tine.definitions.TArrayType;
import de.desy.tine.structUtils.TStructRegistry;
import de.desy.tine.types.ADDRESS;
import de.desy.tine.types.DBLDBL;
import de.desy.tine.types.DBLDBLDBL;
import de.desy.tine.types.FILTER;
import de.desy.tine.types.FLTFLTINT;
import de.desy.tine.types.FLTINT;
import de.desy.tine.types.FLTINTINT;
import de.desy.tine.types.IMAGE;
import de.desy.tine.types.INTFLTINT;
import de.desy.tine.types.INTINT;
import de.desy.tine.types.INTINTFLTFLT;
import de.desy.tine.types.INTINTINT;
import de.desy.tine.types.INTINTINTINT;
import de.desy.tine.types.NAME16;
import de.desy.tine.types.NAME16DBLDBL;
import de.desy.tine.types.NAME16FI;
import de.desy.tine.types.NAME16I;
import de.desy.tine.types.NAME16II;
import de.desy.tine.types.NAME32;
import de.desy.tine.types.NAME32DBLDBL;
import de.desy.tine.types.NAME32I;
import de.desy.tine.types.NAME48I;
import de.desy.tine.types.NAME64;
import de.desy.tine.types.NAME64DBL;
import de.desy.tine.types.NAME64DBLDBL;
import de.desy.tine.types.NAME64DBLDBLDBL;
import de.desy.tine.types.NAME64I;
import de.desy.tine.types.NAME8;
import de.desy.tine.types.POINT;
import de.desy.tine.types.SPECTRUM;
import de.desy.tine.types.TCompoundDataObject;
import de.desy.tine.types.UNAME;
import de.desy.tine.types.USTRING;

public final class TFormat {
    public static final short CF_DOUBLE = 0;
    public static final short CF_INT16 = 1;
    public static final short CF_SHORT = 1;
    public static final short CF_BYTE = 2;
    public static final short CF_INT8 = 2;
    public static final short CF_INT32 = 3;
    public static final short CF_LONG = 3;
    public static final short CF_TEXT = 4;
    public static final short CF_CHAR = 4;
    public static final short CF_FLOAT = 5;
    public static final short CF_INT64 = 6;
    public static final short CF_DLONG = 6;
    public static final short CF_STRUCT = 7;
    public static final short CF_NAME8 = 8;
    public static final short CF_NAME16 = 9;
    public static final short CF_NAME16FI = 10;
    public static final short CF_NAMEFI = 10;
    public static final short CF_BIT = 11;
    public static final short CF_HITTS = 12;
    public static final short CF_NAME32 = 13;
    public static final short CF_FLTINT = 14;
    public static final short CF_LNGINT = 15;
    public static final short CF_INTINT = 15;
    public static final short CF_DBLINT = 16;
    public static final short CF_SHTINT = 17;
    public static final short CF_INTFLTINT = 18;
    public static final short CF_TDS = 18;
    public static final short CF_NAME48 = 19;
    public static final short CF_NAME8I = 20;
    public static final short CF_NAME16I = 21;
    public static final short CF_NAME32I = 22;
    public static final short CF_NAME48I = 23;
    public static final short CF_USTRING = 24;
    public static final short CF_FLTFLTINT = 25;
    public static final short CF_XYS = 25;
    public static final short CF_FLTINTINT = 26;
    public static final short CF_FIS = 26;
    public static final short CF_FILTER = 27;
    public static final short CF_INTFLTFLTFLT = 27;
    public static final short CF_IFFF = 27;
    public static final short CF_SPECTRUM = 28;
    public static final short CF_ADDRESS = 29;
    public static final short CF_IIII = 29;
    public static final short CF_INTINTINTINT = 29;
    public static final short CF_WINDOW = 30;
    public static final short CF_TTII = 30;
    public static final short CF_POINT = 31;
    public static final short CF_FF = 31;
    public static final short CF_XY = 31;
    public static final short CF_FLTFLT = 31;
    public static final short CF_TDSI = 32;
    public static final short CF_INTFLTSHTSHT = 32;
    public static final short CF_BOOLEAN = 33;
    public static final short CF_IIFF = 34;
    public static final short CF_INTINTFLTFLT = 34;
    public static final short CF_FWINDOW = 34;
    public static final short CF_FIFI = 35;
    public static final short CF_FLTINTFLTINT = 35;
    public static final short CF_NAME64 = 36;
    public static final short CF_NAME64I = 37;
    public static final short CF_INTDBL = 38;
    public static final short CF_FLTDBL = 39;
    public static final short CF_DBLDBL = 40;
    public static final short CF_NAMEDBLDBL = 41;
    public static final short CF_NAME16DBLDBL = 41;
    public static final short CF_NAME16DD = 41;
    public static final short CF_NAMEII = 42;
    public static final short CF_NAME16II = 42;
    public static final short CF_III = 43;
    public static final short CF_INTINTINT = 43;
    public static final short CF_NAME32DBLDBL = 44;
    public static final short CF_NAME64DBLDBL = 45;
    public static final short CF_UNAME = 46;
    public static final short CF_IFFFNAME = 46;
    public static final short CF_XML = 47;
    public static final short CF_DBLDBLDBL = 48;
    public static final short CF_NAME64DBLDBLDBL = 49;
    public static final short CF_CHAR64DBLDBLDBL = 49;
    public static final short CF_STRING64DBLDBLDBL = 49;
    public static final short CF_BITFIELD8 = 50;
    public static final short CF_BITFIELD16 = 51;
    public static final short CF_BITFIELD32 = 52;
    public static final short CF_BITFIELD64 = 53;
    public static final short CF_NAME64DBL = 54;
    public static final short CF_CHAR64DBL = 54;
    public static final short CF_STRING64DBL = 54;
    public static final short CF_IMAGE = 55;
    public static final short CF_HISTORY = 56;
    public static final short CF_STRING = 57;
    public static final short CF_DEFAULT = 254;
    public static final short CF_NULL = 255;
    public static final String[] availableFormats = new String[]{"NULL", "BYTE", "BOOLEAN", "SHORT", "LONG", "DLONG", "FLOAT", "DOUBLE", "BITFIELD8", "BITFIELD16", "BITFIELD32", "BITFIELD64", "STRUCT", "TEXT", "XML", "NAME8", "NAME16", "NAME32", "NAME48", "NAME64", "INTINT", "FLTINT", "DBLDBL", "NAME8I", "NAME16I", "NAME32I", "NAME48I", "NAME64I", "NAME64DBL", "INTFLTINT", "INTINTINT", "USTRING", "UNAME", "DBLDBLDBL", "SPECTRUM", "WINDOW", "FWINDOW", "ADDRESS", "NAME16FI", "NAME16II", "NAME16DBLDBL", "NAME32DBLDBL", "NAME64DBLDBL", "NAME64DBLDBLDBL", "FILTER", "FLTFLTINT", "IMAGE", "HISTORY", "STRING"};
    private static final int IMAGE_HDR_SIZE = 188;
    private static final int SPECTRUM_HDR_SIZE = 96;
    private static final int HISTORY_HDR_SIZE = 16;
    private static final int IMAGE_STD_FRAMESIZE = 500000;
    private static final int SPECTRUM_STD_SIZE = 4096;
    public static final int STRING_STD_CAPACITY = 128;
    private short value;

    public static boolean isSimpleFormat(short dataFormat) {
        if (dataFormat <= 9) {
            return true;
        }
        if (dataFormat == 13) {
            return true;
        }
        if (dataFormat == 19) {
            return true;
        }
        if (dataFormat == 36) {
            return true;
        }
        if (dataFormat == 11) {
            return true;
        }
        if (dataFormat == 33) {
            return true;
        }
        return dataFormat == 47;
    }

    public static boolean isName(short dataFormat) {
        switch (dataFormat) {
            case 8: 
            case 9: 
            case 13: 
            case 19: 
            case 36: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBitfield(short dataFormat) {
        switch (dataFormat) {
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStructFormat(short dataFormat) {
        return dataFormat == 7;
    }

    public static boolean isTaggedStruct(short dataFormat, String dataTag) {
        if (dataFormat != 7) {
            return false;
        }
        return TStructRegistry.contains(dataTag);
    }

    public static boolean isCompoundFormat(short dataFormat) {
        if (dataFormat <= 7) {
            return false;
        }
        if (dataFormat == 11) {
            return false;
        }
        if (dataFormat == 33) {
            return false;
        }
        if (dataFormat == 47) {
            return false;
        }
        return dataFormat != 57;
    }

    public static TCompoundDataObject[] makeCompoundDataObjectArray(short dataFormat, String dataTag, int arrayLength) {
        switch (dataFormat) {
            case 8: {
                TCompoundDataObject[] tco = new NAME8[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new NAME8();
                }
                return tco;
            }
            case 9: {
                TCompoundDataObject[] tco = new NAME16[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new NAME16();
                }
                return tco;
            }
            case 10: {
                TCompoundDataObject[] tco = new NAME16FI[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new NAME16FI();
                }
                return tco;
            }
            case 13: {
                TCompoundDataObject[] tco = new NAME32[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new NAME32();
                }
                return tco;
            }
            case 14: {
                TCompoundDataObject[] tco = new FLTINT[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new FLTINT();
                }
                return tco;
            }
            case 15: {
                TCompoundDataObject[] tco = new INTINT[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new INTINT();
                }
                return tco;
            }
            case 18: {
                TCompoundDataObject[] tco = new INTFLTINT[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new INTFLTINT();
                }
                return tco;
            }
            case 19: {
                TCompoundDataObject[] tco = new NAME8[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new NAME8();
                }
                return tco;
            }
            case 21: {
                TCompoundDataObject[] tco = new NAME16I[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new NAME16I();
                }
                return tco;
            }
            case 22: {
                TCompoundDataObject[] tco = new NAME32I[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new NAME32I();
                }
                return tco;
            }
            case 23: {
                TCompoundDataObject[] tco = new NAME48I[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new NAME48I();
                }
                return tco;
            }
            case 24: {
                TCompoundDataObject[] tco = new USTRING[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new USTRING();
                }
                return tco;
            }
            case 25: {
                TCompoundDataObject[] tco = new FLTFLTINT[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new FLTFLTINT();
                }
                return tco;
            }
            case 26: {
                TCompoundDataObject[] tco = new FLTINTINT[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new FLTINTINT();
                }
                return tco;
            }
            case 27: {
                TCompoundDataObject[] tco = new FILTER[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new FILTER();
                }
                return tco;
            }
            case 28: {
                TCompoundDataObject[] tco = new SPECTRUM[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new SPECTRUM();
                }
                return tco;
            }
            case 29: {
                TCompoundDataObject[] tco = new ADDRESS[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new ADDRESS();
                }
                return tco;
            }
            case 30: {
                TCompoundDataObject[] tco = new INTINTINTINT[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new INTINTINTINT();
                }
                return tco;
            }
            case 31: {
                TCompoundDataObject[] tco = new POINT[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new POINT();
                }
                return tco;
            }
            case 34: {
                TCompoundDataObject[] tco = new INTINTFLTFLT[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new INTINTFLTFLT();
                }
                return tco;
            }
            case 36: {
                TCompoundDataObject[] tco = new NAME64[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new NAME64();
                }
                return tco;
            }
            case 37: {
                TCompoundDataObject[] tco = new NAME64I[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new NAME64I();
                }
                return tco;
            }
            case 40: {
                TCompoundDataObject[] tco = new DBLDBL[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new DBLDBL();
                }
                return tco;
            }
            case 41: {
                TCompoundDataObject[] tco = new NAME16DBLDBL[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new NAME16DBLDBL();
                }
                return tco;
            }
            case 42: {
                TCompoundDataObject[] tco = new NAME16II[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new NAME16II();
                }
                return tco;
            }
            case 43: {
                TCompoundDataObject[] tco = new INTINTINT[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new INTINTINT();
                }
                return tco;
            }
            case 44: {
                TCompoundDataObject[] tco = new NAME32DBLDBL[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new NAME32DBLDBL();
                }
                return tco;
            }
            case 45: {
                TCompoundDataObject[] tco = new NAME64DBLDBL[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new NAME64DBLDBL();
                }
                return tco;
            }
            case 46: {
                TCompoundDataObject[] tco = new UNAME[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new UNAME();
                }
                return tco;
            }
            case 48: {
                TCompoundDataObject[] tco = new DBLDBLDBL[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new DBLDBLDBL();
                }
                return tco;
            }
            case 49: {
                TCompoundDataObject[] tco = new NAME64DBLDBLDBL[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new NAME64DBLDBLDBL();
                }
                return tco;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                TCompoundDataObject[] tco = new TBitfield[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new TBitfield(dataTag, dataFormat);
                }
                return tco;
            }
            case 54: {
                TCompoundDataObject[] tco = new NAME64DBL[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new NAME64DBL();
                }
                return tco;
            }
            case 55: {
                TCompoundDataObject[] tco = new IMAGE[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    tco[i] = new IMAGE();
                }
                return tco;
            }
        }
        return null;
    }

    public static short getBitfieldFormat(short dataFormat) {
        switch (dataFormat) {
            case 2: 
            case 50: {
                return 50;
            }
            case 1: 
            case 51: {
                return 51;
            }
            case 3: 
            case 52: {
                return 52;
            }
            case 6: 
            case 53: {
                return 53;
            }
        }
        return 255;
    }

    public static short getIntegerFormat(short dataFormat) {
        switch (dataFormat) {
            case 2: 
            case 50: {
                return 2;
            }
            case 1: 
            case 51: {
                return 1;
            }
            case 3: 
            case 52: {
                return 3;
            }
            case 6: 
            case 53: {
                return 6;
            }
        }
        return 255;
    }

    public static boolean isNameInt(short dataFormat) {
        switch (dataFormat) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 37: {
                return true;
            }
        }
        return false;
    }

    public static int getHistoryHeaderSize() {
        return 16;
    }

    public static int getFormatHeaderSize(short dataFormat) {
        switch (dataFormat) {
            case 55: {
                return 188;
            }
            case 28: {
                return 96;
            }
        }
        return 0;
    }

    public static int getFormatBodyStart(short dataFormat) {
        switch (dataFormat) {
            case 55: {
                return 188;
            }
            case 28: {
                return 0;
            }
        }
        return 0;
    }

    public static short getFormatDataType(short dataFormat) {
        int df = dataFormat % 256;
        switch (df) {
            case 55: {
                return 2;
            }
            case 28: {
                return 5;
            }
        }
        return (short)df;
    }

    public static boolean hasHeader(short dataFormat) {
        switch (dataFormat) {
            case 28: 
            case 55: {
                return true;
            }
        }
        return false;
    }

    public static boolean isString(short dataFormat) {
        switch (dataFormat) {
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 19: 
            case 24: 
            case 36: 
            case 46: {
                return true;
            }
        }
        return false;
    }

    public static boolean formatsCanMap(short dataFormat1, short dataFormat2, boolean input) {
        if (dataFormat1 == dataFormat2) {
            return true;
        }
        switch (dataFormat1) {
            case 2: {
                if (input || dataFormat2 != 4) break;
                return true;
            }
            case 0: 
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 33: {
                if (dataFormat2 != 5 && dataFormat2 != 0 && dataFormat2 != 1 && dataFormat2 != 3 && dataFormat2 != 6 && dataFormat2 != 33) break;
                return true;
            }
            case 14: 
            case 15: 
            case 40: {
                if (input) break;
                if (dataFormat2 == 15 || dataFormat2 == 14 || dataFormat2 == 40) {
                    return true;
                }
                if (dataFormat2 != 5 && dataFormat2 != 0 && dataFormat2 != 3 && dataFormat2 != 6) break;
                return true;
            }
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 19: 
            case 36: {
                if (dataFormat2 == 8 || dataFormat2 == 9 || dataFormat2 == 13 || dataFormat2 == 19 || dataFormat2 == 36 || dataFormat2 == 24 || dataFormat2 == 4) {
                    return true;
                }
                if (input || dataFormat2 != 2) break;
                return true;
            }
            case 21: 
            case 22: 
            case 23: 
            case 37: {
                if (input || dataFormat2 != 21 && dataFormat2 != 22 && dataFormat2 != 23 && dataFormat2 != 37) break;
                return true;
            }
            case 41: 
            case 44: 
            case 45: {
                if (input || dataFormat2 != 41 && dataFormat2 != 44 && dataFormat2 != 45) break;
                return true;
            }
        }
        return false;
    }

    public static int formatSizeOf(short dataFormat) {
        short df;
        short s = df = dataFormat >= 0 ? dataFormat : (short)(256 + dataFormat);
        if (df >= 512) {
            df = (short)(df - 512);
        }
        switch (df) {
            case 255: {
                return 0;
            }
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 47: 
            case 50: 
            case 55: 
            case 56: 
            case 57: {
                return 1;
            }
            case 1: 
            case 51: {
                return 2;
            }
            case 3: 
            case 5: 
            case 33: 
            case 52: {
                return 4;
            }
            case 0: 
            case 6: 
            case 53: {
                return 8;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 16;
            }
            case 13: {
                return 32;
            }
            case 19: {
                return 48;
            }
            case 36: {
                return 64;
            }
            case 14: 
            case 15: 
            case 31: {
                return 8;
            }
            case 16: {
                return 12;
            }
            case 25: 
            case 26: 
            case 43: {
                return 12;
            }
            case 27: 
            case 29: 
            case 34: 
            case 35: {
                return 16;
            }
            case 42: {
                return 24;
            }
            case 10: {
                return 24;
            }
            case 21: {
                return 20;
            }
            case 22: {
                return 36;
            }
            case 23: {
                return 52;
            }
            case 37: {
                return 68;
            }
            case 54: {
                return 72;
            }
            case 41: {
                return 32;
            }
            case 44: {
                return 48;
            }
            case 45: {
                return 80;
            }
            case 49: {
                return 88;
            }
            case 38: {
                return 12;
            }
            case 39: {
                return 12;
            }
            case 40: {
                return 16;
            }
            case 48: {
                return 24;
            }
            case 28: {
                return 4;
            }
            case 18: {
                return 12;
            }
            case 32: {
                return 16;
            }
            case 24: {
                return 96;
            }
            case 46: {
                return 32;
            }
        }
        return -1;
    }

    public static String toString(short dataFormat) {
        short df;
        short s = df = dataFormat >= 0 ? dataFormat : (short)(256 + dataFormat);
        if (df >= 512) {
            df = (short)(df - 512);
        }
        switch (df) {
            case 255: {
                return "null";
            }
            case 11: {
                return "bit";
            }
            case 7: {
                return "struct";
            }
            case 4: {
                return "char";
            }
            case 2: {
                return "byte";
            }
            case 1: {
                return "short";
            }
            case 3: {
                return "int";
            }
            case 6: {
                return "int64";
            }
            case 5: {
                return "float";
            }
            case 0: {
                return "double";
            }
            case 8: {
                return "NAME8";
            }
            case 9: {
                return "NAME16";
            }
            case 13: {
                return "NAME32";
            }
            case 19: {
                return "NAME48";
            }
            case 36: {
                return "NAME64";
            }
            case 14: {
                return "FLTINT";
            }
            case 15: {
                return "LNGINT";
            }
            case 16: {
                return "DBLINT";
            }
            case 31: {
                return "FLTFLT";
            }
            case 35: {
                return "FIFI";
            }
            case 25: {
                return "FLTFLTINT";
            }
            case 26: {
                return "FLTINTINT";
            }
            case 48: {
                return "DBLDBLDBL";
            }
            case 29: {
                return "ADDRESS";
            }
            case 33: {
                return "boolean";
            }
            case 34: {
                return "WINDOW";
            }
            case 10: {
                return "NAMEFI";
            }
            case 42: {
                return "NAMEII";
            }
            case 21: {
                return "NAME16I";
            }
            case 22: {
                return "NAME32I";
            }
            case 23: {
                return "NAME48I";
            }
            case 37: {
                return "NAME64I";
            }
            case 54: {
                return "NAME64DBL";
            }
            case 38: {
                return "INTDBL";
            }
            case 39: {
                return "FLTDBL";
            }
            case 40: {
                return "DBLDBL";
            }
            case 28: {
                return "SPECTRUM";
            }
            case 18: {
                return "TDS";
            }
            case 32: {
                return "TDSI";
            }
            case 24: {
                return "USTRING";
            }
            case 46: {
                return "UNAME";
            }
            case 27: {
                return "IFFF";
            }
            case 43: {
                return "INTINTINT";
            }
            case 41: {
                return "NAME16DBLDBL";
            }
            case 44: {
                return "NAME32DBLDBL";
            }
            case 45: {
                return "NAME64DBLDBL";
            }
            case 49: {
                return "NAME64DBLDBLDBL";
            }
            case 47: {
                return "xml";
            }
            case 50: {
                return "BITFIELD8";
            }
            case 51: {
                return "BITFIELD16";
            }
            case 52: {
                return "BITFIELD32";
            }
            case 53: {
                return "BITFIELD64";
            }
            case 55: {
                return "IMAGE";
            }
            case 56: {
                return "HISTORY";
            }
            case 57: {
                return "STRING";
            }
        }
        return "unknown";
    }

    public static String getFormatTag(String dataFormatString) {
        if (dataFormatString == null) {
            return null;
        }
        int p = dataFormatString.indexOf(".");
        if (p < 1) {
            return "";
        }
        String fmt = dataFormatString.substring(0, p).toUpperCase();
        if (fmt.startsWith("STRUCT") || fmt.startsWith("BITFIELD")) {
            return dataFormatString.substring(p + 1);
        }
        return "";
    }

    public static short getFormatArrayType(String dataFormatString) {
        if (dataFormatString == null) {
            return 0;
        }
        int p = dataFormatString.indexOf(".");
        if (p < 1) {
            return 0;
        }
        String fmt = dataFormatString.substring(0, p).toUpperCase();
        if (fmt.startsWith("STRUCT") || fmt.startsWith("BITFIELD")) {
            return 0;
        }
        return TArrayType.getType(dataFormatString.substring(p + 1));
    }

    public static short getFormatCode(String dataFormatString) {
        String dfs = dataFormatString.toUpperCase();
        if (dfs.compareTo("NULL") == 0) {
            return 255;
        }
        if (dfs.startsWith("BITFIELD8")) {
            return 50;
        }
        if (dfs.startsWith("BITFIELD16")) {
            return 51;
        }
        if (dfs.startsWith("BITFIELD32")) {
            return 52;
        }
        if (dfs.startsWith("BITFIELD64")) {
            return 53;
        }
        if (dfs.startsWith("BIT")) {
            return 11;
        }
        if (dfs.startsWith("STRUCT")) {
            return 7;
        }
        if (dfs.startsWith("TEXT")) {
            return 4;
        }
        if (dfs.startsWith("BYTE")) {
            return 2;
        }
        if (dfs.startsWith("INT8")) {
            return 2;
        }
        if (dfs.startsWith("SHORT")) {
            return 1;
        }
        if (dfs.startsWith("INT16")) {
            return 1;
        }
        if (dfs.startsWith("LONG")) {
            return 3;
        }
        if (dfs.startsWith("INT32")) {
            return 3;
        }
        if (dfs.startsWith("UINT32")) {
            return 3;
        }
        if (dfs.startsWith("DLONG")) {
            return 6;
        }
        if (dfs.startsWith("INT64")) {
            return 6;
        }
        if (dfs.startsWith("FLOAT")) {
            return 5;
        }
        if (dfs.startsWith("DOUBLE")) {
            return 0;
        }
        if (dfs.startsWith("NAME16FI")) {
            return 10;
        }
        if (dfs.startsWith("STRING16FI")) {
            return 10;
        }
        if (dfs.startsWith("CHAR16FI")) {
            return 10;
        }
        if (dfs.startsWith("NAMEFI")) {
            return 10;
        }
        if (dfs.startsWith("NAME16II")) {
            return 42;
        }
        if (dfs.startsWith("NAMEII")) {
            return 42;
        }
        if (dfs.startsWith("STRING16II")) {
            return 42;
        }
        if (dfs.startsWith("CHAR16II")) {
            return 42;
        }
        if (dfs.startsWith("NAME16I")) {
            return 21;
        }
        if (dfs.startsWith("STRING16I")) {
            return 21;
        }
        if (dfs.startsWith("CHAR16I")) {
            return 21;
        }
        if (dfs.startsWith("NAME32I")) {
            return 22;
        }
        if (dfs.startsWith("STRING32I")) {
            return 22;
        }
        if (dfs.startsWith("CHAR32I")) {
            return 22;
        }
        if (dfs.startsWith("NAME48I")) {
            return 23;
        }
        if (dfs.startsWith("STRING48I")) {
            return 23;
        }
        if (dfs.startsWith("CHAR48I")) {
            return 23;
        }
        if (dfs.startsWith("NAME64I")) {
            return 37;
        }
        if (dfs.startsWith("STRING64I")) {
            return 37;
        }
        if (dfs.startsWith("CHAR64I")) {
            return 37;
        }
        if (dfs.startsWith("NAMEDBLDBL")) {
            return 41;
        }
        if (dfs.startsWith("NAME16DBLDBL")) {
            return 41;
        }
        if (dfs.startsWith("STRING16DBLDBL")) {
            return 41;
        }
        if (dfs.startsWith("CHAR16DBLDBL")) {
            return 41;
        }
        if (dfs.startsWith("NAME32DBLDBL")) {
            return 44;
        }
        if (dfs.startsWith("STRING32DBLDBL")) {
            return 44;
        }
        if (dfs.startsWith("CHAR32DBLDBL")) {
            return 44;
        }
        if (dfs.startsWith("NAME64DBLDBLDBL")) {
            return 49;
        }
        if (dfs.startsWith("STRING64DBLDBLDBL")) {
            return 49;
        }
        if (dfs.startsWith("CHAR64DBLDBLDBL")) {
            return 49;
        }
        if (dfs.startsWith("NAME64DBLDBL")) {
            return 45;
        }
        if (dfs.startsWith("STRING64DBLDBL")) {
            return 45;
        }
        if (dfs.startsWith("CHAR64DBLDBL")) {
            return 45;
        }
        if (dfs.startsWith("NAME64DBL")) {
            return 54;
        }
        if (dfs.startsWith("STRING64DBL")) {
            return 54;
        }
        if (dfs.startsWith("CHAR64DBL")) {
            return 54;
        }
        if (dfs.startsWith("NAME8")) {
            return 8;
        }
        if (dfs.startsWith("STRING8")) {
            return 8;
        }
        if (dfs.startsWith("CHAR8")) {
            return 8;
        }
        if (dfs.startsWith("NAME16")) {
            return 9;
        }
        if (dfs.startsWith("STRING16")) {
            return 9;
        }
        if (dfs.startsWith("CHAR16")) {
            return 9;
        }
        if (dfs.startsWith("NAME32")) {
            return 13;
        }
        if (dfs.startsWith("STRING32")) {
            return 13;
        }
        if (dfs.startsWith("CHAR32")) {
            return 13;
        }
        if (dfs.startsWith("NAME48")) {
            return 19;
        }
        if (dfs.startsWith("STRING48")) {
            return 19;
        }
        if (dfs.startsWith("CHAR48")) {
            return 19;
        }
        if (dfs.startsWith("NAME64")) {
            return 36;
        }
        if (dfs.startsWith("STRING64")) {
            return 36;
        }
        if (dfs.startsWith("CHAR64")) {
            return 36;
        }
        if (dfs.startsWith("FLTFLTINT")) {
            return 25;
        }
        if (dfs.startsWith("FLTFLT")) {
            return 31;
        }
        if (dfs.startsWith("FIFI")) {
            return 35;
        }
        if (dfs.startsWith("FLTINTFLTINT")) {
            return 35;
        }
        if (dfs.startsWith("FFI")) {
            return 25;
        }
        if (dfs.startsWith("FLTINTINT")) {
            return 26;
        }
        if (dfs.startsWith("FII")) {
            return 26;
        }
        if (dfs.startsWith("ADDRESS")) {
            return 29;
        }
        if (dfs.startsWith("IIII")) {
            return 29;
        }
        if (dfs.startsWith("III")) {
            return 43;
        }
        if (dfs.startsWith("INTINTINT")) {
            return 43;
        }
        if (dfs.startsWith("BOOL")) {
            return 33;
        }
        if (dfs.startsWith("WINDOW")) {
            return 30;
        }
        if (dfs.startsWith("FWINDOW")) {
            return 34;
        }
        if (dfs.startsWith("SPECTRUM")) {
            return 28;
        }
        if (dfs.startsWith("TDSI")) {
            return 32;
        }
        if (dfs.startsWith("TDS")) {
            return 18;
        }
        if (dfs.startsWith("UNAME")) {
            return 46;
        }
        if (dfs.startsWith("IFFFNAME")) {
            return 46;
        }
        if (dfs.startsWith("INTFLTFLTFLTNAME")) {
            return 46;
        }
        if (dfs.startsWith("INTFLTINTINT")) {
            return 32;
        }
        if (dfs.startsWith("INTFLTINT")) {
            return 18;
        }
        if (dfs.startsWith("INTFLTFLTFLT")) {
            return 27;
        }
        if (dfs.startsWith("FILTER")) {
            return 27;
        }
        if (dfs.startsWith("USTRING")) {
            return 24;
        }
        if (dfs.startsWith("INTDBL")) {
            return 38;
        }
        if (dfs.startsWith("FLTDBL")) {
            return 39;
        }
        if (dfs.startsWith("DBLDBLDBL")) {
            return 48;
        }
        if (dfs.startsWith("DBLDBL")) {
            return 40;
        }
        if (dfs.startsWith("FLTINT")) {
            return 14;
        }
        if (dfs.startsWith("LNGINT")) {
            return 15;
        }
        if (dfs.startsWith("INTINT")) {
            return 15;
        }
        if (dfs.startsWith("DBLINT")) {
            return 16;
        }
        if (dfs.startsWith("XML")) {
            return 47;
        }
        if (dfs.startsWith("CHAR")) {
            return 4;
        }
        if (dfs.startsWith("INT")) {
            return 3;
        }
        if (dfs.startsWith("BOOLEAN")) {
            return 33;
        }
        if (dfs.startsWith("IMAGE")) {
            return 55;
        }
        if (dfs.startsWith("HISTORY")) {
            return 56;
        }
        if (dfs.compareToIgnoreCase("STRING") == 0) {
            return 57;
        }
        return 255;
    }

    public static int getCarriedFormatSize(String tag) {
        short fmt = TFormat.getFormatCode(tag);
        switch (fmt) {
            case 255: {
                int siz = TStructRegistry.getSizeInBytes(tag);
                if (siz <= 0) break;
                return siz;
            }
            case 7: 
            case 56: {
                break;
            }
            case 55: {
                return 500188;
            }
            case 28: {
                return 4192;
            }
            default: {
                return TFormat.formatSizeOf(fmt);
            }
        }
        return -2;
    }

    public static TFormat valueOf(short fmt) {
        return new TFormat(fmt);
    }

    private TFormat(short val) {
        this.value = val;
    }

    public short getValue() {
        return this.value;
    }

    public String toString() {
        return TFormat.toString(this.value);
    }
}

