/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.client;

import de.desy.tine.client.TLink;
import de.desy.tine.client.TLinkCallback;
import de.desy.tine.client.TLinkFactory;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TMode;
import de.desy.tine.server.logger.DbgLog;
import de.desy.tine.server.logger.MsgLog;
import java.util.LinkedList;

public class TWatchdogLink
implements TLinkCallback {
    TLink tgt = null;
    String key = null;
    private static final String lwdProperty = "SRVSTARTTIME";
    private static final String lwdTag = "WDOG";
    static final int LWD_TIMER_DEADBAND = 5;
    private int[] srvStartTime = new int[1];
    private static int pollingInterval = 1000;
    LinkedList<TLink> lnks = new LinkedList();
    private TWatchdogLink parent;

    public TWatchdogLink(TLink lnk) {
        this.key = "/" + lnk.cntName + "/" + lnk.expName;
        TLinkFactory tf = TLinkFactory.getInstance();
        this.parent = tf.getWatchdogLink(this.key);
        lnk.isBeingWatched = true;
        if (this.parent == null) {
            if (lnk.sub.pollingRate < pollingInterval && TMode.getBaseMode(lnk.sub.mode) != 6) {
                TWatchdogLink.setPollingInterval(lnk.sub.pollingRate);
            }
            tf.addWatchdogLink(this.key, this);
            this.parent = this;
            TDataType dout = new TDataType(this.srvStartTime);
            dout.setTag(lwdTag);
            this.tgt = new TLink(this.key, lwdProperty, dout, null, 1);
            this.tgt.attach((short)3, (TLinkCallback)this, pollingInterval);
            MsgLog.log("TWatchdogLink", "add " + this.key + " to the watched links table", 0, null, 0);
        }
        if (!this.parent.lnks.contains(lnk)) {
            this.parent.lnks.add(lnk);
        }
    }

    public void remove(TLink lnk) {
        if (lnk == null) {
            return;
        }
        this.parent.lnks.remove(lnk);
        lnk.isBeingWatched = false;
        if (this.lnks.size() == 0 && this.tgt != null) {
            DbgLog.log("TWatchdogLink", "removing watchdog link to " + this.parent.tgt.getFullDeviceName());
            this.tgt.close();
            this.tgt = null;
            this.parent = null;
            TLinkFactory.getInstance().rmvWatchdogLink(this.key);
        }
    }

    public static boolean isWatchableLink(TLink lnk) {
        if (lnk == null) {
            return false;
        }
        if (lnk.dOutput.getTag().compareTo(lwdTag) == 0) {
            return false;
        }
        if (lnk.con.eqmProperty.compareTo(lwdProperty) == 0) {
            return false;
        }
        if (lnk.isBound()) {
            return false;
        }
        if (lnk.isBeingWatched) {
            return false;
        }
        short bmode = TMode.getBaseMode(lnk.getLinkAccessMode());
        if (bmode < 2) {
            return false;
        }
        if (bmode == 3 && lnk.getLinkPollingInterval() < pollingInterval * 5) {
            return false;
        }
        String key = "/" + lnk.cntName + "/" + lnk.expName;
        return bmode != 3 || TLinkFactory.getInstance().hasWatchdogLink(key);
    }

    public void callback(TLink link) {
        if (this.lnks.size() == 0) {
            link.close();
            TLinkFactory.getInstance().rmvWatchdogLink(this.key);
            MsgLog.log("TWatchdogLink", "remove " + this.key + " from the watched links table", 0, null, 0);
            return;
        }
        switch (link.getLinkStatus()) {
            default: {
                break;
            }
            case 45: 
            case 98: {
                for (TLink lnk : this.lnks) {
                    lnk.sub.linkLastTime = 0L;
                }
            }
        }
    }

    public static int getPollingInterval() {
        return pollingInterval;
    }

    public static void setPollingInterval(int value) {
        if (value < 50) {
            value = 50;
        }
        if (value > 10000) {
            value = 10000;
        }
        pollingInterval = value;
    }
}

