/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.bitfieldUtils;

import de.desy.tine.bitfieldUtils.TBitfield;
import java.util.HashMap;

public class TBitfieldRegistry {
    private static HashMap<String, TBitfield> bfRegistry = new HashMap();

    private static String rmvDeviceName(String fullName) {
        if (fullName == null) {
            return "this";
        }
        String[] parts = fullName.split("/");
        if (parts.length == 1) {
            return parts[0];
        }
        if (fullName.startsWith("/")) {
            return "/" + parts[1] + "/" + parts[2];
        }
        return parts[0];
    }

    public static void add(TBitfield bitfield) {
        if (bitfield == null) {
            return;
        }
        String srv = TBitfieldRegistry.rmvDeviceName(bitfield.getSrvName());
        String key = srv + "/" + bitfield.getName();
        if (!bfRegistry.containsKey(key)) {
            bfRegistry.put(key, bitfield);
        }
    }

    public static TBitfield getBitfield(String context, String server, String tag) {
        if (tag == null) {
            return null;
        }
        if (context == null) {
            context = "default";
        }
        if (server == null) {
            server = "this";
        }
        return TBitfieldRegistry.getBitfield("/" + context + "/" + server + "/" + tag);
    }

    public static TBitfield getBitfield(String server, String tag) {
        if (tag == null) {
            return null;
        }
        if (server == null) {
            server = "this";
        }
        return TBitfieldRegistry.getBitfield("/" + server + "/" + tag);
    }

    public static TBitfield getBitfield(String name) {
        if (bfRegistry.containsKey(name)) {
            return bfRegistry.get(name);
        }
        if (!name.contains("/")) {
            String[] keys;
            String keytag = "/" + name;
            for (String s : keys = bfRegistry.keySet().toArray(new String[1])) {
                if (!s.endsWith(keytag)) continue;
                return bfRegistry.get(s);
            }
        }
        return null;
    }
}

