/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.alarmUtils;

import de.desy.tine.alarmUtils.AlarmMonitor;
import de.desy.tine.alarmUtils.AlarmMonitorCallback;
import de.desy.tine.alarmUtils.ApcBlk;
import de.desy.tine.alarmUtils.CasSrvInfo;
import de.desy.tine.client.TLink;
import de.desy.tine.client.TLinkCallback;
import de.desy.tine.client.TLinkFactory;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TErrorList;
import de.desy.tine.queryUtils.TQuery;
import de.desy.tine.server.alarms.TAlarmDefinition;
import de.desy.tine.server.alarms.TAlarmMessage;
import de.desy.tine.server.alarms.TCASAlarmMessage;
import de.desy.tine.server.equipment.TEquipmentModuleFactory;
import de.desy.tine.server.logger.DbgLog;
import de.desy.tine.structUtils.TTaggedStructure;
import de.desy.tine.types.NAME;
import de.desy.tine.types.NAME16II;
import de.desy.tine.types.NAME32;
import de.desy.tine.types.NAME8;
import de.desy.tine.types.TCompoundDataObject;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAlarmSystem {
    private static final int nice_query_size = 100;
    private static NAME16II[] almSysBuf = new NAME16II[100];
    private static NAME32[] srvNamesBuf = new NAME32[100];
    private static Hashtable<String, NAME16II[]> ctxInfoTbl = new Hashtable();
    private static Hashtable<String, CasSrvInfo> srvInfoTbl = new Hashtable();
    private static int sessionId = -1;
    private static String sessionEvent = null;
    private static String sessionGroup = null;

    public static String[] getAlarmSystems(String context) {
        NAME16II[] n16ii = TAlarmSystem.getAlarmSystemsMap(context);
        if (n16ii == null || n16ii.length == 0) {
            return null;
        }
        String[] as = new String[n16ii.length];
        for (int i = 0; i < n16ii.length; ++i) {
            as[i] = n16ii[i].getName();
        }
        return as;
    }

    public static String[] getAlarmSystemsViewerColumn(String context, int column) {
        NAME16II[] n16ii = TAlarmSystem.getAlarmSystemsMap(context);
        if (n16ii == null || n16ii.length == 0) {
            return null;
        }
        int[] nsys = new int[3];
        for (int i = 0; i < n16ii.length; ++i) {
            if (n16ii[i].i2val < 1 || n16ii[i].i2val > 3) continue;
            int n = n16ii[i].i2val - 1;
            nsys[n] = nsys[n] + 1;
        }
        int n = nsys[0];
        if (nsys[1] > n) {
            n = nsys[1];
        }
        if (nsys[2] > n) {
            n = nsys[2];
        }
        if (n < 1) {
            n = n16ii.length;
        }
        String[] as = new String[n];
        int k = 0;
        for (int i = 0; i < n16ii.length && k < n; ++i) {
            if (n16ii[i].i2val != column) continue;
            as[k++] = n16ii[i].getName();
        }
        return as;
    }

    public static synchronized NAME16II[] getAlarmSystemsMap(String context) {
        int n;
        if (context == null) {
            return null;
        }
        NAME16II[] as = ctxInfoTbl.get(context);
        if (as != null) {
            return as;
        }
        TDataType ast = new TDataType(almSysBuf);
        String dev = "/" + context + "/CAS";
        TLink tl = new TLink(dev, "ALARMSYSTEMS", ast, null, 1);
        int cc = tl.execute(500, true);
        tl.close();
        if (cc == 0 && (n = ast.getCompletionLength()) > 0) {
            as = new NAME16II[n];
            for (int i = 0; i < n; ++i) {
                as[i] = new NAME16II(almSysBuf[i]);
            }
            if (as != null) {
                ctxInfoTbl.put(context, as);
            }
            return as;
        }
        return null;
    }

    public static String getAlarmSystem(String context, int alarmSystemNumber) {
        NAME16II[] as = TAlarmSystem.getAlarmSystemsMap(context);
        if (as != null) {
            for (int i = 0; i < as.length; ++i) {
                if (as[i].i1val != alarmSystemNumber) continue;
                return as[i].getName();
            }
        }
        return new String("alarm system " + alarmSystemNumber);
    }

    public static int getAlarmSystemNumber(String context, String alarmSystem) {
        NAME16II[] as = TAlarmSystem.getAlarmSystemsMap(context);
        if (as != null && alarmSystem != null) {
            for (int i = 0; i < as.length; ++i) {
                if (as[i].name.compareToIgnoreCase(alarmSystem) != 0) continue;
                return as[i].i1val;
            }
        }
        return 0;
    }

    public static String[] getAlarmServerContexts() {
        return TQuery.getContexts("CAS");
    }

    public static String[] getAlarmServerServers(String context, String alarmSystem) {
        int n;
        if (context == null) {
            return null;
        }
        TDataType srvt = new TDataType(srvNamesBuf);
        String srv = "/" + context + "/CAS";
        String dev = srv + "/" + (alarmSystem != null ? "SYS:" + alarmSystem : "#0");
        String prp = alarmSystem != null && alarmSystem.compareToIgnoreCase("ALL") != 0 ? "Server4AlmSystem" : "SERVERS";
        TLink tl = new TLink(dev, prp, srvt, null, 1);
        int cc = tl.execute(500, true);
        tl.close();
        if (cc == 0 && (n = srvt.getCompletionLength()) > 0) {
            String[] as = new String[n];
            for (int i = 0; i < n; ++i) {
                as[i] = srvNamesBuf[i].getName();
            }
            return as;
        }
        return null;
    }

    public static CasSrvInfo getAlarmServerServerInfo(String context, String server) {
        if (context == null || server == null) {
            return null;
        }
        String key = "/" + context + "/" + server;
        TTaggedStructure[] cq = new CasSrvInfo[]{srvInfoTbl.get(key)};
        if (cq[0] == null) {
            cq[0] = new CasSrvInfo();
            TDataType srvt = new TDataType(cq);
            String srv = "/" + context + "/CAS/" + server;
            TLink tl = new TLink(srv, "SERVERINFO", srvt, null, 1);
            int cc = tl.execute(500, true);
            tl.close();
            if (cc == 0) {
                srvInfoTbl.put(key, (CasSrvInfo)cq[0]);
            }
        }
        return cq[0];
    }

    public static int getNumberOfAlarms(String context, String server, String alarmSystem, long start, long stop, int severity) {
        return TAlarmSystem.getNumberOfAlarms(context, server, alarmSystem, start, stop, severity, false);
    }

    public static int getNumberOfAlarms(String context, String server, String alarmSystem, long start, long stop, int severity, boolean includeTerminated) {
        String prp;
        int[] nalms;
        TDataType sst;
        if (context == null) {
            return -20;
        }
        int[] stst = new int[]{(int)(start / 1000L), (int)(stop / 1000L), severity};
        String srv = server == null ? "CAS" : server;
        String dev = "/" + context + "/" + srv;
        int nindex = 0;
        if (srv.compareToIgnoreCase("CAS") == 0) {
            sst = new TDataType(stst);
            nalms = new int[2];
            String string = prp = includeTerminated ? "NUMALARMS.RAW" : "NUMALARMS";
            if (alarmSystem != null) {
                dev = dev + (alarmSystem.startsWith("Server:") ? alarmSystem.substring(7) : "/SYS:" + alarmSystem);
            }
            nindex = includeTerminated ? 0 : 1;
        } else {
            sst = new TDataType();
            nalms = new int[5];
            prp = "NALARMS";
        }
        TDataType nat = new TDataType(nalms);
        TLink tl = new TLink(dev, prp, nat, sst, 1);
        int cc = tl.execute(500, true);
        tl.close();
        int nalm = 0;
        if (cc == 0) {
            nalm = nalms[nindex];
        }
        return nalm;
    }

    public static int getNumberOfAlarms(String context, String alarmSystem, long start, long stop, int severity) {
        return TAlarmSystem.getNumberOfAlarms(context, null, alarmSystem, start, stop, severity);
    }

    public static TLink monitorAlarms(String context, String server, String alarmSystem, int severity, AlarmMonitor almMonitor) {
        return TAlarmSystem.monitorAlarms(context, server, alarmSystem, severity, almMonitor, false);
    }

    public static TLink monitorAlarms(String context, String server, String alarmSystem, int severity, AlarmMonitor almMonitor, boolean includeTerminated) {
        String prp;
        int[] nalms;
        TDataType sst;
        if (context == null) {
            return null;
        }
        int[] stst = new int[]{-7200, -1, severity};
        String srv = server == null ? "CAS" : server;
        String dev = "/" + context + "/" + srv;
        if (srv.compareToIgnoreCase("CAS") == 0) {
            sst = new TDataType(stst);
            nalms = new int[2];
            String string = prp = includeTerminated ? "NUMALARMS.RAW" : "NUMALARMS";
            if (alarmSystem != null) {
                dev = dev + (alarmSystem.startsWith("Server:") ? alarmSystem.substring(7) : "/SYS:" + alarmSystem);
            }
        } else {
            sst = new TDataType();
            nalms = new int[5];
            prp = "NALARMS";
        }
        TDataType nat = new TDataType(nalms);
        TLink tl = new TLink(dev, prp, nat, sst, 1);
        AlarmMonitorCallback amcb = new AlarmMonitorCallback(context, server, alarmSystem, severity);
        amcb.setIncludeTerminated(includeTerminated);
        int id = tl.attach((short)3, (TLinkCallback)amcb, 1000);
        if (id < 0) {
            tl.close();
            return null;
        }
        if (almMonitor != null) {
            almMonitor.setAmcb(amcb);
            amcb.setAlarmMonitor(almMonitor);
        }
        return tl;
    }

    public static TAlarmMessage[] getAlarms(String context, String server, String alarmSystem, long start, long stop, int severity) {
        return TAlarmSystem.getAlarms(context, server, alarmSystem, start, stop, severity, false);
    }

    public static synchronized TAlarmMessage[] getAlarms(String context, String server, String alarmSystem, long start, long stop, int severity, boolean includeTerminated) {
        TAlarmMessage[] aa;
        String prp;
        boolean callArchive;
        long tnow = System.currentTimeMillis();
        boolean bl = callArchive = start < tnow - 10800000L;
        if (context == null) {
            return null;
        }
        String srv = server == null ? "CAS" : server;
        String dev = "/" + context + "/" + srv;
        if (srv.compareToIgnoreCase("CAS") == 0) {
            String string = prp = includeTerminated ? "SYSALARMS.RAW" : "SYSALARMS";
            dev = alarmSystem != null && alarmSystem.compareToIgnoreCase("ALL") != 0 ? dev + (alarmSystem.startsWith("Server:") ? alarmSystem.substring(7) : "/SYS:" + alarmSystem) : dev + "/ALL";
        } else {
            prp = "ALARMS";
            callArchive = false;
        }
        int n = TAlarmSystem.getNumberOfAlarms(context, server, alarmSystem, start, stop, severity, includeTerminated);
        Object[] ams = null;
        if (n > 0) {
            ams = new TAlarmMessage[n];
            for (int i = 0; i < n; ++i) {
                ams[i] = new TAlarmMessage();
            }
            TDataType amst = new TDataType((TTaggedStructure[])ams);
            int[] stst = new int[]{(int)(start / 1000L), (int)(stop / 1000L), severity};
            TDataType sst = new TDataType(stst);
            TLink tl = new TLink(dev, prp, amst, sst, 1);
            int cc = tl.execute(500, true);
            tl.close();
            if (cc != 0) {
                return null;
            }
            int nret = amst.getCompletionLength();
            if (nret < n) {
                TAlarmMessage[] a = new TAlarmMessage[nret];
                for (int i = 0; i < nret; ++i) {
                    a[i] = ams[i];
                }
                ams = a;
            }
            Arrays.sort(ams);
        }
        if (callArchive && (aa = TAlarmSystem.getArchivedAlarms(context, alarmSystem, start, stop, severity)) != null) {
            if (ams == null) {
                ams = aa;
            } else {
                int i;
                TAlarmMessage[] a = new TAlarmMessage[aa.length + ams.length];
                for (i = 0; i < ams.length; ++i) {
                    a[i] = ams[i];
                }
                for (i = 0; i < aa.length; ++i) {
                    a[ams.length + i] = aa[i];
                }
                ams = a;
            }
        }
        return ams;
    }

    public static synchronized TAlarmMessage[] getAlarms(int numAlarms, String context, String server, String alarmSystem, long start, long stop, int severity, boolean includeTerminated) {
        String prp;
        if (context == null) {
            return null;
        }
        String srv = server == null ? "CAS" : server;
        String dev = "/" + context + "/" + srv;
        if (srv.compareToIgnoreCase("CAS") == 0) {
            String string = prp = includeTerminated ? "SYSALARMS.RAW" : "SYSALARMS";
            dev = alarmSystem != null && alarmSystem.compareToIgnoreCase("ALL") != 0 ? dev + (alarmSystem.startsWith("Server:") ? alarmSystem.substring(7) : "/SYS:" + alarmSystem) : dev + "/ALL";
        } else {
            prp = "ALARMS";
        }
        int n = numAlarms;
        while (n > 800 && stop > start) {
            n = 800;
            start -= 1200000L;
        }
        Object[] ams = null;
        if (n > 0) {
            ams = new TAlarmMessage[n];
            for (int i = 0; i < n; ++i) {
                ams[i] = new TAlarmMessage();
            }
            TDataType amst = new TDataType((TTaggedStructure[])ams);
            int[] stst = new int[]{(int)(start / 1000L), (int)(stop / 1000L), severity};
            TDataType sst = new TDataType(stst);
            TLink tl = new TLink(dev, prp, amst, sst, 1);
            int cc = 98;
            for (int i = 0; i < 2 && (cc = tl.execute(500, true)) != 0; ++i) {
            }
            tl.close();
            if (cc != 0) {
                DbgLog.log("getAlarms", "getAlarms for " + dev + " failed : " + TErrorList.getErrorString(cc));
                return null;
            }
            int nret = amst.getCompletionLength();
            if (nret == 0) {
                return null;
            }
            if (nret < n) {
                TAlarmMessage[] a = new TAlarmMessage[nret];
                for (int i = 0; i < nret; ++i) {
                    a[i] = ams[i];
                }
                ams = a;
            }
            Arrays.sort(ams);
        }
        return ams;
    }

    public static synchronized TAlarmMessage[] getAlarmsAsync(int numAlarms, String context, String server, String alarmSystem, long start, long stop, int severity, boolean includeTerminated, TLinkCallback alarmsCallback) {
        String prp;
        if (start > 0L) {
            --start;
        }
        if (context == null) {
            return null;
        }
        String srv = server == null ? "CAS" : server;
        String dev = "/" + context + "/" + srv;
        if (srv.compareToIgnoreCase("CAS") == 0) {
            String string = prp = includeTerminated ? "SYSALARMS.RAW" : "SYSALARMS";
            dev = alarmSystem != null && alarmSystem.compareToIgnoreCase("ALL") != 0 ? dev + (alarmSystem.startsWith("Server:") ? alarmSystem.substring(7) : "/SYS:" + alarmSystem) : dev + "/ALL";
        } else {
            prp = "ALARMS";
        }
        int n = numAlarms;
        if (n > 1000 && stop > start) {
            if (TLinkFactory.debugLevel > 0) {
                DbgLog.log("getAlarmsAsync", "getAlarms for " + dev + " : " + n + " alarms over last 2 hours");
            }
            if (stop > start + 1200000L) {
                if (TLinkFactory.debugLevel > 0) {
                    DbgLog.log("getAlarmsAsync", "acquire last 20 minutes -> truncate call to 1000 alarms above severity 7");
                }
                start = stop - 1200000L;
                n = 1000;
                severity = 7;
            } else {
                n = 100 * (int)(stop - start) / 1000;
                if (TLinkFactory.debugLevel > 0) {
                    DbgLog.log("getAlarmsAsync", "acquire last " + (stop - start) / 1000L + "seconds -> truncate call to " + n + " alarms");
                }
            }
        }
        if (n > 1000) {
            n = 1000;
        }
        TTaggedStructure[] ams = null;
        if (n > 0) {
            ams = new TAlarmMessage[n];
            for (int i = 0; i < n; ++i) {
                ams[i] = new TAlarmMessage();
            }
            TDataType amst = new TDataType(ams);
            int[] stst = new int[]{(int)(start / 1000L), (int)(stop / 1000L), severity};
            TDataType sst = new TDataType(stst);
            TLink tl = new TLink(dev, prp, amst, sst, 1);
            int lid = tl.attach((short)1, alarmsCallback, 1000);
            if (lid < 0) {
                DbgLog.log("getAlarmsAsync", "getAlarms for " + dev + " failed : " + TErrorList.getErrorString(-lid));
                return null;
            }
        }
        return ams;
    }

    public static TCASAlarmMessage[] getAlarmsWithText(String context, String alarmSystem, long start, long stop, int severity, boolean includeTerminated) {
        TAlarmMessage[] aa;
        String prp;
        boolean callArchive;
        long tnow = System.currentTimeMillis();
        boolean bl = callArchive = start < tnow - 10800000L;
        if (context == null) {
            return null;
        }
        String srv = "CAS";
        String dev = "/" + context + "/" + srv;
        if (srv.compareToIgnoreCase("CAS") == 0) {
            String string = prp = includeTerminated ? "SYSALARMS.RAW" : "SYSALARMS";
            dev = alarmSystem != null && alarmSystem.compareToIgnoreCase("ALL") != 0 ? dev + (alarmSystem.startsWith("Server:") ? alarmSystem.substring(7) : "/SYS:" + alarmSystem) : dev + "/ALL";
        } else {
            prp = "ALARMS";
            callArchive = false;
        }
        int n = TAlarmSystem.getNumberOfAlarms(context, srv, alarmSystem, start, stop, severity);
        Object[] ams = null;
        if (n > 0) {
            ams = new TCASAlarmMessage[n];
            for (int i = 0; i < n; ++i) {
                ams[i] = new TCASAlarmMessage();
            }
            TDataType amst = new TDataType((TTaggedStructure[])ams);
            int[] stst = new int[]{(int)(start / 1000L), (int)(stop / 1000L), severity};
            TDataType sst = new TDataType(stst);
            TLink tl = new TLink(dev, prp, amst, sst, 1);
            int cc = tl.execute(500, true);
            tl.close();
            if (cc != 0) {
                DbgLog.log("getAlarmsWithText", "getAlarmsWithText for " + dev + " failed : " + TErrorList.getErrorString(cc));
                return null;
            }
            int nret = amst.getCompletionLength();
            if (nret < n) {
                TCASAlarmMessage[] a = new TCASAlarmMessage[nret];
                for (int i = 0; i < nret; ++i) {
                    a[i] = ams[i];
                }
                ams = a;
            }
            Arrays.sort(ams);
        }
        if (callArchive && (aa = TAlarmSystem.getArchivedAlarms(context, alarmSystem, start, stop, severity)) != null) {
            TCASAlarmMessage[] xaa = new TCASAlarmMessage[aa.length];
            if (ams == null) {
                for (int i = 0; i < xaa.length; ++i) {
                    xaa[i] = new TCASAlarmMessage(aa[i]);
                }
                ams = xaa;
            } else {
                int i;
                TCASAlarmMessage[] a = new TCASAlarmMessage[aa.length + ams.length];
                for (i = 0; i < ams.length; ++i) {
                    a[i] = ams[i];
                }
                for (i = 0; i < aa.length; ++i) {
                    a[ams.length + i] = new TCASAlarmMessage(aa[i]);
                }
                ams = a;
            }
        }
        return ams;
    }

    public static TAlarmMessage[] getAlarms(String context, String alarmSystem, long start, long stop, int severity) {
        return TAlarmSystem.getAlarms(context, null, alarmSystem, start, stop, severity);
    }

    public static TAlarmMessage[] getAlarmsFromServer(String context, String server, long start, long stop, int severity) {
        return TAlarmSystem.getAlarms(context, server, null, start, stop, severity);
    }

    public static TAlarmDefinition[] getAlarmDefinitions(String context, String server, int alarmCode) {
        if (context == null || server == null) {
            return null;
        }
        String dev = "/" + context + "/CAS/" + server;
        String prp = "SYSALMDEFS";
        int n = 100;
        TTaggedStructure[] d = new TAlarmDefinition[n];
        for (int i = 0; i < n; ++i) {
            d[i] = new TAlarmDefinition();
        }
        TDataType adst = new TDataType(d);
        int[] almcod = new int[]{alarmCode};
        TDataType act = alarmCode > 0 ? new TDataType(almcod) : new TDataType();
        TLink tl = new TLink(dev, prp, adst, act, 1);
        int cc = tl.execute(500, true);
        tl.close();
        if (cc != 0) {
            return null;
        }
        n = adst.getCompletionLength();
        if (n == 0 && alarmCode > 0) {
            TEquipmentModuleFactory.getInstance().registerStockAlarmDefinitions();
            d[0] = (TAlarmDefinition)TEquipmentModuleFactory.getInstance().getStockAlarmDefinitions().get(Integer.toString(alarmCode));
            if (d[0] != null) {
                n = 1;
            }
        }
        TAlarmDefinition[] ads = new TAlarmDefinition[n];
        for (int i = 0; i < n; ++i) {
            ads[i] = d[i];
        }
        return ads;
    }

    public static TAlarmDefinition[] getAlarmDefinitionsFromServer(String context, String server) {
        if (context == null || server == null) {
            return null;
        }
        String dev = "/" + context + "/" + server;
        String prp = "ALMDEFS";
        int n = 100;
        TTaggedStructure[] d = new TAlarmDefinition[n];
        TDataType adst = new TDataType(d);
        TLink tl = new TLink(dev, prp, adst, null, 1);
        int cc = tl.execute(500, true);
        tl.close();
        if (cc != 0) {
            return null;
        }
        n = adst.getCompletionLength();
        TAlarmDefinition[] ads = new TAlarmDefinition[n];
        for (int i = 0; i < n; ++i) {
            ads[i] = d[i];
        }
        return ads;
    }

    private static Vector<TAlarmMessage> getArchivedAlarmsVector(String context, String alarmSystem, String server, long start, long stop, int severity) {
        int n = 0;
        if (server == null) {
            return null;
        }
        CasSrvInfo si = TAlarmSystem.getAlarmServerServerInfo(context, server);
        if (si == null || si.getArchiveExtension().length() == 0) {
            return null;
        }
        String ext = si.getArchiveExtension();
        String dev = "/" + context + "/CAS.ARCHIVE/" + ext;
        int[] nevn = new int[1];
        TDataType dout = new TDataType(nevn);
        int[] stst = new int[]{(int)(start / 1000L), (int)(stop / 1000L)};
        TDataType sst = new TDataType(stst);
        TLink tl = new TLink(dev, "QUERY.NFILES", dout, sst, 1);
        int cc = tl.execute(500, true);
        tl.cancel();
        if (cc != 0) {
            return null;
        }
        n = nevn[0];
        if (n <= 0) {
            return null;
        }
        TCompoundDataObject[] evn = new NAME8[n];
        dout = new TDataType(evn);
        tl = new TLink(dev, "QUERY.FILES", dout, sst, 1);
        int to = n > 5000 ? 3000 : 1000;
        cc = tl.execute(to, true);
        tl.cancel();
        if (cc != 0) {
            return null;
        }
        int alarmSystemNumber = TAlarmSystem.getAlarmSystemNumber(context, alarmSystem);
        Vector<TAlarmMessage> v = new Vector<TAlarmMessage>();
        for (int i = 0; i < evn.length; ++i) {
            Object[] ams = TAlarmSystem.getArchivedAlarmsFromCAS(context, ext, ((NAME)((Object)evn[i])).getName(), "#0");
            if (ams == null) continue;
            Arrays.sort(ams);
            for (n = 0; n < ams.length; ++n) {
                if (((TAlarmMessage)ams[n]).getAlarmSeverity() < severity || alarmSystemNumber != 0 && ((TAlarmMessage)ams[n]).getAlarmSystem() != alarmSystemNumber) continue;
                v.addElement((TAlarmMessage)ams[n]);
            }
        }
        return v;
    }

    public static TAlarmMessage[] getArchivedServerAlarms(String context, String server, long start, long stop, int severity) {
        Vector<TAlarmMessage> v = TAlarmSystem.getArchivedAlarmsVector(context, null, server, start, stop, severity);
        return v != null ? v.toArray(new TAlarmMessage[v.size()]) : null;
    }

    public static TAlarmMessage[] getArchivedServerAlarms(String context, String alarmSystem, String server, long start, long stop, int severity) {
        Vector<TAlarmMessage> v = TAlarmSystem.getArchivedAlarmsVector(context, alarmSystem, server, start, stop, severity);
        return v != null ? v.toArray(new TAlarmMessage[v.size()]) : null;
    }

    public static TAlarmMessage[] getArchivedAlarms(String context, String alarmSystem, long start, long stop, int severity) {
        String[] srvs = TAlarmSystem.getAlarmServerServers(context, alarmSystem);
        if (srvs == null || srvs.length == 0) {
            return null;
        }
        Vector[] v = new Vector[srvs.length];
        int[] idx = new int[srvs.length];
        int nalms = 0;
        for (int i = 0; i < srvs.length; ++i) {
            v[i] = TAlarmSystem.getArchivedAlarmsVector(context, alarmSystem, srvs[i], start, stop, severity);
            if (v[i] == null) {
                idx[i] = -1;
                continue;
            }
            idx[i] = v[i].size() - 1;
            nalms += v[i].size();
        }
        if (nalms == 0) {
            return null;
        }
        Object[] ams = new TAlarmMessage[nalms];
        int off = 0;
        for (int i = 0; i < v.length; ++i) {
            if (v[i] == null) continue;
            int siz = v[i].size();
            TAlarmMessage[] aa = v[i].toArray(new TAlarmMessage[siz]);
            System.arraycopy(aa, 0, ams, off, siz);
            off += siz;
        }
        Arrays.sort(ams);
        return ams;
    }

    private static int getSessionId(String context, String extension, String event) {
        if (extension == null || event == null) {
            return -1;
        }
        String srv = extension;
        String dev = "/" + context + "/CAS.ARCHIVE/" + srv;
        boolean isNew = false;
        int cc = 0;
        if (sessionId < 0) {
            isNew = true;
        } else if (sessionEvent == null || sessionEvent.compareTo(event) != 0) {
            isNew = true;
        } else if (sessionGroup == null || sessionGroup.compareTo(extension) != 0) {
            isNew = true;
        }
        if (isNew) {
            TLink tl;
            short[] id = new short[]{(short)sessionId};
            TDataType din = new TDataType(id);
            if (sessionId > 0) {
                tl = new TLink(dev, "CLOSE", null, din, 1);
                cc = tl.execute(500, true);
                tl.close();
                if (cc != 0) {
                    return -1;
                }
            }
            TCompoundDataObject[] e = new NAME8[]{new NAME8(event)};
            din = new TDataType(e);
            TDataType dout = new TDataType(id);
            tl = new TLink(dev, "OPEN", dout, din, 1);
            cc = tl.execute(500, true);
            tl.close();
            if (cc != 0) {
                return -1;
            }
            sessionId = id[0];
        }
        return sessionId;
    }

    private static synchronized TAlarmMessage[] getArchivedAlarmsFromCAS(String context, String extension, String event, String device) {
        int sid = TAlarmSystem.getSessionId(context, extension, event);
        int evn = Integer.parseInt(event, 16);
        TTaggedStructure[] apc = new ApcBlk[]{new ApcBlk(sid, evn, context, "CAS", device, "NUMALARMS", 1, 1, "")};
        TDataType din = new TDataType(apc);
        int[] nalm = new int[1];
        TDataType dout = new TDataType(nalm);
        String dev = "/" + context + "/CAS.ARCHIVE/" + device;
        TLink tl = new TLink(dev, "READDATA", dout, din, 1);
        int cc = tl.execute(500, true);
        tl.close();
        if (cc != 0) {
            return null;
        }
        int n = nalm[0];
        int to = n > 5000 ? 3000 : 1000;
        apc[0] = new ApcBlk(sid, evn, context, "CAS", device, "SYSALARMS", n, 7, "AMSr4");
        din.putData(apc);
        TTaggedStructure[] a = new TAlarmMessage[n];
        for (int i = 0; i < n; ++i) {
            a[i] = new TAlarmMessage();
        }
        dout = new TDataType(a);
        tl = new TLink(dev, "READDATA", dout, din, 1);
        cc = tl.execute(to, true);
        tl.close();
        if (cc != 0) {
            return null;
        }
        return a;
    }

    public static int getArchivedNumberOfAlarms(String context, String server, String alarmSystem, long start, long stop) {
        int n = 0;
        String[] srvs = server != null && server.compareToIgnoreCase("CAS") != 0 ? new String[]{server} : TAlarmSystem.getAlarmServerServers(context, alarmSystem);
        if (srvs == null || srvs.length == 0) {
            return 0;
        }
        int nalms = 0;
        for (int i = 0; i < srvs.length; ++i) {
            CasSrvInfo si = TAlarmSystem.getAlarmServerServerInfo(context, srvs[i]);
            if (si == null || si.getArchiveExtension().length() == 0) continue;
            String ext = si.getArchiveExtension();
            String dev = "/" + context + "/CAS.ARCHIVE/" + ext;
            int[] nevn = new int[1];
            TDataType dout = new TDataType(nevn);
            int[] stst = new int[]{(int)(start / 1000L), (int)(stop / 1000L)};
            TDataType sst = new TDataType(stst);
            TLink tl = new TLink(dev, "QUERY.NFILES", dout, sst, 1);
            int cc = tl.execute(500, true);
            tl.cancel();
            if (cc != 0) break;
            n = nevn[0];
            if (n <= 0) continue;
            TCompoundDataObject[] evn = new NAME8[n];
            dout = new TDataType(evn);
            tl = new TLink(dev, "QUERY.FILES", dout, sst, 1);
            int to = n > 5000 ? 3000 : 1000;
            cc = tl.execute(to, true);
            tl.cancel();
            if (cc != 0) break;
            n = 0;
            for (int k = 0; k < evn.length; ++k) {
                n += TAlarmSystem.getArchivedNumberOfAlarmsFromCAS(context, ext, ((NAME)((Object)evn[k])).getName(), "#0");
            }
            nalms += n;
        }
        return nalms;
    }

    private static synchronized int getArchivedNumberOfAlarmsFromCAS(String context, String extension, String event, String device) {
        int sid = TAlarmSystem.getSessionId(context, extension, event);
        int evn = Integer.parseInt(event, 16);
        TTaggedStructure[] apc = new ApcBlk[]{new ApcBlk(sid, evn, context, "CAS", device, "NUMALARMS", 1, 1, "")};
        TDataType din = new TDataType(apc);
        int[] nalm = new int[1];
        TDataType dout = new TDataType(nalm);
        String dev = "/" + context + "/CAS.ARCHIVE/" + device;
        TLink tl = new TLink(dev, "READDATA", dout, din, 1);
        int cc = tl.execute(500, true);
        tl.close();
        if (cc != 0) {
            return 0;
        }
        return nalm[0];
    }
}

