/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.alarmUtils;

import de.desy.tine.alarmUtils.AlarmMonitor;
import de.desy.tine.alarmUtils.AlarmMonitorHandler;
import de.desy.tine.alarmUtils.TAlarmSystem;
import de.desy.tine.client.TLink;
import de.desy.tine.client.TLinkCallback;
import de.desy.tine.client.TLinkFactory;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TErrorList;
import de.desy.tine.server.alarms.TAlarmMessage;
import de.desy.tine.server.logger.DbgLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;

public class AlarmMonitorCallback
implements TLinkCallback {
    private long alarmDepth = 0x6DDD00L;
    private long timeNow = 0L;
    private String ctx;
    private String srv = null;
    private String sys;
    private int sev = 7;
    private long lastAcquired = 0L;
    private long lastNotified = 0L;
    private long lastAcquiredByCaller = 0L;
    private int lastAcquiredTableEntry = -1;
    private LinkedList<TAlarmMessage[]> almTbl = new LinkedList();
    private TAlarmMessage[] alms = null;
    private int linkStatus;
    private long almTimeStamp = 0L;
    private AlarmMonitorHandler almHandler = null;
    private AlarmMonitor almMonitor = null;
    private boolean almStateChanged = false;
    private boolean includeTerminated = false;
    private boolean needsToNotify = false;
    private GetAlarmsCallback getAlarmsCallback = new GetAlarmsCallback();
    private int idleCount = 0;
    private int waitPendingCount = 0;
    private int linkErrors = 0;
    private static final int ERROR_THRESHOLD = 5;

    public void setAlarmMonitorHandler(AlarmMonitorHandler myHandler) {
        this.almHandler = myHandler;
    }

    public void setAlarmMonitor(AlarmMonitor myMonitor) {
        this.almMonitor = myMonitor;
        if (this.almMonitor != null) {
            this.almHandler = this.almMonitor.getAmHdlr();
        }
    }

    public AlarmMonitorCallback(String context, String server, String system, int severity) {
        this.ctx = context;
        this.srv = server;
        this.sys = system;
        this.sev = severity;
    }

    private long getAlarmSetTimeStamp(TAlarmMessage[] almset) {
        if (almset == null) {
            return 0L;
        }
        long ts = 0L;
        for (int i = 0; i < almset.length; ++i) {
            long ats = almset[i].getTimeStamp();
            if (ats <= ts) continue;
            ts = ats;
        }
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAlarmList(TAlarmMessage[] newAlarms) {
        this.almStateChanged = true;
        LinkedList<TAlarmMessage[]> linkedList = this.almTbl;
        synchronized (linkedList) {
            if (!this.isIncludeTerminated()) {
                this.almTbl.clear();
                this.lastAcquiredTableEntry = -1;
            }
            if (newAlarms != null) {
                this.almTbl.add(newAlarms);
            }
            ArrayList<TAlarmMessage> almsets = new ArrayList<TAlarmMessage>();
            ListIterator<TAlarmMessage[]> it = this.almTbl.listIterator(0);
            TAlarmMessage aref = null;
            while (it.hasNext()) {
                TAlarmMessage[] m = it.next();
                if (this.getAlarmSetTimeStamp(m) > this.timeNow - this.alarmDepth) {
                    for (int i = 0; i < m.length; ++i) {
                        if (m[i].isInstanceOf(aref) && m[i].getTimeStamp() == aref.getTimeStamp()) continue;
                        almsets.add(m[i]);
                    }
                    if (m.length <= 0) continue;
                    aref = m[0];
                    continue;
                }
                this.almStateChanged = true;
                it.remove();
                if (this.lastAcquiredTableEntry < 0) continue;
                --this.lastAcquiredTableEntry;
            }
            this.alms = almsets.size() > 0 ? almsets.toArray(new TAlarmMessage[almsets.size()]) : null;
        }
    }

    private void notifyCaller() {
        this.needsToNotify = false;
        this.lastNotified = this.lastAcquired;
        if (this.almHandler != null) {
            this.almHandler.alarmsHandler(this.almMonitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void callback(TLink link) {
        this.linkStatus = link.getLinkStatus();
        if (this.linkStatus != 0) {
            if (TLinkFactory.debugLevel > 0) {
                DbgLog.log("AlarmMonitorCallback", link.devName + " alarm monitor callback : " + TErrorList.getErrorString(this.linkStatus));
            }
            if (this.linkErrors++ <= 5) return;
            this.almMonitor.setConnectionStatus(this.linkStatus);
            this.notifyCaller();
            this.linkErrors = 0;
            return;
        }
        this.almMonitor.setConnectionStatus(0);
        this.linkErrors = 0;
        if (this.getAlarmsCallback.pending) {
            ++this.waitPendingCount;
            if (TLinkFactory.debugLevel <= 0) return;
            DbgLog.log("AlarmMonitorCallback", link.devName + " still acquiring last alarm set");
            return;
        }
        if (TLinkFactory.debugLevel > 0 && this.waitPendingCount > 0) {
            DbgLog.log("AlarmMonitorCallback", link.devName + " acquiring new alarm set after " + this.waitPendingCount + " attempts");
        }
        this.waitPendingCount = 0;
        boolean acquire = false;
        long thisTimeStamp = link.getLastTimeStamp();
        if (thisTimeStamp > this.almTimeStamp) {
            acquire = true;
            if (TLinkFactory.debugLevel > 0) {
                DbgLog.log("AlarmMonitorCallback", link.devName + " signal reason to acquire new alarm set (timestamp " + thisTimeStamp + " vs " + this.almTimeStamp + ")");
            }
            this.idleCount = 0;
        } else if (this.includeTerminated) {
            ++this.idleCount;
            if (this.idleCount > 60) {
                this.needsToNotify = true;
            }
        }
        TDataType dt = link.getOutputDataObject();
        int[] n = new int[dt.getArrayLength()];
        dt.getData(n);
        LinkedList<TAlarmMessage[]> linkedList = this.almTbl;
        synchronized (linkedList) {
            block28: {
                this.almStateChanged = false;
                this.timeNow = thisTimeStamp;
                if (this.includeTerminated) {
                    if (n[0] > 0) {
                        if (acquire) {
                            if (TLinkFactory.debugLevel > 0) {
                                DbgLog.log("AlarmMonitorCallback", link.devName + " acquiring new alarm set (" + n[0] + " alarms");
                            }
                            if (this.lastAcquired == 0L) {
                                this.lastAcquired = this.timeNow - this.alarmDepth;
                            }
                            this.getAlarmsCallback.pending = true;
                            this.getAlarmsCallback.ams = TAlarmSystem.getAlarmsAsync(n[0], this.ctx, this.srv, this.sys, this.lastAcquired, this.timeNow, this.sev, this.includeTerminated, this.getAlarmsCallback);
                            if (this.getAlarmsCallback.ams != null) return;
                            DbgLog.log("AlarmMonitorCallback", "getAlarmsAsync failed !");
                            this.getAlarmsCallback.pending = false;
                            break block28;
                        } else {
                            if (!this.needsToNotify) return;
                            if (TLinkFactory.debugLevel > 0) {
                                DbgLog.log("AlarmMonitorCallback", link.devName + " notifying caller of results");
                            }
                            this.notifyCaller();
                            return;
                        }
                    }
                    if (acquire) {
                        if (TLinkFactory.debugLevel > 0) {
                            DbgLog.log("AlarmMonitorCallback", link.devName + " no new alarms to acquire (alarms to remove!)");
                        }
                        if (!this.needsToNotify) {
                            this.lastAcquired = this.timeNow;
                        }
                        this.updateAlarmList(null);
                        this.needsToNotify = true;
                        this.almTimeStamp = thisTimeStamp;
                        break block28;
                    } else {
                        if (!this.needsToNotify) return;
                        if (TLinkFactory.debugLevel > 0) {
                            DbgLog.log("AlarmMonitorCallback", link.devName + " notifying caller of results");
                        }
                        this.notifyCaller();
                        return;
                    }
                }
                if (n[1] > 0) {
                    if (!acquire) {
                        if (!this.needsToNotify) return;
                        this.notifyCaller();
                        return;
                    }
                    this.getAlarmsCallback.pending = true;
                    this.getAlarmsCallback.ams = TAlarmSystem.getAlarmsAsync(n[0], this.ctx, this.srv, this.sys, this.timeNow - this.alarmDepth, this.timeNow, this.sev, this.includeTerminated, this.getAlarmsCallback);
                    if (this.getAlarmsCallback.ams != null) return;
                    DbgLog.log("AlarmMonitorCallback", "getAlarmsAsync failed !");
                    this.getAlarmsCallback.pending = false;
                } else {
                    if (!acquire) {
                        if (!this.needsToNotify) return;
                        this.notifyCaller();
                        return;
                    }
                    if (!this.needsToNotify) {
                        this.lastAcquired = this.timeNow;
                    }
                    this.updateAlarmList(null);
                    this.needsToNotify = true;
                }
            }
            return;
        }
    }

    public TAlarmMessage[] getAlarms() {
        return this.alms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TAlarmMessage[] getLastAcquiredAlarms() {
        LinkedList<TAlarmMessage[]> linkedList = this.almTbl;
        synchronized (linkedList) {
            int last;
            int nalmSets = this.almTbl.size();
            int first = this.lastAcquiredTableEntry;
            if (this.idleCount > 60) {
                this.idleCount = 0;
                first = nalmSets - 2;
                if (TLinkFactory.debugLevel > 0) {
                    DbgLog.log("getLastAcquiredAlarms", this.getSubsystem() + " idle period -> check last alarm set again");
                }
            }
            if (nalmSets == 0) {
                return null;
            }
            if (first > nalmSets - 1) {
                DbgLog.log("getLastAcquiredAlarms", this.getSubsystem() + " last acquired index " + first + " larger than alarm table size : " + this.almTbl.size());
                first = 0;
            }
            if ((last = nalmSets - 1) < 0) {
                last = 0;
            }
            if (first < 0) {
                first = 0;
            }
            ArrayList<TAlarmMessage> lastLst = new ArrayList<TAlarmMessage>();
            ListIterator<TAlarmMessage[]> it = this.almTbl.listIterator(first);
            while (it.hasNext()) {
                TAlarmMessage[] m = it.next();
                for (int i = 0; i < m.length; ++i) {
                    lastLst.add(m[i]);
                }
            }
            this.lastAcquiredTableEntry = last;
            return lastLst.toArray(new TAlarmMessage[lastLst.size()]);
        }
    }

    public String getContext() {
        return this.ctx;
    }

    public long getLastAcquired() {
        return this.lastAcquired;
    }

    public String getServer() {
        return this.srv;
    }

    public String getSubsystem() {
        return this.sys;
    }

    public boolean isIncludeTerminated() {
        return this.includeTerminated;
    }

    public void setIncludeTerminated(boolean includeTerminated) {
        this.includeTerminated = includeTerminated;
    }

    private class GetAlarmsCallback
    implements TLinkCallback {
        TAlarmMessage[] ams = null;
        public boolean pending = false;
        protected int lastnalarms = 0;

        private GetAlarmsCallback() {
        }

        public void setAlarms(TAlarmMessage[] ams) {
            this.ams = ams;
        }

        public TAlarmMessage[] getAlarms() {
            return this.ams;
        }

        public void callback(TLink link) {
            int cc = link.getLinkStatus();
            if (cc != 0) {
                DbgLog.log("GetAlarmsCallback", "getAlarms for " + link.getDeviceName() + " failed : " + TErrorList.getErrorString(cc));
                this.ams = null;
            } else {
                int nret;
                AlarmMonitorCallback.this.almTimeStamp = AlarmMonitorCallback.this.timeNow;
                AlarmMonitorCallback.this.lastAcquired = AlarmMonitorCallback.this.timeNow;
                TDataType amst = link.getOutputDataObject();
                int n = amst.getArrayLength();
                this.lastnalarms = nret = amst.getCompletionLength();
                if (TLinkFactory.debugLevel > 0) {
                    DbgLog.log("GetAlarmsCallback", "getAlarms for " + link.getDeviceName() + " : " + nret + " alarms returned ");
                }
                if (nret == 0) {
                    this.ams = null;
                } else if (nret < n) {
                    TAlarmMessage[] a = new TAlarmMessage[nret];
                    for (int i = 0; i < nret; ++i) {
                        a[i] = this.ams[i];
                    }
                    this.ams = a;
                }
                if (this.ams != null) {
                    Arrays.sort(this.ams);
                }
                AlarmMonitorCallback.this.updateAlarmList(this.ams);
                if (AlarmMonitorCallback.this.almStateChanged) {
                    AlarmMonitorCallback.this.needsToNotify = true;
                }
            }
            this.pending = false;
            link.close();
        }
    }
}

