/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.alarmUtils;

import de.desy.tine.alarmUtils.AlarmMonitorCallback;
import de.desy.tine.alarmUtils.AlarmMonitorHandler;
import de.desy.tine.server.alarms.TAlarmMessage;
import java.util.Vector;

public class AlarmMonitor {
    private int connectionStatus = 0;
    private AlarmMonitorCallback amcb = null;
    private AlarmMonitorHandler amHdlr = null;

    public AlarmMonitor(AlarmMonitorHandler myAlarmsHandler) {
        this.amHdlr = myAlarmsHandler;
    }

    public TAlarmMessage[] getAlarms() {
        return this.amcb == null ? null : this.amcb.getAlarms();
    }

    private TAlarmMessage[] getPrunedAlarmList(TAlarmMessage[] lst, int minSeverity, boolean activeOnly) {
        if (lst == null) {
            return null;
        }
        Vector<TAlarmMessage> av = new Vector<TAlarmMessage>();
        for (TAlarmMessage a : lst) {
            if (a.getAlarmSeverity() < minSeverity || activeOnly && !a.isActive()) continue;
            av.add(a);
        }
        if (av.size() == 0) {
            return null;
        }
        return av.toArray(new TAlarmMessage[av.size()]);
    }

    public TAlarmMessage[] getAlarms(int minSeverity, boolean activeOnly) {
        if (this.amcb == null) {
            return null;
        }
        return this.getPrunedAlarmList(this.amcb.getAlarms(), minSeverity, activeOnly);
    }

    public TAlarmMessage[] getLastAcquiredAlarms() {
        return this.amcb == null ? null : this.amcb.getLastAcquiredAlarms();
    }

    public TAlarmMessage[] getLastAcquiredAlarms(int minSeverity, boolean activeOnly) {
        if (this.amcb == null) {
            return null;
        }
        return this.getPrunedAlarmList(this.amcb.getLastAcquiredAlarms(), minSeverity, activeOnly);
    }

    public long getLastAcquiredAlarmTime() {
        return this.amcb == null ? 0L : this.amcb.getLastAcquired();
    }

    public String getContext() {
        return this.amcb == null ? null : this.amcb.getContext();
    }

    public String getServer() {
        return this.amcb == null ? null : this.amcb.getServer();
    }

    public String getSubsystem() {
        return this.amcb == null ? null : this.amcb.getSubsystem();
    }

    public AlarmMonitorHandler getAmHdlr() {
        return this.amHdlr;
    }

    public void setAmHdlr(AlarmMonitorHandler myHandler) {
        this.amHdlr = myHandler;
    }

    protected void setAmcb(AlarmMonitorCallback amcb) {
        this.amcb = amcb;
    }

    public int getConnectionStatus() {
        return this.connectionStatus;
    }

    public void setConnectionStatus(int status) {
        this.connectionStatus = status;
    }
}

