/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.addrUtils;

import de.desy.tine.addrUtils.SrvAddr;
import de.desy.tine.client.TLink;
import de.desy.tine.csvUtils.csv;
import de.desy.tine.csvUtils.csvColumn;
import de.desy.tine.csvUtils.csvHandler;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.startup.TInitializerFactory;
import de.desy.tine.types.NAME;
import de.desy.tine.types.NAME32;
import de.desy.tine.types.TCompoundDataObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class TFecEntry {
    String fecName;
    csv fecFile;
    public static final short BCAST_ID = 255;
    public static final short ENS_ID = 4096;
    public short fecPortOffset;
    public boolean fecRegistered;
    public InetAddress fecHost;
    private int tineProtocol = 6;

    public TFecEntry(SrvAddr srv) {
        try {
            this.fecName = srv.fecName;
            this.fecHost = InetAddress.getByName(srv.ipAddr.trim());
            this.fecPortOffset = (short)srv.getPortOffset();
            this.tineProtocol = srv.tineProtocol;
            this.fecRegistered = true;
        }
        catch (UnknownHostException e) {
            System.err.println("cannot find host");
            this.fecRegistered = false;
        }
    }

    public TFecEntry(String name) {
        this.fecName = new String(name);
        try {
            if (name.compareTo("ENS") == 0) {
                this.fecHost = InetAddress.getByName(TInitializerFactory.getInstance().getInitializer().getENSAddress());
                this.fecPortOffset = 0;
                this.fecRegistered = true;
            }
        }
        catch (UnknownHostException e) {
            System.err.println("cannot find host");
            this.fecRegistered = false;
        }
    }

    public TFecEntry(BufferedReader in, String name) {
        if (in == null) {
            this.fecRegistered = false;
            return;
        }
        csvColumn[] srvCols = new csvColumn[]{new csvColumn("FEC_NAME", "", new fecNameHndlr(name)), new csvColumn("IP_ADDR", "", new ipAddrHndlr()), new csvColumn("PORT_OFFSET", "0", new portHndlr()), new csvColumn("TINE_PROTOCOL", "6", new protHndlr())};
        this.fecFile = new csv(in);
        this.fecFile.readFile(srvCols);
        this.fecFile.close();
    }

    public int getTineProtocol() {
        return this.tineProtocol;
    }

    public void setTineProtocol(int tineProtocol) {
        this.tineProtocol = tineProtocol;
    }

    public fecImportance getImportance() {
        return TFecEntry.getImportance(this.fecName);
    }

    public static synchronized fecImportance getImportance(String fecName) {
        String importance = null;
        TCompoundDataObject[] tgt = new NAME32[]{new NAME32(fecName)};
        TCompoundDataObject[] imp = new NAME32[1];
        TDataType din = new TDataType(tgt);
        TDataType dout = new TDataType(imp);
        TLink tl = new TLink("/SITE/ENS", "IMPORTANCE", dout, din, 1);
        int rc = tl.execute(500, true);
        tl.close();
        if (rc == 0) {
            importance = ((NAME)((Object)imp[0])).getName();
            if (importance.compareToIgnoreCase("ALL") == 0) {
                importance = "NONE";
            }
        } else {
            importance = "NONE";
        }
        return fecImportance.valueOf(importance);
    }

    public int setImportance(fecImportance importance) {
        return TFecEntry.setImportance(this.fecName, importance);
    }

    public static synchronized int setImportance(String fecName, fecImportance importance) {
        TCompoundDataObject[] tgt = new NAME32[]{new NAME32(fecName), new NAME32(importance.name())};
        TDataType din = new TDataType(tgt);
        TLink tl = new TLink("/SITE/ENS", "IMPORTANCE", null, din, 2);
        int rc = tl.execute(500, true);
        tl.close();
        return rc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum fecImportance {
        NONE,
        IMPORTANT,
        ESSENTIAL,
        CRITICAL;

    }

    class protHndlr
    implements csvHandler {
        protHndlr() {
        }

        public int process(String strValue, int index) {
            TFecEntry.this.tineProtocol = new Integer(strValue);
            return 0;
        }
    }

    class portHndlr
    implements csvHandler {
        portHndlr() {
        }

        public int process(String strValue, int index) {
            TFecEntry.this.fecPortOffset = (short)new Integer(strValue).intValue();
            return 0;
        }
    }

    class ipAddrHndlr
    implements csvHandler {
        ipAddrHndlr() {
        }

        public int process(String strValue, int index) {
            try {
                TFecEntry.this.fecHost = InetAddress.getByName(strValue);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return 0;
        }
    }

    class fecNameHndlr
    implements csvHandler {
        String target;

        fecNameHndlr(String name) {
            this.target = name;
        }

        public int process(String strValue, int index) {
            if (strValue.compareTo(this.target) == 0) {
                TFecEntry.this.fecName = new String(this.target);
                TFecEntry.this.fecRegistered = true;
                return -1;
            }
            return 0;
        }
    }
}

