/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.addrUtils;

import de.desy.tine.server.logger.MsgLog;
import de.desy.tine.server.properties.TStockProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FECInfo {
    private String os;
    private String desc;
    private String loc;
    private String hdw;
    private String ver;
    private String resp;
    private static int sizeInBytes = 208;

    public static int getSizeInBytes() {
        return sizeInBytes;
    }

    public FECInfo(String fecOS, String fecDescription, String fecLocation, String fecHardware, String fecVersion, String responsiblePersons) {
        this.os = fecOS.trim();
        this.desc = fecDescription.trim();
        this.loc = fecLocation.trim();
        this.hdw = fecHardware.trim();
        this.ver = fecVersion.trim();
        this.resp = responsiblePersons.trim();
    }

    public FECInfo(String fecOS, String fecDescription, String fecLocation, String fecHardware, String responsiblePersons) {
        this.os = fecOS.trim();
        this.desc = fecDescription.trim();
        this.loc = fecLocation.trim();
        this.hdw = fecHardware.trim();
        this.ver = TStockProperties.getStockSrvVersion().trim();
        this.resp = responsiblePersons.trim();
    }

    private void pushStringToBytes(String s, byte[] b, int maxlen) {
        int len;
        if (s != null) {
            len = s.length();
            if (len > maxlen) {
                len = maxlen;
            }
            System.arraycopy(s.getBytes(), 0, b, 0, len);
        } else {
            len = 0;
        }
        for (int i = len; i < maxlen; ++i) {
            b[i] = 0;
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(sizeInBytes);
        try {
            DataOutputStream ds = new DataOutputStream(dBuffer);
            byte[] bstr = new byte[64];
            this.pushStringToBytes(this.os, bstr, 16);
            ds.write(bstr, 0, 16);
            this.pushStringToBytes(this.desc, bstr, 64);
            ds.write(bstr, 0, 64);
            this.pushStringToBytes(this.loc, bstr, 48);
            ds.write(bstr, 0, 48);
            this.pushStringToBytes(this.ver, bstr, 16);
            ds.write(bstr, 0, 16);
            this.pushStringToBytes(this.hdw, bstr, 32);
            ds.write(bstr, 0, 32);
            this.pushStringToBytes(this.resp, bstr, 32);
            ds.write(bstr, 0, 32);
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("FECInfo", "could not prepare byte stream", 66, e, 0);
            return null;
        }
        return dBuffer.toByteArray();
    }

    public void toStruct(byte[] hByteArray) {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            byte[] bstr = new byte[64];
            ds.read(bstr, 0, 16);
            this.os = new String(bstr);
            ds.read(bstr, 0, 64);
            this.desc = new String(bstr);
            ds.read(bstr, 0, 48);
            this.loc = new String(bstr);
            ds.read(bstr, 0, 16);
            this.ver = new String(bstr);
            ds.read(bstr, 0, 32);
            this.hdw = new String(bstr);
            ds.read(bstr, 0, 32);
            this.resp = new String(bstr);
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("FECInfo", "could not prepare byte stream", 66, e, 0);
        }
    }

    public String toString() {
        String msg = new String("FEC os   : " + this.os);
        msg = msg.concat("\nFEC loc  : " + this.loc);
        msg = msg.concat("\nFEC hdw  : " + this.hdw);
        msg = msg.concat("\nFEC ver  : " + this.ver);
        msg = msg.concat("\nFEC resp : " + this.resp);
        msg = msg.concat("\nFEC desc : " + this.desc);
        return msg;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getHardware() {
        return this.hdw;
    }

    public String getHdw() {
        return this.hdw;
    }

    public String getLocation() {
        return this.loc;
    }

    public String getLoc() {
        return this.loc;
    }

    public String getOs() {
        return this.os;
    }

    public String getRespible() {
        return this.resp;
    }

    public String getResp() {
        return this.resp;
    }

    public String getVersion() {
        return this.ver;
    }

    public String getVer() {
        return this.ver;
    }
}

