/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.jni;

import gov.aps.jca.CAException;
import gov.aps.jca.CAStatus;
import gov.aps.jca.Channel;
import gov.aps.jca.JCALibrary;
import gov.aps.jca.TimeoutException;
import gov.aps.jca.Version;
import gov.aps.jca.configuration.Configurable;
import gov.aps.jca.configuration.Configuration;
import gov.aps.jca.configuration.ConfigurationException;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.event.ConnectionListener;
import gov.aps.jca.event.EventDispatcher;
import gov.aps.jca.event.GetListener;
import gov.aps.jca.event.MonitorListener;
import gov.aps.jca.event.PutListener;
import gov.aps.jca.jni.JNI;
import gov.aps.jca.jni.JNIAccessRightsCallback;
import gov.aps.jca.jni.JNIChannel;
import gov.aps.jca.jni.JNIConnectionCallback;
import gov.aps.jca.jni.JNIContext;
import gov.aps.jca.jni.JNIContextExceptionCallback;
import gov.aps.jca.jni.JNIContextMessageCallback;
import gov.aps.jca.jni.JNIException;
import gov.aps.jca.jni.JNIGetCallback;
import gov.aps.jca.jni.JNIMonitor;
import gov.aps.jca.jni.JNIMonitorCallback;
import gov.aps.jca.jni.JNIPutCallback;
import java.util.ArrayList;
import java.util.Iterator;

public final class SingleThreadedContext
extends JNIContext
implements Configurable {
    protected ArrayList _threadList = new ArrayList();
    public static final Version VERSION = new Version("JNI/SingleThreadedContext Channel Access", "Java w/ JNI using native C++ code", JCALibrary.getInstance().getVersion(), JCALibrary.getInstance().getRevision(), JCALibrary.getInstance().getModification(), 0);
    protected ArrayList _GetQueue = new ArrayList();
    static /* synthetic */ Class class$gov$aps$jca$jni$SingleThreadedContext$Get;

    public Version getVersion() {
        return VERSION;
    }

    public SingleThreadedContext() {
        String cn = SingleThreadedContext.class.getName();
        JCALibrary jca = JCALibrary.getInstance();
        this.setPreemptiveCallback(jca.getPropertyAsBoolean(cn + ".preemptive_callback", this.getPreemptiveCallback()));
        this.setAddrList(jca.getProperty(cn + ".addr_list", this.getAddrList()));
        this.setAutoAddrList(jca.getPropertyAsBoolean(cn + ".auto_addr_list", this.getAutoAddrList()));
        this.setConnectionTimeout(jca.getPropertyAsFloat(cn + ".connection_timeout", this.getConnectionTimeout()));
        this.setBeaconPeriod(jca.getPropertyAsFloat(cn + ".beacon_period", this.getBeaconPeriod()));
        this.setRepeaterPort(jca.getPropertyAsInt(cn + ".repeater_port", this.getRepeaterPort()));
        this.setServerPort(jca.getPropertyAsInt(cn + ".server_port", this.getServerPort()));
        this.setMaxArrayBytes(jca.getPropertyAsInt(cn + ".max_array_bytes", this.getMaxArrayBytes()));
        try {
            EventDispatcher ed = (EventDispatcher)Class.forName(jca.getProperty(cn + ".event_dispatcher", "")).newInstance();
            this.setEventDispatcher(ed);
        }
        catch (ClassNotFoundException ex1) {
        }
        catch (IllegalAccessException ex1) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }

    public void configure(Configuration conf) throws ConfigurationException {
        boolean preemptive_callback = this.getPreemptiveCallback();
        try {
            preemptive_callback = conf.getChild("preemptive_callback", false).getValueAsBoolean();
        }
        catch (Exception ex) {
            preemptive_callback = conf.getAttributeAsBoolean("preemptive_callback", preemptive_callback);
        }
        this.setPreemptiveCallback(preemptive_callback);
        String addr_list = this.getAddrList();
        try {
            addr_list = conf.getChild("addr_list", false).getValue();
        }
        catch (Exception ex) {
            addr_list = conf.getAttribute("addr_list", addr_list);
        }
        this.setAddrList(addr_list);
        boolean auto_addr_list = this.getAutoAddrList();
        try {
            auto_addr_list = conf.getChild("auto_addr_list", false).getValueAsBoolean();
        }
        catch (Exception ex) {
            auto_addr_list = conf.getAttributeAsBoolean("auto_addr_list", auto_addr_list);
        }
        this.setAutoAddrList(auto_addr_list);
        float connection_timeout = this.getConnectionTimeout();
        try {
            connection_timeout = conf.getChild("connection_timeout", false).getValueAsFloat();
        }
        catch (Exception ex) {
            connection_timeout = conf.getAttributeAsFloat("connection_timeout", connection_timeout);
        }
        this.setConnectionTimeout(connection_timeout);
        float beacon_period = this.getBeaconPeriod();
        try {
            beacon_period = conf.getChild("beacon_period", false).getValueAsFloat();
        }
        catch (Exception ex) {
            beacon_period = conf.getAttributeAsFloat("beacon_period", beacon_period);
        }
        this.setBeaconPeriod(beacon_period);
        int repeater_port = this.getRepeaterPort();
        try {
            repeater_port = conf.getChild("repeater_port", false).getValueAsInteger();
        }
        catch (Exception ex) {
            repeater_port = conf.getAttributeAsInteger("repeater_port", repeater_port);
        }
        this.setRepeaterPort(repeater_port);
        int server_port = this.getServerPort();
        try {
            server_port = conf.getChild("server_port", false).getValueAsInteger();
        }
        catch (Exception ex) {
            server_port = conf.getAttributeAsInteger("server_port", server_port);
        }
        this.setServerPort(server_port);
        int max_array_bytes = this.getMaxArrayBytes();
        try {
            max_array_bytes = conf.getChild("max_array_bytes", false).getValueAsInteger();
        }
        catch (Exception ex) {
            max_array_bytes = conf.getAttributeAsInteger("max_array_bytes", max_array_bytes);
        }
        this.setMaxArrayBytes(max_array_bytes);
        try {
            Configuration evConf = conf.getChild("event_dispatcher", false);
            if (evConf == null) {
                return;
            }
            String evClass = evConf.getAttribute("class");
            EventDispatcher event_dispatcher = (EventDispatcher)Class.forName(evClass).newInstance();
            if (event_dispatcher instanceof Configurable) {
                ((Configurable)((Object)event_dispatcher)).configure(evConf);
            }
            this.setEventDispatcher(event_dispatcher);
        }
        catch (ConfigurationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigurationException("Unable to configure context", ex);
        }
    }

    protected long contextInitialize() throws CAException, IllegalStateException {
        this.assertState(!this.isInitialized(), "Context already initialized");
        this._threadList.add(Thread.currentThread());
        Object object = JNI.lock();
        synchronized (object) {
            try {
                JNI.setenv("EPICS_CA_ADDR_LIST", this._addr_list);
                JNI.setenv("EPICS_CA_AUTO_ADDR_LIST", this._auto_addr_list ? "YES" : "NO");
                JNI.setenv("EPICS_CA_CONN_TMO", "" + this._connection_timeout);
                JNI.setenv("EPICS_CA_BEACON_PERIOD", "" + this._beacon_period);
                JNI.setenv("EPICS_CA_REPEATER_PORT", "" + this._repeater_port);
                JNI.setenv("EPICS_CA_SERVER_PORT", "" + this._server_port);
                JNI.setenv("EPICS_CA_MAX_ARRAY_BYTES", "" + this._max_array_bytes);
                return JNI.ctxt_contextCreate(this._preemptive_callback);
            }
            catch (JNIException ex) {
                throw new CAException("Unable to initialize context", ex);
            }
        }
    }

    public void destroy() throws CAException, IllegalStateException {
        if (this.getCtxtID() == 0L) {
            return;
        }
        this.assertThread();
        super.destroy();
        try {
            JNI.ctxt_contextDestroy();
        }
        catch (JNIException jniex) {
            throw new CAException("Failed to destroy context", jniex);
        }
        finally {
            this.setCtxtID(0L);
        }
    }

    void setMessageCallback(JNIContextMessageCallback callback) throws CAException, IllegalStateException {
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        try {
            JNI.ctxt_setMessageCallback(callback);
        }
        catch (JNIException jniex) {
            throw new CAException("Failed to set message callback handler", jniex);
        }
    }

    void setExceptionCallback(JNIContextExceptionCallback callback) throws CAException, IllegalStateException {
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        try {
            JNI.ctxt_setExceptionCallback(callback);
        }
        catch (JNIException jniex) {
            throw new CAException("Failed to set context exception's handler", jniex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pendIO(double timeout) throws TimeoutException, CAException, IllegalStateException {
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        ArrayList arrayList = this._GetQueue;
        synchronized (arrayList) {
            try {
                JNI.ctxt_pendIO(timeout);
            }
            catch (JNIException ex) {
                if (ex.getStatus() == CAStatus.TIMEOUT) {
                    throw new TimeoutException("pendIO timed out", ex);
                }
                throw new CAException("pendIO failed", ex);
            }
            finally {
                this.clearGetQueue();
            }
        }
    }

    public boolean testIO() throws CAException, IllegalStateException {
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        try {
            return JNI.ctxt_testIO();
        }
        catch (JNIException ex) {
            throw new CAException("testIO failed", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pendEvent(double time) throws CAException, IllegalStateException {
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        ArrayList arrayList = this._GetQueue;
        synchronized (arrayList) {
            try {
                JNI.ctxt_pendEvent(time);
            }
            catch (JNIException ex) {
                throw new CAException("pendEvent failed", ex);
            }
            finally {
                this.clearGetQueue();
            }
        }
    }

    public void poll() throws CAException {
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        try {
            JNI.ctxt_poll();
        }
        catch (JNIException ex) {
            throw new CAException("poll failed", ex);
        }
    }

    public void flushIO() throws CAException {
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        try {
            JNI.ctxt_flushIO();
        }
        catch (JNIException ex) {
            throw new CAException("flushIO failed", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachCurrentThread() throws IllegalStateException {
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        if (this._threadList.contains(Thread.currentThread())) {
            return;
        }
        if (!this._preemptive_callback) {
            throw new IllegalStateException("Unable to attach thread. Preemptive callback is disabled");
        }
        try {
            JNI.ctxt_attachThread(this._ctxtID);
        }
        catch (JNIException jNIException) {
            // empty catch block
        }
        ArrayList arrayList = this._threadList;
        synchronized (arrayList) {
            this._threadList.add(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel createChannel(String name, ConnectionListener l, short priority) throws CAException, IllegalStateException {
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        if (name == null || (name = name.trim()).equals("")) {
            throw new IllegalArgumentException("Channel's name is null or empty");
        }
        if (priority < 0 || priority > 99) {
            throw new IllegalArgumentException("Priority out of bounds");
        }
        this.assertThread();
        JNIChannel channel = new JNIChannel(this, name, l, priority);
        JNIConnectionCallback callback = channel.getConnectionCallback();
        Object object = JNI.lock();
        synchronized (object) {
            JNI.setenv("EPICS_CA_ADDR_LIST", this._addr_list);
            JNI.setenv("EPICS_CA_AUTO_ADDR_LIST", this._auto_addr_list ? "YES" : "NO");
            JNI.setenv("EPICS_CA_CONN_TMO", "" + this._connection_timeout);
            JNI.setenv("EPICS_CA_BEACON_PERIOD", "" + this._beacon_period);
            JNI.setenv("EPICS_CA_REPEATER_PORT", "" + this._repeater_port);
            JNI.setenv("EPICS_CA_SERVER_PORT", "" + this._server_port);
            JNI.setenv("EPICS_CA_MAX_ARRAY_BYTES", "" + this._max_array_bytes);
            try {
                channel.setChannelID(JNI.ch_channelCreate(name, callback, priority));
            }
            catch (JNIException ex) {
                throw new CAException("createChannel failed", ex);
            }
        }
        this.registerChannel(channel);
        return channel;
    }

    void ch_channelDestroy(JNIChannel ch) throws JNIException {
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        JNI.ch_channelDestroy(ch.getChannelID());
    }

    void ch_setConnectionCallback(JNIChannel ch, JNIConnectionCallback cb) throws JNIException {
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        JNI.ch_setConnectionCallback(ch.getChannelID(), cb);
    }

    void ch_setAccessRightsCallback(JNIChannel ch, JNIAccessRightsCallback cb) throws JNIException {
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        JNI.ch_setAccessRightsCallback(ch.getChannelID(), cb);
    }

    int ch_getFieldType(JNIChannel ch) {
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        return JNI.ch_getFieldType(ch.getChannelID());
    }

    int ch_getElementCount(JNIChannel ch) {
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        return JNI.ch_getElementCount(ch.getChannelID());
    }

    int ch_getState(JNIChannel ch) {
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        return JNI.ch_getState(ch.getChannelID());
    }

    String ch_getHostName(JNIChannel ch) {
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        return JNI.ch_getHostName(ch.getChannelID());
    }

    boolean ch_getReadAccess(JNIChannel ch) {
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        return JNI.ch_getReadAccess(ch.getChannelID());
    }

    boolean ch_getWriteAccess(JNIChannel ch) {
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        return JNI.ch_getWriteAccess(ch.getChannelID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ch_arrayPut(DBRType type, int count, JNIChannel ch, Object value) throws JNIException {
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        long dbrid = JNI.dbr_create(type.getValue(), count);
        JNI.dbr_setValue(dbrid, type.getValue(), count, value);
        try {
            JNI.ch_arrayPut(type.getValue(), count, ch.getChannelID(), dbrid);
        }
        finally {
            JNI.dbr_destroy(dbrid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ch_arrayPut(DBRType type, int count, JNIChannel ch, Object value, PutListener l) throws JNIException {
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        JNIPutCallback callback = new JNIPutCallback(ch, this._eventDispatcher, l);
        long dbrid = JNI.dbr_create(type.getValue(), count);
        JNI.dbr_setValue(dbrid, type.getValue(), count, value);
        try {
            JNI.ch_arrayPutCallback(type.getValue(), count, ch.getChannelID(), dbrid, callback);
        }
        finally {
            JNI.dbr_destroy(dbrid);
        }
    }

    protected void clearGetQueue() {
        Iterator it = this._GetQueue.iterator();
        while (it.hasNext()) {
            try {
                ((Get)it.next()).update();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        this._GetQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ch_arrayGet(DBR dbr, JNIChannel ch) throws JNIException {
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        int type = dbr.getType().getValue();
        int count = dbr.getCount();
        long dbrid = JNI.dbr_create(type, count);
        ArrayList arrayList = this._GetQueue;
        synchronized (arrayList) {
            this._GetQueue.add(new Get(dbr, dbrid));
            JNI.ch_arrayGet(type, count, ch.getChannelID(), dbrid);
        }
    }

    void ch_arrayGet(DBRType type, int count, JNIChannel ch, GetListener l) throws JNIException {
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        JNIGetCallback callback = new JNIGetCallback(ch, this._eventDispatcher, l);
        JNI.ch_arrayGetCallback(type.getValue(), count, ch.getChannelID(), callback);
    }

    JNIMonitor ch_addMonitor(DBRType type, int count, JNIChannel ch, MonitorListener l, int mask) throws JNIException {
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        JNIMonitor res = new JNIMonitor(this, type, count, ch, l, mask);
        JNIMonitorCallback callback = res.getMonitorCallback();
        res.setMonitorID(JNI.ch_addMonitor(type.getValue(), count, ch.getChannelID(), callback, mask));
        return res;
    }

    void ch_clearMonitor(JNIMonitor monitor) throws JNIException {
        this.assertState(this.isValid(), "Invalid context");
        this.assertThread();
        JNI.ch_clearMonitor(monitor.getMonitorID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertThread() throws IllegalStateException {
        ArrayList arrayList = this._threadList;
        synchronized (arrayList) {
            Iterator it = this._threadList.iterator();
            while (it.hasNext()) {
                if (Thread.currentThread() != (Thread)it.next()) continue;
                return;
            }
        }
        throw new IllegalStateException("Illegal calling thread");
    }

    protected class Get {
        DBR dbr;
        long dbrid;

        public Get(DBR dbr, long dbrid) {
            this.dbr = dbr;
            this.dbrid = dbrid;
        }

        public void update() {
            JNI.dbr_update(this.dbr, this.dbrid);
            JNI.dbr_destroy(this.dbrid);
        }

        public String toString() {
            return (class$gov$aps$jca$jni$SingleThreadedContext$Get == null ? (class$gov$aps$jca$jni$SingleThreadedContext$Get = SingleThreadedContext.class$("gov.aps.jca.jni.SingleThreadedContext$Get")) : class$gov$aps$jca$jni$SingleThreadedContext$Get).getName() + "[ID: " + this.dbrid + " dbr=" + this.dbr + "]";
        }
    }
}

