/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.dbr;

import gov.aps.jca.CAStatusException;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DBR_TIME_Int;
import gov.aps.jca.dbr.GR;
import gov.aps.jca.dbr.TimeStamp;
import java.io.PrintStream;

public class DBR_GR_Int
extends DBR_TIME_Int
implements GR {
    public static final DBRType TYPE = new DBRType("DBR_GR_INT", 26, DBR_GR_Int.class);
    protected String _unit = "";
    protected Integer _udl = ZEROI;
    protected Integer _ldl = ZEROI;
    protected Integer _ual = ZEROI;
    protected Integer _uwl = ZEROI;
    protected Integer _lwl = ZEROI;
    protected Integer _lal = ZEROI;

    public DBR_GR_Int() {
        this(1);
    }

    public DBR_GR_Int(int count) {
        this(new int[count]);
    }

    public DBR_GR_Int(int[] value) {
        super(value);
    }

    public DBRType getType() {
        return TYPE;
    }

    public String getUnits() {
        return this._unit;
    }

    public void setUnits(String unit) {
        this._unit = unit;
    }

    public Number getUpperDispLimit() {
        return this._udl;
    }

    public void setUpperDispLimit(Number limit) {
        this._udl = new Integer(limit.intValue());
    }

    public Number getLowerDispLimit() {
        return this._ldl;
    }

    public void setLowerDispLimit(Number limit) {
        this._ldl = new Integer(limit.intValue());
    }

    public Number getUpperAlarmLimit() {
        return this._ual;
    }

    public void setUpperAlarmLimit(Number limit) {
        this._ual = new Integer(limit.intValue());
    }

    public Number getUpperWarningLimit() {
        return this._uwl;
    }

    public void setUpperWarningLimit(Number limit) {
        this._uwl = new Integer(limit.intValue());
    }

    public Number getLowerWarningLimit() {
        return this._lwl;
    }

    public void setLowerWarningLimit(Number limit) {
        this._lwl = new Integer(limit.intValue());
    }

    public Number getLowerAlarmLimit() {
        return this._lal;
    }

    public void setLowerAlarmLimit(Number limit) {
        this._lal = new Integer(limit.intValue());
    }

    public void printInfo(PrintStream out) {
        super.printInfo(out);
        out.println("UNITS    : " + this.getUnits());
        out.println("UDL      : " + this.getUpperDispLimit());
        out.println("LDL      : " + this.getLowerDispLimit());
        out.println("UAL      : " + this.getUpperAlarmLimit());
        out.println("UWL      : " + this.getUpperWarningLimit());
        out.println("LWL      : " + this.getLowerWarningLimit());
        out.println("LAL      : " + this.getLowerAlarmLimit());
    }

    public DBR convert(DBRType convertType) throws CAStatusException {
        DBR dbr = super.convert(convertType);
        if (dbr.isGR()) {
            GR gr = (GR)((Object)dbr);
            gr.setUnits(this.getUnits());
            gr.setUpperDispLimit(this.getUpperDispLimit());
            gr.setLowerDispLimit(this.getLowerDispLimit());
            gr.setUpperAlarmLimit(this.getUpperAlarmLimit());
            gr.setUpperWarningLimit(this.getUpperWarningLimit());
            gr.setLowerWarningLimit(this.getLowerWarningLimit());
            gr.setLowerAlarmLimit(this.getLowerAlarmLimit());
        }
        return dbr;
    }

    public TimeStamp getTimeStamp() {
        return super.getTimeStamp();
    }

    public void setTimeStamp(TimeStamp stamp) {
        super.setTimeStamp(stamp);
    }
}

