/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.util;

public class HexDump {
    private static final char[] lookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static synchronized void hexDump(String name, byte[] bs) {
        HexDump.hexDump(name, bs, 0, bs.length);
    }

    public static synchronized void hexDump(String name, byte[] bs, int len) {
        HexDump.hexDump(name, bs, 0, len);
    }

    public static synchronized void hexDump(String name, byte[] bs, int start, int len) {
        StringBuffer out = new StringBuffer("Hexdump [" + name + "] size = " + len);
        StringBuffer chars = new StringBuffer();
        for (int i = start; i < start + len; ++i) {
            if ((i - start) % 16 == 0) {
                out.append(chars);
                out.append("\n");
                chars = new StringBuffer();
            }
            chars.append(HexDump.toAscii(bs[i]));
            out.append(HexDump.toHex(bs[i]));
            if (i % 4 != 3) continue;
            chars.append(' ');
            out.append(' ');
        }
        if (len % 16 != 0) {
            int pad = 0;
            int delta_bytes = 16 - len % 16;
            pad = delta_bytes * 3;
            pad += delta_bytes / 4;
            for (int i = 0; i < pad; ++i) {
                chars.insert(0, ' ');
            }
        }
        out.append(chars);
        System.out.println(out);
    }

    private static final String toHex(byte b) {
        StringBuffer sb = new StringBuffer();
        int upper = b >> 4 & 0xF;
        sb.append(lookup[upper]);
        int lower = b & 0xF;
        sb.append(lookup[lower]);
        sb.append(' ');
        return sb.toString();
    }

    private static final char toAscii(byte b) {
        if (b > 31 && b < 127) {
            return (char)b;
        }
        return '.';
    }
}

