/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl.handlers;

import com.cosylab.epics.caj.CAJContext;
import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.handlers.AbstractCAJResponseHandler;
import com.cosylab.epics.caj.util.InetAddressUtil;
import gov.aps.jca.dbr.DBR;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public class SearchResponse
extends AbstractCAJResponseHandler {
    public SearchResponse(CAJContext context) {
        super(context, "Search response");
    }

    protected void internalHandleResponse(InetSocketAddress responseFrom, Transport transport, ByteBuffer[] response) {
        short minorVersion = 0;
        int payloadStart = response[0].position();
        if (this.payloadSize >= 2) {
            minorVersion = response[0].getShort();
        }
        response[0].position(payloadStart + this.payloadSize);
        int port = this.dataType & 0xFFFF;
        if (minorVersion >= 8) {
            InetAddress addr;
            int INADDR_BROADCAST = -1;
            if (this.parameter1 != -1) {
                addr = InetAddressUtil.intToIPv4Address(this.parameter1);
            } else {
                addr = responseFrom.getAddress();
                if (addr.isLoopbackAddress()) {
                    try {
                        addr = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException e) {
                        // empty catch block
                    }
                }
            }
            responseFrom = new InetSocketAddress(addr, port);
        } else {
            responseFrom = minorVersion >= 5 ? new InetSocketAddress(responseFrom.getAddress(), port) : new InetSocketAddress(responseFrom.getAddress(), this.context.getServerPort());
        }
        if (minorVersion >= 2) {
            this.context.searchResponse(this.parameter2, this.parameter1, (short)DBR.TYPE.getValue(), 0, minorVersion, responseFrom);
        } else {
            this.context.searchResponse(this.parameter2, this.parameter1, this.dataType, this.dataCount, minorVersion, responseFrom);
        }
    }
}

