/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl;

import com.cosylab.epics.caj.CAJContext;
import com.cosylab.epics.caj.impl.requests.RepeaterRegisterRequest;
import com.cosylab.epics.caj.util.Timer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;

public class RepeaterRegistrationTask
implements Timer.TimerRunnable {
    private CAJContext context;
    private RepeaterRegisterRequest registrationRequest;
    private InetSocketAddress repeaterAddress;
    private Object timerID;

    public RepeaterRegistrationTask(CAJContext context, InetSocketAddress repeaterAddress) throws UnknownHostException {
        this.context = context;
        this.repeaterAddress = repeaterAddress;
        this.registrationRequest = new RepeaterRegisterRequest(context.getBroadcastTransport());
    }

    public void timeout(long timeToRun) {
        if (this.context.isRegistrationConfirmed()) {
            Timer.cancel(this.timerID);
        } else {
            this.registrationRequest();
        }
    }

    public void runInBackground(int period) {
        this.timerID = this.context.getTimer().executePeriodically(period, this, 0L);
    }

    public void registrationRequest() {
        this.context.getLogger().log(Level.FINE, "Repeater registation request sent to " + this.repeaterAddress + ".");
        try {
            this.context.getBroadcastTransport().send(this.registrationRequest, this.repeaterAddress);
        }
        catch (IOException ioex) {
            this.context.getLogger().log(Level.FINE, "Failed to send registation request.", ioex);
        }
    }
}

