/*
 * Decompiled with CFR 0.152.
 */
package ttf.doocs.clnt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Locale;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import ttf.doocs.clnt.A_BYTE;
import ttf.doocs.clnt.DataUnion;
import ttf.doocs.clnt.EqDataBlock;
import ttf.doocs.clnt.FI;
import ttf.doocs.clnt.FIS;
import ttf.doocs.clnt.IFFF;
import ttf.doocs.clnt.II;
import ttf.doocs.clnt.IIII;
import ttf.doocs.clnt.IMAGE;
import ttf.doocs.clnt.IMH;
import ttf.doocs.clnt.MDAF;
import ttf.doocs.clnt.NAME16;
import ttf.doocs.clnt.NAME16FI;
import ttf.doocs.clnt.NAME16II;
import ttf.doocs.clnt.NAME32;
import ttf.doocs.clnt.NAME64;
import ttf.doocs.clnt.SPECTRUM;
import ttf.doocs.clnt.TDS;
import ttf.doocs.clnt.TDSi;
import ttf.doocs.clnt.TEXT;
import ttf.doocs.clnt.TS_SPECTRUM;
import ttf.doocs.clnt.TTII;
import ttf.doocs.clnt.USTR;
import ttf.doocs.clnt.XML;
import ttf.doocs.clnt.XY;
import ttf.doocs.clnt.XYZS;
import ttf.doocs.clnt.time_t;
import ttf.doocs.clnt.u_char;

public class EqData {
    private EqDataBlock eq_data;

    public EqData() {
        this.eq_data = new EqDataBlock();
        this.eq_data.error = 0;
        this.eq_data.tm = new time_t((int)(System.currentTimeMillis() / 1000L));
        this.eq_data.data_u = new DataUnion();
    }

    public EqData(EqDataBlock p) {
        this.eq_data = p;
    }

    public EqDataBlock get_Block() {
        return this.eq_data;
    }

    public void init() {
        this.eq_data.error = 0;
        this.eq_data.tm = new time_t((int)(System.currentTimeMillis() / 1000L));
        this.eq_data.data_u = new DataUnion();
        this.eq_data.data_u.data_sel = 0;
    }

    private void toByteArray(String str, byte[] arr, int len) {
        for (int i = 0; i < len; ++i) {
            arr[i] = (byte)str.charAt(i);
        }
    }

    private int get_pos_mda(int[] dp, int dims, float[] val, MDAF mp) {
        int i2;
        int i1;
        int i0;
        int ix = 0;
        if (mp.dims.length != dims) {
            return -1;
        }
        switch (dims) {
            case 1: {
                i0 = dp[0];
                if (i0 >= mp.dims[0]) {
                    return -1;
                }
                ix = i0;
                break;
            }
            case 2: {
                i0 = dp[0];
                i1 = dp[1];
                if (i0 >= mp.dims[0] || i1 >= mp.dims[1]) {
                    return -1;
                }
                ix = i0 * mp.dims[1] + i1;
                break;
            }
            case 3: {
                i0 = dp[0];
                i1 = dp[1];
                i2 = dp[2];
                if (i0 >= mp.dims[0] || i1 >= mp.dims[1] || i2 >= mp.dims[2]) {
                    return -1;
                }
                ix = mp.dims[2] * (i0 * mp.dims[1] + i1) + i2;
                break;
            }
            case 4: {
                i0 = dp[0];
                i1 = dp[1];
                i2 = dp[2];
                int i3 = dp[3];
                if (i0 >= mp.dims[0] || i1 >= mp.dims[1] || i2 >= mp.dims[2] || i3 >= mp.dims[3]) {
                    return -1;
                }
                ix = mp.dims[3] * (mp.dims[2] * (i0 * mp.dims[1] + i1) + i2) + i3;
                break;
            }
            case 5: {
                i0 = dp[0];
                i1 = dp[1];
                i2 = dp[2];
                int i3 = dp[3];
                int i4 = dp[4];
                if (i0 >= mp.dims[0] || i1 >= mp.dims[1] || i2 >= mp.dims[2] || i3 >= mp.dims[3] || i4 >= mp.dims[4]) {
                    return -1;
                }
                ix = mp.dims[4] * (mp.dims[3] * (mp.dims[2] * (i0 * mp.dims[1] + i1) + i2) + i3) + i4;
                break;
            }
            case 6: {
                i0 = dp[0];
                i1 = dp[1];
                i2 = dp[2];
                int i3 = dp[3];
                int i4 = dp[4];
                int i5 = dp[5];
                if (i0 >= mp.dims[0] || i1 >= mp.dims[1] || i2 >= mp.dims[2] || i3 >= mp.dims[3] || i4 >= mp.dims[4] || i5 >= mp.dims[5]) {
                    return -1;
                }
                ix = mp.dims[5] * (mp.dims[4] * (mp.dims[3] * (mp.dims[2] * (i0 * mp.dims[1] + i1) + i2) + i3) + i4) + i5;
            }
        }
        if (ix >= mp.d_farray.length) {
            return -1;
        }
        if (val != null) {
            i1 = 0;
            i2 = mp.d_farray.length - ix;
            if (val.length < i2) {
                i2 = val.length;
            }
            for (i0 = ix; i0 < ix + i2; ++i0) {
                val[i1++] = mp.d_farray[i0];
            }
        }
        return ix;
    }

    public void copy_from(EqData from) {
        int i = 0;
        int n = 0;
        if (from == null) {
            this.init();
            return;
        }
        this.eq_data.data_u.data_sel = from.eq_data.data_u.data_sel;
        this.eq_data.tm = new time_t(from.eq_data.tm.value);
        this.eq_data.error = from.eq_data.error;
        this.eq_data.data_u.data_sel = from.eq_data.data_u.data_sel;
        try {
            switch (this.eq_data.data_u.data_sel) {
                case 0: {
                    break;
                }
                case 1: {
                    this.eq_data.data_u.d_int = from.eq_data.data_u.d_int;
                    break;
                }
                case 8: {
                    this.eq_data.data_u.d_short = from.eq_data.data_u.d_short;
                    break;
                }
                case 4: {
                    this.eq_data.data_u.d_bool = from.eq_data.data_u.d_bool;
                    break;
                }
                case 2: {
                    this.eq_data.data_u.d_float = from.eq_data.data_u.d_float;
                    break;
                }
                case 6: {
                    this.eq_data.data_u.d_double = from.eq_data.data_u.d_double;
                    break;
                }
                case 5: {
                    if (this.eq_data.data_u.d_char16 == null) {
                        this.eq_data.data_u.d_char16 = new byte[16];
                    }
                    for (int j = 0; j < 16; ++j) {
                        this.eq_data.data_u.d_char16[j] = from.eq_data.data_u.d_char16[j];
                    }
                    break;
                }
                case 12: {
                    if (this.eq_data.data_u.d_tds == null) {
                        this.eq_data.data_u.d_tds = new TDS();
                    }
                    this.eq_data.data_u.d_tds.tm = new time_t(from.eq_data.data_u.d_tds.tm.value);
                    this.eq_data.data_u.d_tds.data = from.eq_data.data_u.d_tds.data;
                    this.eq_data.data_u.d_tds.status = new u_char(from.eq_data.data_u.d_tds.status.value);
                    break;
                }
                case 13: {
                    if (this.eq_data.data_u.d_xy == null) {
                        this.eq_data.data_u.d_xy = new XY();
                    }
                    this.eq_data.data_u.d_xy.x_data = from.eq_data.data_u.d_xy.x_data;
                    this.eq_data.data_u.d_xy.y_data = from.eq_data.data_u.d_xy.y_data;
                    break;
                }
                case 14: {
                    if (this.eq_data.data_u.d_iiii == null) {
                        this.eq_data.data_u.d_iiii = new IIII();
                    }
                    this.eq_data.data_u.d_iiii.i1_data = from.eq_data.data_u.d_iiii.i1_data;
                    this.eq_data.data_u.d_iiii.i2_data = from.eq_data.data_u.d_iiii.i2_data;
                    this.eq_data.data_u.d_iiii.i3_data = from.eq_data.data_u.d_iiii.i3_data;
                    this.eq_data.data_u.d_iiii.i4_data = from.eq_data.data_u.d_iiii.i4_data;
                    break;
                }
                case 17: {
                    if (this.eq_data.data_u.d_fis == null) {
                        this.eq_data.data_u.d_fis = new FIS();
                    }
                    this.eq_data.data_u.d_fis.f_data = from.eq_data.data_u.d_fis.f_data;
                    this.eq_data.data_u.d_fis.i_data = from.eq_data.data_u.d_fis.i_data;
                    this.eq_data.data_u.d_fis.status = from.eq_data.data_u.d_fis.status;
                    break;
                }
                case 19: {
                    this.eq_data.data_u.d_spectrum = new SPECTRUM();
                    n = from.eq_data.data_u.d_spectrum.d_spect_array.length;
                    if (n > 0x100000) {
                        n = 0x100000;
                    }
                    this.eq_data.data_u.d_spectrum.d_spect_array = new float[n];
                    for (i = 0; i < n; ++i) {
                        this.eq_data.data_u.d_spectrum.d_spect_array[i] = from.eq_data.data_u.d_spectrum.d_spect_array[i];
                    }
                    n = from.eq_data.data_u.d_spectrum.comment.length;
                    if (n > 80) {
                        n = 80;
                    }
                    this.eq_data.data_u.d_spectrum.comment = n == 0 ? new byte[1] : new byte[n];
                    for (i = 0; i < n; ++i) {
                        this.eq_data.data_u.d_spectrum.comment[i] = from.eq_data.data_u.d_spectrum.comment[i];
                    }
                    this.eq_data.data_u.d_spectrum.tm = new time_t(from.eq_data.data_u.d_spectrum.tm.value);
                    this.eq_data.data_u.d_spectrum.s_start = from.eq_data.data_u.d_spectrum.s_start;
                    this.eq_data.data_u.d_spectrum.s_inc = from.eq_data.data_u.d_spectrum.s_inc;
                    this.eq_data.data_u.d_spectrum.status = from.eq_data.data_u.d_spectrum.status;
                    break;
                }
                case 22: {
                    this.eq_data.data_u.d_image = new IMAGE();
                    n = from.eq_data.data_u.d_image.val.length;
                    if (n > 0x800000) {
                        n = 0x800000;
                    }
                    this.eq_data.data_u.d_image.val = new u_char[n];
                    this.eq_data.data_u.d_image.hdr = new IMH();
                    this.eq_data.data_u.d_image.hdr.aoi_height = from.eq_data.data_u.d_image.hdr.aoi_height;
                    this.eq_data.data_u.d_image.hdr.aoi_width = from.eq_data.data_u.d_image.hdr.aoi_width;
                    this.eq_data.data_u.d_image.hdr.bpp = from.eq_data.data_u.d_image.hdr.bpp;
                    this.eq_data.data_u.d_image.hdr.ebitpp = from.eq_data.data_u.d_image.hdr.ebitpp;
                    this.eq_data.data_u.d_image.hdr.event = from.eq_data.data_u.d_image.hdr.event;
                    this.eq_data.data_u.d_image.hdr.frame = from.eq_data.data_u.d_image.hdr.frame;
                    this.eq_data.data_u.d_image.hdr.fspare2 = from.eq_data.data_u.d_image.hdr.fspare2;
                    this.eq_data.data_u.d_image.hdr.fspare3 = from.eq_data.data_u.d_image.hdr.fspare3;
                    this.eq_data.data_u.d_image.hdr.fspare4 = from.eq_data.data_u.d_image.hdr.fspare4;
                    this.eq_data.data_u.d_image.hdr.hbin = from.eq_data.data_u.d_image.hdr.hbin;
                    this.eq_data.data_u.d_image.hdr.height = from.eq_data.data_u.d_image.hdr.height;
                    this.eq_data.data_u.d_image.hdr.image_flags = from.eq_data.data_u.d_image.hdr.image_flags;
                    this.eq_data.data_u.d_image.hdr.image_format = from.eq_data.data_u.d_image.hdr.image_format;
                    this.eq_data.data_u.d_image.hdr.image_rotation = from.eq_data.data_u.d_image.hdr.image_rotation;
                    this.eq_data.data_u.d_image.hdr.ispare2 = from.eq_data.data_u.d_image.hdr.ispare2;
                    this.eq_data.data_u.d_image.hdr.ispare3 = from.eq_data.data_u.d_image.hdr.ispare3;
                    this.eq_data.data_u.d_image.hdr.ispare4 = from.eq_data.data_u.d_image.hdr.ispare4;
                    this.eq_data.data_u.d_image.hdr.length = from.eq_data.data_u.d_image.hdr.length;
                    this.eq_data.data_u.d_image.hdr.scale_x = from.eq_data.data_u.d_image.hdr.scale_x;
                    this.eq_data.data_u.d_image.hdr.scale_y = from.eq_data.data_u.d_image.hdr.scale_y;
                    this.eq_data.data_u.d_image.hdr.source_format = from.eq_data.data_u.d_image.hdr.source_format;
                    this.eq_data.data_u.d_image.hdr.vbin = from.eq_data.data_u.d_image.hdr.vbin;
                    this.eq_data.data_u.d_image.hdr.width = from.eq_data.data_u.d_image.hdr.width;
                    this.eq_data.data_u.d_image.hdr.x_start = from.eq_data.data_u.d_image.hdr.x_start;
                    this.eq_data.data_u.d_image.hdr.y_start = from.eq_data.data_u.d_image.hdr.y_start;
                    this.eq_data.data_u.d_image.sec = from.eq_data.data_u.d_image.sec;
                    this.eq_data.data_u.d_image.usec = from.eq_data.data_u.d_image.usec;
                    this.eq_data.data_u.d_image.status = from.eq_data.data_u.d_image.status;
                    this.eq_data.data_u.d_image.bbuf = ByteBuffer.allocate(n);
                    this.eq_data.data_u.d_image.bbuf.put(from.eq_data.data_u.d_image.bbuf);
                    for (i = 0; i < n; ++i) {
                        this.eq_data.data_u.d_image.val[i] = from.eq_data.data_u.d_image.val[i];
                    }
                    n = from.eq_data.data_u.d_image.comment.length;
                    if (n > 80) {
                        n = 80;
                    }
                    if (n > 0) {
                        this.eq_data.data_u.d_image.comment = new byte[n];
                        for (i = 0; i < n; ++i) {
                            this.eq_data.data_u.d_image.comment[i] = from.eq_data.data_u.d_image.comment[i];
                        }
                        break;
                    }
                    this.eq_data.data_u.d_image.comment = new byte[1];
                    this.eq_data.data_u.d_image.comment[0] = 0;
                    break;
                }
                case 3: {
                    n = from.eq_data.data_u.d_char.length;
                    if (this.eq_data.data_u.d_char == null) {
                        this.eq_data.data_u.d_char = new byte[n];
                    }
                    for (int j = 0; j < n; ++j) {
                        this.eq_data.data_u.d_char[j] = from.eq_data.data_u.d_char[j];
                    }
                    break;
                }
                case 7: {
                    this.eq_data.data_u.d_text = new TEXT();
                    n = from.eq_data.data_u.d_text.d_text_array.length;
                    if (n > 0x100000) {
                        n = 0x100000;
                    }
                    this.eq_data.data_u.d_text.d_text_array = new byte[n];
                    for (i = 0; i < n; ++i) {
                        this.eq_data.data_u.d_text.d_text_array[i] = from.eq_data.data_u.d_text.d_text_array[i];
                    }
                    break;
                }
                case 20: {
                    this.eq_data.data_u.d_xml = new XML();
                    n = from.eq_data.data_u.d_xml.d_xml_array.length;
                    if (n > 0x400000) {
                        n = 0x400000;
                    }
                    this.eq_data.data_u.d_xml.d_xml_array = new byte[n];
                    for (i = 0; i < n; ++i) {
                        this.eq_data.data_u.d_xml.d_xml_array[i] = from.eq_data.data_u.d_xml.d_xml_array[i];
                    }
                    break;
                }
                case 100: {
                    n = from.eq_data.data_u.d_float_array.length;
                    if (n > 1024) {
                        n = 1024;
                    }
                    if (n > 0) {
                        this.eq_data.data_u.d_float_array = new float[n];
                    }
                    for (i = 0; i < n; ++i) {
                        this.eq_data.data_u.d_float_array[i] = from.eq_data.data_u.d_float_array[i];
                    }
                    break;
                }
                case 110: {
                    n = from.eq_data.data_u.d_double_array.length;
                    if (n > 1024) {
                        n = 1024;
                    }
                    if (n > 0) {
                        this.eq_data.data_u.d_double_array = new double[n];
                    }
                    for (i = 0; i < n; ++i) {
                        this.eq_data.data_u.d_double_array[i] = from.eq_data.data_u.d_double_array[i];
                    }
                    break;
                }
                case 105: 
                case 119: {
                    n = from.eq_data.data_u.d_int_array.length;
                    if (n > 1024) {
                        n = 1024;
                    }
                    if (n > 0) {
                        this.eq_data.data_u.d_int_array = new int[n];
                    }
                    for (i = 0; i < n; ++i) {
                        this.eq_data.data_u.d_int_array[i] = from.eq_data.data_u.d_int_array[i];
                    }
                    break;
                }
                case 115: {
                    n = from.eq_data.data_u.d_short_array.length;
                    if (n > 1024) {
                        n = 1024;
                    }
                    if (n > 0) {
                        this.eq_data.data_u.d_short_array = new short[n];
                    }
                    for (i = 0; i < n; ++i) {
                        this.eq_data.data_u.d_short_array[i] = from.eq_data.data_u.d_short_array[i];
                    }
                    break;
                }
                case 101: {
                    try {
                        n = from.eq_data.data_u.d_tds_array.length;
                        if (n > 2000) {
                            n = 2000;
                        }
                        if (n > 0) {
                            this.eq_data.data_u.d_tds_array = new TDS[n];
                        }
                        for (i = 0; i < n; ++i) {
                            this.eq_data.data_u.d_tds_array[i] = new TDS();
                            this.eq_data.data_u.d_tds_array[i].tm = new time_t();
                            this.eq_data.data_u.d_tds_array[i].tm.value = from.eq_data.data_u.d_tds_array[i].tm.value;
                            this.eq_data.data_u.d_tds_array[i].data = from.eq_data.data_u.d_tds_array[i].data;
                            this.eq_data.data_u.d_tds_array[i].status = new u_char();
                            if (this.eq_data.data_u.d_tds_array[i].status == null) {
                                this.eq_data.data_u.d_tds_array[i].status = new u_char();
                            }
                            this.eq_data.data_u.d_tds_array[i].status.value = from.eq_data.data_u.d_tds_array[i].status.value;
                        }
                        break;
                    }
                    catch (Exception e) {
                        System.out.println("bad TDS n=" + n + "; i=" + i);
                        System.out.println("bad TDS :" + this.eq_data.data_u.d_tds_array[i].tm);
                        System.out.println("bad TDS :" + this.eq_data.data_u.d_tds_array[i].data);
                        System.out.println("bad TDS :" + this.eq_data.data_u.d_tds_array[i].status);
                        System.out.println("bad TDS :" + from.eq_data.data_u.d_tds_array[i].status.value);
                        break;
                    }
                }
                case 107: {
                    n = from.eq_data.data_u.d_tdsi_array.length;
                    if (n > 2000) {
                        n = 2000;
                    }
                    if (n > 0) {
                        this.eq_data.data_u.d_tdsi_array = new TDSi[n];
                    }
                    for (i = 0; i < n; ++i) {
                        this.eq_data.data_u.d_tdsi_array[i] = new TDSi();
                        this.eq_data.data_u.d_tdsi_array[i].tm = new time_t(from.eq_data.data_u.d_tdsi_array[i].tm.value);
                        this.eq_data.data_u.d_tdsi_array[i].data = from.eq_data.data_u.d_tdsi_array[i].data;
                        this.eq_data.data_u.d_tdsi_array[i].status = from.eq_data.data_u.d_tdsi_array[i].status;
                        this.eq_data.data_u.d_tdsi_array[i].t_ms = from.eq_data.data_u.d_tdsi_array[i].t_ms;
                    }
                    break;
                }
                case 102: {
                    n = from.eq_data.data_u.d_xy_array.length;
                    if (n > 2048) {
                        n = 2048;
                    }
                    if (n > 0) {
                        this.eq_data.data_u.d_xy_array = new XY[n];
                    }
                    for (i = 0; i < n; ++i) {
                        this.eq_data.data_u.d_xy_array[i] = new XY();
                        this.eq_data.data_u.d_xy_array[i].x_data = from.eq_data.data_u.d_xy_array[i].x_data;
                        this.eq_data.data_u.d_xy_array[i].y_data = from.eq_data.data_u.d_xy_array[i].y_data;
                    }
                    break;
                }
                case 16: 
                case 103: {
                    n = from.eq_data.data_u.d_ustr_array.length;
                    if (n > 1000) {
                        n = 1000;
                    }
                    if (n > 0) {
                        this.eq_data.data_u.d_ustr_array = new USTR[n];
                    }
                    for (i = 0; i < n; ++i) {
                        try {
                            this.eq_data.data_u.d_ustr_array[i] = new USTR();
                            this.eq_data.data_u.d_ustr_array[i].i1_data = from.eq_data.data_u.d_ustr_array[i].i1_data;
                            this.eq_data.data_u.d_ustr_array[i].f1_data = from.eq_data.data_u.d_ustr_array[i].f1_data;
                            this.eq_data.data_u.d_ustr_array[i].f2_data = from.eq_data.data_u.d_ustr_array[i].f2_data;
                            this.eq_data.data_u.d_ustr_array[i].tm = new time_t(from.eq_data.data_u.d_ustr_array[i].tm.value);
                            int len = from.eq_data.data_u.d_ustr_array[i].str_data.length;
                            if (len > 80) {
                                len = 80;
                            }
                            this.eq_data.data_u.d_ustr_array[i].str_data = len > 0 ? new byte[len] : new byte[1];
                            if (from.eq_data.error == 64) continue;
                            for (int j = 0; j < len; ++j) {
                                this.eq_data.data_u.d_ustr_array[i].str_data[j] = from.eq_data.data_u.d_ustr_array[i].str_data[j];
                            }
                            continue;
                        }
                        catch (NullPointerException e) {
                            System.out.println("EqData copy_from TINE NullPointerException: " + e.getMessage());
                            System.out.println("ERROR=" + from.eq_data.error);
                        }
                    }
                    break;
                }
                case 111: {
                    n = from.eq_data.data_u.d_name16fi.length;
                    if (n > 1000) {
                        n = 1000;
                    }
                    if (n > 0) {
                        this.eq_data.data_u.d_name16fi = new NAME16FI[n];
                    }
                    for (i = 0; i < n; ++i) {
                        try {
                            this.eq_data.data_u.d_name16fi[i] = new NAME16FI();
                            this.eq_data.data_u.d_name16fi[i].i_data = from.eq_data.data_u.d_name16fi[i].i_data;
                            this.eq_data.data_u.d_name16fi[i].f_data = from.eq_data.data_u.d_name16fi[i].f_data;
                            int len = from.eq_data.data_u.d_name16fi[i].str_data.length;
                            if (len > 16) {
                                len = 16;
                            }
                            this.eq_data.data_u.d_name16fi[i].str_data = len > 0 ? new byte[len] : new byte[1];
                            for (int j = 0; j < len; ++j) {
                                this.eq_data.data_u.d_name16fi[i].str_data[j] = from.eq_data.data_u.d_name16fi[i].str_data[j];
                            }
                            continue;
                        }
                        catch (NullPointerException e) {
                            System.out.println("EqData copy_from NAME16FI NullPointerException: " + e.getMessage());
                        }
                    }
                    break;
                }
                case 112: {
                    n = from.eq_data.data_u.d_name16ii.length;
                    if (n > 1000) {
                        n = 1000;
                    }
                    if (n > 0) {
                        this.eq_data.data_u.d_name16ii = new NAME16II[n];
                    }
                    for (i = 0; i < n; ++i) {
                        try {
                            this.eq_data.data_u.d_name16ii[i] = new NAME16II();
                            this.eq_data.data_u.d_name16ii[i].i1_data = from.eq_data.data_u.d_name16ii[i].i1_data;
                            this.eq_data.data_u.d_name16ii[i].i2_data = from.eq_data.data_u.d_name16ii[i].i2_data;
                            int len = from.eq_data.data_u.d_name16ii[i].str_data.length;
                            if (len > 16) {
                                len = 16;
                            }
                            this.eq_data.data_u.d_name16ii[i].str_data = len > 0 ? new byte[len] : new byte[1];
                            for (int j = 0; j < len; ++j) {
                                this.eq_data.data_u.d_name16ii[i].str_data[j] = from.eq_data.data_u.d_name16ii[i].str_data[j];
                            }
                            continue;
                        }
                        catch (NullPointerException e) {
                            System.out.println("EqData copy_from NAME16II NullPointerException: " + e.getMessage());
                        }
                    }
                    break;
                }
                case 104: {
                    n = from.eq_data.data_u.d_fis_array.length;
                    if (n > 128) {
                        n = 128;
                    }
                    if (n > 0) {
                        this.eq_data.data_u.d_fis_array = new FIS[n];
                    }
                    for (i = 0; i < n; ++i) {
                        this.eq_data.data_u.d_fis_array[i] = new FIS();
                        this.eq_data.data_u.d_fis_array[i].f_data = from.eq_data.data_u.d_fis_array[i].f_data;
                        this.eq_data.data_u.d_fis_array[i].i_data = from.eq_data.data_u.d_fis_array[i].i_data;
                        this.eq_data.data_u.d_fis_array[i].status = new u_char(from.eq_data.data_u.d_fis_array[i].status.value);
                    }
                    break;
                }
                case 114: {
                    n = from.eq_data.data_u.d_fi_array.length;
                    if (n > 1000) {
                        n = 1000;
                    }
                    if (n > 0) {
                        this.eq_data.data_u.d_fi_array = new FI[n];
                    }
                    for (i = 0; i < n; ++i) {
                        this.eq_data.data_u.d_fi_array[i] = new FI();
                        this.eq_data.data_u.d_fi_array[i].f_data = from.eq_data.data_u.d_fi_array[i].f_data;
                        this.eq_data.data_u.d_fi_array[i].i_data = from.eq_data.data_u.d_fi_array[i].i_data;
                    }
                    break;
                }
                case 116: {
                    n = from.eq_data.data_u.d_ii_array.length;
                    if (n > 1000) {
                        n = 1000;
                    }
                    if (n > 0) {
                        this.eq_data.data_u.d_ii_array = new II[n];
                    }
                    for (i = 0; i < n; ++i) {
                        this.eq_data.data_u.d_ii_array[i] = new II();
                        this.eq_data.data_u.d_ii_array[i].i1_data = from.eq_data.data_u.d_ii_array[i].i1_data;
                        this.eq_data.data_u.d_ii_array[i].i2_data = from.eq_data.data_u.d_ii_array[i].i2_data;
                    }
                    break;
                }
                case 106: {
                    this.eq_data.data_u.d_byte_struct = new A_BYTE();
                    n = from.eq_data.data_u.d_byte_struct.d_byte_array.length;
                    if (n > 0x800000) {
                        n = 0x800000;
                    }
                    if (n > 0) {
                        this.eq_data.data_u.d_byte_struct.d_byte_array = new byte[n];
                    }
                    for (i = 0; i < n; ++i) {
                        this.eq_data.data_u.d_byte_struct.d_byte_array[i] = from.eq_data.data_u.d_byte_struct.d_byte_array[i];
                    }
                    this.eq_data.data_u.d_byte_struct.x_dim = from.eq_data.data_u.d_byte_struct.x_dim;
                    this.eq_data.data_u.d_byte_struct.y_dim = from.eq_data.data_u.d_byte_struct.y_dim;
                    this.eq_data.data_u.d_byte_struct.x_offset = from.eq_data.data_u.d_byte_struct.x_offset;
                    this.eq_data.data_u.d_byte_struct.y_offset = from.eq_data.data_u.d_byte_struct.y_offset;
                    this.eq_data.data_u.d_byte_struct.option = from.eq_data.data_u.d_byte_struct.option;
                    break;
                }
                case 15: {
                    if (this.eq_data.data_u.d_ifff == null) {
                        this.eq_data.data_u.d_ifff = new IFFF();
                    }
                    this.eq_data.data_u.d_ifff.i1_data = from.eq_data.data_u.d_ifff.i1_data;
                    this.eq_data.data_u.d_ifff.f1_data = from.eq_data.data_u.d_ifff.f1_data;
                    this.eq_data.data_u.d_ifff.f2_data = from.eq_data.data_u.d_ifff.f2_data;
                    this.eq_data.data_u.d_ifff.f3_data = from.eq_data.data_u.d_ifff.f3_data;
                    break;
                }
                case 18: {
                    if (this.eq_data.data_u.d_ttii == null) {
                        this.eq_data.data_u.d_ttii = new TTII();
                    }
                    this.eq_data.data_u.d_ttii.tm1 = new time_t(from.eq_data.data_u.d_ttii.tm1.value);
                    this.eq_data.data_u.d_ttii.tm2 = new time_t(from.eq_data.data_u.d_ttii.tm2.value);
                    this.eq_data.data_u.d_ttii.i1_data = from.eq_data.data_u.d_ttii.i1_data;
                    this.eq_data.data_u.d_ttii.i2_data = from.eq_data.data_u.d_ttii.i2_data;
                    break;
                }
                case 108: {
                    n = from.eq_data.data_u.d_xyzs_array.length;
                    if (n > 1000) {
                        n = 1000;
                    }
                    if (n > 0) {
                        this.eq_data.data_u.d_xyzs_array = new XYZS[n];
                    }
                    for (i = 0; i < n; ++i) {
                        this.eq_data.data_u.d_xyzs_array[i] = new XYZS();
                        this.eq_data.data_u.d_xyzs_array[i].status = from.eq_data.data_u.d_xyzs_array[i].status;
                        this.eq_data.data_u.d_xyzs_array[i].x = from.eq_data.data_u.d_xyzs_array[i].x;
                        this.eq_data.data_u.d_xyzs_array[i].y = from.eq_data.data_u.d_xyzs_array[i].y;
                        this.eq_data.data_u.d_xyzs_array[i].z = from.eq_data.data_u.d_xyzs_array[i].z;
                        int len = from.eq_data.data_u.d_xyzs_array[i].loc.length;
                        if (len > 64) {
                            len = 64;
                        }
                        if (len > 0) {
                            this.eq_data.data_u.d_xyzs_array[i].loc = new byte[len];
                        }
                        for (int j = 0; j < len; ++j) {
                            this.eq_data.data_u.d_xyzs_array[i].loc[j] = from.eq_data.data_u.d_xyzs_array[i].loc[j];
                        }
                    }
                    break;
                }
                case 109: {
                    this.eq_data.data_u.d_mdfa = new MDAF();
                    n = from.eq_data.data_u.d_mdfa.d_farray.length;
                    if (n > 16384) {
                        n = 16384;
                    }
                    this.eq_data.data_u.d_mdfa.d_farray = new float[n];
                    for (i = 0; i < n; ++i) {
                        this.eq_data.data_u.d_mdfa.d_farray[i] = from.eq_data.data_u.d_mdfa.d_farray[i];
                    }
                    n = from.eq_data.data_u.d_mdfa.comment.length;
                    if (n > 80) {
                        n = 80;
                    }
                    this.eq_data.data_u.d_mdfa.comment = n == 0 ? new byte[1] : new byte[n];
                    for (i = 0; i < n; ++i) {
                        this.eq_data.data_u.d_mdfa.comment[i] = from.eq_data.data_u.d_mdfa.comment[i];
                    }
                    n = from.eq_data.data_u.d_mdfa.dims.length;
                    if (n > 6) {
                        n = 6;
                    }
                    this.eq_data.data_u.d_mdfa.dims = n == 0 ? new int[1] : new int[n];
                    for (i = 0; i < n; ++i) {
                        this.eq_data.data_u.d_mdfa.dims[i] = from.eq_data.data_u.d_mdfa.dims[i];
                    }
                    break;
                }
                case 1013: {
                    n = from.eq_data.data_u.d_ts_spectrum_array.length;
                    if (n > 128) {
                        n = 128;
                    }
                    if (n > 0) {
                        this.eq_data.data_u.d_ts_spectrum_array = new TS_SPECTRUM[n];
                    }
                    for (i = 0; i < n; ++i) {
                        if (from.eq_data.data_u.d_ts_spectrum_array[i] != null) {
                            this.eq_data.data_u.d_ts_spectrum_array[i] = new TS_SPECTRUM();
                            this.eq_data.data_u.d_ts_spectrum_array[i].tsec = from.eq_data.data_u.d_ts_spectrum_array[i].tsec;
                            this.eq_data.data_u.d_ts_spectrum_array[i].tmsec = from.eq_data.data_u.d_ts_spectrum_array[i].tmsec;
                            this.eq_data.data_u.d_ts_spectrum_array[i].tstatus = from.eq_data.data_u.d_ts_spectrum_array[i].tstatus;
                            if (from.eq_data.data_u.d_ts_spectrum_array[i].sp != null) {
                                int j;
                                int k;
                                this.eq_data.data_u.d_ts_spectrum_array[i].sp = new SPECTRUM();
                                if (from.eq_data.data_u.d_ts_spectrum_array[i].sp.d_spect_array != null) {
                                    k = from.eq_data.data_u.d_ts_spectrum_array[i].sp.d_spect_array.length;
                                    if (k > 0x100000) {
                                        k = 0x100000;
                                    }
                                    this.eq_data.data_u.d_ts_spectrum_array[i].sp.d_spect_array = new float[k];
                                    for (j = 0; j < k; ++j) {
                                        this.eq_data.data_u.d_ts_spectrum_array[i].sp.d_spect_array[j] = from.eq_data.data_u.d_ts_spectrum_array[i].sp.d_spect_array[j];
                                    }
                                }
                                if (from.eq_data.data_u.d_ts_spectrum_array[i].sp.comment != null) {
                                    k = from.eq_data.data_u.d_ts_spectrum_array[i].sp.comment.length;
                                    if (k > 80) {
                                        k = 80;
                                    }
                                    this.eq_data.data_u.d_ts_spectrum_array[i].sp.comment = k == 0 ? new byte[1] : new byte[k];
                                    for (j = 0; j < k; ++j) {
                                        this.eq_data.data_u.d_ts_spectrum_array[i].sp.comment[j] = from.eq_data.data_u.d_ts_spectrum_array[i].sp.comment[j];
                                    }
                                }
                                this.eq_data.data_u.d_ts_spectrum_array[i].sp.tm = new time_t(from.eq_data.data_u.d_ts_spectrum_array[i].sp.tm.value);
                                this.eq_data.data_u.d_ts_spectrum_array[i].sp.s_start = from.eq_data.data_u.d_ts_spectrum_array[i].sp.s_start;
                                this.eq_data.data_u.d_ts_spectrum_array[i].sp.s_inc = from.eq_data.data_u.d_ts_spectrum_array[i].sp.s_inc;
                                this.eq_data.data_u.d_ts_spectrum_array[i].sp.status = from.eq_data.data_u.d_ts_spectrum_array[i].sp.status;
                                continue;
                            }
                            this.eq_data.data_u.d_ts_spectrum_array[i].sp = null;
                            continue;
                        }
                        this.eq_data.data_u.d_ts_spectrum_array[i] = null;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("EqData copy_from Exception: " + e.getMessage());
        }
    }

    public void copy_from(EqDataBlock data) {
        if (data == null) {
            this.init();
            return;
        }
        this.eq_data.data_u.data_sel = data.data_u.data_sel;
        this.eq_data.tm = new time_t(data.tm.value);
        this.eq_data.error = data.error;
        switch (this.eq_data.data_u.data_sel) {
            case 0: {
                break;
            }
            case 1: {
                this.eq_data.data_u.d_int = data.data_u.d_int;
                break;
            }
            case 8: {
                this.eq_data.data_u.d_short = data.data_u.d_short;
                break;
            }
            case 4: {
                this.eq_data.data_u.d_bool = data.data_u.d_bool;
                break;
            }
            case 2: {
                this.eq_data.data_u.d_float = data.data_u.d_float;
                break;
            }
            case 6: {
                this.eq_data.data_u.d_double = data.data_u.d_double;
                break;
            }
            case 5: {
                if (this.eq_data.data_u.d_char16 == null) {
                    this.eq_data.data_u.d_char16 = new byte[16];
                }
                for (int j = 0; j < 16; ++j) {
                    this.eq_data.data_u.d_char16[j] = data.data_u.d_char16[j];
                }
                break;
            }
            case 3: {
                int n = data.data_u.d_char.length;
                if (this.eq_data.data_u.d_char == null) {
                    this.eq_data.data_u.d_char = new byte[n];
                }
                for (int j = 0; j < n; ++j) {
                    this.eq_data.data_u.d_char[j] = data.data_u.d_char[j];
                }
                break;
            }
            case 12: {
                if (this.eq_data.data_u.d_tds == null) {
                    this.eq_data.data_u.d_tds = new TDS();
                }
                this.eq_data.data_u.d_tds.tm = new time_t(data.data_u.d_tds.tm.value);
                this.eq_data.data_u.d_tds.data = data.data_u.d_tds.data;
                this.eq_data.data_u.d_tds.status = new u_char(data.data_u.d_tds.status.value);
                break;
            }
            case 13: {
                if (this.eq_data.data_u.d_xy == null) {
                    this.eq_data.data_u.d_xy = new XY();
                }
                this.eq_data.data_u.d_xy.x_data = data.data_u.d_xy.x_data;
                this.eq_data.data_u.d_xy.y_data = data.data_u.d_xy.y_data;
                break;
            }
            case 14: {
                if (this.eq_data.data_u.d_iiii == null) {
                    this.eq_data.data_u.d_iiii = new IIII();
                }
                this.eq_data.data_u.d_iiii.i1_data = data.data_u.d_iiii.i1_data;
                this.eq_data.data_u.d_iiii.i2_data = data.data_u.d_iiii.i2_data;
                this.eq_data.data_u.d_iiii.i3_data = data.data_u.d_iiii.i3_data;
                this.eq_data.data_u.d_iiii.i4_data = data.data_u.d_iiii.i4_data;
                break;
            }
            case 17: {
                if (this.eq_data.data_u.d_fis == null) {
                    this.eq_data.data_u.d_fis = new FIS();
                }
                this.eq_data.data_u.d_fis.f_data = data.data_u.d_fis.f_data;
                this.eq_data.data_u.d_fis.i_data = data.data_u.d_fis.i_data;
                this.eq_data.data_u.d_fis.status = data.data_u.d_fis.status;
                break;
            }
            case 19: {
                int i;
                int n;
                if (this.eq_data.data_u.d_spectrum == null) {
                    this.eq_data.data_u.d_spectrum = new SPECTRUM();
                }
                if ((n = data.data_u.d_spectrum.d_spect_array.length) > 0x100000) {
                    n = 0x100000;
                }
                this.eq_data.data_u.d_spectrum.d_spect_array = new float[n];
                for (i = 0; i < n; ++i) {
                    this.eq_data.data_u.d_spectrum.d_spect_array[i] = data.data_u.d_spectrum.d_spect_array[i];
                }
                n = data.data_u.d_spectrum.comment.length;
                if (n > 80) {
                    n = 80;
                }
                this.eq_data.data_u.d_spectrum.comment = n == 0 ? new byte[1] : new byte[n];
                for (i = 0; i < n; ++i) {
                    this.eq_data.data_u.d_spectrum.comment[i] = data.data_u.d_spectrum.comment[i];
                }
                this.eq_data.data_u.d_spectrum.tm = new time_t(data.data_u.d_spectrum.tm.value);
                this.eq_data.data_u.d_spectrum.s_start = data.data_u.d_spectrum.s_start;
                this.eq_data.data_u.d_spectrum.s_inc = data.data_u.d_spectrum.s_inc;
                this.eq_data.data_u.d_spectrum.status = data.data_u.d_spectrum.status;
                break;
            }
            case 20: {
                this.eq_data.data_u.d_xml = new XML();
                int n = data.data_u.d_xml.d_xml_array.length;
                if (n > 0x400000) {
                    n = 0x400000;
                }
                this.eq_data.data_u.d_xml.d_xml_array = new byte[n];
                for (int i = 0; i < n; ++i) {
                    this.eq_data.data_u.d_xml.d_xml_array[i] = data.data_u.d_xml.d_xml_array[i];
                }
                break;
            }
            case 7: {
                this.eq_data.data_u.d_text = new TEXT();
                int n = data.data_u.d_text.d_text_array.length;
                if (n > 0x100000) {
                    n = 0x100000;
                }
                this.eq_data.data_u.d_text.d_text_array = new byte[n];
                for (int i = 0; i < n; ++i) {
                    this.eq_data.data_u.d_text.d_text_array[i] = data.data_u.d_text.d_text_array[i];
                }
                break;
            }
            case 100: {
                int n = data.data_u.d_float_array.length;
                if (n > 1024) {
                    n = 1024;
                }
                if (n > 0) {
                    this.eq_data.data_u.d_float_array = new float[n];
                }
                for (int i = 0; i < n; ++i) {
                    this.eq_data.data_u.d_float_array[i] = data.data_u.d_float_array[i];
                }
                break;
            }
            case 110: {
                int n = data.data_u.d_double_array.length;
                if (n > 1024) {
                    n = 1024;
                }
                if (n > 0) {
                    this.eq_data.data_u.d_double_array = new double[n];
                }
                for (int i = 0; i < n; ++i) {
                    this.eq_data.data_u.d_double_array[i] = data.data_u.d_double_array[i];
                }
                break;
            }
            case 105: 
            case 119: {
                int n = data.data_u.d_int_array.length;
                if (n > 1024) {
                    n = 1024;
                }
                if (n > 0) {
                    this.eq_data.data_u.d_int_array = new int[n];
                }
                for (int i = 0; i < n; ++i) {
                    this.eq_data.data_u.d_int_array[i] = data.data_u.d_int_array[i];
                }
                break;
            }
            case 115: {
                int n = data.data_u.d_short_array.length;
                if (n > 1024) {
                    n = 1024;
                }
                if (n > 0) {
                    this.eq_data.data_u.d_short_array = new short[n];
                }
                for (int i = 0; i < n; ++i) {
                    this.eq_data.data_u.d_short_array[i] = data.data_u.d_short_array[i];
                }
                break;
            }
            case 101: {
                int n = data.data_u.d_tds_array.length;
                if (n > 2000) {
                    n = 2000;
                }
                if (n > 0) {
                    this.eq_data.data_u.d_tds_array = new TDS[n];
                }
                for (int i = 0; i < n; ++i) {
                    this.eq_data.data_u.d_tds_array[i] = new TDS();
                    this.eq_data.data_u.d_tds_array[i].tm = new time_t(data.data_u.d_tds_array[i].tm.value);
                    this.eq_data.data_u.d_tds_array[i].data = data.data_u.d_tds_array[i].data;
                    this.eq_data.data_u.d_tds_array[i].status = new u_char(data.data_u.d_tds_array[i].status.value);
                }
                break;
            }
            case 107: {
                int n = data.data_u.d_tdsi_array.length;
                if (n > 2000) {
                    n = 2000;
                }
                if (n > 0) {
                    this.eq_data.data_u.d_tdsi_array = new TDSi[n];
                }
                for (int i = 0; i < n; ++i) {
                    this.eq_data.data_u.d_tdsi_array[i] = new TDSi();
                    this.eq_data.data_u.d_tdsi_array[i].tm = new time_t(data.data_u.d_tdsi_array[i].tm.value);
                    this.eq_data.data_u.d_tdsi_array[i].data = data.data_u.d_tdsi_array[i].data;
                    this.eq_data.data_u.d_tdsi_array[i].status = data.data_u.d_tdsi_array[i].status;
                    this.eq_data.data_u.d_tdsi_array[i].t_ms = data.data_u.d_tdsi_array[i].t_ms;
                }
                break;
            }
            case 102: {
                int n = data.data_u.d_xy_array.length;
                if (n > 2048) {
                    n = 2048;
                }
                if (n > 0) {
                    this.eq_data.data_u.d_xy_array = new XY[n];
                }
                for (int i = 0; i < n; ++i) {
                    this.eq_data.data_u.d_xy_array[i] = new XY();
                    this.eq_data.data_u.d_xy_array[i].x_data = data.data_u.d_xy_array[i].x_data;
                    this.eq_data.data_u.d_xy_array[i].y_data = data.data_u.d_xy_array[i].y_data;
                }
                break;
            }
            case 16: 
            case 103: {
                int n = data.data_u.d_ustr_array.length;
                if (n > 1000) {
                    n = 1000;
                }
                if (n > 0) {
                    this.eq_data.data_u.d_ustr_array = new USTR[n];
                }
                for (int i = 0; i < n; ++i) {
                    try {
                        this.eq_data.data_u.d_ustr_array[i] = new USTR();
                        this.eq_data.data_u.d_ustr_array[i].i1_data = data.data_u.d_ustr_array[i].i1_data;
                        this.eq_data.data_u.d_ustr_array[i].f1_data = data.data_u.d_ustr_array[i].f1_data;
                        this.eq_data.data_u.d_ustr_array[i].f2_data = data.data_u.d_ustr_array[i].f2_data;
                        this.eq_data.data_u.d_ustr_array[i].tm = new time_t(data.data_u.d_ustr_array[i].tm.value);
                        int len = data.data_u.d_ustr_array[i].str_data.length;
                        if (len > 80) {
                            len = 80;
                        }
                        this.eq_data.data_u.d_ustr_array[i].str_data = len > 0 ? new byte[len] : new byte[1];
                        for (int j = 0; j < len; ++j) {
                            this.eq_data.data_u.d_ustr_array[i].str_data[j] = data.data_u.d_ustr_array[i].str_data[j];
                        }
                        continue;
                    }
                    catch (NullPointerException e) {
                        System.out.println("EqData copy_from TINE NullPointerException: " + e.getMessage());
                    }
                }
                break;
            }
            case 111: {
                int n = data.data_u.d_name16fi.length;
                if (n > 1000) {
                    n = 1000;
                }
                if (n > 0) {
                    this.eq_data.data_u.d_name16fi = new NAME16FI[n];
                }
                for (int i = 0; i < n; ++i) {
                    try {
                        this.eq_data.data_u.d_name16fi[i] = new NAME16FI();
                        this.eq_data.data_u.d_name16fi[i].i_data = data.data_u.d_name16fi[i].i_data;
                        this.eq_data.data_u.d_name16fi[i].f_data = data.data_u.d_name16fi[i].f_data;
                        int len = data.data_u.d_name16fi[i].str_data.length;
                        if (len > 16) {
                            len = 16;
                        }
                        this.eq_data.data_u.d_name16fi[i].str_data = len > 0 ? new byte[len] : new byte[1];
                        for (int j = 0; j < len; ++j) {
                            this.eq_data.data_u.d_name16fi[i].str_data[j] = data.data_u.d_name16fi[i].str_data[j];
                        }
                        continue;
                    }
                    catch (NullPointerException e) {
                        System.out.println("EqData copy_from NAME16FI NullPointerException: " + e.getMessage());
                    }
                }
                break;
            }
            case 112: {
                int n = data.data_u.d_name16ii.length;
                if (n > 1000) {
                    n = 1000;
                }
                if (n > 0) {
                    this.eq_data.data_u.d_name16ii = new NAME16II[n];
                }
                for (int i = 0; i < n; ++i) {
                    try {
                        this.eq_data.data_u.d_name16ii[i] = new NAME16II();
                        this.eq_data.data_u.d_name16ii[i].i1_data = data.data_u.d_name16ii[i].i1_data;
                        this.eq_data.data_u.d_name16ii[i].i2_data = data.data_u.d_name16ii[i].i2_data;
                        int len = data.data_u.d_name16ii[i].str_data.length;
                        if (len > 16) {
                            len = 16;
                        }
                        this.eq_data.data_u.d_name16ii[i].str_data = len > 0 ? new byte[len] : new byte[1];
                        for (int j = 0; j < len; ++j) {
                            this.eq_data.data_u.d_name16ii[i].str_data[j] = data.data_u.d_name16ii[i].str_data[j];
                        }
                        continue;
                    }
                    catch (NullPointerException e) {
                        System.out.println("EqData copy_from NAME16II NullPointerException: " + e.getMessage());
                    }
                }
                break;
            }
            case 104: {
                int n = data.data_u.d_fis_array.length;
                if (n > 128) {
                    n = 128;
                }
                if (n > 0) {
                    this.eq_data.data_u.d_fis_array = new FIS[n];
                }
                for (int i = 0; i < n; ++i) {
                    this.eq_data.data_u.d_fis_array[i] = new FIS();
                    this.eq_data.data_u.d_fis_array[i].f_data = data.data_u.d_fis_array[i].f_data;
                    this.eq_data.data_u.d_fis_array[i].i_data = data.data_u.d_fis_array[i].i_data;
                    this.eq_data.data_u.d_fis_array[i].status = new u_char(data.data_u.d_fis_array[i].status.value);
                }
                break;
            }
            case 114: {
                int i;
                int n = data.data_u.d_fi_array.length;
                if (n > 1000) {
                    n = 1000;
                }
                if (n > 0) {
                    this.eq_data.data_u.d_fi_array = new FI[n];
                }
                for (i = 0; i < n; ++i) {
                    this.eq_data.data_u.d_fi_array[i] = new FI();
                    this.eq_data.data_u.d_fi_array[i].f_data = data.data_u.d_fi_array[i].f_data;
                    this.eq_data.data_u.d_fi_array[i].i_data = data.data_u.d_fi_array[i].i_data;
                }
            }
            case 116: {
                int i;
                int n = data.data_u.d_ii_array.length;
                if (n > 1000) {
                    n = 1000;
                }
                if (n > 0) {
                    this.eq_data.data_u.d_ii_array = new II[n];
                }
                for (i = 0; i < n; ++i) {
                    this.eq_data.data_u.d_ii_array[i] = new II();
                    this.eq_data.data_u.d_ii_array[i].i1_data = data.data_u.d_ii_array[i].i1_data;
                    this.eq_data.data_u.d_ii_array[i].i2_data = data.data_u.d_ii_array[i].i2_data;
                }
                break;
            }
            case 106: {
                this.eq_data.data_u.d_byte_struct = new A_BYTE();
                int n = data.data_u.d_byte_struct.d_byte_array.length;
                if (n > 0x800000) {
                    n = 0x800000;
                }
                if (n > 0) {
                    this.eq_data.data_u.d_byte_struct.d_byte_array = new byte[n];
                }
                for (int i = 0; i < n; ++i) {
                    this.eq_data.data_u.d_byte_struct.d_byte_array[i] = data.data_u.d_byte_struct.d_byte_array[i];
                }
                this.eq_data.data_u.d_byte_struct.x_dim = data.data_u.d_byte_struct.x_dim;
                this.eq_data.data_u.d_byte_struct.y_dim = data.data_u.d_byte_struct.y_dim;
                this.eq_data.data_u.d_byte_struct.x_offset = data.data_u.d_byte_struct.x_offset;
                this.eq_data.data_u.d_byte_struct.y_offset = data.data_u.d_byte_struct.y_offset;
                this.eq_data.data_u.d_byte_struct.option = data.data_u.d_byte_struct.option;
                break;
            }
            case 15: {
                if (this.eq_data.data_u.d_ifff == null) {
                    this.eq_data.data_u.d_ifff = new IFFF();
                }
                this.eq_data.data_u.d_ifff.i1_data = data.data_u.d_ifff.i1_data;
                this.eq_data.data_u.d_ifff.f1_data = data.data_u.d_ifff.f1_data;
                this.eq_data.data_u.d_ifff.f2_data = data.data_u.d_ifff.f2_data;
                this.eq_data.data_u.d_ifff.f3_data = data.data_u.d_ifff.f3_data;
                break;
            }
            case 18: {
                if (this.eq_data.data_u.d_ttii == null) {
                    this.eq_data.data_u.d_ttii = new TTII();
                }
                this.eq_data.data_u.d_ttii.tm1 = new time_t(data.data_u.d_ttii.tm1.value);
                this.eq_data.data_u.d_ttii.tm2 = new time_t(data.data_u.d_ttii.tm2.value);
                this.eq_data.data_u.d_ttii.i1_data = data.data_u.d_ttii.i1_data;
                this.eq_data.data_u.d_ttii.i2_data = data.data_u.d_ttii.i2_data;
                break;
            }
            case 108: {
                int n = data.data_u.d_xyzs_array.length;
                if (n > 1000) {
                    n = 1000;
                }
                if (n > 0) {
                    this.eq_data.data_u.d_xyzs_array = new XYZS[n];
                }
                for (int i = 0; i < n; ++i) {
                    this.eq_data.data_u.d_xyzs_array[i] = new XYZS();
                    this.eq_data.data_u.d_xyzs_array[i].status = data.data_u.d_xyzs_array[i].status;
                    this.eq_data.data_u.d_xyzs_array[i].x = data.data_u.d_xyzs_array[i].x;
                    this.eq_data.data_u.d_xyzs_array[i].y = data.data_u.d_xyzs_array[i].y;
                    this.eq_data.data_u.d_xyzs_array[i].z = data.data_u.d_xyzs_array[i].z;
                    int len = data.data_u.d_xyzs_array[i].loc.length;
                    if (len > 64) {
                        len = 64;
                    }
                    if (len > 0) {
                        this.eq_data.data_u.d_xyzs_array[i].loc = new byte[len];
                    }
                    for (int j = 0; j < len; ++j) {
                        this.eq_data.data_u.d_xyzs_array[i].loc[j] = data.data_u.d_xyzs_array[i].loc[j];
                    }
                }
                break;
            }
            case 109: {
                int i;
                this.eq_data.data_u.d_mdfa = new MDAF();
                int n = data.data_u.d_mdfa.d_farray.length;
                if (n > 16384) {
                    n = 16384;
                }
                this.eq_data.data_u.d_mdfa.d_farray = new float[n];
                for (i = 0; i < n; ++i) {
                    this.eq_data.data_u.d_mdfa.d_farray[i] = data.data_u.d_mdfa.d_farray[i];
                }
                n = data.data_u.d_mdfa.comment.length;
                if (n > 80) {
                    n = 80;
                }
                this.eq_data.data_u.d_mdfa.comment = n == 0 ? new byte[1] : new byte[n];
                for (i = 0; i < n; ++i) {
                    this.eq_data.data_u.d_mdfa.comment[i] = data.data_u.d_mdfa.comment[i];
                }
                n = data.data_u.d_mdfa.dimn;
                if (n > 6) {
                    n = 6;
                }
                this.eq_data.data_u.d_mdfa.dims = n == 0 ? new int[1] : new int[n];
                for (i = 0; i < n; ++i) {
                    this.eq_data.data_u.d_mdfa.dims[i] = data.data_u.d_mdfa.dims[i];
                }
                break;
            }
            case 1013: {
                int n = data.data_u.d_ts_spectrum_array.length;
                if (n > 128) {
                    n = 128;
                }
                if (n > 0) {
                    this.eq_data.data_u.d_ts_spectrum_array = new TS_SPECTRUM[n];
                }
                for (int i = 0; i < n; ++i) {
                    if (data.data_u.d_ts_spectrum_array[i] != null) {
                        this.eq_data.data_u.d_ts_spectrum_array[i] = new TS_SPECTRUM();
                        this.eq_data.data_u.d_ts_spectrum_array[i].tsec = data.data_u.d_ts_spectrum_array[i].tsec;
                        this.eq_data.data_u.d_ts_spectrum_array[i].tmsec = data.data_u.d_ts_spectrum_array[i].tmsec;
                        this.eq_data.data_u.d_ts_spectrum_array[i].tstatus = data.data_u.d_ts_spectrum_array[i].tstatus;
                        if (data.data_u.d_ts_spectrum_array[i].sp != null) {
                            int j;
                            int k;
                            this.eq_data.data_u.d_ts_spectrum_array[i].sp = new SPECTRUM();
                            if (data.data_u.d_ts_spectrum_array[i].sp.d_spect_array != null) {
                                k = data.data_u.d_ts_spectrum_array[i].sp.d_spect_array.length;
                                if (k > 0x100000) {
                                    k = 0x100000;
                                }
                                this.eq_data.data_u.d_ts_spectrum_array[i].sp.d_spect_array = new float[k];
                                for (j = 0; j < k; ++j) {
                                    this.eq_data.data_u.d_ts_spectrum_array[i].sp.d_spect_array[j] = data.data_u.d_ts_spectrum_array[i].sp.d_spect_array[j];
                                }
                            }
                            if (data.data_u.d_ts_spectrum_array[i].sp.comment != null) {
                                k = data.data_u.d_ts_spectrum_array[i].sp.comment.length;
                                if (k > 80) {
                                    k = 80;
                                }
                                this.eq_data.data_u.d_ts_spectrum_array[i].sp.comment = k == 0 ? new byte[1] : new byte[k];
                                for (j = 0; j < k; ++j) {
                                    this.eq_data.data_u.d_ts_spectrum_array[i].sp.comment[j] = data.data_u.d_ts_spectrum_array[i].sp.comment[j];
                                }
                            }
                            this.eq_data.data_u.d_ts_spectrum_array[i].sp.tm = new time_t(data.data_u.d_ts_spectrum_array[i].sp.tm.value);
                            this.eq_data.data_u.d_ts_spectrum_array[i].sp.s_start = data.data_u.d_ts_spectrum_array[i].sp.s_start;
                            this.eq_data.data_u.d_ts_spectrum_array[i].sp.s_inc = data.data_u.d_ts_spectrum_array[i].sp.s_inc;
                            this.eq_data.data_u.d_ts_spectrum_array[i].sp.status = data.data_u.d_ts_spectrum_array[i].sp.status;
                            continue;
                        }
                        this.eq_data.data_u.d_ts_spectrum_array[i].sp = null;
                        continue;
                    }
                    this.eq_data.data_u.d_ts_spectrum_array[i] = null;
                }
                break;
            }
        }
    }

    public void add_from(EqData from) {
        if (from == null) {
            this.init();
            return;
        }
        int lTo = this.array_length();
        int lFrom = from.array_length();
        if (this.eq_data.data_u.data_sel == 0) {
            lTo = 0;
            this.eq_data.tm = new time_t(from.eq_data.tm.value);
            this.eq_data.error = from.eq_data.error;
            this.eq_data.data_u.data_sel = from.eq_data.data_u.data_sel;
        } else {
            if (from.eq_data.error != 0) {
                if (lTo == 0) {
                    this.eq_data.error = from.eq_data.error;
                }
                return;
            }
            if (this.eq_data.error != 0) {
                this.eq_data.data_u.data_sel = from.eq_data.data_u.data_sel;
                this.eq_data.error = from.eq_data.error;
            } else if (this.eq_data.data_u.data_sel != from.eq_data.data_u.data_sel) {
                if (lTo == 0) {
                    this.error(500, "ERR_DIFF_DAT");
                }
                return;
            }
        }
        if (lFrom < 1) {
            return;
        }
        int lTot = lFrom + lTo;
        switch (this.eq_data.data_u.data_sel) {
            case 100: {
                if (lTot > 1024) {
                    lTot = 1024;
                }
                float[] fa = new float[lTot];
                for (int i = 0; i < lTot; ++i) {
                    fa[i] = i < lTo ? this.eq_data.data_u.d_float_array[i] : from.eq_data.data_u.d_float_array[i];
                }
                this.eq_data.data_u.d_float_array = fa;
                break;
            }
            case 110: {
                if (lTot > 1024) {
                    lTot = 1024;
                }
                double[] da = new double[lTot];
                for (int i = 0; i < lTot; ++i) {
                    da[i] = i < lTo ? this.eq_data.data_u.d_double_array[i] : from.eq_data.data_u.d_double_array[i];
                }
                this.eq_data.data_u.d_double_array = da;
                break;
            }
            case 105: 
            case 119: {
                if (lTot > 1024) {
                    lTot = 1024;
                }
                int[] ia = new int[lTot];
                for (int i = 0; i < lTot; ++i) {
                    ia[i] = i < lTo ? this.eq_data.data_u.d_int_array[i] : from.eq_data.data_u.d_int_array[i];
                }
                this.eq_data.data_u.d_int_array = ia;
                break;
            }
            case 115: {
                if (lTot > 1024) {
                    lTot = 1024;
                }
                short[] sa = new short[lTot];
                for (int i = 0; i < lTot; ++i) {
                    sa[i] = i < lTo ? this.eq_data.data_u.d_short_array[i] : from.eq_data.data_u.d_short_array[i];
                }
                this.eq_data.data_u.d_short_array = sa;
                break;
            }
            case 101: {
                if (lTot > 2000) {
                    lTot = 2000;
                }
                TDS[] tds = new TDS[lTot];
                for (int i = 0; i < lTot; ++i) {
                    tds[i] = new TDS();
                    if (i < lTo) {
                        tds[i].tm = new time_t(this.eq_data.data_u.d_tds_array[i].tm.value);
                        tds[i].data = this.eq_data.data_u.d_tds_array[i].data;
                        tds[i].status = new u_char(this.eq_data.data_u.d_tds_array[i].status.value);
                        continue;
                    }
                    tds[i].tm = new time_t(from.eq_data.data_u.d_tds_array[i].tm.value);
                    tds[i].data = from.eq_data.data_u.d_tds_array[i].data;
                    tds[i].status = new u_char(from.eq_data.data_u.d_tds_array[i].status.value);
                }
                this.eq_data.data_u.d_tds_array = tds;
                break;
            }
            case 107: {
                if (lTot > 2000) {
                    lTot = 2000;
                }
                TDSi[] tdsi = new TDSi[lTot];
                for (int i = 0; i < lTot; ++i) {
                    tdsi[i] = new TDSi();
                    if (i < lTo) {
                        tdsi[i].tm = new time_t(this.eq_data.data_u.d_tdsi_array[i].tm.value);
                        tdsi[i].data = this.eq_data.data_u.d_tdsi_array[i].data;
                        tdsi[i].status = this.eq_data.data_u.d_tdsi_array[i].status;
                        tdsi[i].t_ms = this.eq_data.data_u.d_tdsi_array[i].t_ms;
                        continue;
                    }
                    tdsi[i].tm = new time_t(from.eq_data.data_u.d_tdsi_array[i].tm.value);
                    tdsi[i].data = from.eq_data.data_u.d_tdsi_array[i].data;
                    tdsi[i].status = from.eq_data.data_u.d_tdsi_array[i].status;
                    tdsi[i].t_ms = from.eq_data.data_u.d_tdsi_array[i].t_ms;
                }
                this.eq_data.data_u.d_tdsi_array = tdsi;
                break;
            }
            case 102: {
                if (lTot > 2048) {
                    lTot = 2048;
                }
                XY[] xy = new XY[lTot];
                for (int i = 0; i < lTot; ++i) {
                    xy[i] = new XY();
                    if (i < lTo) {
                        xy[i].x_data = this.eq_data.data_u.d_xy_array[i].x_data;
                        xy[i].y_data = this.eq_data.data_u.d_xy_array[i].y_data;
                        continue;
                    }
                    xy[i].x_data = from.eq_data.data_u.d_xy_array[i].x_data;
                    xy[i].y_data = from.eq_data.data_u.d_xy_array[i].y_data;
                }
                this.eq_data.data_u.d_xy_array = xy;
                break;
            }
            case 103: {
                if (lTot > 1000) {
                    lTot = 1000;
                }
                USTR[] ustr = new USTR[lTot];
                for (int i = 0; i < lTot; ++i) {
                    int j;
                    int count;
                    ustr[i] = new USTR();
                    if (i < lTo) {
                        ustr[i].f1_data = this.eq_data.data_u.d_ustr_array[i].f1_data;
                        ustr[i].f2_data = this.eq_data.data_u.d_ustr_array[i].f2_data;
                        ustr[i].tm = new time_t(this.eq_data.data_u.d_ustr_array[i].tm.value);
                        ustr[i].i1_data = this.eq_data.data_u.d_ustr_array[i].i1_data;
                        count = this.eq_data.data_u.d_ustr_array[i].str_data.length;
                        if (count > 80) {
                            count = 80;
                        }
                        ustr[i].str_data = count > 0 ? new byte[count] : new byte[1];
                        for (j = 0; j < count; ++j) {
                            ustr[i].str_data[j] = this.eq_data.data_u.d_ustr_array[i].str_data[j];
                        }
                        continue;
                    }
                    ustr[i].f1_data = from.eq_data.data_u.d_ustr_array[i - lTo].f1_data;
                    ustr[i].f2_data = from.eq_data.data_u.d_ustr_array[i - lTo].f2_data;
                    ustr[i].tm = new time_t(from.eq_data.data_u.d_ustr_array[i - lTo].tm.value);
                    ustr[i].i1_data = from.eq_data.data_u.d_ustr_array[i - lTo].i1_data;
                    count = from.eq_data.data_u.d_ustr_array[i - lTo].str_data.length;
                    if (count > 80) {
                        count = 80;
                    }
                    ustr[i].str_data = count > 0 ? new byte[count] : new byte[1];
                    for (j = 0; j < count; ++j) {
                        ustr[i].str_data[j] = from.eq_data.data_u.d_ustr_array[i - lTo].str_data[j];
                    }
                }
                this.eq_data.data_u.d_ustr_array = ustr;
                break;
            }
            case 111: {
                if (lTot > 1000) {
                    lTot = 1000;
                }
                NAME16FI[] n16fi = new NAME16FI[lTot];
                for (int i = 0; i < lTot; ++i) {
                    int j;
                    int count;
                    n16fi[i] = new NAME16FI();
                    if (i < lTo) {
                        n16fi[i].f_data = this.eq_data.data_u.d_name16fi[i].f_data;
                        n16fi[i].i_data = this.eq_data.data_u.d_name16fi[i].i_data;
                        count = this.eq_data.data_u.d_name16fi[i].str_data.length;
                        if (count > 16) {
                            count = 16;
                        }
                        n16fi[i].str_data = count > 0 ? new byte[count] : new byte[1];
                        for (j = 0; j < count; ++j) {
                            n16fi[i].str_data[j] = this.eq_data.data_u.d_name16fi[i].str_data[j];
                        }
                        continue;
                    }
                    n16fi[i].i_data = from.eq_data.data_u.d_name16fi[i - lTo].i_data;
                    n16fi[i].f_data = from.eq_data.data_u.d_name16fi[i - lTo].f_data;
                    count = from.eq_data.data_u.d_name16fi[i - lTo].str_data.length;
                    if (count > 16) {
                        count = 16;
                    }
                    n16fi[i].str_data = count > 0 ? new byte[count] : new byte[1];
                    for (j = 0; j < count; ++j) {
                        n16fi[i].str_data[j] = from.eq_data.data_u.d_name16fi[i - lTo].str_data[j];
                    }
                }
                this.eq_data.data_u.d_name16fi = n16fi;
                break;
            }
            case 112: {
                if (lTot > 1000) {
                    lTot = 1000;
                }
                NAME16II[] n16ii = new NAME16II[lTot];
                for (int i = 0; i < lTot; ++i) {
                    int j;
                    int count;
                    n16ii[i] = new NAME16II();
                    if (i < lTo) {
                        n16ii[i].i1_data = this.eq_data.data_u.d_name16ii[i].i1_data;
                        n16ii[i].i2_data = this.eq_data.data_u.d_name16ii[i].i2_data;
                        count = this.eq_data.data_u.d_name16ii[i].str_data.length;
                        if (count > 16) {
                            count = 16;
                        }
                        n16ii[i].str_data = count > 0 ? new byte[count] : new byte[1];
                        for (j = 0; j < count; ++j) {
                            n16ii[i].str_data[j] = this.eq_data.data_u.d_name16ii[i].str_data[j];
                        }
                        continue;
                    }
                    n16ii[i].i1_data = from.eq_data.data_u.d_name16ii[i - lTo].i1_data;
                    n16ii[i].i2_data = from.eq_data.data_u.d_name16ii[i - lTo].i2_data;
                    count = from.eq_data.data_u.d_name16ii[i - lTo].str_data.length;
                    if (count > 16) {
                        count = 16;
                    }
                    n16ii[i].str_data = count > 0 ? new byte[count] : new byte[1];
                    for (j = 0; j < count; ++j) {
                        n16ii[i].str_data[j] = from.eq_data.data_u.d_name16ii[i - lTo].str_data[j];
                    }
                }
                this.eq_data.data_u.d_name16ii = n16ii;
                break;
            }
            case 108: {
                if (lTot > 1000) {
                    lTot = 1000;
                }
                XYZS[] xyzs = new XYZS[lTot];
                for (int i = 0; i < lTot; ++i) {
                    int j;
                    xyzs[i] = new XYZS();
                    if (i < lTo) {
                        xyzs[i].status = this.eq_data.data_u.d_xyzs_array[i].status;
                        xyzs[i].x = this.eq_data.data_u.d_xyzs_array[i].x;
                        xyzs[i].y = this.eq_data.data_u.d_xyzs_array[i].y;
                        xyzs[i].z = this.eq_data.data_u.d_xyzs_array[i].z;
                        lFrom = this.eq_data.data_u.d_xyzs_array[i].loc.length;
                        if (lFrom > 64) {
                            lFrom = 64;
                        }
                        if (lFrom > 0) {
                            xyzs[lTo + i].loc = new byte[lFrom];
                        }
                        for (j = 0; j < lFrom; ++j) {
                            xyzs[lTo + i].loc[j] = this.eq_data.data_u.d_xyzs_array[i].loc[j];
                        }
                        continue;
                    }
                    xyzs[i].status = from.eq_data.data_u.d_xyzs_array[i].status;
                    xyzs[i].x = from.eq_data.data_u.d_xyzs_array[i].x;
                    xyzs[i].y = from.eq_data.data_u.d_xyzs_array[i].y;
                    xyzs[i].z = from.eq_data.data_u.d_xyzs_array[i].z;
                    lFrom = from.eq_data.data_u.d_xyzs_array[i].loc.length;
                    if (lFrom > 64) {
                        lFrom = 64;
                    }
                    if (lFrom > 0) {
                        xyzs[lTo + i].loc = new byte[lFrom];
                    }
                    for (j = 0; j < lFrom; ++j) {
                        xyzs[lTo + i].loc[j] = from.eq_data.data_u.d_xyzs_array[i].loc[j];
                    }
                }
                this.eq_data.data_u.d_xyzs_array = xyzs;
                break;
            }
            case 104: {
                if (lTot > 128) {
                    lTot = 128;
                }
                FIS[] fis = new FIS[lTot];
                for (int i = 0; i < lTot; ++i) {
                    fis[i] = new FIS();
                    if (i < lTo) {
                        fis[i].f_data = this.eq_data.data_u.d_fis_array[i].f_data;
                        fis[i].i_data = this.eq_data.data_u.d_fis_array[i].i_data;
                        fis[i].status = new u_char(this.eq_data.data_u.d_fis_array[i].status.value);
                        continue;
                    }
                    fis[i].f_data = from.eq_data.data_u.d_fis_array[i].f_data;
                    fis[i].i_data = from.eq_data.data_u.d_fis_array[i].i_data;
                    fis[i].status = new u_char(from.eq_data.data_u.d_fis_array[i].status.value);
                }
                this.eq_data.data_u.d_fis_array = fis;
                break;
            }
            case 114: {
                if (lTot > 1000) {
                    lTot = 1000;
                }
                FI[] fi = new FI[lTot];
                for (int i = 0; i < lTot; ++i) {
                    fi[i] = new FI();
                    if (i < lTo) {
                        fi[i].f_data = this.eq_data.data_u.d_fi_array[i].f_data;
                        fi[i].i_data = this.eq_data.data_u.d_fi_array[i].i_data;
                        continue;
                    }
                    fi[i].f_data = from.eq_data.data_u.d_fi_array[i].f_data;
                    fi[i].i_data = from.eq_data.data_u.d_fi_array[i].i_data;
                }
                this.eq_data.data_u.d_fi_array = fi;
                break;
            }
            case 116: {
                if (lTot > 1000) {
                    lTot = 1000;
                }
                II[] ii = new II[lTot];
                for (int i = 0; i < lTot; ++i) {
                    ii[i] = new II();
                    if (i < lTo) {
                        ii[i].i1_data = this.eq_data.data_u.d_ii_array[i].i1_data;
                        ii[i].i2_data = this.eq_data.data_u.d_ii_array[i].i2_data;
                        continue;
                    }
                    ii[i].i1_data = from.eq_data.data_u.d_ii_array[i].i1_data;
                    ii[i].i2_data = from.eq_data.data_u.d_ii_array[i].i2_data;
                }
                this.eq_data.data_u.d_ii_array = ii;
                break;
            }
            default: {
                this.copy_from(from);
            }
        }
    }

    public int error() {
        return this.eq_data.error;
    }

    public int type() {
        return this.eq_data.data_u.data_sel;
    }

    public void alloc_array() {
        switch (this.eq_data.data_u.data_sel) {
            case 1013: {
                this.eq_data.data_u.d_ts_spectrum_array = new TS_SPECTRUM[128];
                for (int i = 0; i < 128; ++i) {
                    this.eq_data.data_u.d_ts_spectrum_array[i] = new TS_SPECTRUM();
                    this.eq_data.data_u.d_ts_spectrum_array[i].sp = new SPECTRUM();
                }
                break;
            }
        }
    }

    public void assign_type(int type) {
        this.eq_data.data_u = new DataUnion();
        this.eq_data.data_u.data_sel = type;
        if (type >= 1000) {
            this.alloc_array();
        }
    }

    public String type_string() {
        return this.type_string(this.eq_data.data_u.data_sel);
    }

    public String type_string(int type) {
        switch (type) {
            case 0: {
                return "NULL";
            }
            case 1: {
                return "INT";
            }
            case 2: {
                return "FLOAT";
            }
            case 3: {
                return "STRING";
            }
            case 4: {
                return "BOOL";
            }
            case 5: {
                return "STRING16";
            }
            case 6: {
                return "DOUBLE";
            }
            case 8: {
                return "SHORT";
            }
            case 10: {
                return "YT";
            }
            case 11: {
                return "XYT";
            }
            case 12: {
                return "TDS";
            }
            case 13: {
                return "XY";
            }
            case 14: {
                return "IIII";
            }
            case 15: {
                return "IFFF";
            }
            case 16: {
                return "USTR";
            }
            case 17: {
                return "FIS";
            }
            case 18: {
                return "TTII";
            }
            case 19: {
                return "SPECTRUM";
            }
            case 20: {
                return "XML";
            }
            case 21: {
                return "XYZS";
            }
            case 22: {
                return "IMAGE";
            }
            case 100: {
                return "A_FLOAT";
            }
            case 101: {
                return "A_TDS";
            }
            case 102: {
                return "A_XY";
            }
            case 103: {
                return "A_USTR";
            }
            case 104: {
                return "A_FIS";
            }
            case 105: {
                return "A_INT";
            }
            case 106: {
                return "A_BYTE";
            }
            case 107: {
                return "A_TDSi";
            }
            case 108: {
                return "A_XYZS";
            }
            case 109: {
                return "MDA_FLOAT";
            }
            case 115: {
                return "A_SHORT";
            }
            case 110: {
                return "A_DOUBLE";
            }
            case 113: {
                return "A_NAME16";
            }
            case 118: {
                return "A_NAME32";
            }
            case 117: {
                return "A_NAME64";
            }
            case 111: {
                return "A_NAME16FI";
            }
            case 112: {
                return "A_NAME16II";
            }
            case 114: {
                return "A_FI";
            }
            case 116: {
                return "A_II";
            }
            case 1013: {
                return "A_TS_SPECTRUM";
            }
        }
        return "NULL";
    }

    public int length() {
        try {
            switch (this.eq_data.data_u.data_sel) {
                case 0: {
                    return 0;
                }
                case 3: {
                    return this.eq_data.data_u.d_char.length;
                }
                case 5: {
                    int l = this.eq_data.data_u.d_char16.length;
                    if (l > 16) {
                        l = 16;
                    }
                    return l;
                }
                case 19: {
                    return this.eq_data.data_u.d_spectrum.d_spect_array.length;
                }
                case 20: {
                    return this.eq_data.data_u.d_xml.d_xml_array.length;
                }
                case 7: {
                    return this.eq_data.data_u.d_text.d_text_array.length;
                }
                case 22: {
                    return this.eq_data.data_u.d_image.val.length;
                }
                case 100: {
                    return this.eq_data.data_u.d_float_array.length;
                }
                case 110: {
                    return this.eq_data.data_u.d_double_array.length;
                }
                case 105: 
                case 119: {
                    return this.eq_data.data_u.d_int_array.length;
                }
                case 115: {
                    return this.eq_data.data_u.d_short_array.length;
                }
                case 101: {
                    return this.eq_data.data_u.d_tds_array.length;
                }
                case 107: {
                    return this.eq_data.data_u.d_tdsi_array.length;
                }
                case 102: {
                    return this.eq_data.data_u.d_xy_array.length;
                }
                case 103: {
                    return this.eq_data.data_u.d_ustr_array.length;
                }
                case 111: {
                    return this.eq_data.data_u.d_name16fi.length;
                }
                case 112: {
                    return this.eq_data.data_u.d_name16ii.length;
                }
                case 113: {
                    return this.eq_data.data_u.d_name16.length;
                }
                case 118: {
                    return this.eq_data.data_u.d_name32.length;
                }
                case 117: {
                    return this.eq_data.data_u.d_name64.length;
                }
                case 104: {
                    return this.eq_data.data_u.d_fis_array.length;
                }
                case 114: {
                    return this.eq_data.data_u.d_fi_array.length;
                }
                case 116: {
                    return this.eq_data.data_u.d_ii_array.length;
                }
                case 106: {
                    return this.eq_data.data_u.d_byte_struct.d_byte_array.length;
                }
                case 108: {
                    return this.eq_data.data_u.d_xyzs_array.length;
                }
                case 109: {
                    return this.eq_data.data_u.d_mdfa.d_farray.length;
                }
                case 14: {
                    return 4;
                }
                case 15: {
                    return 4;
                }
                case 1013: {
                    return this.eq_data.data_u.d_ts_spectrum_array.length;
                }
            }
            return 1;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int array_length() {
        try {
            switch (this.eq_data.data_u.data_sel) {
                case 19: {
                    return this.eq_data.data_u.d_spectrum.d_spect_array.length;
                }
                case 100: {
                    return this.eq_data.data_u.d_float_array.length;
                }
                case 110: {
                    return this.eq_data.data_u.d_double_array.length;
                }
                case 105: 
                case 119: {
                    return this.eq_data.data_u.d_int_array.length;
                }
                case 115: {
                    return this.eq_data.data_u.d_short_array.length;
                }
                case 101: {
                    return this.eq_data.data_u.d_tds_array.length;
                }
                case 107: {
                    return this.eq_data.data_u.d_tdsi_array.length;
                }
                case 102: {
                    return this.eq_data.data_u.d_xy_array.length;
                }
                case 103: {
                    return this.eq_data.data_u.d_ustr_array.length;
                }
                case 111: {
                    return this.eq_data.data_u.d_name16fi.length;
                }
                case 112: {
                    return this.eq_data.data_u.d_name16ii.length;
                }
                case 113: {
                    return this.eq_data.data_u.d_name16.length;
                }
                case 117: {
                    return this.eq_data.data_u.d_name64.length;
                }
                case 118: {
                    return this.eq_data.data_u.d_name32.length;
                }
                case 104: {
                    return this.eq_data.data_u.d_fis_array.length;
                }
                case 114: {
                    return this.eq_data.data_u.d_fi_array.length;
                }
                case 116: {
                    return this.eq_data.data_u.d_ii_array.length;
                }
                case 106: {
                    return this.eq_data.data_u.d_byte_struct.d_byte_array.length;
                }
                case 108: {
                    return this.eq_data.data_u.d_xyzs_array.length;
                }
                case 109: {
                    return this.eq_data.data_u.d_mdfa.d_farray.length;
                }
                case 1013: {
                    return this.eq_data.data_u.d_ts_spectrum_array.length;
                }
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int array_length(int index) {
        try {
            switch (this.eq_data.data_u.data_sel) {
                case 109: {
                    if (index < this.eq_data.data_u.d_mdfa.dimn) {
                        return this.eq_data.data_u.d_mdfa.dims[index];
                    }
                }
                case 1013: {
                    if (index < this.eq_data.data_u.d_ts_spectrum_array.length) {
                        return this.eq_data.data_u.d_ts_spectrum_array[index].sp.d_spect_array.length;
                    }
                    return 0;
                }
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int string_length(int index) {
        if (index >= this.length()) {
            return 0;
        }
        try {
            switch (this.eq_data.data_u.data_sel) {
                case 3: {
                    return this.eq_data.data_u.d_char.length;
                }
                case 5: {
                    int l = this.eq_data.data_u.d_char16.length;
                    if (l > 16) {
                        l = 16;
                    }
                    return l;
                }
                case 19: {
                    return this.eq_data.data_u.d_spectrum.comment.length;
                }
                case 22: {
                    return this.eq_data.data_u.d_image.comment.length;
                }
                case 103: {
                    return this.eq_data.data_u.d_ustr_array[index].str_data.length;
                }
                case 108: {
                    return this.eq_data.data_u.d_xyzs_array[index].loc.length;
                }
                case 109: {
                    return this.eq_data.data_u.d_mdfa.comment.length;
                }
                case 111: {
                    return this.eq_data.data_u.d_name16fi[index].str_data.length;
                }
                case 112: {
                    return this.eq_data.data_u.d_name16ii[index].str_data.length;
                }
                case 113: {
                    return this.eq_data.data_u.d_name16[index].str_data.length;
                }
                case 118: {
                    return this.eq_data.data_u.d_name32[index].str_data.length;
                }
                case 117: {
                    return this.eq_data.data_u.d_name64[index].str_data.length;
                }
                case 1013: {
                    return this.eq_data.data_u.d_ts_spectrum_array[index].sp.comment.length;
                }
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public String time_string() {
        long time = 1000L * (long)this.eq_data.tm.value;
        return new String(new Date(time).toString());
    }

    public int get_int() {
        switch (this.eq_data.data_u.data_sel) {
            case 1: {
                return this.eq_data.data_u.d_int;
            }
            case 8: {
                return this.eq_data.data_u.d_short;
            }
            case 2: {
                return (int)this.eq_data.data_u.d_float;
            }
            case 6: {
                return (int)this.eq_data.data_u.d_double;
            }
            case 4: {
                return this.eq_data.data_u.d_bool;
            }
            case 100: 
            case 105: 
            case 110: 
            case 115: 
            case 119: {
                return this.get_int(0);
            }
        }
        return 0;
    }

    public int get_int(int index) {
        int n = this.length() - 1;
        if (this.eq_data.data_u.data_sel != 103 && index > n) {
            index = n;
        }
        if (index < 0) {
            index = 0;
        }
        switch (this.eq_data.data_u.data_sel) {
            case 100: {
                return (int)this.eq_data.data_u.d_float_array[index];
            }
            case 105: 
            case 119: {
                return this.eq_data.data_u.d_int_array[index];
            }
            case 115: {
                return this.eq_data.data_u.d_short_array[index];
            }
            case 101: {
                return this.eq_data.data_u.d_tds_array[index].tm.value;
            }
            case 107: {
                return this.eq_data.data_u.d_tdsi_array[index].tm.value;
            }
            case 106: {
                return this.eq_data.data_u.d_byte_struct.d_byte_array[index];
            }
            case 104: {
                return this.eq_data.data_u.d_fis_array[index].i_data;
            }
            case 114: {
                return this.eq_data.data_u.d_fi_array[index].i_data;
            }
            case 116: {
                return this.eq_data.data_u.d_ii_array[index].i1_data;
            }
            case 14: {
                if (index == 0) {
                    return this.eq_data.data_u.d_iiii.i1_data;
                }
                if (index == 1) {
                    return this.eq_data.data_u.d_iiii.i2_data;
                }
                if (index == 2) {
                    return this.eq_data.data_u.d_iiii.i3_data;
                }
                if (index == 3) {
                    return this.eq_data.data_u.d_iiii.i4_data;
                }
                return 0;
            }
            case 15: {
                if (index == 0) {
                    return this.eq_data.data_u.d_ifff.i1_data;
                }
                if (index == 1) {
                    return (int)this.eq_data.data_u.d_ifff.f1_data;
                }
                if (index == 2) {
                    return (int)this.eq_data.data_u.d_ifff.f2_data;
                }
                if (index != 3) break;
                return (int)this.eq_data.data_u.d_ifff.f3_data;
            }
            case 111: {
                return this.eq_data.data_u.d_name16fi[index].i_data;
            }
            case 112: {
                return this.eq_data.data_u.d_name16ii[index].i1_data;
            }
            case 103: {
                switch (index) {
                    case 0: {
                        return this.eq_data.data_u.d_ustr_array[0].i1_data;
                    }
                    case 1: {
                        return (int)this.eq_data.data_u.d_ustr_array[0].f1_data;
                    }
                    case 2: {
                        return (int)this.eq_data.data_u.d_ustr_array[0].f2_data;
                    }
                    case 3: {
                        return this.eq_data.data_u.d_ustr_array[0].tm.value;
                    }
                }
                return 0;
            }
            case 108: {
                switch (index) {
                    case 0: {
                        return this.eq_data.data_u.d_xyzs_array[0].status;
                    }
                    case 1: {
                        return (int)this.eq_data.data_u.d_xyzs_array[0].x;
                    }
                    case 2: {
                        return (int)this.eq_data.data_u.d_xyzs_array[0].y;
                    }
                    case 3: {
                        return (int)this.eq_data.data_u.d_xyzs_array[0].z;
                    }
                }
                return 0;
            }
            case 109: {
                if (index >= this.eq_data.data_u.d_mdfa.d_farray.length) {
                    return 0;
                }
                return (int)this.eq_data.data_u.d_mdfa.d_farray[index];
            }
            default: {
                if (index == 0) {
                    return this.get_int();
                }
                return 0;
            }
        }
        return 0;
    }

    public float get_float() {
        switch (this.eq_data.data_u.data_sel) {
            case 1: {
                return this.eq_data.data_u.d_int;
            }
            case 105: {
                return this.eq_data.data_u.d_int_array[0];
            }
            case 8: {
                return this.eq_data.data_u.d_short;
            }
            case 115: {
                return this.eq_data.data_u.d_short_array[0];
            }
            case 4: {
                return this.eq_data.data_u.d_bool;
            }
            case 2: {
                return this.eq_data.data_u.d_float;
            }
            case 100: {
                return this.eq_data.data_u.d_float_array[0];
            }
            case 6: {
                return (float)this.eq_data.data_u.d_double;
            }
            case 110: {
                return (float)this.eq_data.data_u.d_double_array[0];
            }
        }
        return 0.0f;
    }

    public float get_float(int index) {
        int n = this.length() - 1;
        if (this.eq_data.data_u.data_sel != 103 && index > n) {
            index = n;
        }
        if (index < 0) {
            index = 0;
        }
        try {
            switch (this.eq_data.data_u.data_sel) {
                case 19: {
                    return this.eq_data.data_u.d_spectrum.d_spect_array[index];
                }
                case 100: {
                    return this.eq_data.data_u.d_float_array[index];
                }
                case 110: {
                    return (float)this.eq_data.data_u.d_double_array[index];
                }
                case 101: {
                    return this.eq_data.data_u.d_tds_array[index].data;
                }
                case 107: {
                    return this.eq_data.data_u.d_tdsi_array[index].data;
                }
                case 104: {
                    return this.eq_data.data_u.d_fis_array[index].f_data;
                }
                case 114: {
                    return this.eq_data.data_u.d_fi_array[index].f_data;
                }
                case 14: {
                    if (index == 0) {
                        return this.eq_data.data_u.d_iiii.i1_data;
                    }
                    if (index == 1) {
                        return this.eq_data.data_u.d_iiii.i2_data;
                    }
                    if (index == 2) {
                        return this.eq_data.data_u.d_iiii.i3_data;
                    }
                    if (index == 3) {
                        return this.eq_data.data_u.d_iiii.i4_data;
                    }
                    return 0.0f;
                }
                case 15: {
                    if (index == 0) {
                        return this.eq_data.data_u.d_ifff.i1_data;
                    }
                    if (index == 1) {
                        return this.eq_data.data_u.d_ifff.f1_data;
                    }
                    if (index == 2) {
                        return this.eq_data.data_u.d_ifff.f2_data;
                    }
                    if (index == 3) {
                        return this.eq_data.data_u.d_ifff.f3_data;
                    }
                    return 0.0f;
                }
                case 18: {
                    if (index == 0) {
                        return this.eq_data.data_u.d_ttii.tm1.value;
                    }
                    if (index == 1) {
                        return this.eq_data.data_u.d_ttii.tm2.value;
                    }
                    if (index == 2) {
                        return this.eq_data.data_u.d_ttii.i1_data;
                    }
                    if (index == 3) {
                        return this.eq_data.data_u.d_ttii.i2_data;
                    }
                    return 0.0f;
                }
                case 111: {
                    return this.eq_data.data_u.d_name16fi[index].f_data;
                }
                case 103: {
                    switch (index) {
                        case 0: {
                            return this.eq_data.data_u.d_ustr_array[0].i1_data;
                        }
                        case 1: {
                            return this.eq_data.data_u.d_ustr_array[0].f1_data;
                        }
                        case 2: {
                            return this.eq_data.data_u.d_ustr_array[0].f2_data;
                        }
                        case 3: {
                            return this.eq_data.data_u.d_ustr_array[0].tm.value;
                        }
                    }
                    return 0.0f;
                }
                case 108: {
                    switch (index) {
                        case 0: {
                            return this.eq_data.data_u.d_xyzs_array[0].status;
                        }
                        case 1: {
                            return this.eq_data.data_u.d_xyzs_array[0].x;
                        }
                        case 2: {
                            return this.eq_data.data_u.d_xyzs_array[0].y;
                        }
                        case 3: {
                            return this.eq_data.data_u.d_xyzs_array[0].z;
                        }
                    }
                    return 0.0f;
                }
                case 109: {
                    if (index >= this.eq_data.data_u.d_mdfa.d_farray.length) {
                        return 0.0f;
                    }
                    return this.eq_data.data_u.d_mdfa.d_farray[index];
                }
            }
            if (index == 0) {
                return this.get_float();
            }
            return 0.0f;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public double get_double() {
        switch (this.eq_data.data_u.data_sel) {
            case 1: {
                return this.eq_data.data_u.d_int;
            }
            case 8: {
                return this.eq_data.data_u.d_short;
            }
            case 4: {
                return this.eq_data.data_u.d_bool;
            }
            case 2: {
                return this.eq_data.data_u.d_float;
            }
            case 6: {
                return this.eq_data.data_u.d_double;
            }
        }
        return 0.0;
    }

    public double get_double(int index) {
        int n = this.length() - 1;
        if (this.eq_data.data_u.data_sel != 103 && index > n) {
            index = n;
        }
        if (index < 0) {
            index = 0;
        }
        switch (this.eq_data.data_u.data_sel) {
            case 19: {
                return this.eq_data.data_u.d_spectrum.d_spect_array[index];
            }
            case 100: {
                return this.eq_data.data_u.d_float_array[index];
            }
            case 110: {
                return this.eq_data.data_u.d_double_array[index];
            }
            case 101: {
                return this.eq_data.data_u.d_tds_array[index].data;
            }
            case 107: {
                return this.eq_data.data_u.d_tdsi_array[index].data;
            }
            case 104: {
                return this.eq_data.data_u.d_fis_array[index].f_data;
            }
            case 114: {
                return this.eq_data.data_u.d_fi_array[index].f_data;
            }
            case 14: {
                if (index == 0) {
                    return this.eq_data.data_u.d_iiii.i1_data;
                }
                if (index == 1) {
                    return this.eq_data.data_u.d_iiii.i2_data;
                }
                if (index == 2) {
                    return this.eq_data.data_u.d_iiii.i3_data;
                }
                if (index == 3) {
                    return this.eq_data.data_u.d_iiii.i4_data;
                }
                return 0.0;
            }
            case 15: {
                if (index == 0) {
                    return this.eq_data.data_u.d_ifff.i1_data;
                }
                if (index == 1) {
                    return this.eq_data.data_u.d_ifff.f1_data;
                }
                if (index == 2) {
                    return this.eq_data.data_u.d_ifff.f2_data;
                }
                if (index == 3) {
                    return this.eq_data.data_u.d_ifff.f3_data;
                }
                return 0.0;
            }
            case 18: {
                if (index == 0) {
                    return this.eq_data.data_u.d_ttii.tm1.value;
                }
                if (index == 1) {
                    return this.eq_data.data_u.d_ttii.tm2.value;
                }
                if (index == 2) {
                    return this.eq_data.data_u.d_ttii.i1_data;
                }
                if (index == 3) {
                    return this.eq_data.data_u.d_ttii.i2_data;
                }
                return 0.0;
            }
            case 111: {
                return this.eq_data.data_u.d_name16fi[index].f_data;
            }
            case 103: {
                switch (index) {
                    case 0: {
                        return this.eq_data.data_u.d_ustr_array[0].i1_data;
                    }
                    case 1: {
                        return this.eq_data.data_u.d_ustr_array[0].f1_data;
                    }
                    case 2: {
                        return this.eq_data.data_u.d_ustr_array[0].f2_data;
                    }
                    case 3: {
                        return this.eq_data.data_u.d_ustr_array[0].tm.value;
                    }
                }
                return 0.0;
            }
            case 108: {
                switch (index) {
                    case 0: {
                        return this.eq_data.data_u.d_xyzs_array[0].status;
                    }
                    case 1: {
                        return this.eq_data.data_u.d_xyzs_array[0].x;
                    }
                    case 2: {
                        return this.eq_data.data_u.d_xyzs_array[0].y;
                    }
                    case 3: {
                        return this.eq_data.data_u.d_xyzs_array[0].z;
                    }
                }
                return 0.0;
            }
            case 109: {
                if (index >= this.eq_data.data_u.d_mdfa.d_farray.length) {
                    return 0.0;
                }
                return this.eq_data.data_u.d_mdfa.d_farray[index];
            }
        }
        if (index == 0) {
            return this.get_double();
        }
        return 0.0;
    }

    public float[] get_float_array() {
        switch (this.eq_data.data_u.data_sel) {
            case 19: {
                return this.eq_data.data_u.d_spectrum.d_spect_array;
            }
            case 100: {
                return this.eq_data.data_u.d_float_array;
            }
            case 109: {
                return this.eq_data.data_u.d_mdfa.d_farray;
            }
            case 103: {
                int len = this.array_length();
                float[] a = new float[len];
                for (int i = 0; i < len; ++i) {
                    a[i] = this.eq_data.data_u.d_ustr_array[i].f1_data;
                }
                return a;
            }
        }
        return null;
    }

    public String get_string() {
        String info = null;
        DataUnion DataUnion_u = this.eq_data.data_u;
        try {
            switch (DataUnion_u.data_sel) {
                case 0: {
                    return "  ";
                }
                case 1: {
                    return String.valueOf(DataUnion_u.d_int);
                }
                case 8: {
                    return String.valueOf(DataUnion_u.d_short);
                }
                case 4: {
                    if (DataUnion_u.d_bool == 1) {
                        return "1";
                    }
                    return "0";
                }
                case 2: {
                    return String.valueOf(DataUnion_u.d_float);
                }
                case 6: {
                    return String.valueOf(DataUnion_u.d_double);
                }
                case 3: {
                    return new String(DataUnion_u.d_char).trim();
                }
                case 5: {
                    return new String(DataUnion_u.d_char16).trim();
                }
                case 12: {
                    long time = 1000L * (long)DataUnion_u.d_tds.tm.value;
                    return new String("\"" + new Date(time).toString() + "\"" + " " + String.valueOf(DataUnion_u.d_tds.tm.value) + " " + String.valueOf(DataUnion_u.d_tds.data) + " " + String.valueOf(DataUnion_u.d_tds.status.value));
                }
                case 13: {
                    return new String(String.valueOf(DataUnion_u.d_xy.x_data) + " " + String.valueOf(DataUnion_u.d_xy.y_data));
                }
                case 14: {
                    return new String(String.valueOf(DataUnion_u.d_iiii.i1_data) + " " + String.valueOf(DataUnion_u.d_iiii.i2_data) + " " + String.valueOf(DataUnion_u.d_iiii.i3_data) + " " + String.valueOf(DataUnion_u.d_iiii.i4_data));
                }
                case 15: {
                    return new String(String.valueOf(DataUnion_u.d_ifff.i1_data) + " " + String.valueOf(DataUnion_u.d_ifff.f1_data) + " " + String.valueOf(DataUnion_u.d_ifff.f2_data) + " " + String.valueOf(DataUnion_u.d_ifff.f3_data));
                }
                case 17: {
                    return new String(String.valueOf(DataUnion_u.d_fis.f_data) + " " + String.valueOf(DataUnion_u.d_fis.i_data) + " " + String.valueOf(DataUnion_u.d_fis.status.value));
                }
                case 18: {
                    long time = 1000L * (long)DataUnion_u.d_ttii.tm1.value;
                    long time1 = 1000L * (long)DataUnion_u.d_ttii.tm2.value;
                    return new String("\"" + new Date(time).toString() + "\"" + " " + String.valueOf(DataUnion_u.d_ttii.tm1.value) + " " + "\"" + new Date(time1).toString() + "\"" + " " + String.valueOf(DataUnion_u.d_ttii.tm2.value) + " " + String.valueOf(DataUnion_u.d_ttii.i1_data) + " " + String.valueOf(DataUnion_u.d_ttii.i2_data));
                }
                case 19: {
                    try {
                        info = new String(DataUnion_u.d_spectrum.comment);
                        long time = 1000L * (long)DataUnion_u.d_spectrum.tm.value;
                        return new String("\"" + new Date(time).toString() + "\"" + " " + String.valueOf(DataUnion_u.d_spectrum.tm.value) + " " + String.valueOf(DataUnion_u.d_spectrum.s_start) + " " + String.valueOf(DataUnion_u.d_spectrum.s_inc) + " " + String.valueOf(DataUnion_u.d_spectrum.status) + " " + info.trim());
                    }
                    catch (NullPointerException e) {
                        return new String("Not set complete");
                    }
                }
                case 22: {
                    if (DataUnion_u.d_image.val == null) {
                        return " ";
                    }
                    int len = DataUnion_u.d_image.val.length;
                    return new String("IMAGE array length = " + String.valueOf(len));
                }
                case 105: 
                case 119: {
                    int len = DataUnion_u.d_int_array.length;
                    StringBuffer buf = new StringBuffer();
                    for (int i = 0; i < len; ++i) {
                        buf.append(DataUnion_u.d_int_array[i]);
                        buf.append(" ");
                    }
                    if (len == 0) {
                        return " ";
                    }
                    return buf.toString();
                }
                case 115: {
                    int len = DataUnion_u.d_short_array.length;
                    if (len == 1) {
                        return new String(String.valueOf(DataUnion_u.d_short_array[0]));
                    }
                    return new String("integer array length = " + String.valueOf(len));
                }
                case 100: {
                    int len = DataUnion_u.d_float_array.length;
                    StringBuffer buf = new StringBuffer();
                    for (int i = 0; i < len; ++i) {
                        buf.append(DataUnion_u.d_float_array[i]);
                        buf.append(" ");
                    }
                    if (len == 0) {
                        return " ";
                    }
                    return buf.toString();
                }
                case 110: {
                    int len = DataUnion_u.d_double_array.length;
                    StringBuffer buf = new StringBuffer();
                    for (int i = 0; i < len; ++i) {
                        buf.append(DataUnion_u.d_double_array[i]);
                        buf.append(" ");
                    }
                    if (len == 0) {
                        return " ";
                    }
                    return buf.toString();
                }
                case 101: {
                    int len = DataUnion_u.d_tds_array.length;
                    if (len == 1) {
                        long time = 1000L * (long)DataUnion_u.d_tds_array[0].tm.value;
                        return new String("\"" + new Date(time).toString() + "\" " + String.valueOf(DataUnion_u.d_tds_array[0].tm.value) + " " + String.valueOf(DataUnion_u.d_tds_array[0].data) + " " + String.valueOf(DataUnion_u.d_tds_array[0].status.value));
                    }
                    return new String("TDS array length = " + String.valueOf(len));
                }
                case 107: {
                    int len = DataUnion_u.d_tdsi_array.length;
                    if (len == 1) {
                        long time = 1000L * (long)DataUnion_u.d_tdsi_array[0].tm.value;
                        return new String("\"" + new Date(time).toString() + "\" " + String.valueOf(DataUnion_u.d_tdsi_array[0].tm.value) + " " + String.valueOf(DataUnion_u.d_tdsi_array[0].data) + " " + String.valueOf(DataUnion_u.d_tdsi_array[0].t_ms) + " " + String.valueOf(DataUnion_u.d_tdsi_array[0].status));
                    }
                    return new String("TDS array length = " + String.valueOf(len));
                }
                case 102: {
                    int len = DataUnion_u.d_xy_array.length;
                    if (len == 1) {
                        return new String(String.valueOf(DataUnion_u.d_xy_array[0].x_data) + " " + String.valueOf(DataUnion_u.d_xy_array[0].y_data));
                    }
                    return new String("XY array length = " + String.valueOf(len));
                }
                case 16: 
                case 103: {
                    int len = DataUnion_u.d_ustr_array.length;
                    if (len == 1) {
                        info = DataUnion_u.d_ustr_array[0].str_data != null ? new String(DataUnion_u.d_ustr_array[0].str_data) : new String();
                        long time = 1000L * (long)DataUnion_u.d_ustr_array[0].tm.value;
                        return new String(String.valueOf(DataUnion_u.d_ustr_array[0].i1_data) + " " + String.valueOf(DataUnion_u.d_ustr_array[0].f1_data) + " " + String.valueOf(DataUnion_u.d_ustr_array[0].f2_data) + " " + String.valueOf(DataUnion_u.d_ustr_array[0].tm.value) + " " + info.trim());
                    }
                    return new String("number of strings = " + String.valueOf(len));
                }
                case 104: {
                    int len = DataUnion_u.d_fis_array.length;
                    if (len == 1) {
                        return new String(String.valueOf(DataUnion_u.d_fis_array[0].f_data) + " " + String.valueOf(DataUnion_u.d_fis_array[0].i_data) + " " + String.valueOf(DataUnion_u.d_fis_array[0].status.value));
                    }
                    return new String("FIS array length = " + String.valueOf(len));
                }
                case 114: {
                    int len = DataUnion_u.d_fi_array.length;
                    if (len == 1) {
                        return new String(String.valueOf(DataUnion_u.d_fi_array[0].f_data) + " " + String.valueOf(DataUnion_u.d_fi_array[0].i_data));
                    }
                    return new String("FI array length = " + String.valueOf(len));
                }
                case 116: {
                    int len = DataUnion_u.d_ii_array.length;
                    if (len == 1) {
                        return new String(String.valueOf(DataUnion_u.d_ii_array[0].i1_data) + " " + String.valueOf(DataUnion_u.d_ii_array[0].i2_data));
                    }
                    return new String("II array length = " + String.valueOf(len));
                }
                case 111: {
                    int len = DataUnion_u.d_name16fi.length;
                    if (len == 1) {
                        return new String(String.valueOf(DataUnion_u.d_name16fi[0].str_data).trim() + " " + String.valueOf(DataUnion_u.d_name16fi[0].f_data) + " " + String.valueOf(DataUnion_u.d_name16fi[0].i_data));
                    }
                    return new String("NAME16FI array length = " + String.valueOf(len));
                }
                case 112: {
                    int len = DataUnion_u.d_name16ii.length;
                    if (len == 1) {
                        return new String(String.valueOf(DataUnion_u.d_name16ii[0].str_data).trim() + " " + String.valueOf(DataUnion_u.d_name16ii[0].i1_data) + " " + String.valueOf(DataUnion_u.d_name16ii[0].i2_data));
                    }
                    return new String("NAME16II array length = " + String.valueOf(len));
                }
                case 113: {
                    int len = DataUnion_u.d_name16.length;
                    if (len == 1) {
                        return new String(String.valueOf(DataUnion_u.d_name16[0].str_data)).trim();
                    }
                    return new String("NAME16 array length = " + String.valueOf(len));
                }
                case 118: {
                    int len = DataUnion_u.d_name32.length;
                    if (len == 1) {
                        return new String(DataUnion_u.d_name32[0].str_data).trim();
                    }
                    return new String("NAME64 array length = " + String.valueOf(len));
                }
                case 117: {
                    int len = DataUnion_u.d_name64.length;
                    if (len == 1) {
                        return new String(DataUnion_u.d_name64[0].str_data).trim();
                    }
                    return new String("NAME64 array length = " + String.valueOf(len));
                }
                case 106: {
                    int len = DataUnion_u.d_byte_struct.d_byte_array.length;
                    StringBuffer buf = new StringBuffer();
                    for (int i = 0; i < len; ++i) {
                        buf.append(DataUnion_u.d_byte_struct.d_byte_array[i]);
                        buf.append(" ");
                    }
                    if (len == 0) {
                        return " ";
                    }
                    return buf.toString();
                }
                case 20: {
                    if (DataUnion_u.d_xml.d_xml_array == null) {
                        return new String("XML data = null");
                    }
                    return new String(DataUnion_u.d_xml.d_xml_array).trim();
                }
                case 7: {
                    if (DataUnion_u.d_text.d_text_array == null) {
                        return new String("TEXT data = null");
                    }
                    return new String(DataUnion_u.d_text.d_text_array).trim();
                }
                case 108: {
                    int len = DataUnion_u.d_xyzs_array.length;
                    if (len == 1) {
                        info = new String(DataUnion_u.d_xyzs_array[0].loc);
                        return new String(String.valueOf(DataUnion_u.d_xyzs_array[0].status) + " " + String.valueOf(DataUnion_u.d_xyzs_array[0].x) + " " + String.valueOf(DataUnion_u.d_xyzs_array[0].y) + " " + String.valueOf(DataUnion_u.d_xyzs_array[0].z) + " " + info);
                    }
                    return new String("number of locations = " + String.valueOf(len));
                }
                case 1013: {
                    int len = DataUnion_u.d_ts_spectrum_array.length;
                    if (len == 1) {
                        info = new String(DataUnion_u.d_ts_spectrum_array[0].sp.comment);
                        return new String(String.valueOf(DataUnion_u.d_ts_spectrum_array[0].tsec) + " " + String.valueOf(DataUnion_u.d_ts_spectrum_array[0].tmsec) + " " + String.valueOf(DataUnion_u.d_ts_spectrum_array[0].tstatus) + " " + String.valueOf(DataUnion_u.d_ts_spectrum_array[0].sp.tm) + " " + String.valueOf(DataUnion_u.d_ts_spectrum_array[0].sp.s_start) + " " + String.valueOf(DataUnion_u.d_ts_spectrum_array[0].sp.s_inc) + " " + String.valueOf(DataUnion_u.d_ts_spectrum_array[0].sp.status) + " " + info + " , data length" + " " + String.valueOf(DataUnion_u.d_ts_spectrum_array[0].sp.d_spect_array.length));
                    }
                    return new String("number of spectrums = " + String.valueOf(len));
                }
                case 109: {
                    switch (DataUnion_u.d_mdfa.dimn) {
                        case 1: {
                            return new String("dims:  " + String.valueOf(DataUnion_u.d_mdfa.dimn) + " " + String.valueOf(DataUnion_u.d_mdfa.dims[0]));
                        }
                        case 2: {
                            return new String("dims:  " + String.valueOf(DataUnion_u.d_mdfa.dimn) + " " + String.valueOf(DataUnion_u.d_mdfa.dims[0]) + " " + String.valueOf(DataUnion_u.d_mdfa.dims[1]));
                        }
                        case 3: {
                            return new String("dims:  " + String.valueOf(DataUnion_u.d_mdfa.dimn) + " " + String.valueOf(DataUnion_u.d_mdfa.dims[0]) + " " + String.valueOf(DataUnion_u.d_mdfa.dims[1]) + " " + String.valueOf(DataUnion_u.d_mdfa.dims[2]));
                        }
                        case 4: {
                            return new String("dims:  " + String.valueOf(DataUnion_u.d_mdfa.dimn) + " " + String.valueOf(DataUnion_u.d_mdfa.dims[0]) + " " + String.valueOf(DataUnion_u.d_mdfa.dims[1]) + " " + String.valueOf(DataUnion_u.d_mdfa.dims[2]) + " " + String.valueOf(DataUnion_u.d_mdfa.dims[3]));
                        }
                        case 5: {
                            return new String("dims:  " + String.valueOf(DataUnion_u.d_mdfa.dimn) + " " + String.valueOf(DataUnion_u.d_mdfa.dims[0]) + " " + String.valueOf(DataUnion_u.d_mdfa.dims[1]) + " " + String.valueOf(DataUnion_u.d_mdfa.dims[2]) + " " + String.valueOf(DataUnion_u.d_mdfa.dims[3]) + " " + String.valueOf(DataUnion_u.d_mdfa.dims[4]));
                        }
                    }
                    return new String("illeg. dim.: 0");
                }
            }
        }
        catch (Exception e) {
            return new String("ERROR: no data ");
        }
        return new String("ill_format " + DataUnion_u.data_sel);
    }

    public String get_string_arg() {
        try {
            switch (this.eq_data.data_u.data_sel) {
                case 3: {
                    if (this.eq_data.data_u.d_char != null) {
                        return new String(this.eq_data.data_u.d_char, "iso-8859-1").trim();
                    }
                    return "";
                }
                case 5: {
                    if (this.eq_data.data_u.d_char16 != null) {
                        return new String(this.eq_data.data_u.d_char16, "iso-8859-1").trim();
                    }
                    return "";
                }
                case 111: {
                    if (this.eq_data.data_u.d_name16fi[0] != null) {
                        return new String(this.eq_data.data_u.d_name16fi[0].str_data, "iso-8859-1").trim();
                    }
                    return "";
                }
                case 112: {
                    if (this.eq_data.data_u.d_name16ii[0] != null) {
                        return new String(this.eq_data.data_u.d_name16ii[0].str_data, "iso-8859-1").trim();
                    }
                    return "";
                }
                case 113: {
                    if (this.eq_data.data_u.d_name16[0] != null) {
                        return new String(this.eq_data.data_u.d_name16[0].str_data, "iso-8859-1").trim();
                    }
                    return "";
                }
                case 118: {
                    if (this.eq_data.data_u.d_name32[0] != null) {
                        return new String(this.eq_data.data_u.d_name32[0].str_data, "iso-8859-1").trim();
                    }
                    return "";
                }
                case 117: {
                    if (this.eq_data.data_u.d_name64[0] != null) {
                        return new String(this.eq_data.data_u.d_name64[0].str_data, "iso-8859-1").trim();
                    }
                    return "";
                }
                case 19: {
                    if (this.eq_data.data_u.d_spectrum.comment != null) {
                        return new String(this.eq_data.data_u.d_spectrum.comment, "iso-8859-1").trim();
                    }
                    return "";
                }
                case 22: {
                    if (this.eq_data.data_u.d_image.comment != null) {
                        int l = this.eq_data.data_u.d_image.comment.length;
                        if (l < 0 || l > 80) {
                            return "data comment corupted";
                        }
                        return new String(this.eq_data.data_u.d_image.comment);
                    }
                }
                case 16: 
                case 103: {
                    if (this.eq_data.data_u.d_ustr_array[0].str_data != null) {
                        return new String(this.eq_data.data_u.d_ustr_array[0].str_data, "iso-8859-1").trim();
                    }
                    return "";
                }
                case 108: {
                    if (this.eq_data.data_u.d_xyzs_array[0].loc != null) {
                        return new String(this.eq_data.data_u.d_xyzs_array[0].loc, "iso-8859-1");
                    }
                    return "";
                }
                case 1013: {
                    if (this.eq_data.data_u.d_ts_spectrum_array[0].sp.comment != null) {
                        return new String(this.eq_data.data_u.d_ts_spectrum_array[0].sp.comment, "iso-8859-1");
                    }
                    return "";
                }
                case 109: {
                    if (this.eq_data.data_u.d_mdfa.comment != null) {
                        return new String(this.eq_data.data_u.d_mdfa.comment, "iso-8859-1");
                    }
                    return "";
                }
            }
            return this.get_string();
        }
        catch (UnsupportedEncodingException uee) {
            System.out.println(uee);
            return this.get_string();
        }
    }

    public String get_time_string() {
        switch (this.eq_data.data_u.data_sel) {
            case 103: {
                long time = 1000L * (long)this.eq_data.data_u.d_ustr_array[0].tm.value;
                return new String(new Date(time).toString());
            }
            case 12: {
                long time = 1000L * (long)this.eq_data.data_u.d_tds.tm.value;
                return new String(new Date(time).toString());
            }
            case 18: {
                long time = 1000L * (long)this.eq_data.data_u.d_ttii.tm1.value;
                long time1 = 1000L * (long)this.eq_data.data_u.d_ttii.tm2.value;
                return new String(new Date(time).toString() + " " + new Date(time).toString());
            }
            case 19: {
                long time = 1000L * (long)this.eq_data.data_u.d_spectrum.tm.value;
                return new String(new Date(time).toString());
            }
        }
        long time = 1000L * (long)this.eq_data.tm.value;
        return new String(new Date(time).toString());
    }

    public long get_time() {
        long time;
        switch (this.eq_data.data_u.data_sel) {
            case 103: {
                time = 1000L * (long)this.eq_data.data_u.d_ustr_array[0].tm.value;
                break;
            }
            case 12: {
                time = 1000L * (long)this.eq_data.data_u.d_tds.tm.value;
                break;
            }
            case 18: {
                time = 1000L * (long)this.eq_data.data_u.d_ttii.tm1.value;
                break;
            }
            case 19: {
                time = 1000L * (long)this.eq_data.data_u.d_spectrum.tm.value;
                break;
            }
            default: {
                time = 1000L * (long)this.eq_data.tm.value;
            }
        }
        return time;
    }

    public long get_time(int index) {
        long time = 0L;
        try {
            switch (this.eq_data.data_u.data_sel) {
                case 101: {
                    if (this.eq_data.data_u.d_tds_array == null) {
                        return 0L;
                    }
                    if (index < this.eq_data.data_u.d_tds_array.length && this.eq_data.data_u.d_tds_array[index].tm != null) {
                        time = 1000L * (long)this.eq_data.data_u.d_tds_array[index].tm.value;
                        break;
                    }
                    time = 0L;
                    break;
                }
                case 107: {
                    if (this.eq_data.data_u.d_tdsi_array == null) {
                        return 0L;
                    }
                    if (index < this.eq_data.data_u.d_tdsi_array.length) {
                        time = 1000L * (long)this.eq_data.data_u.d_tdsi_array[index].tm.value;
                        break;
                    }
                    time = 0L;
                    break;
                }
                default: {
                    time = this.get_time();
                    break;
                }
            }
        }
        catch (Exception e) {
            return 0L;
        }
        return time;
    }

    public String get_string(int index) {
        String info = null;
        DataUnion DataUnion_u = this.eq_data.data_u;
        if (index < 0) {
            return " ";
        }
        switch (DataUnion_u.data_sel) {
            case 0: {
                return "  ";
            }
            case 14: {
                if (index == 0) {
                    return new String(String.valueOf(DataUnion_u.d_iiii.i1_data));
                }
                if (index == 1) {
                    return new String(String.valueOf(DataUnion_u.d_iiii.i2_data));
                }
                if (index == 2) {
                    return new String(String.valueOf(DataUnion_u.d_iiii.i3_data));
                }
                if (index == 3) {
                    return new String(String.valueOf(DataUnion_u.d_iiii.i4_data));
                }
                return " ";
            }
            case 15: {
                if (index == 0) {
                    return new String(String.valueOf(DataUnion_u.d_ifff.i1_data));
                }
                if (index == 1) {
                    return new String(String.valueOf(DataUnion_u.d_ifff.f1_data));
                }
                if (index == 2) {
                    return new String(String.valueOf(DataUnion_u.d_ifff.f2_data));
                }
                if (index == 3) {
                    return new String(String.valueOf(DataUnion_u.d_ifff.f3_data));
                }
                return " ";
            }
            case 18: {
                if (index == 0) {
                    return new String(String.valueOf(DataUnion_u.d_ttii.tm1.value));
                }
                if (index == 1) {
                    return new String(String.valueOf(DataUnion_u.d_ttii.tm2.value));
                }
                if (index == 2) {
                    return new String(String.valueOf(DataUnion_u.d_ttii.i1_data));
                }
                if (index == 3) {
                    return new String(String.valueOf(DataUnion_u.d_ttii.i2_data));
                }
                return " ";
            }
            case 19: {
                int len = DataUnion_u.d_spectrum.d_spect_array.length;
                if (index < len) {
                    return new String(String.valueOf(DataUnion_u.d_spectrum.d_spect_array[index]));
                }
                return " ";
            }
            case 109: {
                int len = DataUnion_u.d_mdfa.dimn;
                if (index < len) {
                    return new String(String.valueOf(DataUnion_u.d_mdfa.dims[index]));
                }
                return " ";
            }
            case 105: 
            case 119: {
                int len = DataUnion_u.d_int_array.length;
                if (index < len) {
                    return new String(String.valueOf(DataUnion_u.d_int_array[index]));
                }
                return " ";
            }
            case 115: {
                int len = DataUnion_u.d_short_array.length;
                if (index < len) {
                    return new String(String.valueOf(DataUnion_u.d_short_array[index]));
                }
                return " ";
            }
            case 100: {
                int len = DataUnion_u.d_float_array.length;
                if (index < len) {
                    return new String(String.valueOf(DataUnion_u.d_float_array[index]));
                }
                return " ";
            }
            case 110: {
                int len = DataUnion_u.d_double_array.length;
                if (index < len) {
                    return new String(String.valueOf(DataUnion_u.d_double_array[index]));
                }
                return " ";
            }
            case 101: {
                int len = DataUnion_u.d_tds_array.length;
                if (index < len) {
                    long time = 1000L * (long)DataUnion_u.d_tds_array[index].tm.value;
                    return new String("\"" + new Date(time).toString() + "\" " + String.valueOf(DataUnion_u.d_tds_array[index].tm.value) + " " + String.valueOf(DataUnion_u.d_tds_array[index].data) + " " + String.valueOf(DataUnion_u.d_tds_array[index].status.value));
                }
                return " ";
            }
            case 107: {
                int len = DataUnion_u.d_tdsi_array.length;
                if (index < len) {
                    long time = 1000L * (long)DataUnion_u.d_tdsi_array[index].tm.value;
                    return new String("\"" + new Date(time).toString() + "\" " + String.valueOf(DataUnion_u.d_tdsi_array[index].tm.value) + " " + String.valueOf(DataUnion_u.d_tdsi_array[index].data) + " " + String.valueOf(DataUnion_u.d_tdsi_array[index].t_ms) + " " + String.valueOf(DataUnion_u.d_tdsi_array[index].status));
                }
                return new String("TDS array length = " + String.valueOf(len));
            }
            case 102: {
                int len = DataUnion_u.d_xy_array.length;
                if (index < len) {
                    return new String(String.valueOf(DataUnion_u.d_xy_array[index].x_data) + " " + String.valueOf(DataUnion_u.d_xy_array[index].y_data));
                }
                return " ";
            }
            case 1013: {
                int len = DataUnion_u.d_ts_spectrum_array.length;
                if (index < len) {
                    return new String(String.valueOf(DataUnion_u.d_ts_spectrum_array[index].tsec) + ":" + String.valueOf(DataUnion_u.d_ts_spectrum_array[index].tmsec) + " " + String.valueOf(DataUnion_u.d_ts_spectrum_array[index].tstatus) + ", Spectrum:  " + String.valueOf(DataUnion_u.d_ts_spectrum_array[index].sp.comment) + " " + String.valueOf(DataUnion_u.d_ts_spectrum_array[index].sp.tm) + " " + String.valueOf(DataUnion_u.d_ts_spectrum_array[index].sp.s_start) + " " + String.valueOf(DataUnion_u.d_ts_spectrum_array[index].sp.s_inc) + " " + String.valueOf(DataUnion_u.d_ts_spectrum_array[index].sp.status) + ", data length: " + String.valueOf(DataUnion_u.d_ts_spectrum_array[index].sp.d_spect_array.length));
                }
                return " ";
            }
            case 103: {
                int len = DataUnion_u.d_ustr_array.length;
                if (index < len) {
                    info = DataUnion_u.d_ustr_array[index].str_data != null ? new String(DataUnion_u.d_ustr_array[index].str_data) : new String();
                    long time = 1000L * (long)DataUnion_u.d_ustr_array[index].tm.value;
                    return new String(String.valueOf(DataUnion_u.d_ustr_array[index].i1_data) + " " + String.valueOf(DataUnion_u.d_ustr_array[index].f1_data) + " " + String.valueOf(DataUnion_u.d_ustr_array[index].f2_data) + " " + String.valueOf(DataUnion_u.d_ustr_array[index].tm.value) + " " + info);
                }
                return " ";
            }
            case 104: {
                int len = DataUnion_u.d_fis_array.length;
                if (index < len) {
                    return new String(String.valueOf(DataUnion_u.d_fis_array[index].f_data) + " " + String.valueOf(DataUnion_u.d_fis_array[index].i_data) + " " + String.valueOf(DataUnion_u.d_fis_array[index].status.value));
                }
                return " ";
            }
            case 114: {
                int len = DataUnion_u.d_fi_array.length;
                if (index < len) {
                    return new String(String.valueOf(DataUnion_u.d_fi_array[index].f_data) + " " + String.valueOf(DataUnion_u.d_fi_array[index].i_data));
                }
                return " ";
            }
            case 116: {
                int len = DataUnion_u.d_ii_array.length;
                if (index < len) {
                    return new String(String.valueOf(DataUnion_u.d_ii_array[index].i1_data) + " " + String.valueOf(DataUnion_u.d_ii_array[index].i2_data));
                }
                return " ";
            }
            case 111: {
                int len = DataUnion_u.d_name16fi.length;
                if (index < len) {
                    return new String(DataUnion_u.d_name16fi[index].str_data).trim() + " " + String.valueOf(DataUnion_u.d_name16fi[index].f_data) + " " + String.valueOf(DataUnion_u.d_name16fi[index].i_data);
                }
                return " ";
            }
            case 112: {
                int len = DataUnion_u.d_name16ii.length;
                if (index < len) {
                    return new String(DataUnion_u.d_name16ii[index].str_data).trim() + " " + String.valueOf(DataUnion_u.d_name16ii[index].i1_data) + " " + String.valueOf(DataUnion_u.d_name16ii[index].i2_data);
                }
                return " ";
            }
            case 113: {
                int len = DataUnion_u.d_name16.length;
                if (index < len) {
                    return new String(DataUnion_u.d_name16[index].str_data).trim();
                }
                return " ";
            }
            case 118: {
                int len = DataUnion_u.d_name32.length;
                if (index < len) {
                    return new String(DataUnion_u.d_name32[index].str_data).trim();
                }
                return " ";
            }
            case 117: {
                int len = DataUnion_u.d_name64.length;
                if (index < len) {
                    return new String(DataUnion_u.d_name64[index].str_data).trim();
                }
                return " ";
            }
            case 106: {
                int len = DataUnion_u.d_byte_struct.d_byte_array.length;
                if (index < len) {
                    return new String(String.valueOf(DataUnion_u.d_byte_struct.d_byte_array[index]));
                }
                return " ";
            }
            case 108: {
                int len = DataUnion_u.d_xyzs_array.length;
                if (index < len) {
                    info = new String(DataUnion_u.d_xyzs_array[index].loc);
                    return new String(String.valueOf(DataUnion_u.d_xyzs_array[index].status) + " " + String.valueOf(DataUnion_u.d_xyzs_array[index].x) + " " + String.valueOf(DataUnion_u.d_xyzs_array[index].y) + " " + String.valueOf(DataUnion_u.d_xyzs_array[index].z) + " " + info);
                }
                return " ";
            }
        }
        if (index == 0) {
            return this.get_string();
        }
        return "ill_format";
    }

    public String get_string_arg(int index) {
        try {
            switch (this.eq_data.data_u.data_sel) {
                case 3: {
                    return new String(this.eq_data.data_u.d_char).trim();
                }
                case 5: {
                    return new String(this.eq_data.data_u.d_char16).trim();
                }
                case 111: {
                    if (this.eq_data.data_u.d_name16fi[index] != null) {
                        return new String(this.eq_data.data_u.d_name16fi[index].str_data).trim();
                    }
                    return "";
                }
                case 112: {
                    if (this.eq_data.data_u.d_name16ii[index] != null) {
                        return new String(this.eq_data.data_u.d_name16ii[index].str_data).trim();
                    }
                    return "";
                }
                case 113: {
                    if (this.eq_data.data_u.d_name16[index] != null) {
                        return new String(this.eq_data.data_u.d_name16[index].str_data).trim();
                    }
                    return "";
                }
                case 118: {
                    if (this.eq_data.data_u.d_name32[index] != null) {
                        return new String(this.eq_data.data_u.d_name32[index].str_data).trim();
                    }
                    return "";
                }
                case 117: {
                    if (this.eq_data.data_u.d_name64[index] != null) {
                        return new String(this.eq_data.data_u.d_name64[index].str_data).trim();
                    }
                    return "";
                }
                case 19: {
                    return new String(this.eq_data.data_u.d_spectrum.comment).trim();
                }
                case 103: {
                    if (index < this.eq_data.data_u.d_ustr_array.length) {
                        return new String(this.eq_data.data_u.d_ustr_array[index].str_data).trim();
                    }
                    break;
                }
                case 108: {
                    if (index < this.eq_data.data_u.d_xyzs_array.length) {
                        return new String(this.eq_data.data_u.d_xyzs_array[index].loc);
                    }
                    break;
                }
                case 1013: {
                    if (index < this.eq_data.data_u.d_ts_spectrum_array.length) {
                        return new String(this.eq_data.data_u.d_xyzs_array[index].loc);
                    }
                    break;
                }
                case 109: {
                    return new String(this.eq_data.data_u.d_mdfa.comment);
                }
                default: {
                    return this.get_string(index);
                }
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        return null;
    }

    public String get_time_string(int index) {
        switch (this.eq_data.data_u.data_sel) {
            case 101: {
                if (index < this.length()) {
                    long time = 1000L * (long)this.eq_data.data_u.d_tds_array[index].tm.value;
                    return new String(new Date(time).toString());
                }
                return new String(new Date(0L).toString());
            }
            case 107: {
                if (index < this.length()) {
                    long time = 1000L * (long)this.eq_data.data_u.d_tdsi_array[index].tm.value;
                    return new String(new Date(time).toString());
                }
                return new String(new Date(0L).toString());
            }
            case 103: {
                if (index < this.length()) {
                    long time = 1000L * (long)this.eq_data.data_u.d_ustr_array[index].tm.value;
                    return new String(new Date(time).toString());
                }
                return new String(new Date(0L).toString());
            }
            case 19: {
                long time = 1000L * (long)this.eq_data.data_u.d_spectrum.tm.value;
                return new String(new Date(time).toString());
            }
        }
        long time = 1000L * (long)this.eq_data.tm.value;
        return new String(new Date(time).toString());
    }

    public String get_string_extra(int index) {
        switch (this.eq_data.data_u.data_sel) {
            case 101: {
                if (index < this.length()) {
                    long time = 1000L * (long)this.eq_data.data_u.d_tds_array[index].tm.value;
                    return new String(new Date(time).toString());
                }
            }
            case 107: {
                if (index >= this.length()) break;
                long time = 1000L * (long)this.eq_data.data_u.d_tdsi_array[index].tm.value;
                return new String(new Date(time).toString());
            }
        }
        return new String("ill format");
    }

    public TDS get_tds() {
        if (this.eq_data.data_u.data_sel == 12) {
            return this.eq_data.data_u.d_tds;
        }
        return null;
    }

    public int get_tds(time_t[] tm, float[] f, u_char[] s) {
        if (this.eq_data.data_u.data_sel == 12) {
            if (tm.length > 0) {
                tm[0].value = this.eq_data.data_u.d_tds.tm.value;
            }
            if (f.length > 0) {
                f[0] = this.eq_data.data_u.d_tds.data;
            }
            if (s.length > 0) {
                s[0].value = this.eq_data.data_u.d_tds.status.value;
            }
            return 1;
        }
        return 0;
    }

    public TDS get_tds(int index) {
        if (this.eq_data.data_u.data_sel == 101 && this.eq_data.data_u.d_tds_array.length > 0 && this.eq_data.data_u.d_tds_array.length > index) {
            return this.eq_data.data_u.d_tds_array[index];
        }
        return null;
    }

    public TDSi get_tds2(int index) {
        if (this.eq_data.data_u.data_sel == 107 && this.eq_data.data_u.d_tdsi_array.length > 0 && this.eq_data.data_u.d_tdsi_array.length > index) {
            return this.eq_data.data_u.d_tdsi_array[index];
        }
        return null;
    }

    public int get_tds(time_t[] tm, float[] f, short[] s, int index) {
        if (this.eq_data.data_u.data_sel == 107 && this.eq_data.data_u.d_tdsi_array.length > 0 && this.eq_data.data_u.d_tdsi_array.length > index) {
            if (tm.length > 0) {
                tm[0].value = this.eq_data.data_u.d_tdsi_array[index].tm.value;
            }
            if (f.length > 0) {
                f[0] = this.eq_data.data_u.d_tdsi_array[index].data;
            }
            if (s.length > 0) {
                s[0] = this.eq_data.data_u.d_tdsi_array[index].status;
            }
            if (s.length > 1) {
                s[1] = this.eq_data.data_u.d_tdsi_array[index].t_ms;
            }
            return 1;
        }
        return 0;
    }

    public int get_tds(time_t[] tm, float[] f, u_char[] s, int index) {
        if (this.eq_data.data_u.data_sel == 101 && this.eq_data.data_u.d_tds_array.length > 0 && this.eq_data.data_u.d_tds_array.length > index) {
            if (tm.length > 0) {
                tm[0].value = this.eq_data.data_u.d_tds_array[index].tm.value;
            }
            if (f.length > 0) {
                f[0] = this.eq_data.data_u.d_tds_array[index].data;
            }
            if (s.length > 0) {
                s[0].value = this.eq_data.data_u.d_tds_array[index].status.value;
            }
            if (s.length > 1) {
                s[1].value = 0;
            }
            return 1;
        }
        if (this.eq_data.data_u.data_sel == 107 && this.eq_data.data_u.d_tds_array.length > 0 && this.eq_data.data_u.d_tds_array.length >= index) {
            if (tm.length > 0) {
                tm[0].value = this.eq_data.data_u.d_tdsi_array[index].tm.value;
            }
            if (f.length > 0) {
                f[0] = this.eq_data.data_u.d_tdsi_array[index].data;
            }
            if (s.length > 0) {
                s[0].value = (byte)this.eq_data.data_u.d_tdsi_array[index].status;
            }
            if (s.length > 1) {
                s[1].value = (byte)this.eq_data.data_u.d_tdsi_array[index].t_ms;
            }
            return 1;
        }
        return 0;
    }

    public SPECTRUM get_spectrum() {
        if (this.eq_data.data_u.data_sel == 19) {
            return this.eq_data.data_u.d_spectrum;
        }
        return null;
    }

    public int get_spectrum(byte[] str, int[] i, float[] f, int[] s, time_t[] t, float[] fa) {
        if (this.eq_data.data_u.data_sel == 19) {
            int j;
            int len = this.eq_data.data_u.d_spectrum.comment.length;
            if (i.length > 0) {
                i[0] = len;
            }
            for (j = 0; j < len; ++j) {
                str[j] = this.eq_data.data_u.d_spectrum.comment[j];
            }
            if (f.length > 0) {
                f[0] = this.eq_data.data_u.d_spectrum.s_start;
            }
            if (i.length > 1) {
                f[1] = this.eq_data.data_u.d_spectrum.s_inc;
            }
            if (t.length > 0) {
                t[0].value = this.eq_data.data_u.d_spectrum.tm.value;
            }
            if (s.length > 0) {
                s[0] = this.eq_data.data_u.d_spectrum.status;
            }
            if ((len = this.eq_data.data_u.d_spectrum.d_spect_array.length) > 0x100000) {
                len = 0x100000;
            }
            if (i.length > 1) {
                i[1] = len;
            }
            if (fa != null) {
                for (j = 0; j < len; ++j) {
                    fa[j] = this.eq_data.data_u.d_spectrum.d_spect_array[j];
                }
            }
            return 1;
        }
        int len = this.array_length();
        if (len > 0) {
            int j;
            int faL = fa.length;
            for (j = 0; j < len && j < faL; ++j) {
                fa[j] = this.get_float(j);
            }
            i[0] = 0;
            i[1] = j - 1;
            f[0] = 0.0f;
            f[1] = 1.0f;
            str[0] = 0;
            t[0].value = (int)this.get_time();
            s[0] = 0;
            return 1;
        }
        return 0;
    }

    public TS_SPECTRUM get_ts_spectrum(int index) {
        if (this.eq_data.data_u.data_sel == 1013 && this.eq_data.data_u.d_ts_spectrum_array.length > 0 && this.eq_data.data_u.d_ts_spectrum_array.length > index) {
            return this.eq_data.data_u.d_ts_spectrum_array[index];
        }
        return null;
    }

    public float get_ts_spectrum(int index, int n) {
        if (this.eq_data.data_u.data_sel == 1013 && this.eq_data.data_u.d_ts_spectrum_array.length > 0 && this.eq_data.data_u.d_ts_spectrum_array.length > index && this.eq_data.data_u.d_ts_spectrum_array[index].sp.d_spect_array != null && this.eq_data.data_u.d_ts_spectrum_array[index].sp.d_spect_array.length > n) {
            return this.eq_data.data_u.d_ts_spectrum_array[index].sp.d_spect_array[n];
        }
        return 0.0f;
    }

    public int get_ts_spectrum(byte[] str, int[] i, float[] f, int[] s, time_t[] t, float[] fa, int index) {
        if (this.eq_data.data_u.data_sel == 1013) {
            if (index < this.eq_data.data_u.d_ts_spectrum_array.length) {
                if (this.eq_data.data_u.d_ts_spectrum_array[index] != null && this.eq_data.data_u.d_ts_spectrum_array[index].sp != null) {
                    int j;
                    int len = this.eq_data.data_u.d_ts_spectrum_array[index].sp.comment.length;
                    if (i.length > 0) {
                        i[0] = len;
                    }
                    if (str != null) {
                        for (j = 0; j < len; ++j) {
                            str[j] = this.eq_data.data_u.d_ts_spectrum_array[index].sp.comment[j];
                        }
                        str[len] = 0;
                    }
                    if (f.length > 0) {
                        f[0] = this.eq_data.data_u.d_ts_spectrum_array[index].sp.s_start;
                    }
                    if (i.length > 1) {
                        f[1] = this.eq_data.data_u.d_ts_spectrum_array[index].sp.s_inc;
                    }
                    if (t.length > 0) {
                        t[0].value = this.eq_data.data_u.d_ts_spectrum_array[index].sp.tm.value;
                    }
                    if (s.length > 0) {
                        s[0] = this.eq_data.data_u.d_ts_spectrum_array[index].sp.status;
                    }
                    if (this.eq_data.data_u.d_ts_spectrum_array[index].sp.d_spect_array != null) {
                        len = this.eq_data.data_u.d_ts_spectrum_array[index].sp.d_spect_array.length;
                        if (len > 0x100000) {
                            len = 0x100000;
                        }
                    } else {
                        len = 0;
                    }
                    if (i.length > 1) {
                        i[1] = len;
                    }
                    if (fa != null) {
                        for (j = 0; j < len; ++j) {
                            fa[j] = this.eq_data.data_u.d_ts_spectrum_array[index].sp.d_spect_array[j];
                        }
                    }
                    return 1;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }

    public String get_spec_comm() {
        if (this.eq_data.data_u.data_sel == 19 && this.eq_data.data_u.d_spectrum.comment != null) {
            return new String(this.eq_data.data_u.d_spectrum.comment).trim();
        }
        return null;
    }

    public float get_start() {
        if (this.eq_data.data_u.data_sel == 19) {
            return this.eq_data.data_u.d_spectrum.s_start;
        }
        return 0.0f;
    }

    public float get_increment() {
        if (this.eq_data.data_u.data_sel == 19) {
            return this.eq_data.data_u.d_spectrum.s_inc;
        }
        return 0.0f;
    }

    public USTR get_ustr(int index) {
        if (this.eq_data.data_u.data_sel == 103 && this.eq_data.data_u.d_ustr_array.length > index) {
            return this.eq_data.data_u.d_ustr_array[index];
        }
        return null;
    }

    public int get_ustr(int[] i, float[] f, time_t[] t, byte[] str, int index) {
        try {
            if (this.eq_data.data_u.data_sel == 103 && this.eq_data.data_u.d_ustr_array.length > index) {
                int len;
                if (i.length > 0) {
                    i[0] = this.eq_data.data_u.d_ustr_array[index].i1_data;
                }
                if (f.length > 0) {
                    f[0] = this.eq_data.data_u.d_ustr_array[index].f1_data;
                }
                if (f.length > 1) {
                    f[1] = this.eq_data.data_u.d_ustr_array[index].f2_data;
                }
                if (t.length > 0) {
                    t[0].value = this.eq_data.data_u.d_ustr_array[index].tm.value;
                }
                if ((len = this.eq_data.data_u.d_ustr_array[index].str_data.length) > 80) {
                    len = 80;
                }
                if (i.length > 1) {
                    i[1] = len;
                }
                for (int j = 0; j < len; ++j) {
                    str[j] = this.eq_data.data_u.d_ustr_array[index].str_data[j];
                }
                return 1;
            }
        }
        catch (NullPointerException e) {
            System.out.println("EqData get_ustr TINE NullPointerException: " + e.getMessage());
        }
        return 0;
    }

    public NAME16FI[] get_name16fi() {
        try {
            if (this.eq_data.data_u.data_sel == 111) {
                return this.eq_data.data_u.d_name16fi;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public NAME16II[] get_name16ii() {
        try {
            if (this.eq_data.data_u.data_sel == 112) {
                return this.eq_data.data_u.d_name16ii;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public FIS get_fis() {
        if (this.eq_data.data_u.data_sel == 17) {
            return this.eq_data.data_u.d_fis;
        }
        return null;
    }

    public int get_fis(float[] f, int[] i, u_char[] s) {
        if (this.eq_data.data_u.data_sel == 17) {
            if (f.length > 0) {
                f[0] = this.eq_data.data_u.d_fis.f_data;
            }
            if (i.length > 0) {
                i[0] = this.eq_data.data_u.d_fis.i_data;
            }
            if (s.length > 0) {
                s[0].value = this.eq_data.data_u.d_fis.status.value;
            }
            return 1;
        }
        return 0;
    }

    public FIS get_fis(int index) {
        if (this.eq_data.data_u.data_sel == 17 && this.eq_data.data_u.d_fis_array.length > index) {
            return this.eq_data.data_u.d_fis_array[index];
        }
        return null;
    }

    public int get_fis(float[] f, int[] i, u_char[] s, int index) {
        if (this.eq_data.data_u.data_sel == 17 && this.eq_data.data_u.d_fis_array.length > index) {
            if (f.length > 0) {
                f[0] = this.eq_data.data_u.d_fis_array[index].f_data;
            }
            if (i.length > 0) {
                i[0] = this.eq_data.data_u.d_fis_array[index].i_data;
            }
            if (s.length > 0) {
                s[0].value = this.eq_data.data_u.d_fis_array[index].status.value;
            }
            return 1;
        }
        return 0;
    }

    public FI get_fi(int index) {
        if (this.eq_data.data_u.data_sel == 114 && this.eq_data.data_u.d_fi_array.length > index) {
            return this.eq_data.data_u.d_fi_array[index];
        }
        return null;
    }

    public II get_ii(int index) {
        if (this.eq_data.data_u.data_sel == 116 && this.eq_data.data_u.d_ii_array.length > index) {
            return this.eq_data.data_u.d_ii_array[index];
        }
        return null;
    }

    public XY get_xy() {
        if (this.eq_data.data_u.data_sel == 13) {
            return this.eq_data.data_u.d_xy;
        }
        return null;
    }

    public int get_xy(float[] f) {
        if (this.eq_data.data_u.data_sel == 13) {
            if (f.length > 0) {
                f[0] = this.eq_data.data_u.d_xy.x_data;
            }
            if (f.length > 1) {
                f[1] = this.eq_data.data_u.d_xy.y_data;
            }
            return 1;
        }
        return 0;
    }

    public XY get_xy(int index) {
        if (this.eq_data.data_u.data_sel == 102 && this.eq_data.data_u.d_xy_array.length > index) {
            return this.eq_data.data_u.d_xy_array[index];
        }
        return null;
    }

    public int get_xy(float[] f, int index) {
        if (this.eq_data.data_u.data_sel == 102 && this.eq_data.data_u.d_xy_array.length > index) {
            if (f.length > 0) {
                f[0] = this.eq_data.data_u.d_xy_array[index].x_data;
            }
            if (f.length > 1) {
                f[1] = this.eq_data.data_u.d_xy_array[index].y_data;
            }
            return 1;
        }
        return 0;
    }

    public IIII get_iiii() {
        if (this.eq_data.data_u.data_sel == 14) {
            return this.eq_data.data_u.d_iiii;
        }
        return null;
    }

    public int get_iiii(int[] i) {
        switch (this.eq_data.data_u.data_sel) {
            case 14: {
                if (i.length > 0) {
                    i[0] = this.eq_data.data_u.d_iiii.i1_data;
                }
                if (i.length > 1) {
                    i[1] = this.eq_data.data_u.d_iiii.i2_data;
                }
                if (i.length > 2) {
                    i[2] = this.eq_data.data_u.d_iiii.i3_data;
                }
                if (i.length > 3) {
                    i[3] = this.eq_data.data_u.d_iiii.i4_data;
                }
                return 1;
            }
            case 105: {
                if (i.length > 0 && this.eq_data.data_u.d_int_array.length > 0) {
                    i[0] = this.eq_data.data_u.d_int_array[0];
                }
                if (i.length > 1 && this.eq_data.data_u.d_int_array.length > 1) {
                    i[1] = this.eq_data.data_u.d_int_array[1];
                }
                if (i.length > 2 && this.eq_data.data_u.d_int_array.length > 2) {
                    i[2] = this.eq_data.data_u.d_int_array[2];
                }
                if (i.length > 3 && this.eq_data.data_u.d_int_array.length > 3) {
                    i[3] = this.eq_data.data_u.d_int_array[3];
                }
                return 1;
            }
            case 100: {
                if (i.length > 0 && this.eq_data.data_u.d_float_array.length > 0) {
                    i[0] = this.eq_data.data_u.d_int_array[0];
                }
                if (i.length > 1 && this.eq_data.data_u.d_float_array.length > 1) {
                    i[1] = this.eq_data.data_u.d_int_array[1];
                }
                if (i.length > 2 && this.eq_data.data_u.d_float_array.length > 2) {
                    i[2] = this.eq_data.data_u.d_int_array[2];
                }
                if (i.length > 3 && this.eq_data.data_u.d_float_array.length > 3) {
                    i[3] = this.eq_data.data_u.d_int_array[3];
                }
                return 1;
            }
        }
        return 0;
    }

    public IFFF get_ifff() {
        if (this.eq_data.data_u.data_sel == 15) {
            return this.eq_data.data_u.d_ifff;
        }
        return null;
    }

    public int get_ifff(int[] i, float[] f) {
        switch (this.eq_data.data_u.data_sel) {
            case 15: {
                if (i.length > 0) {
                    i[0] = this.eq_data.data_u.d_ifff.i1_data;
                }
                if (f.length > 0) {
                    f[0] = this.eq_data.data_u.d_ifff.f1_data;
                }
                if (f.length > 1) {
                    f[1] = this.eq_data.data_u.d_ifff.f2_data;
                }
                if (f.length > 2) {
                    f[2] = this.eq_data.data_u.d_ifff.f3_data;
                }
                return 1;
            }
            case 105: {
                if (i.length > 0 && this.eq_data.data_u.d_int_array.length > 0) {
                    i[0] = this.eq_data.data_u.d_int_array[0];
                }
                if (f.length > 0 && this.eq_data.data_u.d_int_array.length > 1) {
                    f[0] = this.eq_data.data_u.d_int_array[1];
                }
                if (f.length > 1 && this.eq_data.data_u.d_int_array.length > 2) {
                    f[1] = this.eq_data.data_u.d_int_array[2];
                }
                if (f.length > 2 && this.eq_data.data_u.d_int_array.length > 3) {
                    f[2] = this.eq_data.data_u.d_int_array[3];
                }
                return 1;
            }
            case 100: {
                if (i.length > 0 && this.eq_data.data_u.d_float_array.length > 0) {
                    i[0] = this.eq_data.data_u.d_int_array[0];
                }
                if (f.length > 0 && this.eq_data.data_u.d_float_array.length > 1) {
                    f[0] = this.eq_data.data_u.d_int_array[1];
                }
                if (f.length > 1 && this.eq_data.data_u.d_float_array.length > 2) {
                    f[1] = this.eq_data.data_u.d_int_array[2];
                }
                if (f.length > 2 && this.eq_data.data_u.d_float_array.length > 3) {
                    f[2] = this.eq_data.data_u.d_int_array[3];
                }
                return 1;
            }
        }
        return 0;
    }

    public TTII get_ttii() {
        if (this.eq_data.data_u.data_sel == 18) {
            return this.eq_data.data_u.d_ttii;
        }
        return null;
    }

    public int get_ttii(time_t[] t, int[] i) {
        switch (this.eq_data.data_u.data_sel) {
            case 18: {
                if (t.length > 0) {
                    t[0] = this.eq_data.data_u.d_ttii.tm1;
                }
                if (t.length > 1) {
                    t[1] = this.eq_data.data_u.d_ttii.tm2;
                }
                if (i.length > 0) {
                    i[0] = this.eq_data.data_u.d_ttii.i1_data;
                }
                if (i.length > 1) {
                    i[1] = this.eq_data.data_u.d_ttii.i2_data;
                }
                return 1;
            }
            case 105: {
                if (t.length > 0 && this.eq_data.data_u.d_int_array.length > 0) {
                    t[0].value = this.eq_data.data_u.d_int_array[0];
                }
                if (t.length > 1 && this.eq_data.data_u.d_int_array.length > 1) {
                    t[1].value = this.eq_data.data_u.d_int_array[1];
                }
                if (i.length > 0 && this.eq_data.data_u.d_int_array.length > 2) {
                    i[0] = this.eq_data.data_u.d_int_array[2];
                }
                if (i.length > 1 && this.eq_data.data_u.d_int_array.length > 3) {
                    i[1] = this.eq_data.data_u.d_int_array[3];
                }
                return 1;
            }
        }
        return 0;
    }

    public byte get_byte(int index) {
        if (this.eq_data.data_u.data_sel == 106 && this.eq_data.data_u.d_byte_struct.d_byte_array.length > index) {
            return this.eq_data.data_u.d_byte_struct.d_byte_array[index];
        }
        return 0;
    }

    public int get_byte(int[] i, byte[] cp) {
        if (this.eq_data.data_u.data_sel == 106) {
            if (i.length > 0) {
                i[0] = this.eq_data.data_u.d_byte_struct.x_dim;
            }
            if (i.length > 1) {
                i[1] = this.eq_data.data_u.d_byte_struct.y_dim;
            }
            if (i.length > 2) {
                i[2] = this.eq_data.data_u.d_byte_struct.x_offset;
            }
            if (i.length > 3) {
                i[3] = this.eq_data.data_u.d_byte_struct.y_offset;
            }
            if (i.length > 4) {
                i[4] = this.eq_data.data_u.d_byte_struct.option;
            }
            cp = this.eq_data.data_u.d_byte_struct.d_byte_array;
            return 1;
        }
        return 0;
    }

    public A_BYTE get_byte() {
        if (this.eq_data.data_u.data_sel == 106) {
            return this.eq_data.data_u.d_byte_struct;
        }
        return null;
    }

    public String get_xml() {
        if (this.eq_data.data_u.data_sel != 20) {
            return " ";
        }
        return new String(this.eq_data.data_u.d_xml.d_xml_array);
    }

    public XYZS get_xyzs(int index) {
        if (this.eq_data.data_u.data_sel == 108 && this.eq_data.data_u.d_xyzs_array.length > index) {
            return this.eq_data.data_u.d_xyzs_array[index];
        }
        return null;
    }

    public int get_xyzs(int[] i, float[] f, byte[] str, int index) {
        if (this.eq_data.data_u.data_sel == 108 && this.eq_data.data_u.d_xyzs_array.length > index) {
            int len;
            if (i.length > 0) {
                i[0] = this.eq_data.data_u.d_xyzs_array[index].status;
            }
            if (f.length > 0) {
                f[0] = this.eq_data.data_u.d_xyzs_array[index].x;
            }
            if (f.length > 1) {
                f[1] = this.eq_data.data_u.d_xyzs_array[index].y;
            }
            if (f.length > 2) {
                f[2] = this.eq_data.data_u.d_xyzs_array[index].z;
            }
            if ((len = this.eq_data.data_u.d_xyzs_array[index].loc.length) > 64) {
                len = 64;
            }
            for (int j = 0; j < len; ++j) {
                str[j] = this.eq_data.data_u.d_xyzs_array[index].loc[j];
            }
            return 1;
        }
        return 0;
    }

    public MDAF get_mda() {
        if (this.eq_data.data_u.data_sel == 109) {
            return this.eq_data.data_u.d_mdfa;
        }
        return null;
    }

    public int get_dims(int[] dp, int[] dsp, byte[] str) {
        switch (this.eq_data.data_u.data_sel) {
            case 109: {
                if (dsp.length > 0) {
                    dsp[0] = this.eq_data.data_u.d_mdfa.dimn;
                    if (dp.length > 0) {
                        for (int i = 0; i < dsp[0]; ++i) {
                            dp[i] = this.eq_data.data_u.d_mdfa.dims[i];
                        }
                    }
                }
                for (byte str[i] : this.eq_data.data_u.d_mdfa.comment) {
                }
                return 1;
            }
            case 19: {
                if (dsp.length > 0) {
                    dsp[0] = 1;
                }
                if (dp.length > 0) {
                    dp[0] = this.eq_data.data_u.d_spectrum.d_spect_array.length;
                }
                for (byte str[i] : this.eq_data.data_u.d_spectrum.comment) {
                }
                return 1;
            }
            case 106: {
                switch (this.eq_data.data_u.d_byte_struct.option) {
                    case 0: {
                        if (dsp.length > 0) {
                            dsp[0] = 3;
                        }
                        if (dp.length <= 0) break;
                        dp[0] = this.eq_data.data_u.d_byte_struct.x_dim / 3;
                        dp[1] = this.eq_data.data_u.d_byte_struct.y_dim;
                        dp[2] = 3;
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (dsp.length > 0) {
                            dsp[0] = 1;
                        }
                        if (dp.length <= 0) break;
                        dp[0] = this.eq_data.data_u.d_byte_struct.x_dim;
                        break;
                    }
                    case 2: {
                        if (dsp.length > 0) {
                            dsp[0] = 2;
                        }
                        if (dp.length <= 0) break;
                        dp[0] = this.eq_data.data_u.d_byte_struct.x_dim;
                        dp[1] = this.eq_data.data_u.d_byte_struct.y_dim;
                        break;
                    }
                    case 4: {
                        if (dsp.length > 0) {
                            dsp[0] = 2;
                        }
                        if (dp.length <= 0) break;
                        dp[0] = this.eq_data.data_u.d_byte_struct.x_dim / 2;
                        dp[1] = this.eq_data.data_u.d_byte_struct.y_dim;
                    }
                }
                return 1;
            }
            case 105: 
            case 119: {
                if (dsp.length > 0) {
                    dsp[0] = 1;
                }
                if (dp.length > 0) {
                    dp[0] = this.eq_data.data_u.d_int_array.length;
                }
                return 1;
            }
            case 115: {
                if (dsp.length > 0) {
                    dsp[0] = 1;
                }
                if (dp.length > 0) {
                    dp[0] = this.eq_data.data_u.d_short_array.length;
                }
                return 1;
            }
            case 100: {
                if (dsp.length > 0) {
                    dsp[0] = 1;
                }
                if (dp.length > 0) {
                    dp[0] = this.eq_data.data_u.d_float_array.length;
                }
                return 1;
            }
            case 110: {
                if (dsp.length > 0) {
                    dsp[0] = 1;
                }
                if (dp.length > 0) {
                    dp[0] = this.eq_data.data_u.d_double_array.length;
                }
                return 1;
            }
            case 101: {
                if (dsp.length > 0) {
                    dsp[0] = 1;
                }
                if (dp.length > 0) {
                    dp[0] = this.eq_data.data_u.d_tds_array.length;
                }
                return 1;
            }
            case 107: {
                if (dsp.length > 0) {
                    dsp[0] = 1;
                }
                if (dp.length > 0) {
                    dp[0] = this.eq_data.data_u.d_tdsi_array.length;
                }
                return 1;
            }
            case 104: {
                if (dsp.length > 0) {
                    dsp[0] = 1;
                }
                if (dp.length > 0) {
                    dp[0] = this.eq_data.data_u.d_fis_array.length;
                }
                return 1;
            }
            case 114: {
                if (dsp.length > 0) {
                    dsp[0] = 1;
                }
                if (dp.length > 0) {
                    dp[0] = this.eq_data.data_u.d_fi_array.length;
                }
                return 1;
            }
            case 116: {
                if (dsp.length > 0) {
                    dsp[0] = 1;
                }
                if (dp.length > 0) {
                    dp[0] = this.eq_data.data_u.d_ii_array.length;
                }
                return 1;
            }
            case 102: {
                if (dsp.length > 0) {
                    dsp[0] = 1;
                }
                if (dp.length > 0) {
                    dp[0] = this.eq_data.data_u.d_xy_array.length;
                }
                return 1;
            }
        }
        if (dsp.length > 0) {
            dsp[0] = 0;
        }
        return 0;
    }

    public int get(int[] dp, int dims, float[] val) {
        if (dims <= 0 || dp.length <= 0) {
            return 0;
        }
        int index = dp[0];
        int i = 0;
        switch (this.eq_data.data_u.data_sel) {
            case 105: 
            case 119: {
                int len = this.eq_data.data_u.d_int_array.length;
                if (dims > 1 || index >= len) {
                    return 0;
                }
                for (int j = index; j < len; ++j) {
                    val[i++] = this.eq_data.data_u.d_int_array[j];
                }
                return 1;
            }
            case 115: {
                int len = this.eq_data.data_u.d_short_array.length;
                if (dims > 1 || index >= len) {
                    return 0;
                }
                for (int j = index; j < len; ++j) {
                    val[i++] = this.eq_data.data_u.d_short_array[j];
                }
                return 1;
            }
            case 100: {
                int len = this.eq_data.data_u.d_float_array.length;
                if (dims > 1 || index >= len) {
                    return 0;
                }
                for (int j = index; j < len; ++j) {
                    val[i++] = this.eq_data.data_u.d_float_array[j];
                }
                return 1;
            }
            case 110: {
                int len = this.eq_data.data_u.d_double_array.length;
                if (dims > 1 || index >= len) {
                    return 0;
                }
                for (int j = index; j < len; ++j) {
                    val[i++] = (float)this.eq_data.data_u.d_double_array[j];
                }
                return 1;
            }
            case 101: {
                int len = this.eq_data.data_u.d_tds_array.length;
                if (dims > 1 || index >= len) {
                    return 0;
                }
                for (int j = index; j < len; ++j) {
                    val[i++] = this.eq_data.data_u.d_tds_array[j].data;
                }
                return 1;
            }
            case 107: {
                int len = this.eq_data.data_u.d_tdsi_array.length;
                if (dims > 1 || index >= len) {
                    return 0;
                }
                for (int j = index; j < len; ++j) {
                    val[i++] = this.eq_data.data_u.d_tdsi_array[j].data;
                }
                return 1;
            }
            case 104: {
                int len = this.eq_data.data_u.d_fis_array.length;
                if (dims > 1 || index >= len) {
                    return 0;
                }
                for (int j = index; j < len; ++j) {
                    val[i++] = this.eq_data.data_u.d_fis_array[j].f_data;
                }
                return 1;
            }
            case 114: {
                int len = this.eq_data.data_u.d_fi_array.length;
                if (dims > 1 || index >= len) {
                    return 0;
                }
                for (int j = index; j < len; ++j) {
                    val[i++] = this.eq_data.data_u.d_fi_array[j].f_data;
                }
                return 1;
            }
            case 116: {
                int len = this.eq_data.data_u.d_ii_array.length;
                if (dims > 1 || index >= len) {
                    return 0;
                }
                for (int j = index; j < len; ++j) {
                    val[i++] = this.eq_data.data_u.d_ii_array[j].i1_data;
                }
                return 1;
            }
            case 19: {
                int len = this.eq_data.data_u.d_spectrum.d_spect_array.length;
                if (dims > 1 || index >= len) {
                    return 0;
                }
                for (int j = index; j < len; ++j) {
                    val[i++] = this.eq_data.data_u.d_spectrum.d_spect_array[j];
                }
                return 1;
            }
            case 109: {
                if (this.get_pos_mda(dp, dims, val, this.eq_data.data_u.d_mdfa) == -1) {
                    return 0;
                }
                return 1;
            }
        }
        return 0;
    }

    public int error(int e) {
        this.eq_data.error = e;
        return 1;
    }

    public int error(int e, String err_str) {
        this.eq_data.error = e;
        this.set(err_str);
        return 1;
    }

    public int set_type(int i) {
        this.eq_data.data_u.data_sel = i;
        return 1;
    }

    public int set(int i) {
        if (this.eq_data.data_u.data_sel != 1) {
            this.eq_data.data_u.data_sel = 1;
        }
        this.eq_data.data_u.d_int = i;
        return 1;
    }

    public int set(short i) {
        if (this.eq_data.data_u.data_sel != 8) {
            this.eq_data.data_u.data_sel = 8;
        }
        this.eq_data.data_u.d_short = i;
        return 1;
    }

    public int set_bool(int i) {
        if (this.eq_data.data_u.data_sel != 4) {
            this.eq_data.data_u.data_sel = 4;
        }
        this.eq_data.data_u.d_bool = i;
        return 1;
    }

    private String string_spc(String line) {
        int len = line.length();
        char[] a = new char[len];
        for (int i = 0; i < len; ++i) {
            a[i] = !Character.isIdentifierIgnorable(line.charAt(i)) ? line.charAt(i) : (char)32;
        }
        return new String(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_from_file(String fileName) {
        BufferedReader inputStream = null;
        StringBuffer buffer = new StringBuffer();
        long lastModified = this.eq_data.tm.value;
        try {
            File file = new File(fileName);
            long lm = file.lastModified() / 1000L;
            if (lm != lastModified) {
                String line;
                this.eq_data.tm.value = (int)lm;
                inputStream = new BufferedReader(new FileReader(file));
                while ((line = inputStream.readLine()) != null) {
                    buffer.append(line);
                    buffer.append(System.getProperty("line.separator"));
                }
                if (this.set_from_stringBuffer(buffer) != 1) {
                    this.error(1234, "ERROR: Can't set data from this string");
                    int n = 0;
                    return n;
                }
            }
        }
        catch (IOException e) {
            this.error(1234, e.getMessage());
            int n = 0;
            return n;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return 1;
    }

    public int set_from_stringBuffer(StringBuffer block) {
        if (block == null || block.length() < 3) {
            return 0;
        }
        String nl = System.getProperty("line.separator");
        float xStart = 0.0f;
        float xInc = 1.0f;
        int length = 0;
        int status = 0;
        int time = 0;
        int count = 0;
        boolean flag = false;
        boolean isDefined = true;
        try {
            String line1;
            Scanner scan = new Scanner(block.toString()).useLocale(Locale.US);
            while (scan.hasNextLine()) {
                ++count;
                line1 = scan.nextLine();
            }
            scan = new Scanner(block.toString()).useLocale(Locale.US);
            String line2 = "";
            line1 = scan.hasNextLine() ? scan.nextLine() : "";
            if (line1.startsWith("#SPECTRUM")) {
                this.eq_data.data_u.data_sel = 19;
            } else if (line1.startsWith("#INT")) {
                this.eq_data.data_u.data_sel = 1;
            } else if (line1.startsWith("#SHORT")) {
                this.eq_data.data_u.data_sel = 8;
            } else if (line1.startsWith("#FLOAT")) {
                this.eq_data.data_u.data_sel = 2;
            } else if (line1.startsWith("#DOUBLE")) {
                this.eq_data.data_u.data_sel = 6;
            } else if (line1.startsWith("#STRING")) {
                this.eq_data.data_u.data_sel = 3;
            } else if (line1.startsWith("#STRING16")) {
                this.eq_data.data_u.data_sel = 5;
            } else if (line1.startsWith("#HIST") || line1.startsWith("# Data Type : A_TDS")) {
                this.eq_data.data_u.data_sel = 101;
            } else {
                if (this.eq_data.data_u.data_sel == 0) {
                    this.eq_data.data_u.data_sel = 7;
                }
                isDefined = false;
                line2 = line1;
            }
            if (isDefined && scan.hasNextLine()) {
                line2 = scan.nextLine();
                --count;
            }
            this.allocate_array(this.eq_data.data_u.data_sel, count, 0);
            length = count;
            count = 0;
            Scanner lineScan = new Scanner(line1).useLocale(Locale.US);
            block9: do {
                switch (this.eq_data.data_u.data_sel) {
                    case 19: {
                        if (this.eq_data.data_u.d_spectrum == null) {
                            this.eq_data.data_u.d_spectrum = new SPECTRUM();
                            this.eq_data.data_u.d_spectrum.tm = new time_t();
                        }
                        if (line1.startsWith("#SPECTRUM")) {
                            String tmp;
                            lineScan.next();
                            if (lineScan.hasNext()) {
                                tmp = lineScan.next();
                                xStart = Float.parseFloat(tmp);
                            }
                            if (lineScan.hasNext()) {
                                xInc = Float.parseFloat(lineScan.next());
                            }
                            if (lineScan.hasNext()) {
                                status = Integer.parseInt(lineScan.next());
                            }
                            if (lineScan.hasNext()) {
                                length = Integer.parseInt(lineScan.next());
                            }
                            lineScan.useDelimiter("\"");
                            if (lineScan.hasNext()) {
                                String comment = lineScan.next();
                                comment = lineScan.next();
                                this.eq_data.data_u.d_spectrum.comment = new byte[80];
                                if (comment.length() > 1) {
                                    this.toByteArray(comment, this.eq_data.data_u.d_spectrum.comment, comment.length());
                                }
                            }
                            lineScan.useDelimiter("\\s");
                            if (lineScan.hasNext()) {
                                tmp = lineScan.next();
                            }
                            if (lineScan.hasNextInt()) {
                                tmp = lineScan.next();
                                time = Integer.parseInt(tmp);
                            }
                        }
                        this.eq_data.data_u.d_spectrum.s_start = xStart;
                        this.eq_data.data_u.d_spectrum.s_inc = xInc;
                        this.eq_data.data_u.d_spectrum.status = status;
                        this.eq_data.data_u.d_spectrum.tm.value = time;
                        int idx = 0;
                        while (line2 != null && idx < length) {
                            Scanner dataScan = new Scanner(line2);
                            if (dataScan.hasNext()) {
                                this.eq_data.data_u.d_spectrum.d_spect_array[idx++] = Float.parseFloat(dataScan.next());
                            }
                            if (scan.hasNext()) {
                                line2 = scan.nextLine();
                                continue;
                            }
                            line2 = null;
                        }
                        continue block9;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 21: {
                        this.set_from_string(line2);
                        break;
                    }
                    case 7: {
                        this.set_text(block.toString());
                        break;
                    }
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 119: {
                        this.set_from_string(line2, count);
                        ++count;
                        flag = scan.hasNextLine();
                        if (!flag) break;
                        line2 = scan.nextLine();
                    }
                }
            } while (flag);
        }
        catch (Exception e) {
            this.error(123, e.getMessage());
            return 0;
        }
        this.error(0);
        return 1;
    }

    public int set_from_string(String line) {
        int rtnFlag = 0;
        int i = 0;
        Scanner dataScan = new Scanner(line);
        dataScan.useDelimiter("[,;\\s]+");
        dataScan.useLocale(Locale.ENGLISH);
        try {
            switch (this.eq_data.data_u.data_sel) {
                case 0: {
                    return 1;
                }
                case 1: {
                    String token;
                    if (dataScan.hasNextInt()) {
                        this.set(dataScan.nextInt());
                        rtnFlag = 1;
                        break;
                    }
                    if (dataScan.hasNext() && (token = dataScan.next()).startsWith("0x")) {
                        int ii = Integer.parseInt(token.substring(2), 16);
                        this.set(ii);
                        rtnFlag = 1;
                    }
                    break;
                }
                case 105: 
                case 119: {
                    int k = 0;
                    int max = this.length();
                    while (dataScan.hasNext() && k < max) {
                        String token;
                        if (dataScan.hasNextInt()) {
                            this.set(dataScan.nextInt(), k++);
                            rtnFlag = 1;
                            continue;
                        }
                        if (!dataScan.hasNext() || !(token = dataScan.next()).startsWith("0x")) continue;
                        int ii = Integer.parseInt(token.substring(2), 16);
                        this.set(ii, k++);
                        rtnFlag = 1;
                    }
                    break;
                }
                case 8: {
                    String token;
                    if (dataScan.hasNextShort()) {
                        this.eq_data.data_u.d_short = dataScan.nextShort();
                        rtnFlag = 1;
                        break;
                    }
                    if (dataScan.hasNext() && (token = dataScan.next()).startsWith("0x")) {
                        int ii = Integer.parseInt(token.substring(2), 16);
                        this.eq_data.data_u.d_short = (short)ii;
                        rtnFlag = 1;
                    }
                    break;
                }
                case 4: {
                    if (dataScan.hasNextInt()) {
                        int fl = dataScan.nextInt();
                        this.eq_data.data_u.d_bool = fl == 0 ? 0 : 1;
                        rtnFlag = 1;
                        break;
                    }
                    if (dataScan.hasNextBoolean()) {
                        boolean b1 = dataScan.nextBoolean();
                        this.eq_data.data_u.d_bool = b1 ? 1 : 0;
                        rtnFlag = 1;
                    }
                    break;
                }
                case 2: {
                    if (dataScan.hasNextFloat()) {
                        this.set(dataScan.nextFloat());
                        rtnFlag = 1;
                    }
                    break;
                }
                case 100: {
                    if (dataScan.hasNext()) {
                        int k = 0;
                        while (dataScan.hasNextFloat()) {
                            this.set(dataScan.nextFloat(), k++);
                        }
                        rtnFlag = 1;
                    }
                    break;
                }
                case 6: {
                    if (dataScan.hasNextDouble()) {
                        this.set(dataScan.nextDouble());
                        rtnFlag = 1;
                    }
                    break;
                }
                case 110: {
                    if (dataScan.hasNext()) {
                        int k = 0;
                        while (dataScan.hasNextDouble()) {
                            this.set(dataScan.nextDouble(), k++);
                        }
                        rtnFlag = 1;
                    }
                    break;
                }
                case 3: {
                    int n = line.length() + 1;
                    if (n > 80) {
                        n = 80;
                    }
                    if (n > 1) {
                        this.eq_data.data_u.d_char = new byte[n];
                        this.toByteArray(line, this.eq_data.data_u.d_char, n - 1);
                        rtnFlag = i;
                        break;
                    }
                    rtnFlag = 0;
                    break;
                }
                case 5: {
                    rtnFlag = this.set(line);
                    break;
                }
                case 20: {
                    rtnFlag = this.set_xml(line);
                    break;
                }
                case 7: {
                    rtnFlag = this.set_text(line);
                    break;
                }
                case 13: {
                    if (dataScan.hasNext()) {
                        this.eq_data.data_u.d_xy = new XY();
                        if (dataScan.hasNextFloat()) {
                            this.eq_data.data_u.d_xy.x_data = dataScan.nextFloat();
                        }
                        rtnFlag = 1;
                        if (dataScan.hasNextFloat()) {
                            this.eq_data.data_u.d_xy.y_data = dataScan.nextFloat();
                        }
                    }
                    break;
                }
                case 14: {
                    if (dataScan.hasNext()) {
                        this.eq_data.data_u.d_iiii = new IIII();
                        if (dataScan.hasNextInt()) {
                            this.eq_data.data_u.d_iiii.i1_data = dataScan.nextInt();
                        }
                        if (dataScan.hasNextInt()) {
                            this.eq_data.data_u.d_iiii.i2_data = dataScan.nextInt();
                        }
                        if (dataScan.hasNextInt()) {
                            this.eq_data.data_u.d_iiii.i3_data = dataScan.nextInt();
                        }
                        if (dataScan.hasNextInt()) {
                            this.eq_data.data_u.d_iiii.i4_data = dataScan.nextInt();
                        }
                        rtnFlag = 1;
                    }
                    break;
                }
                case 18: {
                    if (dataScan.hasNext()) {
                        this.eq_data.data_u.d_ttii = new TTII();
                        if (dataScan.hasNextInt()) {
                            this.eq_data.data_u.d_ttii.tm1 = new time_t();
                            this.eq_data.data_u.d_ttii.tm1.value = dataScan.nextInt();
                        }
                        if (dataScan.hasNextInt()) {
                            this.eq_data.data_u.d_ttii.tm2 = new time_t();
                            this.eq_data.data_u.d_ttii.tm2.value = dataScan.nextInt();
                        }
                        if (dataScan.hasNextInt()) {
                            this.eq_data.data_u.d_ttii.i1_data = dataScan.nextInt();
                        }
                        if (dataScan.hasNextInt()) {
                            this.eq_data.data_u.d_ttii.i1_data = dataScan.nextInt();
                        }
                        rtnFlag = 1;
                    }
                    break;
                }
                case 15: {
                    if (dataScan.hasNext()) {
                        this.eq_data.data_u.d_ifff = new IFFF();
                        if (dataScan.hasNextInt()) {
                            this.eq_data.data_u.d_ifff.i1_data = dataScan.nextInt();
                        }
                        if (dataScan.hasNextFloat()) {
                            this.eq_data.data_u.d_ifff.f1_data = dataScan.nextFloat();
                        }
                        if (dataScan.hasNextFloat()) {
                            this.eq_data.data_u.d_ifff.f2_data = dataScan.nextFloat();
                        }
                        if (dataScan.hasNextFloat()) {
                            this.eq_data.data_u.d_ifff.f3_data = dataScan.nextFloat();
                        }
                        rtnFlag = 1;
                    }
                    break;
                }
                case 17: {
                    if (dataScan.hasNext()) {
                        this.eq_data.data_u.d_fis = new FIS();
                        if (dataScan.hasNextFloat()) {
                            this.eq_data.data_u.d_fis.f_data = dataScan.nextFloat();
                        }
                        if (dataScan.hasNextInt()) {
                            this.eq_data.data_u.d_fis.i_data = dataScan.nextInt();
                        }
                        if (dataScan.hasNextByte()) {
                            this.eq_data.data_u.d_fis.status = new u_char();
                            this.eq_data.data_u.d_fis.status.value = dataScan.nextByte();
                        }
                        rtnFlag = 1;
                    }
                    break;
                }
                case 16: 
                case 103: {
                    Scanner lineScan;
                    boolean n = false;
                    boolean sp = false;
                    boolean flag = false;
                    this.eq_data.data_u.d_ustr_array = new USTR[1];
                    this.eq_data.data_u.d_ustr_array[0] = new USTR();
                    int j = line.length();
                    if (!Character.isDigit(line.charAt(0)) || line.charAt(0) == '\"') {
                        this.eq_data.data_u.d_ustr_array[0].i1_data = 0;
                        this.eq_data.data_u.d_ustr_array[0].f1_data = 0.0f;
                        this.eq_data.data_u.d_ustr_array[0].f2_data = 0.0f;
                        this.eq_data.data_u.d_ustr_array[0].tm = new time_t();
                        this.eq_data.data_u.d_ustr_array[0].tm.value = 0;
                        this.eq_data.data_u.d_ustr_array[0].str_data = new byte[j];
                        this.toByteArray(line, this.eq_data.data_u.d_ustr_array[0].str_data, j);
                        rtnFlag = 1;
                    }
                    if ((lineScan = new Scanner(line).useLocale(Locale.US)).hasNextInt()) {
                        this.eq_data.data_u.d_ustr_array[0].i1_data = lineScan.nextInt();
                        if (lineScan.hasNextFloat()) {
                            this.eq_data.data_u.d_ustr_array[0].f1_data = lineScan.nextFloat();
                        }
                        if (lineScan.hasNextFloat()) {
                            this.eq_data.data_u.d_ustr_array[0].f2_data = lineScan.nextFloat();
                        }
                        if (lineScan.hasNextInt()) {
                            this.eq_data.data_u.d_ustr_array[0].tm = new time_t();
                            this.eq_data.data_u.d_ustr_array[0].tm.value = lineScan.nextInt();
                        }
                        if (lineScan.hasNext()) {
                            String str = lineScan.nextLine();
                            j = str.length();
                            this.eq_data.data_u.d_ustr_array[0].str_data = new byte[j];
                            this.toByteArray(str, this.eq_data.data_u.d_ustr_array[0].str_data, j);
                        }
                    }
                    if (this.eq_data.data_u.d_ustr_array[0].str_data == null) {
                        this.eq_data.data_u.d_ustr_array[0].str_data = new byte[1];
                        this.eq_data.data_u.d_ustr_array[0].str_data[0] = 0;
                    }
                    rtnFlag = 1;
                    break;
                }
                case 108: {
                    String str;
                    boolean n = false;
                    int sp = 0;
                    boolean flag = false;
                    this.eq_data.data_u.d_xyzs_array = new XYZS[1];
                    this.eq_data.data_u.d_xyzs_array[0] = new XYZS();
                    int j = line.length();
                    if (!Character.isDigit(line.charAt(0)) || line.charAt(0) == '\"') {
                        this.eq_data.data_u.d_xyzs_array[0].status = 0;
                        this.eq_data.data_u.d_xyzs_array[0].x = 0.0f;
                        this.eq_data.data_u.d_xyzs_array[0].y = 0.0f;
                        this.eq_data.data_u.d_xyzs_array[0].z = 0.0f;
                        this.eq_data.data_u.d_xyzs_array[0].loc = new byte[j];
                        this.toByteArray(line, this.eq_data.data_u.d_xyzs_array[0].loc, j);
                        return 1;
                    }
                    char[] b = new char[j];
                    for (i = 0; i < j; ++i) {
                        char a = line.charAt(i);
                        if (!flag && a == '\"') {
                            flag = true;
                            continue;
                        }
                        if (flag && a == '\"') {
                            flag = false;
                            continue;
                        }
                        if (flag || a != ' ' && !Character.isLetterOrDigit(a)) continue;
                        b[sp++] = a;
                    }
                    String line1 = new String(b);
                    StringTokenizer pars = new StringTokenizer(line1, " ");
                    if (pars.hasMoreTokens()) {
                        str = pars.nextToken();
                        this.eq_data.data_u.d_xyzs_array[0].status = Integer.valueOf(str);
                    }
                    if (pars.hasMoreTokens()) {
                        str = pars.nextToken();
                        this.eq_data.data_u.d_xyzs_array[0].x = Float.valueOf(str).floatValue();
                    }
                    if (pars.hasMoreTokens()) {
                        str = pars.nextToken();
                        this.eq_data.data_u.d_xyzs_array[0].y = Float.valueOf(str).floatValue();
                    }
                    if (pars.hasMoreTokens()) {
                        str = pars.nextToken();
                        this.eq_data.data_u.d_xyzs_array[0].z = Float.valueOf(str).floatValue();
                    }
                    if (pars.hasMoreTokens()) {
                        str = pars.nextToken("");
                        j = str.length();
                        this.eq_data.data_u.d_xyzs_array[0].loc = new byte[j];
                        this.toByteArray(str, this.eq_data.data_u.d_xyzs_array[0].loc, j);
                    }
                    rtnFlag = 1;
                    break;
                }
                case 113: 
                case 117: 
                case 118: {
                    i = 0;
                    while (dataScan.hasNext()) {
                        String token = dataScan.next();
                        this.set(token, i);
                        ++i;
                    }
                    break;
                }
                default: {
                    rtnFlag = 0;
                }
            }
        }
        catch (Exception e) {
            rtnFlag = 0;
        }
        dataScan.close();
        return rtnFlag;
    }

    public int set_from_string(String line, int idx) {
        int i = 0;
        try {
            switch (this.eq_data.data_u.data_sel) {
                case 0: {
                    return 1;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 20: {
                    if (idx == 0) {
                        return this.set_from_string(line);
                    }
                }
                case 103: {
                    if (idx < this.eq_data.data_u.d_ustr_array.length) {
                        int j = line.length();
                        if (j > 80) {
                            j = 80;
                        }
                        if (!Character.isDigit(line.charAt(0)) || line.charAt(0) == '\"') {
                            if (j > this.eq_data.data_u.d_ustr_array[idx].str_data.length) {
                                j = this.eq_data.data_u.d_ustr_array[idx].str_data.length;
                            }
                            this.toByteArray(line, this.eq_data.data_u.d_ustr_array[idx].str_data, j);
                            return 1;
                        }
                        Scanner lineScan = new Scanner(line).useLocale(Locale.US);
                        if (lineScan.hasNextInt()) {
                            this.eq_data.data_u.d_ustr_array[idx].i1_data = lineScan.nextInt();
                            boolean hD = lineScan.hasNextDouble();
                            if (lineScan.hasNextFloat()) {
                                this.eq_data.data_u.d_ustr_array[idx].f1_data = lineScan.nextFloat();
                            }
                            if (lineScan.hasNextFloat()) {
                                this.eq_data.data_u.d_ustr_array[idx].f2_data = lineScan.nextFloat();
                            }
                            if (lineScan.hasNextInt()) {
                                this.eq_data.data_u.d_ustr_array[idx].tm = new time_t();
                                this.eq_data.data_u.d_ustr_array[idx].tm.value = lineScan.nextInt();
                            }
                            if (lineScan.hasNext()) {
                                String str = lineScan.nextLine();
                                j = str.length();
                                this.eq_data.data_u.d_ustr_array[idx].str_data = new byte[j];
                                this.toByteArray(str, this.eq_data.data_u.d_ustr_array[idx].str_data, j);
                            }
                        }
                        if (this.eq_data.data_u.d_ustr_array[idx].str_data == null) {
                            this.eq_data.data_u.d_ustr_array[idx].str_data = new byte[1];
                            this.eq_data.data_u.d_ustr_array[idx].str_data[0] = 0;
                        }
                    }
                    return 0;
                }
                case 108: {
                    if (idx < this.eq_data.data_u.d_xyzs_array.length) {
                        String str;
                        boolean n = false;
                        int sp = 0;
                        boolean flag = false;
                        int j = line.length();
                        if (!Character.isDigit(line.charAt(0)) || line.charAt(0) == '\"') {
                            this.eq_data.data_u.d_xyzs_array[idx].status = 0;
                            this.eq_data.data_u.d_xyzs_array[idx].x = 0.0f;
                            this.eq_data.data_u.d_xyzs_array[idx].y = 0.0f;
                            this.eq_data.data_u.d_xyzs_array[idx].z = 0.0f;
                            this.eq_data.data_u.d_xyzs_array[idx].loc = new byte[j];
                            if (j > this.eq_data.data_u.d_xyzs_array[idx].loc.length) {
                                j = this.eq_data.data_u.d_xyzs_array[idx].loc.length;
                            }
                            this.toByteArray(line, this.eq_data.data_u.d_xyzs_array[idx].loc, j);
                            return 1;
                        }
                        char[] b = new char[j];
                        for (i = 0; i < j; ++i) {
                            char a = line.charAt(i);
                            if (!flag && a == '\"') {
                                flag = true;
                                continue;
                            }
                            if (flag && a == '\"') {
                                flag = false;
                                continue;
                            }
                            if (flag || a != ' ' && !Character.isLetterOrDigit(a)) continue;
                            b[sp++] = a;
                        }
                        String line1 = new String(b);
                        StringTokenizer pars = new StringTokenizer(line1, " ");
                        if (pars.hasMoreTokens()) {
                            str = pars.nextToken();
                            this.eq_data.data_u.d_xyzs_array[idx].status = Integer.valueOf(str);
                        }
                        if (pars.hasMoreTokens()) {
                            str = pars.nextToken();
                            this.eq_data.data_u.d_xyzs_array[idx].x = Float.valueOf(str).floatValue();
                        }
                        if (pars.hasMoreTokens()) {
                            str = pars.nextToken();
                            this.eq_data.data_u.d_xyzs_array[idx].y = Float.valueOf(str).floatValue();
                        }
                        if (pars.hasMoreTokens()) {
                            str = pars.nextToken();
                            this.eq_data.data_u.d_xyzs_array[idx].z = Float.valueOf(str).floatValue();
                        }
                        if (pars.hasMoreTokens()) {
                            str = pars.nextToken("");
                            j = str.length();
                            if (j > this.eq_data.data_u.d_xyzs_array[idx].loc.length) {
                                j = this.eq_data.data_u.d_xyzs_array[idx].loc.length;
                            }
                            this.toByteArray(str, this.eq_data.data_u.d_xyzs_array[idx].loc, j);
                        }
                        return 1;
                    }
                    return 0;
                }
                case 100: {
                    StringTokenizer pars;
                    if (idx < this.eq_data.data_u.d_float_array.length && (pars = new StringTokenizer(line, " ")).hasMoreTokens()) {
                        String str = pars.nextToken();
                        this.eq_data.data_u.d_float_array[idx] = Float.valueOf(str).floatValue();
                        return 1;
                    }
                    return 0;
                }
                case 110: {
                    StringTokenizer pars;
                    if (idx < this.eq_data.data_u.d_double_array.length && (pars = new StringTokenizer(line, " ")).hasMoreTokens()) {
                        String str = pars.nextToken();
                        this.eq_data.data_u.d_double_array[idx] = Double.valueOf(str);
                        return 1;
                    }
                    return 0;
                }
                case 101: {
                    if (idx < this.eq_data.data_u.d_tds_array.length) {
                        String str;
                        Scanner parScan = new Scanner(line);
                        parScan.useDelimiter("\"");
                        if (parScan.hasNext()) {
                            str = parScan.next();
                            parScan.useDelimiter(" \t");
                            str = parScan.next();
                        } else {
                            parScan.useDelimiter(" \t");
                        }
                        if (parScan.hasNext() && parScan.hasNextInt()) {
                            int ti;
                            this.eq_data.data_u.d_tds_array[idx].tm.value = ti = parScan.nextInt();
                        }
                        if (parScan.hasNext()) {
                            str = parScan.next();
                            this.eq_data.data_u.d_tds_array[idx].data = Float.parseFloat(str);
                        }
                        if (parScan.hasNext()) {
                            str = parScan.next();
                            this.eq_data.data_u.d_tds_array[idx].status.value = Byte.parseByte(str);
                        }
                        return 1;
                    }
                    return 0;
                }
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int set(float f) {
        if (this.eq_data.data_u.data_sel != 2) {
            this.eq_data.data_u.data_sel = 2;
        }
        this.eq_data.data_u.d_float = f;
        return 1;
    }

    private void copy_float(float[] s, float[] t) {
        for (float t[i] : s) {
        }
    }

    private void copy_double(double[] s, double[] t) {
        for (double t[i] : s) {
        }
    }

    private void copy_int(int[] s, int[] t) {
        for (int t[i] : s) {
        }
    }

    private void copy_short(short[] s, short[] t) {
        for (short t[i] : s) {
        }
    }

    public int set(float data, int index) {
        switch (this.eq_data.data_u.data_sel) {
            case 19: {
                if (index < 0x100000) {
                    if (this.eq_data.data_u.d_spectrum.d_spect_array == null) {
                        this.eq_data.data_u.d_spectrum = new SPECTRUM();
                        this.eq_data.data_u.d_spectrum.comment = new byte[80];
                        this.eq_data.data_u.d_spectrum.d_spect_array = new float[index + 1];
                    }
                    if (index >= this.eq_data.data_u.d_spectrum.d_spect_array.length) {
                        float[] tmp = new float[index + 1];
                        this.copy_float(this.eq_data.data_u.d_spectrum.d_spect_array, tmp);
                        this.eq_data.data_u.d_float_array = tmp;
                    }
                    this.eq_data.data_u.d_spectrum.d_spect_array[index] = data;
                    return 1;
                }
                return 0;
            }
            case 100: {
                if (index < 1024) {
                    if (this.eq_data.data_u.d_float_array == null) {
                        this.eq_data.data_u.d_float_array = new float[index + 1];
                    }
                    if (index >= this.eq_data.data_u.d_float_array.length) {
                        float[] tmp = new float[index + 1];
                        this.copy_float(this.eq_data.data_u.d_float_array, tmp);
                        this.eq_data.data_u.d_float_array = tmp;
                    }
                    this.eq_data.data_u.d_float_array[index] = data;
                    return 1;
                }
                return 0;
            }
            case 110: {
                if (index < 1024) {
                    if (this.eq_data.data_u.d_double_array == null) {
                        this.eq_data.data_u.d_double_array = new double[index + 1];
                    }
                    if (index >= this.eq_data.data_u.d_double_array.length) {
                        double[] dtmp = new double[index + 1];
                        this.copy_double(this.eq_data.data_u.d_double_array, dtmp);
                        this.eq_data.data_u.d_double_array = dtmp;
                    }
                    this.eq_data.data_u.d_double_array[index] = data;
                    return 1;
                }
                return 0;
            }
            case 105: 
            case 119: {
                if (index < 1024) {
                    if (this.eq_data.data_u.d_int_array == null) {
                        this.eq_data.data_u.d_int_array = new int[1024];
                    }
                    if (index >= this.eq_data.data_u.d_int_array.length) {
                        int[] temp = new int[index + 1];
                        this.copy_int(this.eq_data.data_u.d_int_array, temp);
                        this.eq_data.data_u.d_int_array = temp;
                    }
                    this.eq_data.data_u.d_int_array[index] = (int)data;
                    return 1;
                }
                return 0;
            }
            case 115: {
                if (index < 1024) {
                    if (this.eq_data.data_u.d_short_array == null) {
                        this.eq_data.data_u.d_short_array = new short[1024];
                    }
                    if (index >= this.eq_data.data_u.d_short_array.length) {
                        short[] stemp = new short[index + 1];
                        this.copy_short(this.eq_data.data_u.d_short_array, stemp);
                        this.eq_data.data_u.d_short_array = stemp;
                    }
                    this.eq_data.data_u.d_short_array[index] = (short)data;
                    return 1;
                }
                return 0;
            }
            case 103: {
                if (this.eq_data.data_u.d_ustr_array == null) {
                    this.eq_data.data_u.d_ustr_array = new USTR[1];
                    this.eq_data.data_u.d_ustr_array[0] = new USTR();
                }
                switch (index) {
                    case 0: {
                        this.eq_data.data_u.d_ustr_array[0].i1_data = (int)data;
                        return 1;
                    }
                    case 1: {
                        this.eq_data.data_u.d_ustr_array[0].f1_data = data;
                        return 1;
                    }
                    case 2: {
                        this.eq_data.data_u.d_ustr_array[0].f2_data = data;
                        return 1;
                    }
                    case 3: {
                        this.eq_data.data_u.d_ustr_array[0].tm.value = (int)data;
                        return 1;
                    }
                }
                return 0;
            }
            case 108: {
                if (this.eq_data.data_u.d_xyzs_array == null) {
                    this.eq_data.data_u.d_xyzs_array = new XYZS[1];
                    this.eq_data.data_u.d_xyzs_array[0] = new XYZS();
                }
                switch (index) {
                    case 0: {
                        this.eq_data.data_u.d_xyzs_array[0].status = (int)data;
                        return 1;
                    }
                    case 1: {
                        this.eq_data.data_u.d_xyzs_array[0].x = data;
                        return 1;
                    }
                    case 2: {
                        this.eq_data.data_u.d_xyzs_array[0].y = data;
                        return 1;
                    }
                    case 3: {
                        this.eq_data.data_u.d_xyzs_array[0].z = data;
                        return 1;
                    }
                }
                return 0;
            }
            case 109: {
                if (index >= this.eq_data.data_u.d_mdfa.d_farray.length) {
                    return 0;
                }
                this.eq_data.data_u.d_mdfa.d_farray[index] = data;
                return 1;
            }
        }
        return 0;
    }

    public int set(double f) {
        if (this.eq_data.data_u.data_sel != 6) {
            this.eq_data.data_u.data_sel = 6;
        }
        this.eq_data.data_u.d_double = f;
        return 1;
    }

    public int set(double data, int index) {
        switch (this.eq_data.data_u.data_sel) {
            case 19: {
                if (index < 0x100000) {
                    if (this.eq_data.data_u.d_spectrum.d_spect_array == null) {
                        this.eq_data.data_u.d_spectrum = new SPECTRUM();
                        this.eq_data.data_u.d_spectrum.comment = new byte[80];
                        this.eq_data.data_u.d_spectrum.d_spect_array = new float[index + 1];
                    }
                    if (index >= this.eq_data.data_u.d_spectrum.d_spect_array.length) {
                        float[] tmp = new float[index + 1];
                        this.copy_float(this.eq_data.data_u.d_spectrum.d_spect_array, tmp);
                        this.eq_data.data_u.d_float_array = tmp;
                    }
                    this.eq_data.data_u.d_spectrum.d_spect_array[index] = (float)data;
                    return 1;
                }
                return 0;
            }
            case 100: {
                if (index < 1024) {
                    if (this.eq_data.data_u.d_float_array == null) {
                        this.eq_data.data_u.d_float_array = new float[index + 1];
                    }
                    if (index >= this.eq_data.data_u.d_float_array.length) {
                        float[] tmp = new float[index + 1];
                        this.copy_float(this.eq_data.data_u.d_float_array, tmp);
                        this.eq_data.data_u.d_float_array = tmp;
                    }
                    this.eq_data.data_u.d_float_array[index] = (float)data;
                    return 1;
                }
                return 0;
            }
            case 110: {
                if (index < 1024) {
                    if (this.eq_data.data_u.d_double_array == null) {
                        this.eq_data.data_u.d_double_array = new double[index + 1];
                    }
                    if (index >= this.eq_data.data_u.d_double_array.length) {
                        double[] dtmp = new double[index + 1];
                        this.copy_double(this.eq_data.data_u.d_double_array, dtmp);
                        this.eq_data.data_u.d_double_array = dtmp;
                    }
                    this.eq_data.data_u.d_double_array[index] = data;
                    return 1;
                }
                return 0;
            }
            case 105: 
            case 119: {
                if (index < 1024) {
                    if (this.eq_data.data_u.d_int_array == null) {
                        this.eq_data.data_u.d_int_array = new int[1024];
                    }
                    if (index >= this.eq_data.data_u.d_int_array.length) {
                        int[] temp = new int[index + 1];
                        this.copy_int(this.eq_data.data_u.d_int_array, temp);
                        this.eq_data.data_u.d_int_array = temp;
                    }
                    this.eq_data.data_u.d_int_array[index] = (int)data;
                    return 1;
                }
                return 0;
            }
            case 115: {
                if (index < 1024) {
                    if (this.eq_data.data_u.d_short_array == null) {
                        this.eq_data.data_u.d_short_array = new short[1024];
                    }
                    if (index >= this.eq_data.data_u.d_short_array.length) {
                        short[] stemp = new short[index + 1];
                        this.copy_short(this.eq_data.data_u.d_short_array, stemp);
                        this.eq_data.data_u.d_short_array = stemp;
                    }
                    this.eq_data.data_u.d_short_array[index] = (short)data;
                    return 1;
                }
                return 0;
            }
            case 103: {
                if (this.eq_data.data_u.d_ustr_array == null) {
                    this.eq_data.data_u.d_ustr_array = new USTR[1];
                    this.eq_data.data_u.d_ustr_array[0] = new USTR();
                }
                switch (index) {
                    case 0: {
                        this.eq_data.data_u.d_ustr_array[0].i1_data = (int)data;
                        return 1;
                    }
                    case 1: {
                        this.eq_data.data_u.d_ustr_array[0].f1_data = (float)data;
                        return 1;
                    }
                    case 2: {
                        this.eq_data.data_u.d_ustr_array[0].f2_data = (float)data;
                        return 1;
                    }
                    case 3: {
                        this.eq_data.data_u.d_ustr_array[0].tm.value = (int)data;
                        return 1;
                    }
                }
                return 0;
            }
            case 108: {
                if (this.eq_data.data_u.d_xyzs_array == null) {
                    this.eq_data.data_u.d_xyzs_array = new XYZS[1];
                    this.eq_data.data_u.d_xyzs_array[0] = new XYZS();
                }
                switch (index) {
                    case 0: {
                        this.eq_data.data_u.d_xyzs_array[0].status = (int)data;
                        return 1;
                    }
                    case 1: {
                        this.eq_data.data_u.d_xyzs_array[0].x = (float)data;
                        return 1;
                    }
                    case 2: {
                        this.eq_data.data_u.d_xyzs_array[0].y = (float)data;
                        return 1;
                    }
                    case 3: {
                        this.eq_data.data_u.d_xyzs_array[0].z = (float)data;
                        return 1;
                    }
                }
                return 0;
            }
            case 109: {
                if (index >= this.eq_data.data_u.d_mdfa.d_farray.length) {
                    return 0;
                }
                this.eq_data.data_u.d_mdfa.d_farray[index] = (float)data;
                return 1;
            }
        }
        return 0;
    }

    public int set(int data, int index) {
        switch (this.eq_data.data_u.data_sel) {
            case 105: 
            case 119: {
                if (index < 1024) {
                    if (this.eq_data.data_u.d_int_array == null) {
                        this.eq_data.data_u.d_int_array = new int[index + 1];
                    }
                    if (index >= this.eq_data.data_u.d_int_array.length) {
                        int[] temp = new int[index + 1];
                        this.copy_int(this.eq_data.data_u.d_int_array, temp);
                        this.eq_data.data_u.d_int_array = temp;
                    }
                    this.eq_data.data_u.d_int_array[index] = data;
                    return 1;
                }
                return 0;
            }
            case 115: {
                if (index < 1024) {
                    if (this.eq_data.data_u.d_short_array == null) {
                        this.eq_data.data_u.d_short_array = new short[index + 1];
                    }
                    if (index >= this.eq_data.data_u.d_short_array.length) {
                        short[] stemp = new short[index + 1];
                        this.copy_short(this.eq_data.data_u.d_short_array, stemp);
                        this.eq_data.data_u.d_short_array = stemp;
                    }
                    this.eq_data.data_u.d_short_array[index] = (short)data;
                    return 1;
                }
                return 0;
            }
            case 100: {
                if (index < 1024) {
                    if (this.eq_data.data_u.d_float_array == null) {
                        this.eq_data.data_u.d_float_array = new float[index + 1];
                    }
                    if (index >= this.eq_data.data_u.d_float_array.length) {
                        float[] tmp = new float[index + 1];
                        this.copy_float(this.eq_data.data_u.d_float_array, tmp);
                        this.eq_data.data_u.d_float_array = tmp;
                    }
                    this.eq_data.data_u.d_float_array[index] = data;
                    return 1;
                }
                return 0;
            }
            case 103: {
                this.eq_data.data_u.data_sel = 103;
                if (this.eq_data.data_u.d_ustr_array == null) {
                    this.eq_data.data_u.d_ustr_array = new USTR[1];
                    this.eq_data.data_u.d_ustr_array[0] = new USTR();
                }
                switch (index) {
                    case 0: {
                        this.eq_data.data_u.d_ustr_array[0].i1_data = data;
                        return 1;
                    }
                    case 1: {
                        this.eq_data.data_u.d_ustr_array[0].f1_data = data;
                        return 1;
                    }
                    case 2: {
                        this.eq_data.data_u.d_ustr_array[0].f2_data = data;
                        return 1;
                    }
                    case 3: {
                        this.eq_data.data_u.d_ustr_array[0].tm.value = data;
                        return 1;
                    }
                }
                return 0;
            }
            case 108: {
                if (this.eq_data.data_u.d_xyzs_array == null) {
                    this.eq_data.data_u.d_xyzs_array = new XYZS[1];
                    this.eq_data.data_u.d_xyzs_array[0] = new XYZS();
                }
                switch (index) {
                    case 0: {
                        this.eq_data.data_u.d_xyzs_array[0].status = data;
                        return 1;
                    }
                    case 1: {
                        this.eq_data.data_u.d_xyzs_array[0].x = data;
                        return 1;
                    }
                    case 2: {
                        this.eq_data.data_u.d_xyzs_array[0].y = data;
                        return 1;
                    }
                    case 3: {
                        this.eq_data.data_u.d_xyzs_array[0].z = data;
                        return 1;
                    }
                }
                return 0;
            }
            case 109: {
                if (index >= this.eq_data.data_u.d_mdfa.d_farray.length) {
                    return 0;
                }
                this.eq_data.data_u.d_mdfa.d_farray[index] = data;
                return 1;
            }
        }
        if (index == 0) {
            this.set(data);
            return 1;
        }
        return 0;
    }

    public int set(String s) {
        int i = s.length() + 1;
        if (i > 16) {
            if (i > 80) {
                i = 80;
            }
            this.eq_data.data_u.data_sel = 103;
            this.eq_data.data_u.d_ustr_array = new USTR[1];
            this.eq_data.data_u.d_ustr_array[0] = new USTR();
            this.eq_data.data_u.d_ustr_array[0].i1_data = 0;
            this.eq_data.data_u.d_ustr_array[0].f1_data = 0.0f;
            this.eq_data.data_u.d_ustr_array[0].f2_data = 0.0f;
            this.eq_data.data_u.d_ustr_array[0].tm = new time_t();
            this.eq_data.data_u.d_ustr_array[0].tm.value = 0;
            this.eq_data.data_u.d_ustr_array[0].str_data = new byte[80];
            this.toByteArray(s, this.eq_data.data_u.d_ustr_array[0].str_data, i - 1);
        } else {
            this.eq_data.data_u.data_sel = 5;
            this.eq_data.data_u.d_char16 = new byte[16];
            this.toByteArray(s, this.eq_data.data_u.d_char16, i - 1);
        }
        return 1;
    }

    public int set(TDS tds) {
        if (this.eq_data.data_u.data_sel != 12) {
            this.eq_data.data_u.data_sel = 12;
        }
        this.eq_data.data_u.d_tds = new TDS();
        this.eq_data.data_u.d_tds.tm = tds.tm;
        this.eq_data.data_u.d_tds.data = tds.data;
        this.eq_data.data_u.d_tds.status = tds.status;
        return 1;
    }

    public int set(time_t t, float f, u_char s) {
        if (this.eq_data.data_u.data_sel != 12) {
            this.eq_data.data_u.data_sel = 12;
        }
        this.eq_data.data_u.d_tds = new TDS();
        this.eq_data.data_u.d_tds.tm = t;
        this.eq_data.data_u.d_tds.data = f;
        this.eq_data.data_u.d_tds.status = s;
        return 1;
    }

    public int set(int it, float f, u_char s) {
        if (this.eq_data.data_u.data_sel != 12) {
            this.eq_data.data_u.data_sel = 12;
        }
        this.eq_data.data_u.d_tds = new TDS();
        this.eq_data.data_u.d_tds.tm.value = it;
        this.eq_data.data_u.d_tds.data = f;
        this.eq_data.data_u.d_tds.status = s;
        return 1;
    }

    public int set(TDS t, int index) {
        if (index >= 2000) {
            return 0;
        }
        if (this.eq_data.data_u.data_sel != 101) {
            this.eq_data.data_u.data_sel = 101;
        }
        if (this.eq_data.data_u.d_tds_array == null) {
            int len = index == 0 ? 2000 : index--;
            this.eq_data.data_u.d_tds_array = new TDS[len];
            for (int i = 0; i < len; ++i) {
                this.eq_data.data_u.d_tds_array[i] = new TDS();
            }
            this.eq_data.data_u.d_tds_array[i].tm = new time_t();
            this.eq_data.data_u.d_tds_array[i].status = new u_char();
        }
        this.eq_data.data_u.d_tds_array[index].tm = t.tm;
        this.eq_data.data_u.d_tds_array[index].data = t.data;
        this.eq_data.data_u.d_tds_array[index].status = t.status;
        return 1;
    }

    public int set(TDSi t, int index) {
        if (index >= 2000) {
            return 0;
        }
        if (this.eq_data.data_u.data_sel != 107) {
            this.eq_data.data_u.data_sel = 107;
        }
        if (this.eq_data.data_u.d_tdsi_array == null) {
            int len = index == 0 ? 2000 : index--;
            this.eq_data.data_u.d_tdsi_array = new TDSi[len];
            for (int i = 0; i < len; ++i) {
                this.eq_data.data_u.d_tdsi_array[i] = new TDSi();
            }
        }
        this.eq_data.data_u.d_tdsi_array[index].tm = t.tm;
        this.eq_data.data_u.d_tdsi_array[index].data = t.data;
        this.eq_data.data_u.d_tdsi_array[index].status = t.status;
        this.eq_data.data_u.d_tdsi_array[index].t_ms = t.t_ms;
        return 1;
    }

    public int set(int itm, float data, u_char status, int index) {
        return this.set(new time_t(itm), data, status, index);
    }

    public int set(time_t tm, float data, u_char status, int index) {
        if (this.eq_data.data_u.data_sel != 101) {
            this.eq_data.data_u.data_sel = 101;
        }
        if (this.eq_data.data_u.d_tds_array == null) {
            int len = index == 0 ? 2000 : index--;
            this.eq_data.data_u.d_tds_array = new TDS[len];
            for (int i = 0; i < len; ++i) {
                this.eq_data.data_u.d_tds_array[i] = new TDS();
                this.eq_data.data_u.d_tds_array[i].tm = new time_t();
                this.eq_data.data_u.d_tds_array[i].status = new u_char();
            }
        }
        this.eq_data.data_u.d_tds_array[index].tm.value = tm.value;
        this.eq_data.data_u.d_tds_array[index].data = data;
        this.eq_data.data_u.d_tds_array[index].status.value = status.value;
        return 1;
    }

    public int set(time_t tm, float data, short status, short tm2, int index) {
        if (index >= 2000) {
            return 0;
        }
        if (this.eq_data.data_u.data_sel != 107) {
            this.eq_data.data_u.data_sel = 107;
        }
        if (this.eq_data.data_u.d_tdsi_array == null) {
            int len = index == 0 ? 2000 : index--;
            this.eq_data.data_u.d_tdsi_array = new TDSi[len];
            for (int i = 0; i < len; ++i) {
                this.eq_data.data_u.d_tdsi_array[i] = new TDSi();
            }
        }
        this.eq_data.data_u.d_tdsi_array[index].tm.value = tm.value;
        this.eq_data.data_u.d_tdsi_array[index].data = data;
        this.eq_data.data_u.d_tdsi_array[index].status = status;
        this.eq_data.data_u.d_tdsi_array[index].t_ms = tm2;
        return 1;
    }

    public int set(SPECTRUM sp) {
        this.set(new String(sp.comment).trim(), sp.tm, sp.s_start, sp.s_inc, sp.status, sp.d_spect_array, sp.d_spect_array.length);
        return 1;
    }

    public int set(String c, time_t t, float st, float inc, int s, float[] fp, int ln) {
        int len;
        if (this.eq_data.data_u.data_sel != 19) {
            this.eq_data.data_u.data_sel = 19;
        }
        if (this.eq_data.data_u.d_spectrum == null) {
            this.eq_data.data_u.d_spectrum = new SPECTRUM();
            len = c.length() + 1;
            if (len > 80) {
                len = 80;
            }
            this.eq_data.data_u.d_spectrum.d_spect_array = ln == 0 ? new float[8192] : new float[ln];
            this.eq_data.data_u.d_spectrum.comment = new byte[len];
        }
        if ((len = c.length() + 1) > 80) {
            len = 80;
        }
        if (len > 1) {
            this.toByteArray(c, this.eq_data.data_u.d_spectrum.comment, len - 1);
        }
        this.eq_data.data_u.d_spectrum.tm = new time_t();
        this.eq_data.data_u.d_spectrum.tm.value = t.value != 0 ? t.value : (int)(System.currentTimeMillis() / 1000L);
        this.eq_data.data_u.d_spectrum.s_start = st;
        this.eq_data.data_u.d_spectrum.s_inc = inc;
        this.eq_data.data_u.d_spectrum.status = s;
        this.eq_data.data_u.d_spectrum.status = s;
        len = fp.length;
        if (len > 0x100000) {
            len = 0x100000;
        }
        if (ln < len) {
            len = ln;
        }
        for (int i = 0; i < len; ++i) {
            this.eq_data.data_u.d_spectrum.d_spect_array[i] = fp[i];
        }
        return 1;
    }

    public int set(USTR t, int index) {
        int i;
        int len;
        if (index >= 1000) {
            return 0;
        }
        if (this.eq_data.data_u.data_sel != 103) {
            this.eq_data.data_u.data_sel = 103;
        }
        if (this.eq_data.data_u.d_ustr_array == null) {
            len = index == 0 ? 1000 : index--;
            this.eq_data.data_u.d_ustr_array = new USTR[len];
            for (i = 0; i < len; ++i) {
                this.eq_data.data_u.d_ustr_array[i] = new USTR();
            }
        }
        this.eq_data.data_u.d_ustr_array[index].i1_data = t.i1_data;
        this.eq_data.data_u.d_ustr_array[index].f1_data = t.f1_data;
        this.eq_data.data_u.d_ustr_array[index].f2_data = t.f2_data;
        this.eq_data.data_u.d_ustr_array[index].tm = new time_t();
        this.eq_data.data_u.d_ustr_array[index].tm.value = t.tm.value;
        len = t.str_data.length;
        if (len >= 80) {
            len = 80;
        }
        this.eq_data.data_u.d_ustr_array[index].str_data = len > 0 ? new byte[len] : new byte[1];
        for (i = 0; i < len; ++i) {
            this.eq_data.data_u.d_ustr_array[index].str_data[i] = t.str_data[i];
        }
        return 1;
    }

    public int set(String cp, int index) {
        switch (this.eq_data.data_u.data_sel) {
            case 113: {
                int len;
                if (index >= 1000) {
                    return 0;
                }
                if (this.eq_data.data_u.d_name16 == null) {
                    this.eq_data.data_u.d_name16 = new NAME16[1];
                    this.eq_data.data_u.d_name16[0] = new NAME16();
                }
                if (this.eq_data.data_u.d_name16.length < index + 1) {
                    NAME16[] nTmp = new NAME16[index + 1];
                    this.copy_name16(this.eq_data.data_u.d_name16, nTmp);
                    nTmp[index] = new NAME16();
                    this.eq_data.data_u.d_name16 = nTmp;
                }
                if ((len = cp.trim().length()) > 16) {
                    len = 16;
                }
                this.eq_data.data_u.d_name16[index].str_data = new byte[16];
                this.toByteArray(cp, this.eq_data.data_u.d_name16[index].str_data, len);
                return 1;
            }
            case 118: {
                int len;
                if (index >= 1000) {
                    return 0;
                }
                if (this.eq_data.data_u.d_name32 == null) {
                    this.eq_data.data_u.d_name32 = new NAME32[1];
                    this.eq_data.data_u.d_name32[0] = new NAME32();
                }
                if (this.eq_data.data_u.d_name32.length < index + 1) {
                    NAME32[] n32Tmp = new NAME32[index + 1];
                    this.copy_name32(this.eq_data.data_u.d_name32, n32Tmp);
                    n32Tmp[index] = new NAME32();
                    this.eq_data.data_u.d_name32 = n32Tmp;
                }
                if ((len = cp.trim().length()) > 32) {
                    len = 32;
                }
                this.eq_data.data_u.d_name32[index].str_data = new byte[32];
                this.toByteArray(cp, this.eq_data.data_u.d_name32[index].str_data, len);
                return 1;
            }
            case 117: {
                int len;
                if (index >= 1000) {
                    return 0;
                }
                if (this.eq_data.data_u.d_name64 == null) {
                    this.eq_data.data_u.d_name64 = new NAME64[1];
                    this.eq_data.data_u.d_name64[0] = new NAME64();
                }
                if (this.eq_data.data_u.d_name64.length < index + 1) {
                    NAME64[] n64Tmp = new NAME64[index + 1];
                    this.copy_name64(this.eq_data.data_u.d_name64, n64Tmp);
                    n64Tmp[index] = new NAME64();
                    this.eq_data.data_u.d_name64 = n64Tmp;
                }
                if ((len = cp.trim().length()) > 64) {
                    len = 64;
                }
                this.eq_data.data_u.d_name64[index].str_data = new byte[64];
                this.toByteArray(cp, this.eq_data.data_u.d_name64[index].str_data, len);
                return 1;
            }
        }
        if (index >= 1000) {
            return 0;
        }
        if (this.eq_data.data_u.data_sel != 103) {
            this.eq_data.data_u.data_sel = 103;
        }
        if (this.eq_data.data_u.d_ustr_array == null) {
            this.eq_data.data_u.d_ustr_array = new USTR[1];
            this.eq_data.data_u.d_ustr_array[0] = new USTR();
        }
        if (this.eq_data.data_u.d_ustr_array.length < index + 1) {
            USTR[] tmp = new USTR[index + 1];
            this.copy_ustr(this.eq_data.data_u.d_ustr_array, tmp);
            tmp[index] = new USTR();
            this.eq_data.data_u.d_ustr_array = tmp;
        }
        this.eq_data.data_u.d_ustr_array[index].i1_data = 0;
        this.eq_data.data_u.d_ustr_array[index].f1_data = 0.0f;
        this.eq_data.data_u.d_ustr_array[index].f2_data = 0.0f;
        this.eq_data.data_u.d_ustr_array[index].tm = new time_t();
        this.eq_data.data_u.d_ustr_array[index].tm.value = 0;
        int len = cp.trim().length();
        if (len >= 80) {
            len = 80;
        }
        this.eq_data.data_u.d_ustr_array[index].str_data = len > 0 ? new byte[len] : new byte[1];
        this.toByteArray(cp, this.eq_data.data_u.d_ustr_array[index].str_data, len);
        return 1;
    }

    private void copy_ustr(USTR[] s, USTR[] t) {
        for (USTR t[i] : s) {
        }
    }

    private void copy_name16fi(NAME16FI[] s, NAME16FI[] t) {
        for (NAME16FI t[i] : s) {
        }
    }

    private void copy_name16ii(NAME16II[] s, NAME16II[] t) {
        for (NAME16II t[i] : s) {
        }
    }

    private void copy_name16(NAME16[] s, NAME16[] t) {
        for (NAME16 t[i] : s) {
        }
    }

    private void copy_name32(NAME32[] s, NAME32[] t) {
        for (NAME32 t[i] : s) {
        }
    }

    private void copy_name64(NAME64[] s, NAME64[] t) {
        for (NAME64 t[i] : s) {
        }
    }

    public int set(int i1, float f1, float f2, int itm, String cp, int index) {
        return this.set(i1, f1, f2, new time_t(itm), cp, index);
    }

    public int set(int i1, float f1, float f2, time_t tm, String cp, int index) {
        if (index >= 1000) {
            return 0;
        }
        if (this.eq_data.data_u.data_sel != 103) {
            this.eq_data.data_u.data_sel = 103;
        }
        if (this.eq_data.data_u.d_ustr_array == null) {
            this.eq_data.data_u.d_ustr_array = new USTR[1];
            this.eq_data.data_u.d_ustr_array[0] = new USTR();
        }
        if (this.eq_data.data_u.d_ustr_array.length < index + 1) {
            USTR[] tmp = new USTR[index + 1];
            this.copy_ustr(this.eq_data.data_u.d_ustr_array, tmp);
            tmp[index] = new USTR();
            this.eq_data.data_u.d_ustr_array = tmp;
        }
        this.eq_data.data_u.d_ustr_array[index].i1_data = i1;
        this.eq_data.data_u.d_ustr_array[index].f1_data = f1;
        this.eq_data.data_u.d_ustr_array[index].f2_data = f2;
        this.eq_data.data_u.d_ustr_array[index].tm = new time_t();
        this.eq_data.data_u.d_ustr_array[index].tm.value = tm.value;
        int len = cp.trim().length();
        if (len >= 80) {
            len = 80;
        }
        this.eq_data.data_u.d_ustr_array[index].str_data = len > 0 ? new byte[len] : new byte[1];
        this.toByteArray(cp, this.eq_data.data_u.d_ustr_array[index].str_data, len);
        return 1;
    }

    public int set(String cp, float f1, int i1, int index) {
        if (index >= 1000) {
            return 0;
        }
        if (this.eq_data.data_u.data_sel != 111) {
            this.eq_data.data_u.data_sel = 111;
        }
        if (this.eq_data.data_u.d_name16fi == null) {
            this.eq_data.data_u.d_name16fi = new NAME16FI[1];
            this.eq_data.data_u.d_name16fi[0] = new NAME16FI();
        }
        if (this.eq_data.data_u.d_name16fi.length < index + 1) {
            NAME16FI[] tmp = new NAME16FI[index + 1];
            this.copy_name16fi(this.eq_data.data_u.d_name16fi, tmp);
            tmp[index] = new NAME16FI();
            this.eq_data.data_u.d_name16fi = tmp;
        }
        this.eq_data.data_u.d_name16fi[index].i_data = i1;
        this.eq_data.data_u.d_name16fi[index].f_data = f1;
        int len = cp.trim().length();
        if (len >= 16) {
            len = 16;
        }
        this.eq_data.data_u.d_name16fi[index].str_data = len > 0 ? new byte[len] : new byte[1];
        this.toByteArray(cp, this.eq_data.data_u.d_name16fi[index].str_data, len);
        return 1;
    }

    public int set(String cp, int i1, int i2, int index) {
        if (index >= 1000) {
            return 0;
        }
        if (this.eq_data.data_u.data_sel != 112) {
            this.eq_data.data_u.data_sel = 112;
        }
        if (this.eq_data.data_u.d_name16ii == null) {
            this.eq_data.data_u.d_name16ii = new NAME16II[1];
            this.eq_data.data_u.d_name16ii[0] = new NAME16II();
        }
        if (this.eq_data.data_u.d_name16ii.length < index + 1) {
            NAME16II[] tmp = new NAME16II[index + 1];
            this.copy_name16ii(this.eq_data.data_u.d_name16ii, tmp);
            tmp[index] = new NAME16II();
            this.eq_data.data_u.d_name16ii = tmp;
        }
        this.eq_data.data_u.d_name16ii[index].i1_data = i1;
        this.eq_data.data_u.d_name16ii[index].i2_data = i2;
        int len = cp.trim().length();
        if (len >= 16) {
            len = 16;
        }
        this.eq_data.data_u.d_name16ii[index].str_data = len > 0 ? new byte[len] : new byte[1];
        this.toByteArray(cp, this.eq_data.data_u.d_name16ii[index].str_data, len);
        return 1;
    }

    public int set(FIS fis) {
        if (this.eq_data.data_u.data_sel != 17) {
            this.eq_data.data_u.data_sel = 17;
        }
        this.eq_data.data_u.d_fis = new FIS();
        this.eq_data.data_u.d_fis.f_data = fis.f_data;
        this.eq_data.data_u.d_fis.i_data = fis.i_data;
        this.eq_data.data_u.d_fis.status = fis.status;
        return 1;
    }

    public int set(float f, int i, u_char s) {
        if (this.eq_data.data_u.data_sel != 17) {
            this.eq_data.data_u.data_sel = 17;
        }
        this.eq_data.data_u.d_fis = new FIS();
        this.eq_data.data_u.d_fis.f_data = f;
        this.eq_data.data_u.d_fis.i_data = i;
        this.eq_data.data_u.d_fis.status = s;
        return 1;
    }

    public int set(FIS t, int index) {
        if (index >= 128) {
            return 0;
        }
        if (this.eq_data.data_u.data_sel != 104) {
            this.eq_data.data_u.data_sel = 104;
        }
        if (this.eq_data.data_u.d_fis_array == null) {
            int len = index == 0 ? 128 : index--;
            this.eq_data.data_u.d_fis_array = new FIS[len];
            for (int i = 0; i < len; ++i) {
                this.eq_data.data_u.d_fis_array[i] = new FIS();
            }
        }
        this.eq_data.data_u.d_fis_array[index].i_data = t.i_data;
        this.eq_data.data_u.d_fis_array[index].f_data = t.f_data;
        this.eq_data.data_u.d_fis_array[index].status = new u_char();
        this.eq_data.data_u.d_fis_array[index].status.value = t.status.value;
        return 1;
    }

    public int set(FI t, int index) {
        if (index >= 1000) {
            return 0;
        }
        if (this.eq_data.data_u.data_sel != 114) {
            this.eq_data.data_u.data_sel = 114;
        }
        if (this.eq_data.data_u.d_fi_array == null) {
            int len = index == 0 ? 1000 : index--;
            this.eq_data.data_u.d_fi_array = new FI[len];
            for (int i = 0; i < len; ++i) {
                this.eq_data.data_u.d_fi_array[i] = new FI();
            }
        }
        this.eq_data.data_u.d_fi_array[index].i_data = t.i_data;
        this.eq_data.data_u.d_fi_array[index].f_data = t.f_data;
        return 1;
    }

    public int set(float f, int i1, int index) {
        if (index >= 1000) {
            return 0;
        }
        if (this.eq_data.data_u.data_sel != 114) {
            this.eq_data.data_u.data_sel = 114;
        }
        if (this.eq_data.data_u.d_fi_array == null) {
            int len = index == 0 ? 1000 : index--;
            this.eq_data.data_u.d_fi_array = new FI[len];
            for (int i = 0; i < len; ++i) {
                this.eq_data.data_u.d_fi_array[i] = new FI();
            }
        }
        this.eq_data.data_u.d_fi_array[index].i_data = i1;
        this.eq_data.data_u.d_fi_array[index].f_data = f;
        return 1;
    }

    public int set(II t, int index) {
        if (index >= 1000) {
            return 0;
        }
        if (this.eq_data.data_u.data_sel != 116) {
            this.eq_data.data_u.data_sel = 116;
        }
        if (this.eq_data.data_u.d_ii_array == null) {
            int len = index == 0 ? 1000 : index--;
            this.eq_data.data_u.d_ii_array = new II[len];
            for (int i = 0; i < len; ++i) {
                this.eq_data.data_u.d_ii_array[i] = new II();
            }
        }
        this.eq_data.data_u.d_ii_array[index].i1_data = t.i1_data;
        this.eq_data.data_u.d_ii_array[index].i2_data = t.i2_data;
        return 1;
    }

    public int set(int i1, int i2, int index) {
        if (index >= 1000) {
            return 0;
        }
        if (this.eq_data.data_u.data_sel != 116) {
            this.eq_data.data_u.data_sel = 116;
        }
        if (this.eq_data.data_u.d_ii_array == null) {
            int len = index == 0 ? 1000 : index--;
            this.eq_data.data_u.d_ii_array = new II[len];
            for (int i = 0; i < len; ++i) {
                this.eq_data.data_u.d_ii_array[i] = new II();
            }
        }
        this.eq_data.data_u.d_ii_array[index].i1_data = i1;
        this.eq_data.data_u.d_ii_array[index].i2_data = i2;
        return 1;
    }

    public int set(float f, int i1, u_char s, int index) {
        if (index >= 128) {
            return 0;
        }
        if (this.eq_data.data_u.data_sel != 104) {
            this.eq_data.data_u.data_sel = 104;
        }
        if (this.eq_data.data_u.d_fis_array == null) {
            int len = index == 0 ? 128 : index--;
            this.eq_data.data_u.d_fis_array = new FIS[len];
            for (int i = 0; i < len; ++i) {
                this.eq_data.data_u.d_fis_array[i] = new FIS();
            }
        }
        this.eq_data.data_u.d_fis_array[index].i_data = i1;
        this.eq_data.data_u.d_fis_array[index].f_data = f;
        this.eq_data.data_u.d_fis_array[index].status = new u_char();
        this.eq_data.data_u.d_fis_array[index].status.value = s.value;
        return 1;
    }

    public int set(XY xy) {
        if (this.eq_data.data_u.data_sel != 13) {
            this.eq_data.data_u.data_sel = 13;
        }
        this.eq_data.data_u.d_xy = new XY();
        this.eq_data.data_u.d_xy.x_data = xy.x_data;
        this.eq_data.data_u.d_xy.x_data = xy.y_data;
        return 1;
    }

    public int set(float f1, float f2) {
        if (this.eq_data.data_u.data_sel != 13) {
            this.eq_data.data_u.data_sel = 13;
        }
        this.eq_data.data_u.d_xy = new XY();
        this.eq_data.data_u.d_xy.x_data = f1;
        this.eq_data.data_u.d_xy.x_data = f2;
        return 1;
    }

    public int set(XY pxy, int index) {
        if (index >= 2048) {
            return 0;
        }
        if (this.eq_data.data_u.data_sel != 102) {
            this.eq_data.data_u.data_sel = 102;
        }
        if (this.eq_data.data_u.d_xy_array == null) {
            int len = index == 0 ? 2048 : index--;
            this.eq_data.data_u.d_xy_array = new XY[len];
            for (int i = 0; i < len; ++i) {
                this.eq_data.data_u.d_xy_array[i] = new XY();
            }
        }
        this.eq_data.data_u.d_xy_array[index].x_data = pxy.x_data;
        this.eq_data.data_u.d_xy_array[index].y_data = pxy.y_data;
        return 1;
    }

    public int set(float f1, float f2, int index) {
        if (index >= 2048) {
            return 0;
        }
        if (this.eq_data.data_u.data_sel != 102) {
            this.eq_data.data_u.data_sel = 102;
        }
        if (this.eq_data.data_u.d_xy_array == null) {
            int len = index == 0 ? 2048 : index--;
            this.eq_data.data_u.d_xy_array = new XY[len];
            for (int i = 0; i < len; ++i) {
                this.eq_data.data_u.d_xy_array[i] = new XY();
            }
        }
        this.eq_data.data_u.d_xy_array[index].x_data = f1;
        this.eq_data.data_u.d_xy_array[index].y_data = f2;
        return 1;
    }

    public int set(IIII i4p) {
        if (this.eq_data.data_u.data_sel != 14) {
            this.eq_data.data_u.data_sel = 14;
        }
        this.eq_data.data_u.d_iiii = new IIII();
        this.eq_data.data_u.d_iiii.i1_data = i4p.i1_data;
        this.eq_data.data_u.d_iiii.i2_data = i4p.i2_data;
        this.eq_data.data_u.d_iiii.i3_data = i4p.i3_data;
        this.eq_data.data_u.d_iiii.i4_data = i4p.i4_data;
        return 1;
    }

    public int set(int i1, int i2, int i3, int i4) {
        if (this.eq_data.data_u.data_sel != 14) {
            this.eq_data.data_u.data_sel = 14;
        }
        this.eq_data.data_u.d_iiii = new IIII();
        this.eq_data.data_u.d_iiii.i1_data = i1;
        this.eq_data.data_u.d_iiii.i2_data = i2;
        this.eq_data.data_u.d_iiii.i3_data = i3;
        this.eq_data.data_u.d_iiii.i4_data = i4;
        return 1;
    }

    public int set(IFFF p) {
        if (this.eq_data.data_u.data_sel != 15) {
            this.eq_data.data_u.data_sel = 15;
        }
        this.eq_data.data_u.d_ifff = new IFFF();
        this.eq_data.data_u.d_ifff.i1_data = p.i1_data;
        this.eq_data.data_u.d_ifff.f1_data = p.f1_data;
        this.eq_data.data_u.d_ifff.f2_data = p.f2_data;
        this.eq_data.data_u.d_ifff.f3_data = p.f3_data;
        return 1;
    }

    public int set(int i1, float f1, float f2, float f3) {
        if (this.eq_data.data_u.data_sel != 15) {
            this.eq_data.data_u.data_sel = 15;
        }
        this.eq_data.data_u.d_ifff = new IFFF();
        this.eq_data.data_u.d_ifff.i1_data = i1;
        this.eq_data.data_u.d_ifff.f1_data = f1;
        this.eq_data.data_u.d_ifff.f2_data = f2;
        this.eq_data.data_u.d_ifff.f3_data = f3;
        return 1;
    }

    public int set(TTII p) {
        if (this.eq_data.data_u.data_sel != 18) {
            this.eq_data.data_u.data_sel = 18;
        }
        this.eq_data.data_u.d_ttii = new TTII();
        this.eq_data.data_u.d_ttii.tm1 = new time_t();
        this.eq_data.data_u.d_ttii.tm1.value = p.tm1.value;
        this.eq_data.data_u.d_ttii.tm2 = new time_t();
        this.eq_data.data_u.d_ttii.tm2.value = p.tm2.value;
        this.eq_data.data_u.d_ttii.i1_data = p.i1_data;
        this.eq_data.data_u.d_ttii.i2_data = p.i2_data;
        return 1;
    }

    public int set(time_t tm1, time_t tm2, int i1, int i2) {
        if (this.eq_data.data_u.data_sel != 18) {
            this.eq_data.data_u.data_sel = 18;
        }
        this.eq_data.data_u.d_ttii = new TTII();
        this.eq_data.data_u.d_ttii.tm1 = new time_t();
        this.eq_data.data_u.d_ttii.tm1.value = tm1.value;
        this.eq_data.data_u.d_ttii.tm2 = new time_t();
        this.eq_data.data_u.d_ttii.tm2.value = tm2.value;
        this.eq_data.data_u.d_ttii.i1_data = i1;
        this.eq_data.data_u.d_ttii.i2_data = i2;
        return 1;
    }

    public int set_byte(int ix, int iy, int ixo, int iyo, int iopt, byte[] cp) {
        int len;
        if (this.eq_data.data_u.data_sel != 106) {
            this.eq_data.data_u.data_sel = 106;
        }
        if ((len = ix * iy) > 0x800000) {
            len = 0x800000;
        }
        if (this.eq_data.data_u.d_byte_struct == null) {
            this.eq_data.data_u.d_byte_struct = new A_BYTE();
            this.eq_data.data_u.d_byte_struct.d_byte_array = new byte[0x800000];
        }
        this.eq_data.data_u.d_byte_struct.x_dim = ix;
        this.eq_data.data_u.d_byte_struct.y_dim = iy;
        this.eq_data.data_u.d_byte_struct.x_offset = ixo;
        this.eq_data.data_u.d_byte_struct.y_offset = iyo;
        this.eq_data.data_u.d_byte_struct.option = iopt;
        for (byte this.eq_data.data_u.d_byte_struct.d_byte_array[i] : cp) {
        }
        return 1;
    }

    public int set_xml(String s) {
        int len;
        if (this.eq_data.data_u.data_sel != 20) {
            this.eq_data.data_u.data_sel = 20;
        }
        if ((len = s.length() + 1) > 0x400000) {
            len = 0x400000;
        }
        if (this.eq_data.data_u.d_xml == null) {
            this.eq_data.data_u.d_xml = new XML();
            this.eq_data.data_u.d_xml.d_xml_array = new byte[len];
        }
        this.toByteArray(s, this.eq_data.data_u.d_xml.d_xml_array, len - 1);
        return 1;
    }

    public int set_text(String s) {
        int len;
        if (this.eq_data.data_u.data_sel != 7) {
            this.eq_data.data_u.data_sel = 7;
        }
        if ((len = s.length()) > 0x100000) {
            len = 0x100000;
        }
        if (this.eq_data.data_u.d_text == null || this.eq_data.data_u.d_text.d_text_array.length < len) {
            this.eq_data.data_u.d_text = new TEXT();
            this.eq_data.data_u.d_text.d_text_array = new byte[len];
        }
        this.toByteArray(s, this.eq_data.data_u.d_text.d_text_array, len);
        return 1;
    }

    public int set(XYZS t, int index) {
        int i;
        int len;
        if (index >= 1000) {
            return 0;
        }
        if (this.eq_data.data_u.data_sel != 108) {
            this.eq_data.data_u.data_sel = 108;
        }
        if (this.eq_data.data_u.d_xyzs_array == null) {
            len = index == 0 ? 1000 : index--;
            this.eq_data.data_u.d_xyzs_array = new XYZS[len];
            for (i = 0; i < len; ++i) {
                this.eq_data.data_u.d_xyzs_array[i] = new XYZS();
            }
        }
        this.eq_data.data_u.d_xyzs_array[index].status = t.status;
        this.eq_data.data_u.d_xyzs_array[index].x = t.x;
        this.eq_data.data_u.d_xyzs_array[index].y = t.y;
        this.eq_data.data_u.d_xyzs_array[index].z = t.z;
        len = t.loc.length;
        if (len >= 64) {
            len = 64;
        }
        if (len > 0) {
            this.eq_data.data_u.d_xyzs_array[index].loc = new byte[len];
        }
        for (i = 0; i < len; ++i) {
            this.eq_data.data_u.d_xyzs_array[index].loc[i] = t.loc[i];
        }
        return 1;
    }

    public int set(int i1, float f1, float f2, float f3, String cp, int index) {
        int len;
        if (index >= 1000) {
            return 0;
        }
        if (this.eq_data.data_u.data_sel != 108) {
            this.eq_data.data_u.data_sel = 108;
        }
        if (this.eq_data.data_u.d_xyzs_array == null) {
            len = index == 0 ? 1000 : index--;
            this.eq_data.data_u.d_xyzs_array = new XYZS[len];
            for (int i = 0; i < len; ++i) {
                this.eq_data.data_u.d_xyzs_array[i] = new XYZS();
            }
        }
        this.eq_data.data_u.d_xyzs_array[index].status = i1;
        this.eq_data.data_u.d_xyzs_array[index].x = f1;
        this.eq_data.data_u.d_xyzs_array[index].y = f2;
        this.eq_data.data_u.d_xyzs_array[index].z = f3;
        len = cp.length();
        if (len >= 64) {
            len = 64;
        }
        if (len > 0) {
            this.eq_data.data_u.d_xyzs_array[index].loc = new byte[len];
        }
        this.toByteArray(cp, this.eq_data.data_u.d_xyzs_array[index].loc, len);
        return 1;
    }

    public int set_dims(int[] dp, int dims, String str, float ival) {
        int i;
        if (dims <= 0 || dims >= 6 || dp.length == 0) {
            return 0;
        }
        int size = 1;
        for (i = dims; i > 0; --i) {
            size *= dp[i - 1];
        }
        if (size > 16384) {
            return 0;
        }
        this.eq_data.data_u.d_mdfa = new MDAF();
        this.eq_data.data_u.data_sel = 109;
        this.eq_data.data_u.d_mdfa.dimn = dims;
        this.eq_data.data_u.d_mdfa.dims = new int[dims];
        for (i = 0; i < dims; ++i) {
            this.eq_data.data_u.d_mdfa.dims[i] = dp[i];
        }
        this.eq_data.data_u.d_mdfa.d_farray = new float[size];
        int len = str.length();
        if (len >= 80) {
            len = 80;
        }
        if (len > 0) {
            this.eq_data.data_u.d_mdfa.comment = new byte[len];
        }
        this.toByteArray(str, this.eq_data.data_u.d_mdfa.comment, len);
        if (ival != -1.0f) {
            for (i = 0; i < size; ++i) {
                this.eq_data.data_u.d_mdfa.d_farray[i] = ival;
            }
        }
        return 1;
    }

    public int set(int[] dp, int dims, float val) {
        if (dims < 1 || dp.length > 0) {
            return 0;
        }
        int index = dp[0];
        switch (this.eq_data.data_u.data_sel) {
            case 105: 
            case 119: {
                int len = this.eq_data.data_u.d_int_array.length;
                if (dims > 1 || index >= len) {
                    return 0;
                }
                this.eq_data.data_u.d_int_array[index] = (int)val;
                break;
            }
            case 115: {
                int len = this.eq_data.data_u.d_short_array.length;
                if (dims > 1 || index >= len) {
                    return 0;
                }
                this.eq_data.data_u.d_short_array[index] = (short)val;
                break;
            }
            case 100: {
                int len = this.eq_data.data_u.d_float_array.length;
                if (dims > 1 || index >= len) {
                    return 0;
                }
                this.eq_data.data_u.d_float_array[index] = val;
                break;
            }
            case 110: {
                int len = this.eq_data.data_u.d_double_array.length;
                if (dims > 1 || index >= len) {
                    return 0;
                }
                this.eq_data.data_u.d_double_array[index] = val;
                break;
            }
            case 101: {
                int len = this.eq_data.data_u.d_tds_array.length;
                if (dims > 1 || index >= len) {
                    return 0;
                }
                this.eq_data.data_u.d_tds_array[index].data = val;
                break;
            }
            case 107: {
                int len = this.eq_data.data_u.d_tdsi_array.length;
                if (dims > 1 || index >= len) {
                    return 0;
                }
                this.eq_data.data_u.d_tdsi_array[index].data = val;
                break;
            }
            case 104: {
                int len = this.eq_data.data_u.d_fis_array.length;
                if (dims > 1 || index >= len) {
                    return 0;
                }
                this.eq_data.data_u.d_fis_array[index].f_data = val;
                break;
            }
            case 114: {
                int len = this.eq_data.data_u.d_fi_array.length;
                if (dims > 1 || index >= len) {
                    return 0;
                }
                this.eq_data.data_u.d_fi_array[index].f_data = val;
                break;
            }
            case 19: {
                int len = this.eq_data.data_u.d_spectrum.d_spect_array.length;
                if (dims > 1 || index >= len) {
                    return 0;
                }
                this.eq_data.data_u.d_spectrum.d_spect_array[index] = val;
                break;
            }
            case 109: {
                int len = this.get_pos_mda(dp, dims, null, this.eq_data.data_u.d_mdfa);
                if (len == -1) {
                    return 0;
                }
                this.eq_data.data_u.d_mdfa.d_farray[len] = val;
                break;
            }
            default: {
                return 0;
            }
        }
        return 1;
    }

    void set(int i, int i0, int i1, time_t tm, char[] fa, int Size) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void set_time(int time) {
        this.eq_data.tm.value = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveToFile(String fileName) {
        PrintStream ps = null;
        try {
            ps = new PrintStream(fileName);
            String timeStr = String.format("%tc", this.get_time() * 1000L);
            switch (this.eq_data.data_u.data_sel) {
                case 0: {
                    ps.println("#NULL " + timeStr);
                    return;
                }
                case 1: {
                    ps.println("#INT " + timeStr);
                    ps.println(this.get_string());
                    return;
                }
                case 8: {
                    ps.println("#SHORT " + timeStr);
                    ps.println(this.get_string());
                    return;
                }
                case 2: {
                    ps.println("#FLOAT " + timeStr);
                    ps.println(this.get_string());
                    return;
                }
                case 6: {
                    ps.println("#DOUBLE " + timeStr);
                    ps.println(this.get_string());
                    return;
                }
                case 3: {
                    ps.println("#STRING " + timeStr);
                    ps.println(this.get_string());
                    return;
                }
                case 4: {
                    ps.println("#BOOL " + timeStr);
                    ps.println(this.get_string());
                    return;
                }
                case 5: {
                    ps.println("#STRING16 " + timeStr);
                    ps.println(this.get_string());
                    return;
                }
                case 12: {
                    ps.println("#TDS " + timeStr);
                    ps.println(this.get_string());
                    return;
                }
                case 13: {
                    ps.println("#XY " + timeStr);
                    ps.println(this.get_string());
                    return;
                }
                case 14: {
                    ps.println("#IIII " + timeStr);
                    ps.println(this.get_string());
                    return;
                }
                case 15: {
                    ps.println("#IFFF " + timeStr);
                    ps.println(this.get_string());
                    return;
                }
                case 16: {
                    ps.println("#USTR " + timeStr);
                    ps.println(this.get_string());
                    return;
                }
                case 17: {
                    ps.println("#FIS " + timeStr);
                    ps.println(this.get_string());
                    return;
                }
                case 18: {
                    ps.println("#TTII " + timeStr);
                    ps.println(this.get_string());
                    return;
                }
                case 19: {
                    String tmp = String.format("#SPECTRUM %g %g %d %d %s %d %s", Float.valueOf(this.eq_data.data_u.d_spectrum.s_start), Float.valueOf(this.eq_data.data_u.d_spectrum.s_inc), this.eq_data.data_u.d_spectrum.status, this.array_length(), this.get_string_arg(), this.get_time(), timeStr);
                    ps.println(tmp);
                    int i = 0;
                    while (i < this.array_length()) {
                        ps.println(this.get_string(i));
                        ++i;
                    }
                    return;
                }
                case 20: {
                    ps.println("#XML");
                    ps.println(this.get_string());
                    return;
                }
                case 7: {
                    ps.println("#TEXT");
                    ps.println(this.get_string());
                    return;
                }
                case 21: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 110: 
                case 114: 
                case 115: 
                case 116: 
                case 119: {
                    String tmp = String.format("#%s %d %d %s", this.type_string(), this.array_length(), this.get_time(), timeStr);
                    ps.println(tmp);
                    int i = 0;
                    while (i < this.array_length()) {
                        ps.println(this.get_string(i));
                        ++i;
                    }
                    return;
                }
                case 109: {
                    int n = this.eq_data.data_u.d_mdfa.dims.length;
                    String tmp = String.format("#MDA_FLOAT Dims=%d ", n);
                    for (int j = 0; j < n; ++j) {
                        tmp = tmp + "[" + this.eq_data.data_u.d_mdfa.dims[j] + "]";
                    }
                    tmp = tmp + String.format(" %d %s", this.get_time(), timeStr);
                    ps.println(tmp);
                    int i = 0;
                    while (i < this.array_length()) {
                        ps.println(this.get_string(i));
                        ++i;
                    }
                    return;
                }
            }
            return;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(EqData.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        finally {
            ps.close();
        }
    }

    private void typeCaseTemplate() {
        switch (this.eq_data.data_u.data_sel) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 8: {
                break;
            }
            case 2: {
                break;
            }
            case 6: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                break;
            }
            case 7: {
                break;
            }
            case 21: {
                break;
            }
            case 100: {
                break;
            }
            case 110: {
                break;
            }
            case 101: {
                break;
            }
            case 102: {
                break;
            }
            case 103: {
                break;
            }
            case 104: {
                break;
            }
            case 114: {
                break;
            }
            case 116: {
                break;
            }
            case 105: 
            case 119: {
                break;
            }
            case 115: {
                break;
            }
            case 106: {
                break;
            }
            case 107: {
                break;
            }
            case 108: {
                break;
            }
        }
    }

    public int set_ts_spect(time_t tsec, short tmsec, short stat, SPECTRUM sp, int index) {
        int i;
        if (this.type() != 1013) {
            this.assign_type(1013);
        }
        if (index >= 128) {
            return 0;
        }
        if (this.eq_data.data_u.d_ts_spectrum_array == null) {
            this.eq_data.data_u.d_ts_spectrum_array = new TS_SPECTRUM[128];
            for (i = 0; i < 128; ++i) {
                if (i == index) {
                    this.eq_data.data_u.d_ts_spectrum_array[i] = new TS_SPECTRUM();
                    this.eq_data.data_u.d_ts_spectrum_array[i].sp = new SPECTRUM();
                    continue;
                }
                this.eq_data.data_u.d_ts_spectrum_array[i] = null;
            }
        }
        if (this.eq_data.data_u.d_ts_spectrum_array[index] == null) {
            this.eq_data.data_u.d_ts_spectrum_array[index] = new TS_SPECTRUM();
            this.eq_data.data_u.d_ts_spectrum_array[index].sp = new SPECTRUM();
        }
        this.eq_data.data_u.d_ts_spectrum_array[index].tsec = tsec.value;
        this.eq_data.data_u.d_ts_spectrum_array[index].tmsec = tmsec;
        this.eq_data.data_u.d_ts_spectrum_array[index].tstatus = stat;
        this.eq_data.data_u.d_ts_spectrum_array[index].sp.tm = sp.tm;
        this.eq_data.data_u.d_ts_spectrum_array[index].sp.s_start = sp.s_start;
        this.eq_data.data_u.d_ts_spectrum_array[index].sp.s_inc = sp.s_inc;
        this.eq_data.data_u.d_ts_spectrum_array[index].sp.status = sp.status;
        this.eq_data.data_u.d_ts_spectrum_array[index].sp.comment = new byte[sp.comment.length];
        for (i = 0; i < sp.comment.length; ++i) {
            this.eq_data.data_u.d_ts_spectrum_array[index].sp.comment[i] = sp.comment[i];
        }
        if (sp.d_spect_array != null) {
            this.eq_data.data_u.d_ts_spectrum_array[index].sp.d_spect_array = new float[sp.d_spect_array.length];
            for (i = 0; i < sp.d_spect_array.length; ++i) {
                this.eq_data.data_u.d_ts_spectrum_array[index].sp.d_spect_array[i] = sp.d_spect_array[i];
            }
        } else {
            this.eq_data.data_u.d_ts_spectrum_array[index].sp.d_spect_array = null;
        }
        return 1;
    }

    public int allocate_array(int type, int length, int dims) {
        this.eq_data.data_u.data_sel = type;
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                int rtn = this.set_type(type);
                return rtn;
            }
            case 20: {
                this.eq_data.data_u.d_xml = new XML();
                if (length > 0x400000) {
                    length = 0x400000;
                }
                this.eq_data.data_u.d_xml.d_xml_array = new byte[length];
                return 1;
            }
            case 7: {
                this.eq_data.data_u.d_text = new TEXT();
                if (length > 0x100000) {
                    length = 0x100000;
                }
                this.eq_data.data_u.d_text.d_text_array = new byte[length];
                return 1;
            }
            case 19: {
                if (length > 0x100000) {
                    length = 0x100000;
                }
                this.eq_data.data_u.d_spectrum = new SPECTRUM();
                this.eq_data.data_u.d_spectrum.d_spect_array = new float[length];
                this.eq_data.data_u.d_spectrum.comment = new byte[80];
                this.eq_data.data_u.d_spectrum.tm = new time_t();
                return 1;
            }
            case 100: {
                if (length > 1024) {
                    length = 1024;
                }
                this.eq_data.data_u.d_float_array = new float[length];
                return 1;
            }
            case 110: {
                if (length > 1024) {
                    length = 1024;
                }
                this.eq_data.data_u.d_double_array = new double[length];
                return 1;
            }
            case 101: {
                if (length > 2000) {
                    length = 2000;
                }
                this.eq_data.data_u.d_tds_array = new TDS[length];
                for (int i = 0; i < length; ++i) {
                    this.eq_data.data_u.d_tds_array[i] = new TDS();
                    this.eq_data.data_u.d_tds_array[i].tm = new time_t();
                    this.eq_data.data_u.d_tds_array[i].status = new u_char();
                }
                return 1;
            }
            case 102: {
                if (length > 2048) {
                    length = 2048;
                }
                this.eq_data.data_u.d_xy_array = new XY[length];
                return 1;
            }
            case 103: {
                if (length > 1000) {
                    length = 1000;
                }
                this.eq_data.data_u.d_ustr_array = new USTR[length];
                for (int i = 0; i < length; ++i) {
                    this.eq_data.data_u.d_ustr_array[i] = new USTR();
                    this.eq_data.data_u.d_ustr_array[i].str_data = new byte[80];
                    this.eq_data.data_u.d_ustr_array[i].tm = new time_t();
                }
                return 1;
            }
            case 111: {
                if (length > 1000) {
                    length = 1000;
                }
                this.eq_data.data_u.d_name16fi = new NAME16FI[length];
                for (int i = 0; i < length; ++i) {
                    this.eq_data.data_u.d_name16fi[i] = new NAME16FI();
                    this.eq_data.data_u.d_name16fi[i].str_data = new byte[16];
                }
                return 1;
            }
            case 112: {
                if (length > 1000) {
                    length = 1000;
                }
                this.eq_data.data_u.d_name16ii = new NAME16II[length];
                for (int i = 0; i < length; ++i) {
                    this.eq_data.data_u.d_name16ii[i] = new NAME16II();
                    this.eq_data.data_u.d_name16ii[i].str_data = new byte[16];
                }
                return 1;
            }
            case 113: {
                if (length > 1000) {
                    length = 1000;
                }
                this.eq_data.data_u.d_name16 = new NAME16[length];
                for (int i = 0; i < length; ++i) {
                    this.eq_data.data_u.d_name16[i] = new NAME16();
                    this.eq_data.data_u.d_name16[i].str_data = new byte[16];
                }
                return 1;
            }
            case 118: {
                if (length > 1000) {
                    length = 1000;
                }
                this.eq_data.data_u.d_name32 = new NAME32[length];
                for (int i = 0; i < length; ++i) {
                    this.eq_data.data_u.d_name32[i] = new NAME32();
                    this.eq_data.data_u.d_name32[i].str_data = new byte[32];
                }
                return 1;
            }
            case 117: {
                if (length > 1000) {
                    length = 1000;
                }
                this.eq_data.data_u.d_name64 = new NAME64[length];
                for (int i = 0; i < length; ++i) {
                    this.eq_data.data_u.d_name64[i] = new NAME64();
                    this.eq_data.data_u.d_name64[i].str_data = new byte[64];
                }
                return 1;
            }
            case 104: {
                if (length > 128) {
                    length = 128;
                }
                this.eq_data.data_u.d_fis_array = new FIS[length];
                for (int i = 0; i < length; ++i) {
                    this.eq_data.data_u.d_fis_array[i] = new FIS();
                }
                return 1;
            }
            case 114: {
                if (length > 1000) {
                    length = 1000;
                }
                this.eq_data.data_u.d_fi_array = new FI[length];
                for (int i = 0; i < length; ++i) {
                    this.eq_data.data_u.d_fi_array[i] = new FI();
                }
                return 1;
            }
            case 116: {
                if (length > 1000) {
                    length = 1000;
                }
                this.eq_data.data_u.d_ii_array = new II[length];
                for (int i = 0; i < length; ++i) {
                    this.eq_data.data_u.d_ii_array[i] = new II();
                }
                return 1;
            }
            case 105: 
            case 119: {
                if (length > 1024) {
                    length = 1024;
                }
                this.eq_data.data_u.d_int_array = new int[length];
                return 1;
            }
            case 115: {
                if (length > 1024) {
                    length = 1024;
                }
                this.eq_data.data_u.d_short_array = new short[length];
                return 1;
            }
            case 106: {
                if (length > 0x800000) {
                    length = 0x800000;
                }
                this.eq_data.data_u.d_byte_struct = new A_BYTE();
                this.eq_data.data_u.d_byte_struct.d_byte_array = new byte[length];
                return 1;
            }
            case 107: {
                if (length > 2000) {
                    length = 2000;
                }
                this.eq_data.data_u.d_tdsi_array = new TDSi[length];
                for (int i = 0; i < length; ++i) {
                    this.eq_data.data_u.d_tdsi_array[i] = new TDSi();
                }
                return 1;
            }
            case 108: {
                if (length > 1000) {
                    length = 1000;
                }
                this.eq_data.data_u.d_xyzs_array = new XYZS[length];
                this.eq_data.data_u.d_byte_struct.d_byte_array = new byte[length];
                for (int i = 0; i < length; ++i) {
                    this.eq_data.data_u.d_xyzs_array[i].loc = new byte[16];
                }
                return 1;
            }
            case 109: {
                if (length > 128) {
                    length = 128;
                }
                this.eq_data.data_u.d_mdfa = new MDAF();
                this.eq_data.data_u.d_mdfa.comment = new byte[80];
                this.eq_data.data_u.d_mdfa.dims = new int[dims];
                this.eq_data.data_u.d_mdfa.d_farray = new float[length];
                return 1;
            }
        }
        return 0;
    }

    public int get_timestamp(time_t[] psec, time_t[] pusec, int[] pstat) {
        if (this.eq_data.data_u.data_sel != 22) {
            return 0;
        }
        if (psec != null) {
            psec[0] = this.eq_data.data_u.d_image.sec;
        }
        if (pusec != null) {
            pusec[0] = this.eq_data.data_u.d_image.usec;
        }
        if (pstat != null) {
            pstat[0] = this.eq_data.data_u.d_image.status;
        }
        return 1;
    }

    public IMH get_image_header() {
        if (this.eq_data.data_u.data_sel != 22 || this.eq_data.data_u.d_image == null) {
            return null;
        }
        if (this.eq_data.data_u.d_image.val == null) {
            return null;
        }
        return this.eq_data.data_u.d_image.hdr;
    }

    public int get_image(u_char[] valp, int[] lenp, IMH[] hdp) {
        if (this.eq_data.data_u.data_sel != 22 || this.eq_data.data_u.d_image == null) {
            return 0;
        }
        if (this.eq_data.data_u.d_image.val == null) {
            return 0;
        }
        if (hdp != null) {
            hdp[0] = this.get_image_header();
        }
        if (valp != null) {
            for (int i = 0; i < this.eq_data.data_u.d_image.val.length; ++i) {
                valp[i] = this.eq_data.data_u.d_image.val[i];
            }
        }
        if (lenp != null) {
            lenp[0] = this.eq_data.data_u.d_image.val.length;
        }
        return 1;
    }

    public int get_image_pixel(int pixel, float[] data) {
        IMH hdr = this.get_image_header();
        try {
            if (hdr == null) {
                return 0;
            }
            if (pixel * hdr.bpp >= hdr.length) {
                return 0;
            }
            switch (hdr.bpp) {
                case 1: {
                    if (data != null) {
                        data[0] = this.eq_data.data_u.d_image.bbuf.get(pixel);
                    }
                    return 1;
                }
                case 2: {
                    if (data != null) {
                        data[0] = this.eq_data.data_u.d_image.bbuf.getShort(pixel * 2);
                    }
                    return 1;
                }
                case 3: {
                    if (data != null) {
                        data[0] = this.eq_data.data_u.d_image.bbuf.getShort(pixel * 3);
                    }
                    return 1;
                }
                case 4: {
                    if (data != null) {
                        data[0] = this.eq_data.data_u.d_image.bbuf.getInt(pixel * 4);
                    }
                    return 1;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            return 0;
        }
        return 0;
    }

    public int get_image_comm(byte[] buf, int len) {
        if (this.eq_data.data_u.data_sel != 22 || this.eq_data.data_u.d_image == null) {
            return 0;
        }
        if (this.eq_data.data_u.d_image.val == null) {
            return 0;
        }
        if (buf == null || len == 0) {
            return 0;
        }
        buf[0] = 0;
        if (this.eq_data.data_u.d_image.comment != null && this.eq_data.data_u.d_image.comment.length != 0) {
            if (len < this.eq_data.data_u.d_image.comment.length) {
                len = this.eq_data.data_u.d_image.comment.length;
            }
            for (int i = 0; i < len - 1; ++i) {
                buf[i] = this.eq_data.data_u.d_image.comment[i];
            }
            buf[len - 1] = 0;
        }
        return 1;
    }

    public int set_timestamp(time_t sec, time_t usec, int stat) {
        if (this.eq_data.data_u.data_sel != 22) {
            return 0;
        }
        this.eq_data.data_u.d_image.sec = sec;
        this.eq_data.data_u.d_image.usec = usec;
        this.eq_data.data_u.d_image.status = stat;
        return 1;
    }

    public int set_image_header(IMH valp) {
        if (this.eq_data.data_u.data_sel != 22) {
            return 0;
        }
        if (this.eq_data.data_u.d_image.hdr == null) {
            this.eq_data.data_u.d_image.hdr = new IMH();
        }
        this.eq_data.data_u.d_image.hdr.width = valp.width;
        this.eq_data.data_u.d_image.hdr.height = valp.height;
        this.eq_data.data_u.d_image.hdr.aoi_width = valp.aoi_width;
        this.eq_data.data_u.d_image.hdr.aoi_height = valp.aoi_height;
        this.eq_data.data_u.d_image.hdr.x_start = valp.x_start;
        this.eq_data.data_u.d_image.hdr.y_start = valp.y_start;
        this.eq_data.data_u.d_image.hdr.bpp = valp.bpp;
        this.eq_data.data_u.d_image.hdr.ebitpp = valp.ebitpp;
        this.eq_data.data_u.d_image.hdr.hbin = valp.hbin;
        this.eq_data.data_u.d_image.hdr.vbin = valp.vbin;
        this.eq_data.data_u.d_image.hdr.source_format = valp.source_format;
        this.eq_data.data_u.d_image.hdr.image_format = valp.image_format;
        this.eq_data.data_u.d_image.hdr.frame = valp.frame;
        this.eq_data.data_u.d_image.hdr.event = valp.event;
        this.eq_data.data_u.d_image.hdr.scale_x = valp.scale_x;
        this.eq_data.data_u.d_image.hdr.scale_y = valp.scale_y;
        this.eq_data.data_u.d_image.hdr.image_rotation = valp.image_rotation;
        this.eq_data.data_u.d_image.hdr.fspare2 = valp.fspare2;
        this.eq_data.data_u.d_image.hdr.fspare3 = valp.fspare3;
        this.eq_data.data_u.d_image.hdr.fspare4 = valp.fspare4;
        this.eq_data.data_u.d_image.hdr.image_flags = valp.image_flags;
        this.eq_data.data_u.d_image.hdr.ispare2 = valp.ispare2;
        this.eq_data.data_u.d_image.hdr.ispare3 = valp.ispare3;
        this.eq_data.data_u.d_image.hdr.ispare4 = valp.ispare4;
        this.eq_data.data_u.d_image.hdr.length = valp.length;
        return 1;
    }

    public int set_image(u_char[] val, int len, IMH hdp) {
        if (len > 0x800000) {
            len = 0x800000;
        }
        if (this.eq_data.data_u.data_sel != 22) {
            this.assign_type(22);
        }
        if (this.eq_data.data_u.d_image == null) {
            this.eq_data.data_u.d_image = new IMAGE();
        }
        this.set_image_header(hdp);
        this.eq_data.data_u.d_image.val = new u_char[len];
        this.eq_data.data_u.d_image.comment = new byte[80];
        this.eq_data.data_u.d_image.comment[0] = 0;
        this.eq_data.data_u.d_image.bbuf = ByteBuffer.allocate(len);
        for (int i = 0; i < len; ++i) {
            this.eq_data.data_u.d_image.val[i] = val[i];
            this.eq_data.data_u.d_image.bbuf.put(val[i].value);
        }
        return 1;
    }

    public int set_image_comm(byte[] buf) {
        if (buf == null) {
            return 0;
        }
        if (this.eq_data.data_u.data_sel != 22 || this.eq_data.data_u.d_image == null) {
            return 0;
        }
        if (this.eq_data.data_u.d_image.val == null) {
            return 0;
        }
        int len = buf.length;
        if (len > 80) {
            len = 80;
        }
        if (this.eq_data.data_u.d_image.comment == null) {
            this.eq_data.data_u.d_image.comment = new byte[len];
        }
        for (int i = 0; i < len; ++i) {
            this.eq_data.data_u.d_image.comment[i] = buf[i];
        }
        return 1;
    }
}

