/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcAuthenticationException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcPortmapClient;
import org.acplt.oncrpc.OncRpcUdpSocketHelper;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;
import org.acplt.oncrpc.XdrUdpDecodingStream;
import org.acplt.oncrpc.XdrUdpEncodingStream;
import org.acplt.oncrpc.server.OncRpcCallInformation;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.acplt.oncrpc.server.OncRpcServerReplyMessage;
import org.acplt.oncrpc.server.OncRpcServerTransport;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;

public class OncRpcUdpServerTransport
extends OncRpcServerTransport {
    private DatagramSocket socket;
    private OncRpcUdpSocketHelper socketHelper;
    private XdrUdpEncodingStream sendingXdr;
    private XdrUdpDecodingStream receivingXdr;
    private boolean pendingDecoding = false;

    public OncRpcUdpServerTransport(OncRpcDispatchable dispatcher, int port, int program, int version, int bufferSize) throws OncRpcException, IOException {
        this(dispatcher, port, new OncRpcServerTransportRegistrationInfo[]{new OncRpcServerTransportRegistrationInfo(program, version)}, bufferSize);
    }

    public OncRpcUdpServerTransport(OncRpcDispatchable dispatcher, int port, OncRpcServerTransportRegistrationInfo[] info, int bufferSize) throws OncRpcException, IOException {
        super(dispatcher, port, info);
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        this.socket = new DatagramSocket(port);
        this.socketHelper = new OncRpcUdpSocketHelper(this.socket);
        if (port == 0) {
            this.port = this.socket.getLocalPort();
        }
        if (this.socketHelper.getSendBufferSize() < bufferSize) {
            this.socketHelper.setSendBufferSize(bufferSize);
        }
        if (this.socketHelper.getReceiveBufferSize() < bufferSize) {
            this.socketHelper.setReceiveBufferSize(bufferSize);
        }
        this.sendingXdr = new XdrUdpEncodingStream(this.socket, bufferSize);
        this.receivingXdr = new XdrUdpDecodingStream(this.socket, bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        if (this.sendingXdr != null) {
            try {
                this.sendingXdr.close();
            }
            catch (IOException e) {
            }
            catch (OncRpcException e) {
            }
            finally {
                this.sendingXdr = null;
            }
        }
        if (this.receivingXdr != null) {
            try {
                this.receivingXdr.close();
            }
            catch (IOException e) {
            }
            catch (OncRpcException oncRpcException) {
            }
            finally {
                this.receivingXdr = null;
            }
        }
    }

    public void register() throws OncRpcException {
        try {
            OncRpcPortmapClient portmapper = new OncRpcPortmapClient(InetAddress.getByName("127.0.0.1"));
            int size = this.info.length;
            for (int idx = 0; idx < size; ++idx) {
                portmapper.setPort(this.info[idx].program, this.info[idx].version, 17, this.port);
            }
        }
        catch (IOException e) {
            throw new OncRpcException(16);
        }
    }

    protected void retrieveCall(XdrAble call) throws OncRpcException, IOException {
        call.xdrDecode(this.receivingXdr);
        if (this.pendingDecoding) {
            this.pendingDecoding = false;
            this.receivingXdr.endDecoding();
        }
    }

    protected XdrDecodingStream getXdrDecodingStream() {
        return this.receivingXdr;
    }

    protected void endDecoding() throws OncRpcException, IOException {
        if (this.pendingDecoding) {
            this.pendingDecoding = false;
            this.receivingXdr.endDecoding();
        }
    }

    protected XdrEncodingStream getXdrEncodingStream() {
        return this.sendingXdr;
    }

    protected void beginEncoding(OncRpcCallInformation callInfo, OncRpcServerReplyMessage state) throws OncRpcException, IOException {
        if (this.pendingDecoding) {
            this.pendingDecoding = false;
            this.receivingXdr.endDecoding();
        }
        this.sendingXdr.beginEncoding(callInfo.peerAddress, callInfo.peerPort);
        state.xdrEncode(this.sendingXdr);
    }

    protected void endEncoding() throws OncRpcException, IOException {
        this.sendingXdr.endEncoding();
    }

    protected void reply(OncRpcCallInformation callInfo, OncRpcServerReplyMessage state, XdrAble reply) throws OncRpcException, IOException {
        this.beginEncoding(callInfo, state);
        if (reply != null) {
            reply.xdrEncode(this.sendingXdr);
        }
        this.endEncoding();
    }

    public void listen() {
        Thread listener = new Thread("UDP server transport listener thread"){

            public void run() {
                OncRpcUdpServerTransport.this._listen();
            }
        };
        listener.setDaemon(true);
        listener.start();
    }

    public void _listen() {
        OncRpcCallInformation callInfo = new OncRpcCallInformation(this);
        while (true) {
            try {
                this.pendingDecoding = true;
                this.receivingXdr.beginDecoding();
                callInfo.peerAddress = this.receivingXdr.getSenderAddress();
                callInfo.peerPort = this.receivingXdr.getSenderPort();
            }
            catch (IOException e) {
                this.close();
                return;
            }
            catch (OncRpcException e) {
                continue;
            }
            try {
                callInfo.callMessage.xdrDecode(this.receivingXdr);
            }
            catch (IOException e) {
                this.close();
                return;
            }
            catch (OncRpcException e) {
                if (!this.pendingDecoding) continue;
                this.pendingDecoding = false;
                try {
                    this.receivingXdr.endDecoding();
                    continue;
                }
                catch (IOException e2) {
                    this.close();
                    return;
                }
                catch (OncRpcException e2) {
                    continue;
                }
            }
            try {
                this.dispatcher.dispatchOncRpcCall(callInfo, callInfo.callMessage.program, callInfo.callMessage.version, callInfo.callMessage.procedure);
                continue;
            }
            catch (Exception e) {
                if (this.pendingDecoding) {
                    this.pendingDecoding = false;
                    try {
                        this.receivingXdr.endDecoding();
                    }
                    catch (IOException e2) {
                        this.close();
                        return;
                    }
                    catch (OncRpcException e2) {
                        // empty catch block
                    }
                }
                try {
                    if (e instanceof OncRpcAuthenticationException) {
                        callInfo.failAuthenticationFailed(((OncRpcAuthenticationException)e).getAuthStatus());
                        continue;
                    }
                    callInfo.failSystemError();
                    continue;
                }
                catch (IOException e2) {
                    this.close();
                    return;
                }
                catch (OncRpcException oncRpcException) {
                    continue;
                }
            }
            break;
        }
    }
}

