/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcPortmapClient;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;
import org.acplt.oncrpc.server.OncRpcCallInformation;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.acplt.oncrpc.server.OncRpcServerReplyMessage;
import org.acplt.oncrpc.server.OncRpcServerTransport;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;
import org.acplt.oncrpc.server.OncRpcTcpConnectionServerTransport;

public class OncRpcTcpServerTransport
extends OncRpcServerTransport {
    private ServerSocket socket;
    private int bufferSize;
    private TransportList openTransports = new TransportList();
    protected int transmissionTimeout = 30000;

    public OncRpcTcpServerTransport(OncRpcDispatchable dispatcher, int port, int program, int version, int bufferSize) throws OncRpcException, IOException {
        this(dispatcher, port, new OncRpcServerTransportRegistrationInfo[]{new OncRpcServerTransportRegistrationInfo(program, version)}, bufferSize);
    }

    public OncRpcTcpServerTransport(OncRpcDispatchable dispatcher, int port, OncRpcServerTransportRegistrationInfo[] info, int bufferSize) throws OncRpcException, IOException {
        super(dispatcher, port, info);
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        this.bufferSize = bufferSize;
        this.socket = new ServerSocket(port);
        if (port == 0) {
            this.port = this.socket.getLocalPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.socket = null;
            }
        }
        TransportList transportList = this.openTransports;
        synchronized (transportList) {
            while (this.openTransports.size() > 0) {
                OncRpcTcpConnectionServerTransport transport = (OncRpcTcpConnectionServerTransport)this.openTransports.removeFirst();
                transport.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTransport(OncRpcTcpConnectionServerTransport transport) {
        TransportList transportList = this.openTransports;
        synchronized (transportList) {
            this.openTransports.remove(transport);
        }
    }

    public void register() throws OncRpcException {
        try {
            OncRpcPortmapClient portmapper = new OncRpcPortmapClient(InetAddress.getByName("127.0.0.1"));
            int size = this.info.length;
            for (int idx = 0; idx < size; ++idx) {
                portmapper.setPort(this.info[idx].program, this.info[idx].version, 6, this.port);
            }
        }
        catch (IOException e) {
            throw new OncRpcException(16);
        }
    }

    public void retrieveCall(XdrAble call) throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.retrieveCall() is abstract and can not be called.");
    }

    protected XdrDecodingStream getXdrDecodingStream() {
        throw new Error("OncRpcTcpServerTransport.getXdrDecodingStream() is abstract and can not be called.");
    }

    protected void endDecoding() throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.endDecoding() is abstract and can not be called.");
    }

    protected XdrEncodingStream getXdrEncodingStream() {
        throw new Error("OncRpcTcpServerTransport.getXdrEncodingStream() is abstract and can not be called.");
    }

    protected void beginEncoding(OncRpcCallInformation callInfo, OncRpcServerReplyMessage state) throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.beginEncoding() is abstract and can not be called.");
    }

    protected void endEncoding() throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.endEncoding() is abstract and can not be called.");
    }

    protected void reply(OncRpcCallInformation callInfo, OncRpcServerReplyMessage state, XdrAble reply) throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.reply() is abstract and can not be called.");
    }

    public void listen() {
        Thread listenThread = new Thread("TCP server transport listener thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Socket newSocket = OncRpcTcpServerTransport.this.socket.accept();
                            OncRpcTcpConnectionServerTransport transport = new OncRpcTcpConnectionServerTransport(OncRpcTcpServerTransport.this.dispatcher, newSocket, OncRpcTcpServerTransport.this.info, OncRpcTcpServerTransport.this.bufferSize, OncRpcTcpServerTransport.this, OncRpcTcpServerTransport.this.transmissionTimeout);
                            TransportList transportList = OncRpcTcpServerTransport.this.openTransports;
                            synchronized (transportList) {
                                OncRpcTcpServerTransport.this.openTransports.add(transport);
                            }
                            transport.listen();
                        }
                    }
                    catch (OncRpcException e) {
                        continue;
                    }
                    catch (IOException e) {
                        if (OncRpcTcpServerTransport.this.socket == null) return;
                        continue;
                    }
                    break;
                }
            }
        };
        listenThread.setDaemon(true);
        listenThread.start();
    }

    public void setTransmissionTimeout(int milliseconds) {
        if (milliseconds <= 0) {
            throw new IllegalArgumentException("transmission timeout must be > 0");
        }
        this.transmissionTimeout = milliseconds;
    }

    public int getTransmissionTimeout() {
        return this.transmissionTimeout;
    }

    private class TransportList {
        private Node head = new Node(null);
        private int size = 0;

        public TransportList() {
            this.head.next = this.head;
            this.head.prev = this.head;
        }

        public void add(Object o) {
            Node node = new Node(o);
            node.next = this.head.next;
            this.head.next = node;
            node.prev = this.head;
            node.next.prev = node;
            ++this.size;
        }

        public void remove(Object o) {
            Node node = this.head.next;
            while (node != this.head) {
                if (node.item == o) {
                    node.prev.next = node.next;
                    node.next.prev = node.prev;
                    --this.size;
                    return;
                }
                node = node.next;
            }
        }

        public Object removeFirst() {
            if (this.head.next == this.head.prev) {
                return null;
            }
            Node node = this.head.next;
            this.head.next = node.next;
            node.next.prev = this.head;
            --this.size;
            return node.item;
        }

        public int size() {
            return this.size;
        }

        private class Node {
            Node next;
            Node prev;
            Object item;

            public Node(Object item) {
                this.item = item;
            }
        }
    }
}

