/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.jni;

import gov.aps.jca.CAException;
import gov.aps.jca.Channel;
import gov.aps.jca.Context;
import gov.aps.jca.JCALibrary;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.event.ContextExceptionListener;
import gov.aps.jca.event.ContextMessageListener;
import gov.aps.jca.event.DefaultContextExceptionListener;
import gov.aps.jca.event.DefaultContextMessageListener;
import gov.aps.jca.event.DirectEventDispatcher;
import gov.aps.jca.event.EventDispatcher;
import gov.aps.jca.event.GetListener;
import gov.aps.jca.event.MonitorListener;
import gov.aps.jca.event.PutListener;
import gov.aps.jca.jni.JNI;
import gov.aps.jca.jni.JNIAccessRightsCallback;
import gov.aps.jca.jni.JNIChannel;
import gov.aps.jca.jni.JNIConnectionCallback;
import gov.aps.jca.jni.JNIContextExceptionCallback;
import gov.aps.jca.jni.JNIContextMessageCallback;
import gov.aps.jca.jni.JNIException;
import gov.aps.jca.jni.JNIMonitor;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

public abstract class JNIContext
extends Context {
    protected boolean _initialized = false;
    protected boolean _preemptive_callback = true;
    protected String _addr_list = "";
    protected boolean _auto_addr_list = true;
    protected float _connection_timeout = 30.0f;
    protected float _beacon_period = 15.0f;
    protected int _repeater_port = 5065;
    protected int _server_port = 5064;
    protected int _max_array_bytes = 16384;
    protected EventDispatcher _eventDispatcher = new DirectEventDispatcher();
    protected Logger _logger = null;
    protected long _ctxtID = 0L;
    protected ArrayList _msgListenerList = new ArrayList();
    protected ArrayList _exceptionListenerList = new ArrayList();
    HashMap _channelMap = new HashMap();

    protected JNIContext() {
        JCALibrary jca = JCALibrary.getInstance();
        String dcn = Context.class.getName();
        this.setPreemptiveCallback(jca.getPropertyAsBoolean(dcn + ".preemptive_callback", this.getPreemptiveCallback()));
        this.setAddrList(jca.getProperty(dcn + ".addr_list", this.getAddrList()));
        this.setAutoAddrList(jca.getPropertyAsBoolean(dcn + ".auto_addr_list", this.getAutoAddrList()));
        this.setConnectionTimeout(jca.getPropertyAsFloat(dcn + ".connection_timeout", this.getConnectionTimeout()));
        this.setBeaconPeriod(jca.getPropertyAsFloat(dcn + ".beacon_period", this.getBeaconPeriod()));
        this.setRepeaterPort(jca.getPropertyAsInt(dcn + ".repeater_port", this.getRepeaterPort()));
        this.setServerPort(jca.getPropertyAsInt(dcn + ".server_port", this.getServerPort()));
        this.setMaxArrayBytes(jca.getPropertyAsInt(dcn + ".max_array_bytes", this.getMaxArrayBytes()));
        String ed = jca.getProperty(dcn + ".event_dispatcher", "");
        String cn = JNIContext.class.getName();
        this.setPreemptiveCallback(jca.getPropertyAsBoolean(cn + ".preemptive_callback", this.getPreemptiveCallback()));
        this.setAddrList(jca.getProperty(cn + ".addr_list", this.getAddrList()));
        this.setAutoAddrList(jca.getPropertyAsBoolean(cn + ".auto_addr_list", this.getAutoAddrList()));
        this.setConnectionTimeout(jca.getPropertyAsFloat(cn + ".connection_timeout", this.getConnectionTimeout()));
        this.setBeaconPeriod(jca.getPropertyAsFloat(cn + ".beacon_period", this.getBeaconPeriod()));
        this.setRepeaterPort(jca.getPropertyAsInt(cn + ".repeater_port", this.getRepeaterPort()));
        this.setServerPort(jca.getPropertyAsInt(cn + ".server_port", this.getServerPort()));
        this.setMaxArrayBytes(jca.getPropertyAsInt(cn + ".max_array_bytes", this.getMaxArrayBytes()));
        ed = jca.getProperty(cn + ".event_dispatcher", ed);
        try {
            this.setEventDispatcher((EventDispatcher)Class.forName(ed).newInstance());
        }
        catch (ClassNotFoundException ex1) {
        }
        catch (IllegalAccessException ex1) {
        }
        catch (InstantiationException ex1) {
            // empty catch block
        }
        String logger = jca.getProperty(cn + ".logger", null);
        this.setLogger(logger == null ? this.getLogger() : Logger.getLogger(logger));
    }

    public void initialize() throws CAException {
        this.assertState(!this.isInitialized(), "Context Already Initialized");
        try {
            JNI.init();
            this.setCtxtID(this.contextInitialize());
            this._initialized = true;
            this.addContextMessageListener(new DefaultContextMessageListener());
            this.addContextExceptionListener(new DefaultContextExceptionListener());
        }
        catch (Throwable th) {
            throw new CAException("Unable to initialize context", th);
        }
    }

    public final boolean isInitialized() throws IllegalStateException {
        return this._initialized;
    }

    protected void _initialize() throws IllegalStateException {
        if (this._initialized) {
            return;
        }
        try {
            this.initialize();
        }
        catch (Throwable th) {
            throw new IllegalStateException("Context not initialized", th);
        }
    }

    protected abstract long contextInitialize() throws CAException;

    public void printInfo(PrintStream out) {
        super.printInfo(out);
        out.println("PREEMPTIVE_CALLBACK : " + this.getPreemptiveCallback());
        out.println("ADDR_LIST : " + this.getAddrList());
        out.println("AUTO_ADDR_LIST : " + this.getAutoAddrList());
        out.println("CONNECTION_TIMEOUT : " + this.getConnectionTimeout());
        out.println("BEACON_PERIOD : " + this.getBeaconPeriod());
        out.println("REPEATER_PORT : " + this.getRepeaterPort());
        out.println("SERVER_PORT : " + this.getServerPort());
        out.println("MAX_ARRAY_BYTES : " + this.getMaxArrayBytes());
        out.println("EVENT_DISPATCHER: " + this.getEventDispatcher());
    }

    protected void setPreemptiveCallback(boolean enable) {
        this._preemptive_callback = enable;
    }

    public boolean getPreemptiveCallback() {
        return this._preemptive_callback;
    }

    protected void setAddrList(String list) {
        this._addr_list = list;
    }

    public String getAddrList() {
        return this._addr_list;
    }

    protected void setAutoAddrList(boolean auto) {
        this._auto_addr_list = auto;
    }

    public boolean getAutoAddrList() {
        return this._auto_addr_list;
    }

    protected void setConnectionTimeout(float timeout) {
        this._connection_timeout = timeout;
    }

    public float getConnectionTimeout() {
        return this._connection_timeout;
    }

    protected void setBeaconPeriod(float period) {
        this._beacon_period = period;
    }

    public float getBeaconPeriod() {
        return this._beacon_period;
    }

    protected void setRepeaterPort(int port) {
        this._repeater_port = port;
    }

    public int getRepeaterPort() {
        return this._repeater_port;
    }

    protected void setServerPort(int port) {
        this._server_port = port;
    }

    public int getServerPort() {
        return this._server_port;
    }

    protected void setMaxArrayBytes(int max) {
        this._max_array_bytes = max;
    }

    public int getMaxArrayBytes() {
        return this._max_array_bytes;
    }

    protected void setEventDispatcher(EventDispatcher eventDispatcher) {
        if (eventDispatcher == null) {
            throw new IllegalArgumentException("EventDispatcher cannot be null");
        }
        this._eventDispatcher = eventDispatcher;
    }

    public EventDispatcher getEventDispatcher() {
        return this._eventDispatcher;
    }

    protected void setLogger(Logger logger) {
        this._logger = logger;
    }

    public Logger getLogger() {
        return this._logger;
    }

    public void addContextMessageListener(ContextMessageListener l) throws CAException, IllegalStateException {
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        if (l != null) {
            this._msgListenerList.add(l);
        }
        if (this._msgListenerList.size() == 1) {
            this.setMessageCallback(new JNIContextMessageCallback(this, this._eventDispatcher, this._msgListenerList));
        }
    }

    public void removeContextMessageListener(ContextMessageListener l) throws CAException, IllegalStateException {
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        if (l != null) {
            this._msgListenerList.remove(l);
        }
        if (this._msgListenerList.size() == 0) {
            this.setMessageCallback(null);
        }
    }

    public ContextMessageListener[] getContextMessageListeners() {
        return this._msgListenerList.toArray(new ContextMessageListener[0]);
    }

    abstract void setMessageCallback(JNIContextMessageCallback var1) throws CAException;

    public void addContextExceptionListener(ContextExceptionListener l) throws CAException, IllegalStateException {
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        if (l != null) {
            this._exceptionListenerList.add(l);
        }
        if (this._exceptionListenerList.size() == 1) {
            this.setExceptionCallback(new JNIContextExceptionCallback(this, this._eventDispatcher, this._exceptionListenerList));
        }
    }

    public void removeContextExceptionListener(ContextExceptionListener l) throws CAException {
        this._initialize();
        this.assertState(this.isValid(), "Invalid context");
        if (l != null) {
            this._exceptionListenerList.remove(l);
        }
        if (this._exceptionListenerList.size() == 0) {
            this.setExceptionCallback(null);
        }
    }

    public ContextExceptionListener[] getContextExceptionListeners() {
        return this._exceptionListenerList.toArray(new ContextExceptionListener[0]);
    }

    abstract void setExceptionCallback(JNIContextExceptionCallback var1) throws CAException;

    void setCtxtID(long id) {
        this._ctxtID = id;
    }

    final long getCtxtID() {
        return this._ctxtID;
    }

    final boolean isValid() {
        return this._ctxtID != 0L;
    }

    protected final void assertState(boolean cond, String msg) {
        if (!cond) {
            throw new IllegalStateException(msg);
        }
    }

    public Channel[] getChannels() {
        WeakReference[] refs = this._channelMap.values().toArray(new WeakReference[0]);
        ArrayList<Channel> channels = new ArrayList<Channel>(refs.length);
        for (int t = 0; t < refs.length; ++t) {
            Channel ch = (Channel)refs[t].get();
            if (ch == null) continue;
            channels.add(ch);
        }
        return channels.toArray(new Channel[0]);
    }

    void registerChannel(JNIChannel ch) {
        if (ch == null) {
            return;
        }
        this._channelMap.put(new Long(ch.getChannelID()), new WeakReference<JNIChannel>(ch));
    }

    JNIChannel lookupChannel(long channelID) {
        WeakReference ref = (WeakReference)this._channelMap.get(new Long(channelID));
        if (ref == null) {
            return null;
        }
        return (JNIChannel)ref.get();
    }

    void unregisterChannel(JNIChannel ch) {
        if (ch == null) {
            return;
        }
        this._channelMap.remove(new Long(ch.getChannelID()));
    }

    public void destroy() throws CAException {
        WeakReference[] channelRefs = this._channelMap.values().toArray(new WeakReference[0]);
        for (int t = 0; t < channelRefs.length; ++t) {
            Channel ch = (Channel)channelRefs[t].get();
            if (ch == null) continue;
            try {
                ch.destroy();
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this._eventDispatcher != null) {
            this._eventDispatcher.dispose();
        }
    }

    abstract void ch_channelDestroy(JNIChannel var1) throws JNIException;

    abstract void ch_setConnectionCallback(JNIChannel var1, JNIConnectionCallback var2) throws JNIException;

    abstract void ch_setAccessRightsCallback(JNIChannel var1, JNIAccessRightsCallback var2) throws JNIException;

    abstract int ch_getFieldType(JNIChannel var1);

    abstract int ch_getElementCount(JNIChannel var1);

    abstract int ch_getState(JNIChannel var1);

    abstract String ch_getHostName(JNIChannel var1);

    abstract boolean ch_getReadAccess(JNIChannel var1);

    abstract boolean ch_getWriteAccess(JNIChannel var1);

    abstract void ch_arrayPut(DBRType var1, int var2, JNIChannel var3, Object var4) throws JNIException;

    abstract void ch_arrayPut(DBRType var1, int var2, JNIChannel var3, Object var4, PutListener var5) throws JNIException;

    abstract void ch_arrayGet(DBR var1, JNIChannel var2) throws JNIException;

    abstract void ch_arrayGet(DBRType var1, int var2, JNIChannel var3, GetListener var4) throws JNIException;

    abstract JNIMonitor ch_addMonitor(DBRType var1, int var2, JNIChannel var3, MonitorListener var4, int var5) throws JNIException;

    abstract void ch_clearMonitor(JNIMonitor var1) throws JNIException;
}

