/*
 * Decompiled with CFR 0.152.
 */
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSPlugin;
import TangoComponents.ITangoComponent;
import TangoComponents.ITangoErrorHistory;
import editor.undo.SetProperty;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.widget.command.VoidVoidCommandViewer;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.event.MouseInputListener;
import tangoatk.jddd.utils.TangoErrorHistory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOOCSTangoVoidVoidCommandViewer
extends VoidVoidCommandViewer
implements ITangoComponent,
DOOCSPlugin {
    private String doocsToolTipText = null;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private String doocsAddress = null;
    private String fullDoocsAddress = null;
    private CommandList list;
    private String valid_tango_address = null;
    private double refresh_rate = 1.0;
    private String buttonText = null;

    public DOOCSTangoVoidVoidCommandViewer() {
        this.setPreferredSize(new Dimension(100, 50));
        this.setSize(new Dimension(100, 50));
        this.list = new CommandList();
    }

    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        if (bRun) {
            // empty if block
        }
    }

    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    public void setFullDoocsAddress(String address) {
        try {
            if (address != null) {
                if (this.valid_tango_address != null) {
                    this.list.remove(this.valid_tango_address);
                }
                this.setModel((ICommand)this.list.add(address));
                this.valid_tango_address = address;
            }
        }
        catch (ConnectionException ex) {
            Logger.getLogger(DOOCSTangoVoidVoidCommandViewer.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.fullDoocsAddress = address;
    }

    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    public void setDoocsAddress(String address) {
        try {
            if (address != null) {
                if (this.valid_tango_address != null) {
                    this.list.remove(this.valid_tango_address);
                }
                this.setModel((ICommand)this.list.add(address));
                this.valid_tango_address = address;
            }
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    public ImageIcon getIcon() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("icons/VoidVoidCommandViewer.gif"));
    }

    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    public void setDnDText(String str) {
    }

    public String getDnDText() {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }

    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL, "A command name or device name/* for all commands"), new DOOCSParameter("label", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL, "The label text on the command button"), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE, "Tooltip")};
        return parameters;
    }

    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        return null;
    }

    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSTangoVoidVoidCommandViewer ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct((String)this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds((Rectangle)this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct((String)this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSTangoVoidVoidCommandViewer>\n");
        return xmlStructure;
    }

    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("label")) {
            this.setButtonText(value);
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds((String)value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize((String)value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSOval.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("label")) {
            return this.getButtonText();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds((Rectangle)this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize((Dimension)this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSOval.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    public void addTangoErrorListener(ITangoErrorHistory eh) {
        this.list.addErrorListener((IErrorListener)((TangoErrorHistory)eh).getErrorListener());
    }

    public void setButtonText(String b) {
        this.buttonText = b;
        if (this.buttonText != null && !this.buttonText.isEmpty()) {
            this.setExtendedParam("text", this.buttonText, false);
        }
    }

    public String getButtonText() {
        return this.buttonText;
    }
}

