/*
 * Decompiled with CFR 0.152.
 */
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSPlugin;
import TangoComponents.ITangoComponent;
import TangoComponents.ITangoErrorHistory;
import editor.undo.SetProperty;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.widget.attribute.NumberSpectrumItemTrend;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.event.MouseInputListener;
import tangoatk.jddd.addresses.TangoAdrList;
import tangoatk.jddd.utils.TangoErrorHistory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOOCSTangoNumberSpectrumItemTrend
extends NumberSpectrumItemTrend
implements ITangoComponent,
DOOCSPlugin {
    private String doocsToolTipText = null;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private String doocsAddress = null;
    private String fullDoocsAddress = null;
    private AttributeList list;
    private String valid_tango_address = null;
    private double refresh_rate = 1.0;
    private double display_duration = 30.0;
    private boolean plot_all = false;
    private TangoAdrList adrList;

    public DOOCSTangoNumberSpectrumItemTrend() {
        this.setPreferredSize(new Dimension(440, 200));
        this.setSize(new Dimension(400, 200));
        this.list = new AttributeList();
        this.adrList = new TangoAdrList("adrIndex", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL, "Spectrum index to be plotted", "0");
        this.adrList.add("Axis", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL, "The Axis to be used for the attribute", "Y1 Axis");
        this.adrList.add("Label", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL, "The name to be displayed in the trend legend", null);
        this.getY1Axis().setAutoScale(true);
        this.getY2Axis().setAutoScale(true);
        this.setPlotAll(this.plot_all);
        this.setDisplayDuration(this.display_duration * 1000.0);
    }

    public void setRunMode(boolean bRun) {
        if (!this.doocsRunMode) {
            this.doocsRunMode = bRun;
            if (bRun) {
                this.list.setRefreshInterval((int)(this.refresh_rate * 1000.0));
                this.list.startRefresher();
            }
        }
    }

    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    public void setFullDoocsAddress(String address) {
        if (address != null) {
            if (this.valid_tango_address != null) {
                this.list.remove(this.valid_tango_address);
            }
            this.plot_config(address);
        }
        this.fullDoocsAddress = address;
    }

    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    public void setDoocsAddress(String address) {
        if (address != null && !address.isEmpty()) {
            if (this.valid_tango_address != null) {
                this.list.remove(this.valid_tango_address);
            }
            this.plot_config(address);
        }
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    public ImageIcon getIcon() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("icons/NumberSpectrumItemTrend.gif"));
    }

    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    public void setDnDText(String str) {
    }

    public String getDnDText() {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }

    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters1 = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL, "The Tango spectrum attribute name"), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL, "Set the refresh rate for the widget in seconds"), new DOOCSParameter("displayTime", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL, "Set the display duration in seconds"), new DOOCSParameter("plotAll", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL, "Plot all spectrum elements when true"), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE, "Tooltip")};
        DOOCSParameter[] parameters2 = this.adrList.getDOOCSParameterList();
        DOOCSParameter[] parameters = new DOOCSParameter[parameters1.length + parameters2.length];
        System.arraycopy(parameters1, 0, parameters, 0, parameters1.length);
        System.arraycopy(parameters2, 0, parameters, parameters1.length, parameters2.length);
        return parameters;
    }

    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.startsWith("Axis")) {
            String[] allowedValues = new String[]{"Y1 Axis", "Y2 Axis"};
            return allowedValues;
        }
        String[] allowedValues = new String[]{"ill.ParameterName"};
        return allowedValues;
    }

    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSTangoNumberSpectrumItemTrend ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct((String)this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds((Rectangle)this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct((String)this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSTangoNumberSpectrumItemTrend>\n");
        return xmlStructure;
    }

    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.startsWith("adrIndex")) {
            this.setIndex(parameter, value);
        } else if (parameter.startsWith("Axis")) {
            this.setAxis(parameter, value);
        } else if (parameter.startsWith("Label")) {
            this.setLabel(parameter, value);
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setUpdateTime(Double.parseDouble(value));
        } else if (parameter.equalsIgnoreCase("displayTime")) {
            this.setDisplayTime(Double.parseDouble(value));
        } else if (parameter.equalsIgnoreCase("plotAll")) {
            this.setPlAll(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds((String)value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize((String)value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSOval.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.startsWith("adrIndex")) {
            return this.getIndex(parameter);
        }
        if (parameter.startsWith("Axis")) {
            return this.getAxis(parameter);
        }
        if (parameter.startsWith("Label")) {
            return this.getLabel(parameter);
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return this.getUpdateTime();
        }
        if (parameter.equalsIgnoreCase("displayTime")) {
            return this.getDisplayTime();
        }
        if (parameter.equalsIgnoreCase("plotAll")) {
            return this.getPlAll();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds((Rectangle)this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize((Dimension)this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSOval.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    public void addTangoErrorListener(ITangoErrorHistory eh) {
        this.list.addErrorListener((IErrorListener)((TangoErrorHistory)eh).getErrorListener());
    }

    public void setIndex(String parameter, String index) {
        this.adrList.setAddress(parameter, index);
        this.plot_config(this.valid_tango_address);
    }

    public String getIndex(String parameter) {
        return this.adrList.getAddress(parameter);
    }

    public void setAxis(String parameter, String axe) {
        this.adrList.setParameter(parameter, axe);
        this.plot_config(this.valid_tango_address);
    }

    public String getAxis(String parameter) {
        return this.adrList.getParameter(parameter);
    }

    public void setLabel(String parameter, String label) {
        this.adrList.setParameter(parameter, label);
        this.plot_config(this.valid_tango_address);
    }

    public String getLabel(String parameter) {
        return this.adrList.getParameter(parameter);
    }

    public void setUpdateTime(double up) {
        this.refresh_rate = up;
    }

    public double getUpdateTime() {
        return this.refresh_rate;
    }

    public void setDisplayTime(double disp) {
        this.display_duration = disp;
        this.setDisplayDuration(this.display_duration * 1000.0);
    }

    public double getDisplayTime() {
        return this.display_duration;
    }

    public void setPlAll(boolean all) {
        this.plot_all = all;
        this.setPlotAll(this.plot_all);
        if (!this.plot_all) {
            this.plot_config(this.valid_tango_address);
        }
    }

    public boolean getPlAll() {
        return this.plot_all;
    }

    public void plot_config(String address) {
        List<String> axisList = this.adrList.getAdrRelation("Axis");
        List<String> labelList = this.adrList.getAdrRelation("Label");
        if (address == null || address.isEmpty()) {
            return;
        }
        try {
            this.setModel((INumberSpectrum)this.list.add(address));
            this.valid_tango_address = address;
            for (int i = 0; i < axisList.size(); i += 2) {
                String index = axisList.get(i);
                String axis = axisList.get(i + 1);
                String label = labelList.get(i + 1);
                int axis_nu = 1;
                if (axis.equalsIgnoreCase("Y2 Axis")) {
                    axis_nu = 2;
                }
                if (label == null) {
                    label = "[" + index + "]";
                }
                this.plotItem(Integer.parseInt(index), axis_nu, label);
            }
        }
        catch (ConnectionException ex) {
            Logger.getLogger(DOOCSTangoScalarListViewer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

