/*
 * Decompiled with CFR 0.152.
 */
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSPlugin;
import TangoComponents.ITangoComponent;
import TangoComponents.ITangoErrorHistory;
import editor.undo.SetProperty;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarCheckBoxViewer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.event.MouseInputListener;
import tangoatk.jddd.utils.TangoErrorHistory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOOCSTangoBooleanScalarCheckBoxViewer
extends BooleanScalarCheckBoxViewer
implements ITangoComponent,
DOOCSPlugin {
    private String doocsToolTipText = null;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private String doocsAddress = null;
    private String fullDoocsAddress = null;
    private AttributeList list;
    private String valid_tango_address = null;
    private double refresh_rate = 1.0;
    private Color back_color;
    private String trueLabel = null;
    private String falseLabel = null;

    public DOOCSTangoBooleanScalarCheckBoxViewer() {
        this.setPreferredSize(new Dimension(100, 50));
        this.setSize(new Dimension(100, 50));
        this.list = new AttributeList();
        this.setQualityEnabled(true);
        this.back_color = this.getBackground();
    }

    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        if (bRun) {
            this.list.setRefreshInterval((int)(this.refresh_rate * 1000.0));
            this.list.startRefresher();
        } else {
            this.list.stopRefresher();
        }
    }

    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    public void setFullDoocsAddress(String address) {
        try {
            if (address != null) {
                if (this.valid_tango_address != null) {
                    this.list.remove(this.valid_tango_address);
                }
                IAttribute attribute = (IAttribute)this.list.add(address);
                this.setAttModel((IBooleanScalar)attribute);
                this.valid_tango_address = address;
            }
        }
        catch (ConnectionException ex) {
            Logger.getLogger(DOOCSTangoBooleanScalarCheckBoxViewer.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.fullDoocsAddress = address;
    }

    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    public ImageIcon getIcon() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("icons/BooleanScalarCheckBoxViewer.gif"));
    }

    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    public void setDnDText(String str) {
    }

    public String getDnDText() {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    public void setDoocsAddress(String address) {
        try {
            if (address != null) {
                if (this.valid_tango_address != null) {
                    this.list.remove(this.valid_tango_address);
                }
                IAttribute attribute = (IAttribute)this.list.add(address);
                this.setAttModel((IBooleanScalar)attribute);
                this.list.refresh();
                this.valid_tango_address = address;
            }
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }

    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL, "The full Tango attribute name"), new DOOCSParameter("trueLabel", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL, "The label text when true"), new DOOCSParameter("falseLabel", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL, "The label text when false"), new DOOCSParameter("qualityEnabled", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL, "Enable the attribute quality as background color"), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL, "Set the refresh rate for the widget in seconds"), new DOOCSParameter("background", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL, "Set the background color"), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE, "Tooltip")};
        return parameters;
    }

    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        return null;
    }

    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSTangoBooleanScalarCheckBoxViewer ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct((String)this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds((Rectangle)this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct((String)this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSTangoBooleanScalarCheckBoxViewer>\n");
        return xmlStructure;
    }

    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("trueLabel")) {
            this.setTrueLabel(value);
        } else if (parameter.equalsIgnoreCase("falseLabel")) {
            this.setFalseLabel(value);
        } else if (parameter.equalsIgnoreCase("qualityEnabled")) {
            this.setQualityEnabled(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setUpdateTime(Double.parseDouble(value));
        } else if (parameter.equalsIgnoreCase("background")) {
            this.setBackground(DOOCSParameter.convertToColor((String)value));
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds((String)value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize((String)value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSOval.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("trueLabel")) {
            return this.getTrueLabel();
        }
        if (parameter.equalsIgnoreCase("falseLabel")) {
            return this.getFalseLabel();
        }
        if (parameter.equalsIgnoreCase("qualityEnabled")) {
            return this.getQualityEnabled();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return this.getUpdateTime();
        }
        if (parameter.equalsIgnoreCase("background")) {
            return DOOCSParameter.getDoocsColor((Color)this.getBackground());
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds((Rectangle)this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize((Dimension)this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSOval.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    public void addTangoErrorListener(ITangoErrorHistory eh) {
        this.list.addErrorListener((IErrorListener)((TangoErrorHistory)eh).getErrorListener());
    }

    public void setTrueLabel(String l) {
        this.trueLabel = l;
        if (this.trueLabel != null && !this.trueLabel.isEmpty()) {
            super.setTrueLabel(this.trueLabel);
        }
    }

    public String getTrueLabel() {
        return this.trueLabel;
    }

    public void setFalseLabel(String l) {
        this.falseLabel = l;
        if (this.falseLabel != null && !this.falseLabel.isEmpty()) {
            super.setFalseLabel(this.falseLabel);
        }
    }

    public String getFalseLabel() {
        return this.falseLabel;
    }

    public void setUpdateTime(double up) {
        this.refresh_rate = up;
    }

    public double getUpdateTime() {
        return this.refresh_rate;
    }
}

