/*
 * Decompiled with CFR 0.152.
 */
package editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class SplashScreen
extends JWindow {
    private JProgressBar progressBar = null;
    private int maxValue = 0;
    final Runnable closerRunner = new Runnable(){

        @Override
        public void run() {
            SplashScreen.this.setVisible(false);
            SplashScreen.this.dispose();
        }
    };

    public SplashScreen(Frame f, int intProgressMaxValue) {
        super(f);
        this.maxValue = intProgressMaxValue;
        this.progressBar = new JProgressBar(0, intProgressMaxValue);
        this.progressBar.setStringPainted(true);
        this.progressBar.setBackground(new Color(8, 2, 121));
        this.progressBar.setForeground(new Color(104, 139, 194));
        this.progressBar.setBorderPainted(false);
        this.getContentPane().add((Component)this.progressBar, "South");
        ImageIcon icon = new ImageIcon(this.getClass().getResource("icons/splash_jddd.png"));
        JLabel image = new JLabel(icon);
        this.getContentPane().add((Component)image, "Center");
        this.pack();
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        Rectangle r = device.getDefaultConfiguration().getBounds();
        int screenWidth = r.width;
        int screenHeight = r.height;
        Dimension labelSize = image.getPreferredSize();
        this.setLocation(screenWidth / 2 - labelSize.width / 2, screenHeight / 2 - labelSize.height / 2);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SplashScreen.this.setVisible(false);
                SplashScreen.this.dispose();
            }
        });
        this.setVisible(true);
    }

    public void setProgressValue(int value, String text) {
        this.progressBar.setValue(value);
        this.progressBar.setString(text);
        if (value >= this.maxValue) {
            try {
                SwingUtilities.invokeAndWait(this.closerRunner);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

