/*
 * Decompiled with CFR 0.152.
 */
package editor;

import DOOCSComponents.DOOCSParameter;
import TangoComponents.TangoOptions;
import editor.EditorPanel;
import editor.ExampleFileFilter;
import editor.IAddrEditor;
import editor.ImagePreviewPanel;
import editor.StartParameters;
import editor.dialogs.BoundsEditor;
import editor.dialogs.ChooseComponentEditor;
import editor.dialogs.DoocsAddrEditor;
import editor.dialogs.GridSizeEditor;
import editor.dialogs.JFontChooser;
import editor.dialogs.PointsEditor;
import editor.dialogs.SizeEditor;
import editor.dialogs.TextEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URLClassLoader;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellEditor;
import jsvnbrowser.JSVNBrowser;
import jsvnbrowser.JSVNFileInfo;

public class PropsTableCellEditor2
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    JButton colorChooserButton = new JButton();
    JButton fontChooserButton;
    JButton textEditorButton;
    JButton boundsEditorButton;
    JButton pointsEditorButton;
    JButton gridEditorButton;
    JButton sizeEditorButton;
    JButton doocsAddrEditorButton;
    JButton componentEditorButton;
    JButton fileChooserButton;
    JColorChooser colorChooser;
    JFileChooser fileChooser;
    private FileFilter defaultFilter;
    JFontChooser fontChooser;
    TextEditor textEditor;
    BoundsEditor boundsEditor;
    PointsEditor pointsEditor;
    GridSizeEditor gridEditor;
    SizeEditor sizeEditor;
    IAddrEditor doocsAddrEditor;
    ChooseComponentEditor componentEditor;
    JDialog dialog;
    String type;
    String propertyName;
    String editorValue;
    Color currentColor;
    Font currentFont;
    String currentText;
    String currentAddr;
    String currentComponent;
    protected static final String EDIT = "edit";
    boolean panelFromSVN = false;
    EditorPanel epanel;

    public PropsTableCellEditor2() {
        this.colorChooserButton.setActionCommand(EDIT);
        this.colorChooserButton.addActionListener(this);
        this.colorChooser = new JColorChooser();
        this.dialog = JColorChooser.createDialog(this.colorChooserButton, "Color Chooser", true, this.colorChooser, this, null);
        this.fontChooserButton = new JButton();
        this.fontChooserButton.setActionCommand(EDIT);
        this.fontChooserButton.addActionListener(this);
        this.fontChooser = new JFontChooser();
        this.fileChooserButton = new JButton();
        this.fileChooserButton.setActionCommand(EDIT);
        this.fileChooserButton.addActionListener(this);
        this.fileChooser = new JFileChooser();
        this.defaultFilter = this.fileChooser.getFileFilter();
        ImagePreviewPanel preview = new ImagePreviewPanel();
        this.fileChooser.setAccessory(preview);
        this.fileChooser.addPropertyChangeListener(preview);
        this.textEditorButton = new JButton();
        this.textEditorButton.setActionCommand(EDIT);
        this.textEditorButton.addActionListener(this);
        this.textEditor = new TextEditor();
        this.textEditor.jButtonCancel.addActionListener(this);
        this.textEditor.jButtonOK.addActionListener(this);
        this.textEditor.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PropsTableCellEditor2.this.fireEditingStopped();
            }
        });
        this.boundsEditorButton = new JButton();
        this.boundsEditorButton.setActionCommand(EDIT);
        this.boundsEditorButton.addActionListener(this);
        this.boundsEditor = new BoundsEditor();
        this.boundsEditor.jButtonCancel.addActionListener(this);
        this.boundsEditor.jButtonOK.addActionListener(this);
        this.boundsEditor.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PropsTableCellEditor2.this.fireEditingStopped();
            }
        });
        this.pointsEditorButton = new JButton();
        this.pointsEditorButton.setActionCommand(EDIT);
        this.pointsEditorButton.addActionListener(this);
        this.pointsEditor = new PointsEditor();
        this.pointsEditor.jButtonCancel.addActionListener(this);
        this.pointsEditor.jButtonOK.addActionListener(this);
        this.pointsEditor.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PropsTableCellEditor2.this.fireEditingStopped();
            }
        });
        this.gridEditorButton = new JButton();
        this.gridEditorButton.setActionCommand(EDIT);
        this.gridEditorButton.addActionListener(this);
        this.gridEditor = new GridSizeEditor();
        this.gridEditor.jButtonCancel.addActionListener(this);
        this.gridEditor.jButtonOK.addActionListener(this);
        this.gridEditor.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PropsTableCellEditor2.this.fireEditingStopped();
            }
        });
        this.sizeEditorButton = new JButton();
        this.sizeEditorButton.setActionCommand(EDIT);
        this.sizeEditorButton.addActionListener(this);
        this.sizeEditor = new SizeEditor();
        this.sizeEditor.jButtonCancel.addActionListener(this);
        this.sizeEditor.jButtonOK.addActionListener(this);
        this.sizeEditor.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PropsTableCellEditor2.this.fireEditingStopped();
            }
        });
        this.doocsAddrEditorButton = new JButton();
        this.doocsAddrEditorButton.setActionCommand(EDIT);
        this.doocsAddrEditorButton.addActionListener(this);
        if (TangoOptions.TANGO_ONLY) {
            String pluginPath = StartParameters.getInstance().getPluginPath();
            if (pluginPath != null && pluginPath.length() > 0) {
                URLClassLoader newCL = StartParameters.getInstance().getClassLoader();
                try {
                    this.doocsAddrEditor = (IAddrEditor)newCL.loadClass("tangoatk.jddd.utils.TangoAddrEditor").newInstance();
                }
                catch (ClassNotFoundException ex) {
                    String msg = "tangoatk.jddd.utils.TangoAddrEditor class not found!";
                    Logger.getLogger(PropsTableCellEditor2.class.getName()).log(Level.SEVERE, msg, ex);
                    this.doocsAddrEditor = new DoocsAddrEditor();
                }
                catch (InstantiationException ex) {
                    String msg = "tangoatk.jddd.utils.TangoAddrEditor cannot instantiate object!";
                    Logger.getLogger(PropsTableCellEditor2.class.getName()).log(Level.SEVERE, msg, ex);
                    this.doocsAddrEditor = new DoocsAddrEditor();
                }
                catch (IllegalAccessException ex) {
                    String msg = "Illegal resource access in the tangoatk.jddd.utils.TangoAddrEditor class!";
                    Logger.getLogger(PropsTableCellEditor2.class.getName()).log(Level.SEVERE, msg, ex);
                    this.doocsAddrEditor = new DoocsAddrEditor();
                }
            }
            if (this.doocsAddrEditor == null) {
                this.doocsAddrEditor = new DoocsAddrEditor();
            }
        } else {
            this.doocsAddrEditor = new DoocsAddrEditor();
        }
        this.doocsAddrEditor.addActionListener(this);
        this.doocsAddrEditor.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PropsTableCellEditor2.this.fireEditingStopped();
            }
        });
        this.doocsAddrEditor.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    PropsTableCellEditor2.this.doocsAddrEditor.setVisible(false);
                    PropsTableCellEditor2.this.currentAddr = PropsTableCellEditor2.this.doocsAddrEditor.getTextFieldAddr();
                    PropsTableCellEditor2.this.fireEditingStopped();
                }
            }
        });
        this.componentEditorButton = new JButton();
        this.componentEditorButton.setActionCommand(EDIT);
        this.componentEditorButton.addActionListener(this);
        this.componentEditor = new ChooseComponentEditor();
        this.componentEditor.jButtonCancel.addActionListener(this);
        this.componentEditor.jButtonOK.addActionListener(this);
        this.componentEditor.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PropsTableCellEditor2.this.fireEditingStopped();
            }
        });
        this.componentEditor.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    PropsTableCellEditor2.this.componentEditor.setVisible(false);
                    PropsTableCellEditor2.this.currentComponent = PropsTableCellEditor2.this.componentEditor.getComponent();
                    PropsTableCellEditor2.this.fireEditingStopped();
                }
            }
        });
        this.type = null;
        this.propertyName = null;
        this.editorValue = null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.propertyName = ((Vector)table.getValueAt(row, 0)).get(0).toString();
        this.type = table.getModel().getValueAt(row, 2).toString();
        this.editorValue = table.getModel().getValueAt(row, 4) != null ? table.getModel().getValueAt(row, 4).toString() : null;
        if (this.type.equalsIgnoreCase("COLOR")) {
            this.currentColor = DOOCSParameter.convertToColor(this.editorValue);
            return this.colorChooserButton;
        }
        if (this.type.equals("STRING")) {
            this.currentText = this.editorValue;
            return this.textEditorButton;
        }
        if (this.type.equals("BOUNDS")) {
            this.currentText = this.editorValue;
            return this.boundsEditorButton;
        }
        if (this.type.equals("POINTS")) {
            this.currentText = this.editorValue;
            return this.pointsEditorButton;
        }
        if (this.type.equals("GRID")) {
            this.currentText = this.editorValue;
            return this.gridEditorButton;
        }
        if (this.type.equals("SIZE")) {
            this.currentText = this.editorValue;
            return this.sizeEditorButton;
        }
        if (this.type.equals("DOOCSADDRESS")) {
            this.currentAddr = this.editorValue;
            return this.doocsAddrEditorButton;
        }
        if (this.type.equals("COMPONENT")) {
            this.currentComponent = this.editorValue;
            return this.componentEditorButton;
        }
        if (this.type.equals("FILE") || this.type.equals("XMLFILE") || this.type.equals("ICONFILE") || this.type.equals("AUDIOFILE")) {
            this.currentText = this.editorValue;
            return this.fileChooserButton;
        }
        if (this.type.equals("FONT")) {
            this.currentFont = DOOCSParameter.convertToFont(this.editorValue);
            return this.fontChooserButton;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.type.equalsIgnoreCase("COLOR")) {
            return DOOCSParameter.getDoocsColor(this.currentColor);
        }
        if (this.type.equalsIgnoreCase("STRING")) {
            return this.currentText;
        }
        if (this.type.equalsIgnoreCase("BOUNDS")) {
            return this.currentText;
        }
        if (this.type.equalsIgnoreCase("POINTS")) {
            return this.currentText;
        }
        if (this.type.equalsIgnoreCase("GRID")) {
            return this.currentText;
        }
        if (this.type.equalsIgnoreCase("SIZE")) {
            return this.currentText;
        }
        if (this.type.equalsIgnoreCase("FILE")) {
            return this.currentText;
        }
        if (this.type.equalsIgnoreCase("XMLFILE")) {
            return this.currentText;
        }
        if (this.type.equalsIgnoreCase("ICONFILE")) {
            return this.currentText;
        }
        if (this.type.equalsIgnoreCase("AUDIOFILE")) {
            return this.currentText;
        }
        if (this.type.equalsIgnoreCase("DOOCSADDRESS")) {
            return this.currentAddr;
        }
        if (this.type.equalsIgnoreCase("COMPONENT")) {
            return this.currentComponent;
        }
        if (this.type.equalsIgnoreCase("FONT")) {
            return DOOCSParameter.getDoocsFont(this.currentFont);
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (EDIT.equals(e.getActionCommand())) {
            int result;
            int result2;
            if (this.type.equalsIgnoreCase("COLOR")) {
                this.colorChooserButton.setBackground(this.currentColor);
                this.colorChooser.setColor(this.currentColor);
                this.dialog.setVisible(true);
                this.fireEditingStopped();
            }
            if (this.type.equalsIgnoreCase("STRING")) {
                this.textEditor.setText(this.currentText);
                this.textEditor.setTitle(this.propertyName);
                this.textEditor.setVisible(true);
            }
            if (this.type.equalsIgnoreCase("BOUNDS")) {
                this.boundsEditor.setText(this.currentText);
                this.boundsEditor.setTitle(this.propertyName);
                this.boundsEditor.setVisible(true);
            }
            if (this.type.equalsIgnoreCase("POINTS")) {
                this.pointsEditor.setText(this.currentText);
                this.pointsEditor.setTitle(this.propertyName);
                this.pointsEditor.setVisible(true);
            }
            if (this.type.equalsIgnoreCase("GRID")) {
                this.gridEditor.setText(this.currentText);
                this.gridEditor.setTitle(this.propertyName);
                this.gridEditor.setVisible(true);
            }
            if (this.type.equalsIgnoreCase("SIZE")) {
                if (this.currentText != null) {
                    this.sizeEditor.setText(this.currentText);
                }
                this.sizeEditor.setTitle(this.propertyName);
                this.sizeEditor.setVisible(true);
            }
            if (this.type.equalsIgnoreCase("DOOCSADDRESS")) {
                this.doocsAddrEditor.setAddr(this.editorValue);
                this.doocsAddrEditor.setVisible(true);
            }
            if (this.type.equalsIgnoreCase("COMPONENT")) {
                this.componentEditor.tree.changeModel(this.epanel);
                this.componentEditor.setVisible(true);
            }
            if (this.type.equalsIgnoreCase("FONT")) {
                this.fontChooser.setSelectedFont(this.currentFont);
                result2 = this.fontChooser.showDialog(null);
                if (result2 == 0) {
                    this.currentFont = this.fontChooser.getSelectedFont();
                }
                this.fireEditingStopped();
            }
            if (this.type.equalsIgnoreCase("FILE") && !this.panelFromSVN) {
                this.fileChooser.setFileFilter(this.defaultFilter);
                result2 = this.fileChooser.showOpenDialog(null);
                if (this.fileChooser.getSelectedFile() != null && result2 == 0) {
                    this.currentText = this.fileChooser.getSelectedFile().getPath();
                }
                this.fireEditingStopped();
            }
            if (this.type.equalsIgnoreCase("XMLFILE") && !this.panelFromSVN) {
                ExampleFileFilter filter = new ExampleFileFilter();
                filter.addExtension("xml");
                filter.setDescription("XML files");
                this.fileChooser.setFileFilter(filter);
                result = this.fileChooser.showOpenDialog(null);
                if (this.fileChooser.getSelectedFile() != null && result == 0) {
                    this.currentText = this.fileChooser.getSelectedFile().getPath();
                }
                this.fireEditingStopped();
            }
            if (this.type.equalsIgnoreCase("ICONFILE") && !this.panelFromSVN) {
                ExampleFileFilter filter = new ExampleFileFilter();
                filter.addExtension("gif");
                filter.addExtension("png");
                filter.addExtension("jpg");
                filter.addExtension("jpeg");
                filter.addExtension("bmp");
                filter.setDescription("icon files");
                this.fileChooser.setFileFilter(filter);
                result = this.fileChooser.showOpenDialog(null);
                if (this.fileChooser.getSelectedFile() != null && result == 0) {
                    this.currentText = this.fileChooser.getSelectedFile().getPath();
                }
                this.fireEditingStopped();
            }
            if (this.type.equalsIgnoreCase("AUDIOFILE") && !this.panelFromSVN) {
                ExampleFileFilter filter = new ExampleFileFilter();
                filter.addExtension("wav");
                filter.setDescription("audio files");
                this.fileChooser.setFileFilter(filter);
                result = this.fileChooser.showOpenDialog(null);
                if (this.fileChooser.getSelectedFile() != null && result == 0) {
                    this.currentText = this.fileChooser.getSelectedFile().getPath();
                }
                this.fireEditingStopped();
            }
            if ((this.type.equalsIgnoreCase("FILE") || this.type.equalsIgnoreCase("XMLFILE") || this.type.equalsIgnoreCase("ICONFILE") || this.type.equalsIgnoreCase("AUDIOFILE")) && this.panelFromSVN) {
                JSVNFileInfo fInfo;
                String svnDir = StartParameters.getInstance().getSvnDirectory();
                JSVNBrowser browser = new JSVNBrowser();
                if (svnDir != null) {
                    browser.setCurrentDirectory(svnDir);
                }
                this.currentText = (fInfo = browser.showOpenDialog(null)) != null ? (this.type.equalsIgnoreCase("FILE") || this.type.equalsIgnoreCase("XMLFILE") && fInfo.filename.endsWith(".xml") || this.type.equalsIgnoreCase("ICONFILE") && (fInfo.filename.endsWith(".gif") || fInfo.filename.endsWith(".png") || fInfo.filename.endsWith(".jpeg") || fInfo.filename.endsWith(".jpg") || fInfo.filename.endsWith(".bmp")) || this.type.equalsIgnoreCase("AUDIOFILE") && fInfo.filename.endsWith(".wav") ? fInfo.filename : null) : null;
                this.fireEditingStopped();
            }
        } else {
            if (this.type.equalsIgnoreCase("STRING")) {
                this.textEditor.setVisible(false);
                if (e.getActionCommand().equalsIgnoreCase("OK")) {
                    this.currentText = this.textEditor.getText();
                }
                this.fireEditingStopped();
            }
            if (this.type.equalsIgnoreCase("BOUNDS")) {
                this.boundsEditor.setVisible(false);
                if (e.getActionCommand().equalsIgnoreCase("OK")) {
                    this.currentText = this.boundsEditor.getText();
                }
                this.fireEditingStopped();
            }
            if (this.type.equalsIgnoreCase("POINTS")) {
                this.pointsEditor.setVisible(false);
                if (e.getActionCommand().equalsIgnoreCase("OK")) {
                    this.currentText = this.pointsEditor.getText();
                }
                this.fireEditingStopped();
            }
            if (this.type.equalsIgnoreCase("GRID")) {
                this.gridEditor.setVisible(false);
                if (e.getActionCommand().equalsIgnoreCase("OK")) {
                    this.currentText = this.gridEditor.getText();
                }
                this.fireEditingStopped();
            }
            if (this.type.equalsIgnoreCase("SIZE")) {
                this.sizeEditor.setVisible(false);
                if (e.getActionCommand().equalsIgnoreCase("OK")) {
                    this.currentText = this.sizeEditor.getText();
                }
                this.fireEditingStopped();
            }
            if (this.type.equalsIgnoreCase("DOOCSADDRESS")) {
                this.doocsAddrEditor.setVisible(false);
                if (e.getActionCommand().equalsIgnoreCase("OK")) {
                    this.currentAddr = this.doocsAddrEditor.getTextFieldAddr();
                }
                this.fireEditingStopped();
            }
            if (this.type.equalsIgnoreCase("COMPONENT")) {
                this.componentEditor.setVisible(false);
                if (e.getActionCommand().equalsIgnoreCase("OK")) {
                    this.currentComponent = this.componentEditor.getComponent();
                }
                this.fireEditingStopped();
            }
            if (this.type.equalsIgnoreCase("COLOR")) {
                this.currentColor = this.colorChooser.getColor();
            }
        }
    }
}

