/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot.utils;

import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.utils.PlotDataTable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.table.AbstractTableModel;

public class PlotDataTableModel
extends AbstractTableModel {
    public String[] columnNames = new String[]{"Name", "Show", "Style", "Color", "Stroke", "Mark", "EGU", "Math Result"};
    protected Vector<DOOCSChannel> m_Components = new Vector();
    protected JLabel[] styleLabels = null;
    public JComponent styleComboBox;
    public int[] selectedStyle;
    protected JLabel[] markLabels = null;
    public JComponent markComboBox;
    public int[] selectedMark;
    private PlotDataTable table;

    public PlotDataTableModel(PlotDataTable tab) {
        this.table = tab;
    }

    public void setRow(int idx, DOOCSChannel chan) {
        int i;
        int n;
        int l = this.m_Components.size();
        if (idx + 1 > l) {
            this.m_Components.add(idx, chan);
        } else {
            this.m_Components.setElementAt(chan, idx);
        }
        if (this.styleLabels == null) {
            DOOCSChannel dOOCSChannel = this.m_Components.get(0);
            DOOCSChannel.LineStyle[] lines = dOOCSChannel.lineStyle.values();
            n = lines.length;
            this.styleLabels = new JLabel[n];
            this.selectedStyle = new int[n];
            for (i = 0; i < n; ++i) {
                this.styleLabels[i] = this.createIconLabel(lines[i].toString());
            }
            this.styleComboBox = new JComboBox<JLabel>(this.styleLabels);
            ((JComboBox)this.styleComboBox).setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    if (index >= 0) {
                        return PlotDataTableModel.this.styleLabels[index];
                    }
                    return PlotDataTableModel.this.styleLabels[0];
                }
            });
            ((JComboBox)this.styleComboBox).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlotDataTableModel.this.table.getCellEditor().stopCellEditing();
                }
            });
        }
        if (this.markLabels == null) {
            DOOCSChannel dOOCSChannel = this.m_Components.get(0);
            DOOCSChannel.Marks[] marks = dOOCSChannel.marks.values();
            n = marks.length;
            this.markLabels = new JLabel[n];
            for (i = 0; i < n; ++i) {
                this.markLabels[i] = this.createIconLabel(marks[i].toString());
            }
            this.markComboBox = new JComboBox<JLabel>(this.markLabels);
            ((JComboBox)this.markComboBox).setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    if (index >= 0) {
                        return PlotDataTableModel.this.markLabels[index];
                    }
                    return PlotDataTableModel.this.markLabels[0];
                }
            });
            ((JComboBox)this.markComboBox).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlotDataTableModel.this.table.getCellEditor().stopCellEditing();
                }
            });
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.m_Components.size();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < this.m_Components.size()) {
            switch (col) {
                case 0: {
                    return this.m_Components.get((int)row).doocsAdr;
                }
                case 1: {
                    return this.m_Components.get((int)row).isVisible;
                }
                case 2: {
                    return this.m_Components.get((int)row).lineStyle;
                }
                case 3: {
                    return this.m_Components.get((int)row).lineColor;
                }
                case 4: {
                    return Float.valueOf(this.m_Components.get((int)row).strokeSize.getLineWidth());
                }
                case 5: {
                    return this.m_Components.get((int)row).marks;
                }
                case 6: {
                    return this.m_Components.get((int)row).chanErrorMsg;
                }
                case 7: {
                    return this.m_Components.get((int)row).chanErrorMsg;
                }
            }
            return null;
        }
        return null;
    }

    public Object getComponentAt(int row, int col) {
        if (row < this.m_Components.size()) {
            switch (col) {
                case 0: {
                    return this.m_Components.get((int)row).doocsAdr;
                }
                case 1: {
                    return this.m_Components.get((int)row).isVisible;
                }
                case 2: {
                    int i = this.m_Components.get((int)row).lineStyle.ordinal();
                    return this.styleLabels[i];
                }
                case 3: {
                    return this.m_Components.get((int)row).lineColor;
                }
                case 4: {
                    return Float.valueOf(this.m_Components.get((int)row).strokeSize.getLineWidth());
                }
                case 5: {
                    int i = this.m_Components.get((int)row).marks.ordinal();
                    return this.markLabels[i];
                }
                case 6: {
                    return this.m_Components.get((int)row).chanErrorMsg;
                }
                case 7: {
                    return this.m_Components.get((int)row).chanErrorMsg;
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (value != null) {
            switch (col) {
                case 1: {
                    String valTxt = value.toString();
                    if (valTxt.equalsIgnoreCase("true")) {
                        this.m_Components.get((int)row).isVisible = true;
                        break;
                    }
                    this.m_Components.get((int)row).isVisible = false;
                    break;
                }
                case 2: {
                    String valTxt = ((JLabel)value).getText();
                    DOOCSChannel.LineStyle cfr_ignored_0 = this.m_Components.get((int)row).lineStyle;
                    this.m_Components.get((int)row).lineStyle = DOOCSChannel.LineStyle.valueOf(valTxt);
                    break;
                }
                case 3: {
                    this.m_Components.get((int)row).lineColor = (Color)value;
                    break;
                }
                case 4: {
                    String valTxt = value.toString();
                    this.m_Components.get((int)row).strokeSize = new BasicStroke(Float.parseFloat(valTxt));
                    break;
                }
                case 5: {
                    String valTxt = ((JLabel)value).getText();
                    DOOCSChannel.Marks cfr_ignored_1 = this.m_Components.get((int)row).marks;
                    this.m_Components.get((int)row).marks = DOOCSChannel.Marks.valueOf(valTxt);
                    break;
                }
            }
            this.fireTableCellUpdated(row, 1);
        }
    }

    public JLabel createIconLabel(String name) {
        JLabel iLabel = new JLabel();
        ImageIcon icon = null;
        URL imageUrl = this.getClass().getResource("/editor/icons/choiceIcons/" + name + ".gif");
        if (imageUrl != null) {
            icon = new ImageIcon(imageUrl);
        } else {
            imageUrl = this.getClass().getResource("/editor/icons/choiceIcons/" + name + ".png");
            if (imageUrl != null) {
                icon = new ImageIcon(imageUrl);
            }
        }
        iLabel.setIcon(icon);
        iLabel.setText(name);
        return iLabel;
    }

    public Object[] getOptionList(int col) {
        if (col == 2) {
            return this.styleLabels;
        }
        if (col == 5) {
            return this.markLabels;
        }
        return new String[]{"ERROR!"};
    }
}

