/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSPlot;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.plaf.metal.MetalToolTipUI;

public class PlotToolTipUI
extends MetalToolTipUI {
    private int maxWidth = 0;
    private DOOCSPlot plot;
    private Color fillColor;

    public PlotToolTipUI(DOOCSPlot p) {
        this.plot = p;
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(true);
        int rd = ToolTipManager.sharedInstance().getReshowDelay();
        int id = ToolTipManager.sharedInstance().getInitialDelay();
        ToolTipManager.sharedInstance().setInitialDelay(300);
        float[] cols = new float[4];
        p.getBackground().getRGBComponents(cols);
        this.fillColor = new Color(cols[0], cols[1], cols[2], 0.8f);
    }

    public void paintBorder(Graphics g) {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        FontMetrics metrics = g.getFontMetrics();
        Dimension size = c.getSize();
        g.setColor(this.fillColor);
        g.fillRoundRect(12, 5, size.width - 13, size.height - 6, 6, 6);
        if (this.plot.mouseClosestDataChannel != null) {
            g.setColor(this.plot.mouseClosestDataChannel.lineColor);
        } else {
            g.setColor(Color.BLACK);
        }
        String tipText = ((JToolTip)c).getTipText();
        if (tipText != null) {
            g.drawString(tipText, 14, metrics.getHeight());
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        FontMetrics metrics = c.getFontMetrics(c.getFont());
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            tipText = "";
        }
        this.maxWidth = SwingUtilities.computeStringWidth(metrics, tipText);
        int height = metrics.getHeight();
        return new Dimension(this.maxWidth + 15, height + 4);
    }
}

