/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSPlot;
import DOOCSPlot.DOOCSPlotAxis;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.IllegalFormatException;

public class DOOCSPlotXAxisLocation
extends DOOCSPlotAxis {
    public DOOCSPlotXAxisLocation() {
    }

    public DOOCSPlotXAxisLocation(DOOCSPlot p) {
        this.plot = p;
    }

    @Override
    public void setIsLog(boolean val) {
        this.isLog = false;
    }

    @Override
    public void linRoundUp(double rmin, double rmax) {
        double del;
        if (this.plot == null) {
            return;
        }
        if (rmin > rmax) {
            double f = rmax;
            rmax = rmin;
            rmin = f;
        }
        if ((del = rmax - rmin) == 0.0) {
            this.actMin = rmin;
            this.delMajor = 1.0;
            this.actMax = rmin + 10.0;
            this.nMajorTicks = 10;
            this.nMinorTicks = 10;
            this.delMinor = 0.0;
        } else {
            this.actMin = Math.floor(rmin);
            if (this.actMin < 0.5) {
                this.actMin = -1.0;
            }
            this.actMax = Math.ceil(rmax);
            this.nMajorTicks = (int)Math.round(this.actMax - this.actMin);
            this.nMinorTicks = this.nMajorTicks + 1;
        }
        this.setScale(this.actMin, this.actMax);
    }

    @Override
    public void setScale(double rmin, double rmax) {
        this.actMin = rmin;
        this.actMax = rmax;
        if (this.isLog) {
            double lmin = rmin <= 0.0 ? -20.0 : Math.log10(rmin);
            double lmax = rmax <= 0.0 ? -20.0 : Math.log10(rmax);
            this.precision = 2;
            try {
                String fmt = String.format("%%2.%dg", this.precision);
                String t1 = String.format(fmt, this.actMin);
                String t2 = String.format(fmt, this.actMax);
                this.tickStringLength = Math.max(t1.length(), t2.length());
            }
            catch (IllegalFormatException e) {
                this.tickStringLength = 5;
            }
            this.transformScale = (double)this.pixelLength / (lmax - lmin);
        } else {
            int ideca;
            if (this.nMajorTicks < 1) {
                this.nMajorTicks = 1;
            }
            if ((ideca = (int)Math.log10(Math.abs(this.delMajor))) < 0) {
                --ideca;
            }
            this.delMinor = Math.pow(10.0, ideca);
            if (Math.abs(this.actMax) > Math.abs(this.actMin)) {
                this.precision = (int)(Math.log10(Math.abs(this.actMax) / this.delMajor) + 1.0);
                ideca = (int)(Math.log10(Math.abs(this.actMax)) + 1.0);
            } else {
                this.precision = (int)(Math.log10(Math.abs(this.actMin) / this.delMajor) + 1.0);
                ideca = (int)(Math.log10(Math.abs(this.actMin)) + 1.0);
            }
            if (ideca < 6 && this.precision < ideca) {
                this.precision = ideca;
            }
            if (this.nMajorTicks > 10) {
                ++this.precision;
            }
            if (this.precision < 2) {
                this.precision = 2;
            }
            if (this.precision > 10) {
                this.precision = 10;
            }
            if (this.nMinorTicks < 1) {
                this.nMinorTicks = 1;
            }
            if (this.nMinorTicks > 100) {
                this.nMinorTicks = 100;
            }
            try {
                String fmt = String.format("%%.%dg", this.precision);
                String t1 = this.actMin == 0.0 ? "0.0" : String.format(fmt, this.actMin);
                String t2 = String.format(fmt, this.actMax);
                this.tickStringLength = Math.max(t1.length(), t2.length());
            }
            catch (IllegalFormatException e) {
                this.tickStringLength = 5;
            }
            this.transformScale = (double)this.pixelLength / (this.actMax - this.actMin);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int ix;
        int idMin;
        Graphics2D g2d = (Graphics2D)g;
        int id = idMin = (int)Math.round(this.actMin);
        int markTick = 0;
        float x = 0.0f;
        float y = 0.0f;
        g2d.setColor(this.getForeground());
        g2d.setFont(this.getFont());
        BasicStroke myStroke = new BasicStroke(this.strokeSize);
        g2d.setStroke(myStroke);
        float space = this.p1X - this.p0X;
        float delx = space / (float)this.nMajorTicks;
        float delx2 = delx / (float)this.nMinorTicks;
        space = 0.0f;
        int ch = g2d.getFontMetrics().getHeight();
        for (int i = 0; i < this.nMajorTicks; ++i) {
            int cw;
            int pos;
            x = (float)this.p0X + delx * (float)i;
            ix = (int)((double)x + 0.5);
            id = idMin + i;
            if (id < 0) continue;
            String tmp = this.plot.doocsAdrList.list.size() > 0 && this.plot.doocsAdrList.list.get((int)0).channels.size() > 0 && this.plot.doocsAdrList.list.get((int)0).channels.get((int)0).dataContainer != null ? this.plot.doocsAdrList.list.get((int)0).channels.get((int)0).dataContainer.getXString(id) : " ";
            if (tmp == null) {
                tmp = "?";
            }
            if ((pos = ix - (cw = g2d.getFontMetrics().stringWidth(tmp)) / 2) < 2) {
                pos = 2;
            }
            int tick = this.tickLength / 2;
            if ((float)pos > space) {
                if (this.showText && this.spaceForText) {
                    space = pos + cw + 10;
                    g2d.drawString(tmp, pos, this.p1Y + ch + this.tickLength);
                    tick = this.tickLength;
                    markTick = 2;
                } else {
                    markTick = 0;
                }
            }
            if (this.hasGrid) {
                g2d.drawLine(ix, this.p1Y + tick + markTick, ix, this.p2XY);
            } else {
                g2d.drawLine(ix, this.p1Y, ix, this.p1Y + tick + markTick);
            }
            if (i + 1 != this.nMajorTicks) continue;
            space -= delx / 2.0f;
        }
        x = (float)this.p0X + delx * (float)this.nMajorTicks;
        ix = (int)((double)x + 0.5);
        g2d.drawLine(ix, this.p1Y, ix, this.p1Y);
        g2d.drawLine(this.p0X, this.p1Y, ix, this.p1Y);
        g2d.drawLine(this.p0X, this.p2XY, ix, this.p2XY);
    }
}

