/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSAdrList;
import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.DOOCSPlot;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.JComponent;

public class DOOCSPlotLegend
extends JComponent {
    private transient DOOCSAdrList list;
    protected DOOCSPlot plot;
    private List<DOOCSChannel> listChan;
    private Color colBG;
    private Color colFrame;

    public DOOCSPlotLegend(DOOCSAdrList l, DOOCSPlot p) {
        this.list = l;
        this.plot = p;
        this.setFont(new Font("Dialog", 0, 10));
        this.colBG = new Color(180, 180, 180, 40);
        this.colFrame = new Color(20, 20, 20);
    }

    public void setLegend(List<DOOCSChannel> listCh) {
        this.listChan = listCh;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setFont(this.getFont());
        int ch = g2d.getFontMetrics().getHeight();
        if (this.listChan == null) {
            return;
        }
        int l = this.listChan.size();
        int w = 0;
        int iii = this.getBounds().x;
        int x = this.getX();
        int y = this.getY();
        for (DOOCSChannel li : this.listChan) {
            if (li == null) {
                return;
            }
            int strw = g2d.getFontMetrics().stringWidth(li.getLegendString());
            if (strw <= w) continue;
            w = strw;
        }
        g2d.setStroke(new BasicStroke(1.0f));
        this.setBounds(x, y, w += 17, ch * l);
        g2d.setColor(this.colBG);
        g2d.fillRect(x, y, w, ch * l);
        g2d.setColor(this.colFrame);
        g2d.drawRect(x, y, w, ch * l);
        g2d.setStroke(new BasicStroke(3.0f));
        for (int i = 0; i < l; ++i) {
            Color c = this.listChan.get((int)i).lineColor;
            g2d.setColor(c);
            g2d.setPaintMode();
            g2d.drawLine(x + 2, y + ch / 2, x + 10, y + ch / 2);
            if (this.listChan.get(i).getLegendError()) {
                g2d.setColor(Color.RED);
            } else {
                g2d.setColor(Color.BLACK);
            }
            g2d.drawString(this.listChan.get(i).getLegendString(), x + 15, y + ch - 3);
            y += ch;
        }
    }
}

