/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class StringTransferHandler
extends TransferHandler {
    @Override
    protected Transferable createTransferable(JComponent c) {
        return new StringSelection(this.exportString(c));
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        if (this.canImport(c, t.getTransferDataFlavors())) {
            try {
                String str = (String)t.getTransferData(DataFlavor.stringFlavor);
                this.importString(c, str);
                return true;
            }
            catch (UnsupportedFlavorException ufe) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        this.cleanup(c, action == 2);
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!DataFlavor.stringFlavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    protected void importString(JComponent c, String str) {
        DOOCSComponent target = (DOOCSComponent)((Object)c);
        if (str != null && str.length() > 7) {
            try {
                target.setDnDText(str);
            }
            catch (Exception e) {
                System.out.println("StringTransferHandler.importString: " + e);
            }
        }
    }

    protected String exportString(JComponent c) {
        String dndText;
        DOOCSComponent target = (DOOCSComponent)((Object)c);
        try {
            dndText = target.getDnDText();
        }
        catch (Exception e) {
            System.out.println("StringTransferHandler.exportString: " + e);
            dndText = null;
        }
        return dndText;
    }

    protected void cleanup(JComponent c, boolean remove) {
    }
}

