/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSSwitch;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import xmlparser.IntegerParser;

public class DOOCSIfCase
extends DOOCSLayeredPane {
    public final int NO_COMP = -1;
    public final int EQUAL = 0;
    public final int NO_EQUAL = 1;
    public final int LESS = 2;
    public final int GREATER = 3;
    public final int LESS_EQUAL = 4;
    public final int GREATER_EQUAL = 5;
    public final int AVAILABLE = 6;
    private String doocsCase = "1";
    private int doocsComparator = 0;
    private int doocsRadix = 10;

    public DOOCSIfCase() {
        this.setEnabled(false);
        this.setOpaque(false);
        this.setDoocsBorderType("If Border");
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (comp instanceof DOOCSIfCase) {
            this.getParent().add(comp, constraints);
            return;
        }
        super.add(comp, constraints);
    }

    @Override
    public String toString() {
        String sCase = "";
        if (this.doocsComparator == -1) {
            return "else";
        }
        if (this.doocsComparator == 6) {
            return "available";
        }
        switch (this.doocsComparator) {
            case 0: {
                sCase = "X = " + this.doocsCase;
                break;
            }
            case 1: {
                sCase = "X != " + this.doocsCase;
                break;
            }
            case 2: {
                sCase = "X < " + this.doocsCase;
                break;
            }
            case 4: {
                sCase = "X <= " + this.doocsCase;
                break;
            }
            case 3: {
                sCase = "X > " + this.doocsCase;
                break;
            }
            case 5: {
                sCase = "X >= " + this.doocsCase;
                break;
            }
        }
        return sCase;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (name.equalsIgnoreCase("else")) {
            this.doocsComparator = -1;
        }
    }

    public void showThisCase() {
        ((DOOCSSwitch)this.getParent()).showCase(this);
    }

    public void setCase(String casevalue) {
        this.doocsCase = casevalue;
        this.setName(this.toString());
    }

    public String getCase() {
        return this.doocsCase;
    }

    public void setComparator(int value) {
        this.doocsComparator = value;
        this.setName(this.toString());
    }

    public int getComparator() {
        return this.doocsComparator;
    }

    protected int parseComparator(String value) {
        if (value.equals("greater")) {
            return 3;
        }
        if (value.equals("greater or equal")) {
            return 5;
        }
        if (value.equals("equal")) {
            return 0;
        }
        if (value.equals("not equal")) {
            return 1;
        }
        if (value.equals("less")) {
            return 2;
        }
        if (value.equals("less or equal")) {
            return 4;
        }
        if (value.equals("available")) {
            return 6;
        }
        return -1;
    }

    protected String comparatorToString(int value) {
        switch (value) {
            case 0: {
                return "equal";
            }
            case 1: {
                return "not equal";
            }
            case 2: {
                return "less";
            }
            case 4: {
                return "less or equal";
            }
            case 3: {
                return "greater";
            }
            case 5: {
                return "greater or equal";
            }
            case 6: {
                return "available";
            }
        }
        return "ignore";
    }

    public boolean evaluateCase(Object doocsValue, int dataType) {
        if (this.doocsComparator == -1) {
            return true;
        }
        if (doocsValue == null) {
            return false;
        }
        if (dataType == 7 || dataType == 3 || dataType == 103 || dataType == 16 || dataType == 5) {
            if (this.doocsComparator == 6) {
                return true;
            }
            String sValue = (String)doocsValue;
            if (this.doocsComparator == 0) {
                return sValue.equalsIgnoreCase(this.doocsCase);
            }
            if (this.doocsComparator == 1) {
                return !sValue.equalsIgnoreCase(this.doocsCase);
            }
        } else {
            if (dataType == 1 || dataType == 105 || dataType == 4 || dataType == 119 || dataType == 8 || dataType == 115 || dataType == 14) {
                Integer numCase = 0;
                if (this.doocsComparator == 6) {
                    return true;
                }
                numCase = this.doocsCase == null ? 0 : IntegerParser.parseInt(this.doocsCase, this.doocsRadix);
                Integer numValue = (Integer)doocsValue;
                boolean isTrue = true;
                if (this.doocsComparator == 0) {
                    return numValue.equals(numCase);
                }
                if (this.doocsComparator == 1) {
                    return !numValue.equals(numCase);
                }
                if (this.doocsComparator == 3) {
                    isTrue = numValue > numCase;
                } else if (this.doocsComparator == 5) {
                    boolean bl = isTrue = numValue >= numCase;
                }
                if (this.doocsComparator == 2) {
                    isTrue = isTrue && numValue < numCase;
                } else if (this.doocsComparator == 4) {
                    isTrue = isTrue && numValue <= numCase;
                }
                return isTrue;
            }
            if (dataType == 2 || dataType == 100 || dataType == 6 || dataType == 110) {
                Double numCase = 0.0;
                if (this.doocsComparator == 6) {
                    return true;
                }
                numCase = this.doocsCase == null ? 0.0 : Double.parseDouble(this.doocsCase);
                Double numValue = (Double)doocsValue;
                boolean isTrue = true;
                if (this.doocsComparator == 0) {
                    return numValue.equals(numCase);
                }
                if (this.doocsComparator == 1) {
                    return !numValue.equals(numCase);
                }
                if (this.doocsComparator == 3) {
                    isTrue = numValue > numCase;
                } else if (this.doocsComparator == 5) {
                    boolean bl = isTrue = numValue >= numCase;
                }
                if (this.doocsComparator == 2) {
                    isTrue = isTrue && numValue < numCase;
                } else if (this.doocsComparator == 4) {
                    isTrue = isTrue && numValue <= numCase;
                }
                return isTrue;
            }
        }
        return false;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        if (this.doocsComparator != -1) {
            DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("compareValue", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("comparator", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL)};
            return parameters;
        }
        DOOCSParameter[] parameters = new DOOCSParameter[]{};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("comparator")) {
            String[] allowedValues = new String[]{"available", "equal", "not equal", "less", "less or equal", "greater", "greater or equal"};
            return allowedValues;
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSIfCase ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("<grid>" + this.getDoocsGrid() + "</grid>");
        xmlStructure.append("\n");
        Component[] subcomp = this.getComponents();
        for (int i = 0; i < subcomp.length; ++i) {
            DOOCSComponent dcomp = (DOOCSComponent)((Object)subcomp[i]);
            xmlStructure.append(dcomp.getDOOCSXmlStructure());
        }
        xmlStructure.append("</DOOCSIfCase>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("compareValue")) {
            this.setCase(value);
        } else if (parameter.equalsIgnoreCase("comparator")) {
            this.setComparator(this.parseComparator(value));
        } else if (parameter.equalsIgnoreCase("grid")) {
            this.setDoocsGrid(value);
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else {
            System.out.println("DOOCSIfCase.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        if (parameter.equalsIgnoreCase("compareValue")) {
            return this.getCase();
        }
        if (parameter.equalsIgnoreCase("comparator")) {
            return this.comparatorToString(this.getComparator());
        }
        System.out.println("DOOCSIfCase.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isRunMode()) {
            super.paintComponent(g);
            Color col = g.getColor();
            g.setColor(Color.GRAY);
            Font font = g.getFont();
            g.setFont(new Font("Arial", 0, 12));
            g.drawString(this.toString(), 2, this.getHeight() - 2);
            g.setColor(col);
            g.setFont(font);
        }
    }

    @Override
    public void setRunMode(boolean bRun) {
        super.setRunMode(bRun);
        this.setEnabled(bRun);
    }
}

