/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import java.awt.Color;
import java.util.Hashtable;

public class ColorMap {
    public int max_colors;
    private String range_string;
    private int interval_count;
    private int interval_size;
    private int[][] interval_rgb;
    public Color[] table;

    private void setup_interval_rgb(String spectrum_str) {
        Hashtable<Character, Integer> color_to_int = new Hashtable<Character, Integer>();
        this.interval_rgb = new int[this.interval_count + 1][3];
        int[][] int_to_rgb = new int[][]{{255, 0, 0}, {0, 255, 0}, {0, 0, 255}, {255, 255, 0}, {0, 0, 0}, {255, 255, 255}, {180, 180, 180}};
        color_to_int.put(Character.valueOf('r'), 0);
        color_to_int.put(Character.valueOf('R'), 0);
        color_to_int.put(Character.valueOf('g'), 1);
        color_to_int.put(Character.valueOf('G'), 1);
        color_to_int.put(Character.valueOf('b'), 2);
        color_to_int.put(Character.valueOf('B'), 2);
        color_to_int.put(Character.valueOf('y'), 3);
        color_to_int.put(Character.valueOf('Y'), 3);
        color_to_int.put(Character.valueOf('0'), 4);
        color_to_int.put(Character.valueOf('1'), 5);
        color_to_int.put(Character.valueOf('2'), 6);
        for (int i = 0; i < this.interval_count + 1; ++i) {
            for (int j = 0; j < 3; ++j) {
                Integer idx = (Integer)color_to_int.get(Character.valueOf(spectrum_str.charAt(i)));
                this.interval_rgb[i][j] = int_to_rgb[idx][j];
            }
        }
    }

    public ColorMap(String spectrum_str, int max) {
        int count = 0;
        this.max_colors = max;
        this.range_string = spectrum_str;
        this.interval_count = this.range_string.length() - 1;
        this.interval_size = this.max_colors / this.interval_count;
        this.table = new Color[this.max_colors];
        if (spectrum_str.equalsIgnoreCase("StatusCode")) {
            this.table[0] = new Color(0, 255, 0);
            this.table[1] = new Color(255, 0, 0);
            this.table[2] = new Color(180, 180, 180);
            this.table[3] = new Color(255, 255, 0);
            this.table[4] = new Color(0, 0, 255);
            this.table[5] = new Color(195, 151, 68);
            this.table[6] = new Color(153, 0, 153);
            this.table[7] = new Color(0, 153, 153);
            return;
        }
        if (spectrum_str.equalsIgnoreCase("RedGreen")) {
            this.table[0] = new Color(255, 0, 0);
            this.table[1] = new Color(0, 255, 0);
            return;
        }
        if (spectrum_str.equalsIgnoreCase("GrayGreen")) {
            this.table[0] = new Color(180, 180, 180);
            this.table[1] = new Color(0, 255, 0);
            return;
        }
        this.setup_interval_rgb(this.range_string);
        for (int i = 0; i < this.interval_count; ++i) {
            int start_range = i * this.interval_size;
            int end_range = i == this.interval_count - 1 ? this.max_colors : (i + 1) * this.interval_size;
            int range_size = end_range - start_range;
            float rstart = this.interval_rgb[i][0];
            float rend = this.interval_rgb[i + 1][0];
            float rstep = rstart - rend == 0.0f ? 0.0f : -(rstart - rend) / (float)range_size;
            float gstart = this.interval_rgb[i][1];
            float gend = this.interval_rgb[i + 1][1];
            float gstep = gstart - gend == 0.0f ? 0.0f : -(gstart - gend) / (float)range_size;
            float bstart = this.interval_rgb[i][2];
            float bend = this.interval_rgb[i + 1][2];
            float bstep = bstart - bend == 0.0f ? 0.0f : -(bstart - bend) / (float)range_size;
            for (int j = start_range; j < end_range; ++j) {
                this.table[count++] = new Color((int)(rstart + (float)(j - start_range) * rstep), (int)(gstart + (float)(j - start_range) * gstep), (int)(bstart + (float)(j - start_range) * bstep));
            }
        }
    }
}

