/*
 * Decompiled with CFR 0.152.
 */
package ttf.doocs.clnt;

import com.cosylab.epics.caj.CAJContext;
import de.desy.tine.client.TLink;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TErrorList;
import de.desy.tine.histUtils.THistory;
import de.desy.tine.histUtils.THistorySource;
import de.desy.tine.queryUtils.TPropertyQuery;
import de.desy.tine.queryUtils.TQuery;
import de.desy.tine.types.ADDRESS;
import de.desy.tine.types.DBLINT;
import de.desy.tine.types.FLTINT;
import de.desy.tine.types.INTINT;
import de.desy.tine.types.LNGINT;
import de.desy.tine.types.NAME16;
import de.desy.tine.types.NAME16I;
import de.desy.tine.types.NAME32;
import de.desy.tine.types.NAME32I;
import de.desy.tine.types.NAME48;
import de.desy.tine.types.NAME64;
import de.desy.tine.types.NAME8;
import de.desy.tine.types.TCompoundDataObject;
import de.desy.tine.types.USTRING;
import gov.aps.jca.CAException;
import gov.aps.jca.Channel;
import gov.aps.jca.TimeoutException;
import gov.aps.jca.configuration.Configuration;
import gov.aps.jca.configuration.ConfigurationException;
import gov.aps.jca.configuration.DefaultConfiguration;
import gov.aps.jca.configuration.DefaultConfigurationBuilder;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcClientAuth;
import org.acplt.oncrpc.OncRpcClientAuthUnix;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcProgramNotRegisteredException;
import org.acplt.oncrpc.OncRpcTimeoutException;
import org.xml.sax.SAXException;
import ttf.doocs.clnt.ENS_DB;
import ttf.doocs.clnt.ENSinfo;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCallSingleton;
import ttf.doocs.clnt.EqCallback;
import ttf.doocs.clnt.EqData;
import ttf.doocs.clnt.EqDataBlock;
import ttf.doocs.clnt.FI;
import ttf.doocs.clnt.FIS;
import ttf.doocs.clnt.II;
import ttf.doocs.clnt.Monitoring;
import ttf.doocs.clnt.NAME16FI;
import ttf.doocs.clnt.NAME16II;
import ttf.doocs.clnt.SPECTRUM;
import ttf.doocs.clnt.TDS;
import ttf.doocs.clnt.TangoAccess;
import ttf.doocs.clnt.USTR;
import ttf.doocs.clnt.ens_name_param;
import ttf.doocs.clnt.ens_name_results;
import ttf.doocs.clnt.ens_param;
import ttf.doocs.clnt.ens_results;
import ttf.doocs.clnt.get_param;
import ttf.doocs.clnt.get_results;
import ttf.doocs.clnt.name_param;
import ttf.doocs.clnt.name_results;
import ttf.doocs.clnt.set_param;
import ttf.doocs.clnt.set_results;
import ttf.doocs.clnt.time_t;
import ttf.doocs.clnt.u_char;

public class EqCall {
    public static final int MODE_NULL = 0;
    public static final int MODE_SINGLE = 1;
    public static final int MODE_DATACHANGE = 2;
    public static final int MODE_RATE = 3;
    private EqData result_;
    private static String enshost_;
    private OncRpcClient ensClient_;
    private OncRpcClientAuth auth_;
    private static Monitoring monitor;
    private static long retryDelay;
    private static final int debugENS = 2;
    private static final int debugGET = 1;
    private static int debug;
    private static int TIMEOUT;
    private static final String API_VERSION = "1.04.11";
    private int timeOut = TIMEOUT;
    public static CAJContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EqCall() {
        ENS_DB ei = new ENS_DB();
        enshost_ = ei.get_enshost(false);
        this.result_ = new EqData();
        this.auth_ = ei.get_groups().length != 0 ? new OncRpcClientAuthUnix(ei.get_localhost(), ei.get_uid(), ei.get_gid(), ei.get_groups()) : new OncRpcClientAuthUnix(ei.get_localhost(), ei.get_uid(), ei.get_gid());
        EqCallSingleton eqCallSingleton = EqCallSingleton.getSingleton();
        synchronized (eqCallSingleton) {
            if (monitor == null) {
                monitor = new Monitoring(this);
            }
        }
    }

    public int get_monitor(EqAdr adr, EqData dataIn, EqData dataOut, int mode, float rate) {
        return this.common_get_monitor(adr, dataIn, dataOut, mode, rate, null, null);
    }

    public int get_monitor(EqAdr adr, EqData dataIn, EqData dataOut, int mode, float rate, EqCallback callBack, Object userData) {
        return this.common_get_monitor(adr, dataIn, dataOut, mode, rate, callBack, userData);
    }

    private int common_get_monitor(EqAdr adr, EqData dataIn, EqData dataOut, int mode, float rate, EqCallback callBack, Object userData) {
        int err;
        if (adr == null || !adr.isValidFullAdr()) {
            dataOut.error(103, "inv. address");
            return -1;
        }
        String adrStr = adr.show_adr();
        ENSinfo info = null;
        info = this.ENS_info(adr);
        if (info == null) {
            dataOut.error(603, "protocol or address not supported!!!!");
            adr.lastCallError = System.currentTimeMillis() + retryDelay;
            return -1;
        }
        if (info.error == 1) {
            dataOut.error(603, "address not in name server!!!!");
            adr.lastCallError = System.currentTimeMillis() + retryDelay;
            return -1;
        }
        if (info.error == 22) {
            this.result_ = new EqData();
            dataOut.error(103, "inv. address");
            adr.lastCallError = System.currentTimeMillis() + retryDelay;
            return -1;
        }
        switch (info.protocol) {
            case 1: {
                monitor.get_monitor(adr, dataIn, dataOut, info, mode, rate, callBack, userData);
                if (dataOut.error() != 1008) break;
                ENS_DB ei = new ENS_DB();
                ei.remove(adr, info);
                monitor.get_monitor(adr, dataIn, dataOut, info, mode, rate, callBack, userData);
                break;
            }
            case 2: {
                monitor.tine_get_monitor(adr, dataIn, dataOut, info, mode, rate, callBack, userData);
                break;
            }
            case 3: {
                monitor.epics_get_monitor(adr, dataIn, dataOut, info, mode, rate, callBack, userData);
                break;
            }
            case 4: {
                monitor.tango_get_monitor(adr, dataIn, dataOut, info, mode, rate, callBack, userData);
                break;
            }
            default: {
                dataOut.error(603, "protocol not supported!!!!");
                adr.lastCallError = System.currentTimeMillis() + retryDelay;
                return -1;
            }
        }
        if ((err = dataOut.error()) != 0) {
            if (err == 100 || err == 101 || err == 113) {
                adr.lastCallError = System.currentTimeMillis() + retryDelay;
            }
            return -1;
        }
        adr.lastCallError = 0L;
        return 0;
    }

    public int clear_monitor(EqAdr adr) {
        monitor.clear_monitor(adr);
        return 0;
    }

    public void reconnect(EqAdr ea) {
        ENS_DB ei = new ENS_DB();
        ei.remove(ea, this.ENS_info(ea));
    }

    public EqData names(EqAdr ea) {
        long act;
        EqDataBlock data = null;
        ENSinfo info = null;
        String debug1 = ea.show_adr();
        if (!ea.facility().startsWith("*")) {
            info = this.ENS_info(ea);
        }
        if (ea.lastCallError != 0L && ea.lastCallError > (act = System.currentTimeMillis())) {
            this.result_ = new EqData();
            this.result_.error(603, "ill. service!!!!");
            return this.result_;
        }
        if (info == null) {
            data = this.ens_connect(ea);
            if (data.error == 0 && data.data_u.d_ustr_array.length == 1) {
                EqData tine = new EqData(data);
                if (tine.get_string_arg(0).trim().equals("@")) {
                    ENS_DB ei = new ENS_DB();
                    ei.append(ea.facility(), new EqData());
                }
                if (tine.get_string_arg(0).trim().equals("@") || "*".equals(ea.location()) || "*".equals(ea.property())) {
                    data = this.Tine_name_connect(ea, info);
                }
            } else if (data.error == 101) {
                // empty if block
            }
        } else {
            switch (info.protocol) {
                case 1: {
                    data = this.name_connect(ea, info);
                    if (data.error != 1008) break;
                    ENS_DB ei = new ENS_DB();
                    ei.remove(ea, info);
                    data = this.name_connect(ea, info);
                    break;
                }
                case 2: {
                    data = this.Tine_name_connect(ea, info);
                    break;
                }
                case 3: {
                    this.result_ = new EqData();
                    ea.lastCallError = System.currentTimeMillis() + retryDelay;
                    this.result_.error(603, "EPICS: no name server!!!!");
                    return this.result_;
                }
                case 4: {
                    this.result_ = new EqData();
                    data = TangoAccess.name_connect(ea, info, this.result_);
                    if (this.result_.error() == 0) break;
                    return this.result_;
                }
                default: {
                    this.result_ = new EqData();
                    ea.lastCallError = System.currentTimeMillis() + retryDelay;
                    this.result_.error(603, "protocol not supported!!!!");
                    return this.result_;
                }
            }
        }
        this.result_ = new EqData(data);
        ea.lastCallError = this.result_.error() != 0 ? System.currentTimeMillis() + retryDelay : 0L;
        return this.result_;
    }

    public EqData get(EqAdr ea, EqData data) {
        this.result_ = new EqData();
        this.get(ea, data, this.result_);
        return this.result_;
    }

    public int get(EqAdr ea, EqData dataIn, EqData dataOut) {
        int err;
        long act;
        if (ea == null || !ea.isValidFullAdr()) {
            dataOut.error(103, "inv. address");
            return -1;
        }
        String adr = ea.show_adr();
        if (adr.startsWith("file:")) {
            return dataOut.set_from_file(ea.show_adr().substring(5));
        }
        if (ea.lastCallError != 0L && ea.lastCallError > (act = System.currentTimeMillis())) {
            return -1;
        }
        ENSinfo info = null;
        info = this.ENS_info(ea);
        if (info == null) {
            dataOut.error(603, "protocol or address not supported!!!!");
            ea.lastCallError = System.currentTimeMillis() + retryDelay;
            return -1;
        }
        if (info.error == 1) {
            dataOut.error(603, "address not in name server!!!!");
            ea.lastCallError = System.currentTimeMillis() + retryDelay;
            return -1;
        }
        if (info.error == 22) {
            this.result_ = new EqData();
            dataOut.error(103, "inv. address");
            ea.lastCallError = System.currentTimeMillis() + retryDelay;
            return -1;
        }
        switch (info.protocol) {
            case 1: {
                this.get_connect(ea, dataIn, info, dataOut);
                if (dataOut.error() != 1008) break;
                ENS_DB ei = new ENS_DB();
                ei.remove(ea, info);
                this.get_connect(ea, dataIn, info, dataOut);
                break;
            }
            case 2: {
                this.Tine_get_connect(ea, dataIn, dataOut);
                break;
            }
            case 3: {
                if (info.file_or_ch != null && info.file_or_ch.length > 0) {
                    this.Epics_get_connect(ea, new String(info.file_or_ch).trim(), dataIn, dataOut);
                    break;
                }
                this.Epics_get_connect(ea, ea.file(), dataIn, dataOut);
                break;
            }
            case 4: {
                TangoAccess Ta = new TangoAccess(ea, info, dataOut);
                if (dataOut.error() != 0) break;
                Ta.get_connect(dataIn, dataOut);
                break;
            }
            default: {
                dataOut.error(603, "protocol not supported!!!!");
                ea.lastCallError = System.currentTimeMillis() + retryDelay;
                return -1;
            }
        }
        if ((err = dataOut.error()) != 0) {
            if (err == 100 || err == 101 || err == 113) {
                ea.lastCallError = System.currentTimeMillis() + retryDelay;
            }
            return -1;
        }
        ea.lastCallError = 0L;
        return 0;
    }

    public EqData set(EqAdr ea, EqData data) {
        EqData dataOut = new EqData();
        this.set(ea, data, dataOut);
        return dataOut;
    }

    public int set(EqAdr ea, EqData dataIn, EqData dataOut) {
        long act;
        ENSinfo info = null;
        if (!ea.isValidFullAdr()) {
            dataOut.error(103, "inv. address");
            return -1;
        }
        info = this.ENS_info(ea);
        if (info == null) {
            dataOut.error(603, "protocol or address not supported!!!!");
            return -1;
        }
        if (info.error == 22) {
            this.result_ = new EqData();
            dataOut.error(103, "inv. address");
            return -1;
        }
        if (ea.lastCallError != 0L && ea.lastCallError > (act = System.currentTimeMillis())) {
            return -1;
        }
        if (info != null) {
            switch (info.protocol) {
                case 1: {
                    this.set_connect(ea, dataIn, dataOut, info);
                    if (dataOut.error() != 1008) break;
                    ENS_DB ei = new ENS_DB();
                    ei.remove(ea, info);
                    this.set_connect(ea, dataIn, dataOut, info);
                    break;
                }
                case 2: {
                    this.Tine_set_connect(ea, dataIn, dataOut);
                    break;
                }
                case 4: {
                    TangoAccess Ta = new TangoAccess(ea, info, dataOut);
                    if (dataOut.error() != 0) break;
                    Ta.set_connect(dataIn, dataOut);
                    break;
                }
                case 3: {
                    if (info.file_or_ch != null && info.file_or_ch.length > 0) {
                        this.Epics_set_connect(ea, new String(info.file_or_ch).trim(), dataIn, dataOut);
                        break;
                    }
                    this.Epics_set_connect(ea, ea.file(), dataIn, dataOut);
                    break;
                }
                default: {
                    dataOut.error(603, "protocol not supported!!!!");
                    return -1;
                }
            }
        }
        if (dataOut.error() != 0) {
            ea.lastCallError = System.currentTimeMillis() + retryDelay;
            return -1;
        }
        ea.lastCallError = 0L;
        return 0;
    }

    public int set_option(EqAdr ea, int param, EqData data) {
        switch (param) {
            case 16: 
            case 17: {
                return monitor.set_option(ea, param, data);
            }
            case 14: {
                float f = data.get_float();
                if (f == 0.0f) {
                    this.timeOut = TIMEOUT;
                    break;
                }
                if (!(f > 0.0f) || !((double)f < 1000000.0)) break;
                this.timeOut = (int)Math.round((double)f * 1000.0);
            }
        }
        return 1;
    }

    public String get_option(EqAdr ea, int param) {
        String opt = null;
        ENS_DB ei = new ENS_DB();
        ENSinfo info = ei.find(ea);
        if (info != null) {
            switch (param) {
                case 2: {
                    switch (info.protocol) {
                        case 1: {
                            return new String("DOOCS hosts= " + new String(info.hostname).trim() + " ( server_mask = " + String.valueOf(info.server_mask) + " auth_mask = " + String.valueOf(info.auth_mask) + " options = " + String.valueOf(info.options) + " status = " + String.valueOf(info.status) + ")");
                        }
                        case 2: {
                            return new String("TINE hosts= " + new String(info.hostname).trim() + " ( server_mask = " + String.valueOf(info.server_mask) + " auth_mask = " + String.valueOf(info.auth_mask) + " options = " + String.valueOf(info.options) + " status = " + String.valueOf(info.status) + ")");
                        }
                        case 3: {
                            return new String("EPICS hosts= " + new String(info.hostname).trim() + " ( server_mask = " + String.valueOf(info.server_mask) + " auth_mask = " + String.valueOf(info.auth_mask) + " options = " + String.valueOf(info.options) + " status = " + String.valueOf(info.status) + ")");
                        }
                    }
                }
                case 1: {
                    switch (info.protocol) {
                        case 1: {
                            return new String("DOOCS");
                        }
                        case 2: {
                            return new String("TINE");
                        }
                        case 3: {
                            return new String("EPICS");
                        }
                        case 4: {
                            return new String("TANGO");
                        }
                    }
                    return new String("undefined");
                }
                case 0: {
                    return new String(info.hostname);
                }
                case 10: {
                    return new String(String.valueOf(info.server_mask));
                }
                case 8: {
                    return new String(String.valueOf(info.auth_mask));
                }
            }
        }
        switch (param) {
            case 16: 
            case 17: {
                return new String(monitor.get_option(ea, param));
            }
            case 21: {
                return new String("Uid:" + ENS_DB.uid_ + " GID:" + ENS_DB.gid_ + " Groups:" + ei.get_groups());
            }
        }
        return opt;
    }

    public static String versionString() {
        return API_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EqDataBlock ens_connect(EqAdr ea) {
        ens_name_results result = null;
        EqCallSingleton eqCallSingleton = EqCallSingleton.getSingleton();
        synchronized (eqCallSingleton) {
            ens_name_param params = new ens_name_param();
            EqData ed = new EqData();
            params.eq_data = ed.get_Block();
            params.eq_name = ea.EqName();
            result = new ens_name_results();
            if ((debug & 2) != 0) {
                String str = ea.show_adr();
                System.out.println("ENS read: " + str);
            }
            try {
                this.ensClient_ = OncRpcClient.newOncRpcClient(InetAddress.getByName(enshost_), 541412947, 1, 6);
                this.ensClient_.setTimeout(3000);
                this.ensClient_.setAuth(this.auth_);
                this.ensClient_.call(2, params, result);
                this.ensClient_.close();
            }
            catch (OncRpcProgramNotRegisteredException e) {
                System.out.println("ONC/RPC program server not found");
                ENS_DB ei = new ENS_DB();
                enshost_ = ei.get_enshost(true);
                try {
                    this.ensClient_ = OncRpcClient.newOncRpcClient(InetAddress.getByName(enshost_), 541412947, 1, 6);
                    this.ensClient_.setTimeout(3000);
                    this.ensClient_.setAuth(this.auth_);
                    this.ensClient_.call(2, params, result);
                    this.ensClient_.close();
                }
                catch (OncRpcProgramNotRegisteredException ex) {
                    System.out.println("OncRpcProgramNotRegisteredException " + ex.getMessage());
                    ed = new EqData();
                    ed.error(103, "ill.ENS request");
                    return ed.get_Block();
                }
                catch (OncRpcException ex) {
                    System.out.println("OncRpcException " + ex.getMessage());
                    ed = new EqData();
                    ed.error(101, "ill. service");
                    return ed.get_Block();
                }
                catch (IOException ex) {
                    System.out.println("IOException " + ex.getMessage());
                    ed = new EqData();
                    ed.error(101, "ill. service");
                    return ed.get_Block();
                }
                return result.eq_data;
            }
            catch (OncRpcException e) {
                System.out.println("OncRpcException " + e.getMessage());
                ed = new EqData();
                ed.error(101, "ill. service");
                return ed.get_Block();
            }
            catch (IOException e) {
                System.out.println("ENS connect: IOException " + e.getMessage());
                ed = new EqData();
                ed.error(101, "ill. service");
                return ed.get_Block();
            }
            return result.eq_data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void get_connect(EqAdr ea, EqData ed, ENSinfo info, EqData dataOut) {
        String adr = ea.show_adr();
        if (ea.facility().length() < 1) {
            dataOut.error(201, "ill. Facility");
            return;
        }
        if (ea.device().length() < 1) {
            dataOut.error(201, "ill. Device");
            return;
        }
        if (ea.location().length() < 1) {
            dataOut.error(201, "ill. Location");
            return;
        }
        if (ea.property().length() < 1) {
            dataOut.error(201, "ill. Property");
            return;
        }
        ENSinfo eNSinfo = info;
        synchronized (eNSinfo) {
            get_param params = new get_param();
            String tmpLocation = ea.location();
            if (info.status < 0) {
                String alias = "@" + new String(info.file_or_ch);
                ea.set_location(alias.trim());
            }
            params.eq_name = ea.EqName();
            params.eq_data = ed.get_Block();
            get_results result = new get_results();
            String hostname = new String(info.hostname).trim();
            try {
                if (info.client_ == null) {
                    info.client_ = OncRpcClient.newOncRpcClient(InetAddress.getByName(hostname), info.prog_no, info.prog_vers, 6);
                    info.client_.setAuth(this.auth_);
                }
                info.client_.setTimeout(this.timeOut);
                info.client_.call(1, 1, params, result);
                if (result.eq_data.data_u.data_sel == 0) {
                    boolean bl = false;
                }
            }
            catch (OncRpcProgramNotRegisteredException e) {
                System.out.println(adr + ": OncRpcProgramNotRegisteredException (PortMapper)" + e.getMessage());
                dataOut.error(100, "unavailable srv");
                ea.set_location(tmpLocation);
                return;
            }
            catch (OncRpcException e) {
                if (e.getReason() == 4 || e.getReason() == 3) {
                    try {
                        info.client_.close();
                    }
                    catch (OncRpcException ce) {
                        System.out.println(adr + ", close: OncRpcException " + ce.getMessage());
                    }
                    finally {
                        info.client_ = null;
                    }
                }
                if (e.getReason() == 5) {
                    dataOut.error(111, "Timeout");
                } else {
                    dataOut.error(101, e.getMessage());
                }
                ea.set_location(tmpLocation);
                return;
            }
            catch (IOException e) {
                System.out.println(adr + ": IOException " + e.getMessage() + " ENS=" + new String(info.server_name).trim() + ", Host= " + new String(info.hostname).trim());
                dataOut.error(101, "ill. service");
                ea.set_location(tmpLocation);
                return;
            }
            dataOut.copy_from(result.eq_data);
            ea.set_location(tmpLocation);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set_connect(EqAdr ea, EqData dataIn, EqData dataOut, ENSinfo info) {
        set_results result = null;
        String hostname = null;
        if (info.status < 0) {
            String alias = "@" + new String(info.file_or_ch);
            ea.set_location(alias);
        }
        String adr = ea.show_adr();
        ENSinfo eNSinfo = info;
        synchronized (eNSinfo) {
            set_param params = new set_param();
            params.eq_name = ea.EqName();
            params.eq_data = dataIn.get_Block();
            result = new set_results();
            hostname = new String(info.hostname).trim();
            try {
                if (info.client_ == null) {
                    info.client_ = OncRpcClient.newOncRpcClient(InetAddress.getByName(hostname), info.prog_no, info.prog_vers, 6);
                    info.client_.setTimeout(this.timeOut);
                    info.client_.setAuth(this.auth_);
                }
                info.client_.call(2, 1, params, result);
                dataOut.copy_from(result.eq_data);
                if (dataOut.error() == 1006) {
                    System.out.println("No permission! " + adr + "; AUTH=" + this.auth_);
                }
            }
            catch (OncRpcProgramNotRegisteredException e) {
                dataOut.error(100, "unavailable srv");
                return;
            }
            catch (OncRpcException e) {
                dataOut.error(101, e.getMessage());
                return;
            }
            catch (IOException e) {
                dataOut.error(101, e.getMessage());
                return;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EqDataBlock name_connect(EqAdr ea, ENSinfo info) {
        name_results result = null;
        String hostname = null;
        if (info.status < 0) {
            String alias = "@" + new String(info.file_or_ch);
            ea.set_location(alias);
        }
        ENSinfo eNSinfo = info;
        synchronized (eNSinfo) {
            name_param params = new name_param();
            params.eq_name = ea.EqName();
            EqData ed = new EqData();
            params.eq_data = ed.get_Block();
            result = new name_results();
            hostname = new String(info.hostname).trim();
            try {
                if (info.client_ == null) {
                    info.client_ = OncRpcClient.newOncRpcClient(InetAddress.getByName(hostname), info.prog_no, info.prog_vers, 6);
                    info.client_.setAuth(this.auth_);
                }
                info.client_.setTimeout(TIMEOUT);
                info.client_.call(3, 1, params, result);
            }
            catch (OncRpcProgramNotRegisteredException e) {
                ed = new EqData();
                ed.error(100, "unavailable srv");
                return ed.get_Block();
            }
            catch (OncRpcException e) {
                ed = new EqData();
                ed.error(101, e.getMessage());
                return ed.get_Block();
            }
            catch (IOException e) {
                ed = new EqData();
                ed.error(101, e.getMessage());
                return ed.get_Block();
            }
        }
        return result.eq_data;
    }

    private ENSinfo ENS_call(EqAdr ea) {
        ENS_DB ei = new ENS_DB();
        ENSinfo info = ei.find(ea);
        if (info != null) {
            return info;
        }
        ens_param prms = new ens_param();
        prms.eq_name = ea.EqName();
        ens_results rslt = new ens_results();
        String adr = ea.show_adr();
        if ((debug & 2) != 0) {
            System.out.println("ENS call: " + adr + ";entries: " + ENS_DB.services_.size());
        }
        try {
            this.ensClient_ = OncRpcClient.newOncRpcClient(InetAddress.getByName(enshost_), 541412947, 1, 6);
            this.ensClient_.setTimeout(3000);
            this.ensClient_.setAuth(this.auth_);
            this.ensClient_.call(1, 1, prms, rslt);
            this.ensClient_.close();
        }
        catch (OncRpcProgramNotRegisteredException e) {
            System.out.println(adr + ": OncRpcProgramNotRegisteredException " + e.getMessage());
            enshost_ = ei.get_enshost(true);
            return null;
        }
        catch (OncRpcTimeoutException e) {
            System.out.println(adr + ": ENS Timeout " + e.getMessage());
            enshost_ = ei.get_enshost(true);
            return null;
        }
        catch (OncRpcException e) {
            System.out.println(adr + ": ENS OncRpcException " + e.getMessage());
            enshost_ = ei.get_enshost(true);
            return null;
        }
        catch (UnknownHostException e) {
            System.out.println(adr + ": ENS unknown host " + e.getMessage());
            enshost_ = ei.get_enshost(true);
            return null;
        }
        catch (IOException e) {
            System.out.println(adr + ": ENS (" + enshost_ + ") IOException " + e.getMessage());
            enshost_ = ei.get_enshost(true);
            return null;
        }
        int err = rslt.eq_data.error;
        if (err == 0 || err == 1) {
            if (err == 0) {
                ei.append(ea, rslt.eq_data);
            }
            return rslt.eq_data;
        }
        if (err == 2) {
            ei.append(ea, rslt.eq_data);
            return rslt.eq_data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ENSinfo ENS_info(EqAdr ea) {
        EqDataBlock ed = null;
        ENSinfo info = null;
        ENS_DB ei = new ENS_DB();
        info = ei.find(ea);
        if (info != null) {
            return info;
        }
        if (ea.protocol().length() > 1) {
            String host;
            boolean known = false;
            info = new ENSinfo();
            if (ea.protocol().startsWith("doocs")) {
                known = true;
                info.protocol = 1;
                int idx = ea.host().indexOf(58);
                if (idx > 0) {
                    host = ea.host().substring(0, idx);
                    String prog = ea.host().substring(idx + 1);
                    try {
                        info.prog_no = Integer.parseInt(prog);
                    }
                    catch (Exception e) {
                        info.prog_no = 610498009;
                    }
                } else {
                    host = ea.host();
                    info.prog_no = 610498009;
                }
                if (host.length() < 2) {
                    host = "localhost";
                }
                int len = host.length();
                info.hostname = new byte[len];
                for (int i = 0; i < len; ++i) {
                    info.hostname[i] = (byte)host.charAt(i);
                }
            } else if (ea.protocol().startsWith("tine")) {
                known = true;
                info.protocol = 2;
            }
            if (ea.protocol().startsWith("tango")) {
                known = true;
                host = ea.host();
                info.setHost(host);
                String svr = ea.facility();
                info.setServer(svr);
                info.protocol = 4;
            }
            if (ea.protocol().startsWith("epics")) {
                known = true;
                info.setHost(ea.host());
                info.protocol = 3;
            }
            if (known) {
                info.error = 0;
                info.server_mask = 4;
                info.options = 0;
                info.status = 0;
                return info;
            }
        }
        EqCallSingleton eqCallSingleton = EqCallSingleton.getSingleton();
        synchronized (eqCallSingleton) {
            info = this.ENS_call(ea);
            if (info != null && info.error == 2) {
                EqAdr tine = new EqAdr(ea.show_adr());
                tine.set_property("*");
                ed = this.Tine_name_connect(tine, info);
                EqData ed_tine = ei.find(new String(ea.facility() + "/" + ea.device() + "/" + ea.location()));
                if (ed_tine != null) {
                    info = new ENSinfo();
                    info.protocol = 2;
                    info.error = 0;
                    info.server_mask = 4;
                    info.options = 0;
                    info.status = 0;
                    ei.append(ea, info);
                    return info;
                }
                return null;
            }
        }
        if (info != null) {
            if (info.server_mask == 0) {
                return null;
            }
            if (info.server_mask == 2 && ea.device().startsWith("*")) {
                return null;
            }
            if (info.server_mask == 4 && ea.location().startsWith("*")) {
                return null;
            }
        }
        return info;
    }

    private void Tine_get_connect(EqAdr ea, EqData dataIn, EqData dataOut) {
        String cp = ea.property();
        if (cp.endsWith(".HIST") || cp.endsWith(".ARCH")) {
            this.Tine_getHist(cp, dataIn, dataOut, ea);
        } else {
            String adr = "/" + ea.facility() + "/" + ea.device() + "/" + ea.location();
            this.Tine_dout(adr, cp, dataIn, dataOut, ea);
        }
    }

    private EqDataBlock Tine_name_connect(EqAdr ea, ENSinfo info) {
        EqData ed = new EqData();
        int i1 = 0;
        float f1 = 0.0f;
        float f2 = 0.0f;
        time_t tm = new time_t(0);
        String cp = null;
        ENS_DB ei = new ENS_DB();
        if ("*".equals(ea.device())) {
            String[] qds = TQuery.getDeviceServers((String)ea.facility().trim());
            if ((debug & 2) != 0) {
                System.out.println("TQuery.getDeviceServers: " + ea.show_adr());
            }
            if (qds != null) {
                for (int i = 0; i < qds.length; ++i) {
                    ed.set(i1, f1, f2, tm, qds[i], i);
                }
            } else {
                ed.error(301, "no entries");
            }
            return ed.get_Block();
        }
        if ("*".equals(ea.location())) {
            String[] qds = TQuery.getDeviceNames((String)ea.facility().trim(), (String)ea.device().trim());
            if ((debug & 2) != 0) {
                System.out.println("TQuery.getDeviceNames: " + ea.show_adr());
            }
            if (qds != null) {
                for (int i = 0; i < qds.length; ++i) {
                    ed.set(i1, f1, f2, tm, qds[i], i);
                }
            } else {
                ed.error(301, "no entries");
            }
            return ed.get_Block();
        }
        if ("*".equals(ea.property())) {
            cp = "/" + ea.facility() + "/" + ea.device() + "/" + ea.location();
            try {
                TPropertyQuery[] gdp = TQuery.getPropertyInformation((String)ea.facility().trim(), (String)ea.device().trim(), (String)ea.location().trim(), (String)"*");
                if ((debug & 2) != 0) {
                    System.out.println("TQuery.getPropertyInformation: " + ea.show_adr());
                }
                for (int i = 0; i < gdp.length; ++i) {
                    cp = new String(gdp[i].prpName + " " + gdp[i].prpDescription);
                    ed.set(this.Tine_Doocs_type(gdp[i].prpFormat, gdp[i].prpSize), (float)gdp[i].prpFormat, (float)gdp[i].prpSize, tm, cp, i);
                }
                ei.append(ea.facility() + "/" + ea.device() + "/" + ea.location(), ed);
            }
            catch (Exception e) {
                ed.error(301, "no entries" + e.toString());
                return ed.get_Block();
            }
            return ed.get_Block();
        }
        ed.error(101, "ill. service");
        return ed.get_Block();
    }

    private void Tine_getHist(String cp, EqData dataIn, EqData dataOut, EqAdr ea) {
        double stop;
        double start;
        int length = dataOut.array_length();
        if (length < 10) {
            length = 1000;
        }
        FLTINT[] hst = new FLTINT[length];
        if (dataIn.type() == 18) {
            time_t[] tm = new time_t[2];
            int[] ii = new int[2];
            dataIn.get_ttii(tm, ii);
            start = tm[0].value;
            stop = tm[1].value;
        } else {
            stop = (double)System.currentTimeMillis() / 1000.0;
            start = stop - 86400.0;
        }
        THistorySource hsrc = new THistorySource();
        int cc = THistory.getArchivedData((String)ea.facility(), (String)ea.device(), (String)ea.property(), (String)ea.location(), (double)start, (double)stop, (FLTINT[])hst, (THistorySource)hsrc, (int)length);
        if (cc == 0) {
            time_t t = new time_t();
            u_char s = new u_char();
            if (hst[0] != null) {
                for (int i = 0; i < length; ++i) {
                    t.value = hst[i].ival;
                    s.value = 0;
                    dataOut.set(t, hst[i].fval, s, i);
                }
            } else {
                dataOut.error(100, "no data in time range");
            }
        } else {
            dataOut.error(cc, TErrorList.getErrorString((int)cc));
        }
    }

    private void Tine_dout(String adr, String cp, EqData dataIn, EqData dataOut, EqAdr ea) {
        boolean first;
        TDataType din = new TDataType();
        TLink dev = null;
        int cc = 0;
        TDataType dout = ea.tData;
        if (dout == null) {
            if (dataOut.type() != 0) {
                int l = dataOut.array_length();
                if (l < 1) {
                    l = ea.location().contains("*") ? 1000 : dataOut.length();
                }
                dout = new TDataType(l, this.convertDoocsToTineFormat(dataOut));
                first = false;
            } else {
                dout = new TDataType(64000, 254);
                first = true;
            }
            ea.tData = dout;
        } else {
            first = false;
        }
        dev = new TLink(adr, cp, dout, din, 1);
        cc = dev.execute(500, true);
        String errStr = dev.getError(cc);
        dev.cancel();
        if (cc != 0) {
            dataOut.error(cc, errStr);
            return;
        }
        EqCall.Tine2Doocs(dout, dataOut, first);
    }

    public static void Tine2Doocs(TDataType dout, EqData dataOut, boolean first) {
        time_t tm = new time_t(0);
        dataOut.set_time((int)(System.currentTimeMillis() / 1000L));
        short type = dout.getFormat();
        int Size = dout.getArrayLength();
        int lArray = dout.getCompletionLength();
        if (first && lArray == 0) {
            lArray = Size;
        }
        String str = dout.toString();
        switch (type) {
            case 0: {
                if (lArray <= 1) {
                    dataOut.set_type(6);
                    double[] fa = new double[1];
                    dout.getData(fa);
                    dataOut.set(fa[0]);
                } else {
                    double[] fa = new double[lArray];
                    dout.getData(fa);
                    if (dataOut.array_length() < lArray) {
                        dataOut.allocate_array(110, lArray, 0);
                    }
                    dataOut.set_type(100);
                    for (int i = 0; i < lArray; ++i) {
                        dataOut.set(fa[i], i);
                    }
                }
                return;
            }
            case 1: {
                if (lArray <= 1) {
                    dataOut.set_type(8);
                    short[] fa = new short[1];
                    dout.getData(fa);
                    dataOut.set(fa[0]);
                } else {
                    short[] fa = new short[lArray];
                    dout.getData(fa);
                    if (dataOut.array_length() < lArray) {
                        dataOut.allocate_array(115, lArray, 0);
                    }
                    for (int i = 0; i < lArray; ++i) {
                        dataOut.set(fa[i], i);
                    }
                }
                return;
            }
            case 2: {
                if (lArray <= 1) {
                    dataOut.set_type(1);
                    byte[] fa = new byte[1];
                    dout.getData(fa);
                    dataOut.set((int)fa[0]);
                } else {
                    byte[] fa = new byte[lArray];
                    dout.getData(fa);
                    if (dataOut.array_length() < lArray) {
                        dataOut.allocate_array(105, lArray, 0);
                    }
                    for (int i = 0; i < lArray; ++i) {
                        dataOut.set(fa[i], i);
                    }
                }
                return;
            }
            case 3: {
                if (lArray <= 1) {
                    dataOut.set_type(1);
                    int[] fa = new int[1];
                    dout.getData(fa);
                    dataOut.set(fa[0]);
                } else {
                    int[] fa = new int[lArray];
                    dout.getData(fa);
                    if (dataOut.array_length() < lArray) {
                        dataOut.allocate_array(105, lArray, 0);
                    }
                    for (int i = 0; i < lArray; ++i) {
                        dataOut.set(fa[i], i);
                    }
                }
                return;
            }
            case 19: {
                char[] fa = new char[lArray * 48];
                char[] cha = new char[48];
                dout.getData(fa);
                if (dataOut.array_length() < lArray) {
                    dataOut.allocate_array(103, lArray, 0);
                }
                for (int i = 0; i < lArray; ++i) {
                    System.arraycopy(fa, i * 48, cha, 0, 48);
                    dataOut.set(0, 0.0f, 0.0f, tm, new String(cha).trim(), i);
                }
                return;
            }
            case 9: {
                char[] fa = new char[lArray * 16];
                char[] cha = new char[16];
                dout.getData(fa);
                if (dataOut.array_length() < lArray) {
                    dataOut.allocate_array(113, lArray, 0);
                }
                for (int i = 0; i < lArray; ++i) {
                    System.arraycopy(fa, i * 16, cha, 0, 16);
                    dataOut.set(new String(cha).trim(), i);
                }
                return;
            }
            case 36: {
                char[] fa = new char[lArray * 64];
                char[] cha = new char[64];
                dout.getData(fa);
                if (dataOut.array_length() < lArray) {
                    dataOut.allocate_array(117, lArray, 0);
                }
                for (int i = 0; i < lArray; ++i) {
                    System.arraycopy(fa, i * 64, cha, 0, 64);
                    dataOut.set(new String(cha).trim(), i);
                }
                return;
            }
            case 8: {
                char[] fa = new char[lArray * 8];
                char[] cha = new char[8];
                dout.getData(fa);
                if (dataOut.array_length() < lArray) {
                    dataOut.allocate_array(103, lArray, 0);
                }
                for (int i = 0; i < lArray; ++i) {
                    System.arraycopy(fa, i * 8, cha, 0, 8);
                    if (lArray > 1) {
                        dataOut.set(0, 0.0f, 0.0f, tm, new String(cha).trim(), i);
                        continue;
                    }
                    dataOut.set(new String(cha).trim());
                }
                return;
            }
            case 13: {
                char[] fa = new char[lArray * 32];
                char[] cha = new char[32];
                dout.getData(fa);
                if (dataOut.array_length() < lArray) {
                    dataOut.allocate_array(118, lArray, 0);
                }
                for (int i = 0; i < lArray; ++i) {
                    System.arraycopy(fa, i * 32, cha, 0, 32);
                    dataOut.set(new String(cha).trim(), i);
                }
                return;
            }
            case 4: {
                String fa = dout.toString();
                if (dataOut.array_length() < lArray) {
                    dataOut.allocate_array(7, lArray, 0);
                }
                dataOut.set_text(fa);
                return;
            }
            case 10: {
                de.desy.tine.types.NAME16FI[] fa = new de.desy.tine.types.NAME16FI[lArray];
                dout.getData((TCompoundDataObject[])fa);
                if (dataOut.array_length() < lArray) {
                    dataOut.allocate_array(111, lArray, 0);
                }
                for (int i = 0; i < lArray; ++i) {
                    dataOut.set(fa[i].name.trim(), fa[i].fval, fa[i].ival, i);
                }
                return;
            }
            case 42: {
                de.desy.tine.types.NAME16II[] fa = new de.desy.tine.types.NAME16II[lArray];
                dout.getData((TCompoundDataObject[])fa);
                if (dataOut.array_length() < lArray) {
                    dataOut.allocate_array(112, lArray, 0);
                }
                for (int i = 0; i < lArray; ++i) {
                    dataOut.set(fa[i].name.trim(), fa[i].i1val, fa[i].i2val, i);
                }
                return;
            }
            case 5: {
                if (lArray <= 1) {
                    lArray = 1;
                }
                float[] fa = new float[lArray];
                dout.getData(fa);
                if (dataOut.array_length() < lArray) {
                    dataOut.allocate_array(100, lArray, 0);
                }
                for (int i = 0; i < lArray; ++i) {
                    dataOut.set(fa[i], i);
                }
                return;
            }
            case 14: {
                FLTINT[] fa = new FLTINT[lArray];
                dout.getData((TCompoundDataObject[])fa);
                if (dataOut.array_length() < lArray) {
                    dataOut.allocate_array(114, lArray, 0);
                }
                for (int i = 0; i < lArray; ++i) {
                    dataOut.set(fa[i].fval, fa[i].ival, i);
                }
                return;
            }
            case 29: {
                ADDRESS[] fa = new ADDRESS[lArray];
                dout.getData((TCompoundDataObject[])fa);
                dataOut.set(fa[0].i1val, fa[0].i2val, fa[0].i3val, fa[0].i4val);
                return;
            }
            case 15: {
                INTINT[] fa = new INTINT[lArray];
                dout.getData((TCompoundDataObject[])fa);
                if (dataOut.array_length() < lArray) {
                    dataOut.allocate_array(116, lArray, 0);
                }
                for (int i = 0; i < lArray; ++i) {
                    dataOut.set(fa[i].i1val, fa[i].i2val, i);
                }
                return;
            }
            case 16: {
                dataOut.error(101, "unspported type");
                return;
            }
            case 18: {
                TDS[] tdsa = new TDS[lArray];
                dout.getData((Object)tdsa);
                if (dataOut.array_length() < lArray) {
                    dataOut.allocate_array(101, lArray, 0);
                }
                for (int i = 0; i < lArray; ++i) {
                    dataOut.set(tdsa[i].tm, tdsa[i].data, tdsa[i].status, i);
                }
                return;
            }
            case 21: {
                dataOut.error(101, "unspported type");
                return;
            }
            case 22: {
                dataOut.error(101, "unspported type");
                return;
            }
            case 24: {
                USTRING[] ua = new USTRING[lArray];
                dout.getData((TCompoundDataObject[])ua);
                if (dataOut.array_length() < lArray) {
                    dataOut.allocate_array(103, lArray, 0);
                }
                for (int i = 0; i < lArray; ++i) {
                    if (ua[i].tm != 0) {
                        dataOut.set(ua[i].ival, ua[i].f1val, ua[i].f2val, new time_t(ua[i].tm), ua[i].str, i);
                        continue;
                    }
                    dataOut.set(ua[i].ival, ua[i].f1val, ua[i].f2val, new time_t(0), ua[i].str, i);
                }
                return;
            }
            case 28: {
                SPECTRUM fa = new SPECTRUM();
                dout.getData((Object)fa);
                dataOut.set(fa);
                return;
            }
            case 33: {
                if (lArray <= 1) {
                    dataOut.set_type(4);
                    byte[] fa = new byte[1];
                    dout.getData(fa);
                    dataOut.set_bool(fa[0]);
                } else {
                    byte[] fa = new byte[lArray];
                    dout.getData(fa);
                    if (dataOut.array_length() < lArray) {
                        dataOut.allocate_array(119, lArray, 0);
                    }
                    for (int i = 0; i < lArray; ++i) {
                        dataOut.set(fa[i], i);
                    }
                }
                return;
            }
            case 255: {
                dataOut.set_type(0);
                return;
            }
        }
        dataOut.error(101, "unspported type");
    }

    public short convertDoocsToTineFormat(EqData dataOut) {
        switch (dataOut.type()) {
            case 0: {
                return 255;
            }
            case 1: {
                return 3;
            }
            case 8: {
                return 1;
            }
            case 2: {
                return 5;
            }
            case 6: {
                return 0;
            }
            case 3: {
                return 4;
            }
            case 7: {
                return 4;
            }
            case 4: {
                return 33;
            }
            case 5: {
                return 9;
            }
            case 111: {
                return 10;
            }
            case 112: {
                return 42;
            }
            case 113: {
                return 9;
            }
            case 118: {
                return 13;
            }
            case 117: {
                return 36;
            }
            case 12: {
                return 18;
            }
            case 13: {
                return 31;
            }
            case 14: {
                return 29;
            }
            case 15: {
                return 27;
            }
            case 16: {
                return 24;
            }
            case 17: {
                return 26;
            }
            case 18: {
                return 30;
            }
            case 19: {
                return 28;
            }
            case 20: {
                return 47;
            }
            case 21: {
                return 27;
            }
            case 100: {
                return 5;
            }
            case 110: {
                return 0;
            }
            case 101: {
                return 18;
            }
            case 102: {
                return 31;
            }
            case 103: {
                return 24;
            }
            case 104: {
                return 26;
            }
            case 114: {
                return 14;
            }
            case 116: {
                return 15;
            }
            case 119: {
                return 33;
            }
            case 105: {
                return 3;
            }
            case 115: {
                return 1;
            }
            case 106: {
                return 4;
            }
            case 107: {
                return 32;
            }
            case 108: {
                return 27;
            }
            case 109: {
                return 5;
            }
        }
        return 255;
    }

    private void Tine_set_connect(EqAdr ea, EqData dataIn, EqData dataOut) {
        String cp = ea.property();
        String adr = "/" + ea.facility() + "/" + ea.device() + "/" + ea.location();
        this.Tine_din(adr, cp, dataIn, dataOut);
    }

    private void Tine_din(String adr, String cp, EqData dataIn, EqData dataOut) {
        TDataType dout = new TDataType();
        TDataType din = null;
        TLink dev = null;
        int cc = 0;
        switch (this.convertDoocsToTineFormat(dataIn)) {
            case 255: {
                din = new TDataType();
                break;
            }
            case 0: {
                int len = dataIn.length();
                Object[] b = new double[len];
                if (len == 1) {
                    b[0] = dataIn.get_double();
                } else {
                    for (int i = 0; i < len; ++i) {
                        b[i] = dataIn.get_double(i);
                    }
                }
                din = new TDataType(b);
                break;
            }
            case 1: {
                int len = dataIn.length();
                Object[] b = new short[len];
                if (len == 1) {
                    b[0] = (short)dataIn.get_int();
                } else {
                    for (int i = 0; i < len; ++i) {
                        b[i] = (short)dataIn.get_int(i);
                    }
                }
                din = new TDataType((short[])b);
                break;
            }
            case 33: {
                int len = dataIn.length();
                Object[] b = new int[len];
                if (len == 1) {
                    b[0] = dataIn.get_int();
                } else {
                    for (int i = 0; i < len; ++i) {
                        b[i] = dataIn.get_int(i);
                    }
                }
                din = new TDataType((int[])b);
                break;
            }
            case 2: {
                int len = dataIn.length();
                Object[] b = new byte[len];
                if (len == 1) {
                    b[0] = (byte)dataIn.get_int();
                } else {
                    for (int i = 0; i < len; ++i) {
                        b[i] = (byte)dataIn.get_int(i);
                    }
                }
                din = new TDataType((byte[])b);
                break;
            }
            case 3: {
                int len = dataIn.length();
                Object[] b = new int[len];
                if (len == 1) {
                    b[0] = dataIn.get_int();
                } else {
                    for (int i = 0; i < len; ++i) {
                        b[i] = dataIn.get_int(i);
                    }
                }
                din = new TDataType((int[])b);
                break;
            }
            case 4: {
                Object[] b;
                String str = dataIn.get_string_arg();
                int len = str.length();
                if (len > 0) {
                    b = new char[len];
                    for (int i = 0; i < len; ++i) {
                        b[i] = str.charAt(i);
                    }
                } else {
                    len = 1;
                    b = new char[1];
                }
                din = new TDataType((char[])b);
                break;
            }
            case 5: {
                int len = dataIn.length();
                Object[] b = new float[len];
                if (len == 1) {
                    b[0] = dataIn.get_float();
                } else {
                    for (int i = 0; i < len; ++i) {
                        b[i] = dataIn.get_float(i);
                    }
                }
                din = new TDataType((float[])b);
                break;
            }
            case 8: {
                int len = dataIn.length();
                Object[] b = new NAME8[len];
                if (len == 1) {
                    b[0] = (double)new NAME8(dataIn.get_string());
                    b[0].toName();
                } else {
                    for (int i = 0; i < len; ++i) {
                        b[i] = (double)new NAME8(dataIn.get_string_arg(i));
                        b[i].toName();
                    }
                }
                din = new TDataType((TCompoundDataObject[])b);
                break;
            }
            case 9: {
                Object[] b;
                int len = dataIn.array_length();
                if (len <= 1) {
                    b = new NAME16[1];
                    String str = dataIn.get_string();
                    b[0] = (double)new NAME16(str);
                } else {
                    b = new NAME16[len];
                    for (int i = 0; i < len; ++i) {
                        String str = dataIn.get_string_arg(i);
                        b[i] = (double)new NAME16(str);
                    }
                }
                din = new TDataType((TCompoundDataObject[])b);
                break;
            }
            case 13: {
                int len = dataIn.length();
                Object[] b = new NAME32[len];
                if (len == 1) {
                    b[0] = (double)new NAME32(dataIn.get_string());
                } else {
                    for (int i = 0; i < len; ++i) {
                        b[i] = (double)new NAME32(dataIn.get_string_arg(i));
                    }
                }
                din = new TDataType((TCompoundDataObject[])b);
                break;
            }
            case 36: {
                Object[] b;
                int len = dataIn.array_length();
                if (len <= 1) {
                    b = new NAME64[1];
                    String str = dataIn.get_string();
                    b[0] = (double)new NAME64(str);
                } else {
                    b = new NAME64[len];
                    for (int i = 0; i < len; ++i) {
                        String str = dataIn.get_string_arg(i);
                        b[i] = (double)new NAME64(str);
                    }
                }
                din = new TDataType((TCompoundDataObject[])b);
                break;
            }
            case 14: {
                int len = dataIn.length();
                FLTINT[] b = new FLTINT[len];
                for (int i = 0; i < len; ++i) {
                    FI fi = dataIn.get_fi(i);
                    b[i] = new FLTINT(fi.f_data, fi.i_data);
                }
                din = new TDataType((TCompoundDataObject[])b);
                break;
            }
            case 15: {
                int len = dataIn.length();
                LNGINT[] b = new LNGINT[len];
                for (int i = 0; i < len; ++i) {
                    II ii = dataIn.get_ii(i);
                    b[i] = new LNGINT(ii.i1_data, ii.i2_data);
                }
                din = new TDataType((TCompoundDataObject[])b);
                break;
            }
            case 16: {
                FIS fis;
                int len = dataIn.length();
                DBLINT[] db = new DBLINT[len];
                if (len == 1) {
                    fis = dataIn.get_fis();
                    db[0] = new DBLINT((double)fis.f_data, fis.i_data);
                } else {
                    for (int i = 0; i < len; ++i) {
                        fis = dataIn.get_fis(i);
                        db[i] = new DBLINT((double)fis.f_data, fis.i_data);
                    }
                }
                din = new TDataType((TCompoundDataObject[])db);
                break;
            }
            case 18: {
                TDS tds;
                int len = dataIn.length();
                de.desy.tine.types.TDS[] b = new de.desy.tine.types.TDS[len];
                if (len == 1) {
                    tds = dataIn.get_tds();
                    b[0] = new de.desy.tine.types.TDS(tds.data, tds.tm.value, (int)tds.status.value);
                    b[0].toStruct();
                } else {
                    for (int i = 0; i < len; ++i) {
                        tds = dataIn.get_tds(i);
                        b[i] = new de.desy.tine.types.TDS(tds.data, tds.tm.value, (int)tds.status.value);
                        b[i].toStruct();
                    }
                }
                din = new TDataType((TCompoundDataObject[])b);
                break;
            }
            case 19: {
                int len = dataIn.length();
                Object[] b = new NAME48[len];
                if (len == 1) {
                    b[0] = (double)new NAME48(dataIn.get_string());
                    b[0].toName();
                } else {
                    for (int i = 0; i < len; ++i) {
                        b[i] = (double)new NAME48(dataIn.get_string_arg(i));
                        b[i].toName();
                    }
                }
                din = new TDataType((TCompoundDataObject[])b);
                break;
            }
            case 21: {
                USTR us;
                int len = dataIn.length();
                NAME16I[] b = new NAME16I[len];
                if (len == 1) {
                    us = dataIn.get_ustr(0);
                    b[0] = new NAME16I(dataIn.get_string(), us.i1_data);
                    b[0].toStruct();
                } else {
                    for (int i = 0; i < len; ++i) {
                        us = dataIn.get_ustr(i);
                        b[i] = new NAME16I(dataIn.get_string_arg(i), us.i1_data);
                        b[i].toStruct();
                    }
                }
                din = new TDataType((TCompoundDataObject[])b);
                break;
            }
            case 42: {
                int len = dataIn.length();
                de.desy.tine.types.NAME16II[] b = new de.desy.tine.types.NAME16II[len];
                NAME16II[] n16ii = dataIn.get_name16ii();
                for (int i = 0; i < len; ++i) {
                    b[i] = new de.desy.tine.types.NAME16II(dataIn.get_string_arg(i), n16ii[i].i1_data, n16ii[i].i2_data);
                }
                din = new TDataType((TCompoundDataObject[])b);
                break;
            }
            case 10: {
                int len = dataIn.length();
                de.desy.tine.types.NAME16FI[] b = new de.desy.tine.types.NAME16FI[len];
                NAME16FI[] n16fi = dataIn.get_name16fi();
                for (int i = 0; i < len; ++i) {
                    b[i] = new de.desy.tine.types.NAME16FI(dataIn.get_string_arg(i), n16fi[i].f_data, n16fi[i].i_data);
                }
                din = new TDataType((TCompoundDataObject[])b);
                break;
            }
            case 22: {
                USTR us;
                int len = dataIn.length();
                NAME32I[] b = new NAME32I[len];
                if (len == 1) {
                    us = dataIn.get_ustr(0);
                    b[0] = new NAME32I(dataIn.get_string(), us.i1_data);
                } else {
                    for (int i = 0; i < len; ++i) {
                        us = dataIn.get_ustr(i);
                        b[i] = new NAME32I(dataIn.get_string_arg(i), us.i1_data);
                    }
                }
                din = new TDataType((TCompoundDataObject[])b);
                break;
            }
            case 24: {
                USTR us;
                int len = dataIn.length();
                USTRING[] b = new USTRING[len];
                if (len == 1) {
                    us = dataIn.get_ustr(0);
                    if (us == null || us.str_data == null) {
                        dataOut.error(101, "set: Bad CF_USTRING in input data");
                    }
                    b[0] = new USTRING(us.i1_data, us.f1_data, us.f2_data, us.tm.value, dataIn.get_string_arg());
                } else {
                    for (int i = 0; i < len; ++i) {
                        us = dataIn.get_ustr(i);
                        b[i] = new USTRING(us.i1_data, us.f1_data, us.f2_data, us.tm.value, dataIn.get_string_arg(i));
                    }
                }
                din = new TDataType((TCompoundDataObject[])b);
                break;
            }
            case 28: {
                SPECTRUM sp = dataIn.get_spectrum();
                de.desy.tine.types.SPECTRUM b = new de.desy.tine.types.SPECTRUM();
                b.comment = new String(sp.comment).trim();
                b.tm = sp.tm.value;
                b.s_start = sp.s_start;
                b.s_inc = sp.s_inc;
                b.status = sp.status;
                b.d_spect_array = sp.d_spect_array;
                b.length = sp.d_spect_array.length;
                b.toStruct();
                din = new TDataType(b);
                break;
            }
            default: {
                dataOut.error(101, "unspported data type");
                return;
            }
        }
        dev = new TLink(adr, cp, dout, din, 2);
        cc = dev.execute(3000);
        if (!this.error(cc, false)) {
            if (dev != null) {
                String errStr = dev.getError(cc);
                dataOut.error(cc, errStr);
            } else {
                dataOut.error(101, "unspported type");
            }
        }
        dev.cancel();
    }

    private boolean error(int cc, boolean get) {
        if (get) {
            if (cc == 0) {
                return true;
            }
            if (cc == 2) {
                return true;
            }
            if (cc == 36) {
                return true;
            }
            if (cc == 38) {
                return true;
            }
        } else {
            if (cc == 0) {
                return true;
            }
            if (cc == -141) {
                return true;
            }
        }
        return false;
    }

    private int Tine_Doocs_type(int type, int Size) {
        switch (type) {
            case 0: {
                if (Size == 1) {
                    return 2;
                }
                return 100;
            }
            case 1: {
                if (Size == 1) {
                    return 8;
                }
                return 115;
            }
            case 2: {
                if (Size == 1) {
                    return 1;
                }
                return 105;
            }
            case 3: {
                if (Size == 1) {
                    return 1;
                }
                return 105;
            }
            case 4: {
                return 7;
            }
            case 19: {
                if (Size == 1) {
                    return 3;
                }
                return 103;
            }
            case 5: {
                if (Size == 1) {
                    return 2;
                }
                return 100;
            }
            case 8: 
            case 9: {
                return 113;
            }
            case 13: {
                return 118;
            }
            case 36: {
                return 117;
            }
            case 11: {
                if (Size == 1) {
                    return 4;
                }
                return 119;
            }
            case 14: {
                return 114;
            }
            case 15: {
                return 116;
            }
            case 16: {
                if (Size == 1) {
                    return 17;
                }
                return 104;
            }
            case 18: {
                if (Size == 1) {
                    return 12;
                }
                return 101;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return 103;
            }
            case 25: {
                if (Size == 1) {
                    return 13;
                }
                return 102;
            }
            case 26: {
                if (Size == 1) {
                    return 17;
                }
                return 104;
            }
            case 27: {
                return 15;
            }
            case 28: {
                return 19;
            }
            case 29: {
                if (Size == 1) {
                    return 14;
                }
                return 14;
            }
            case 30: {
                if (Size == 1) {
                    return 18;
                }
                return 18;
            }
            case 31: {
                if (Size == 1) {
                    return 13;
                }
                return 102;
            }
            case 32: {
                if (Size == 1) {
                    return 107;
                }
                return 107;
            }
            case 33: {
                if (Size == 1) {
                    return 4;
                }
                return 119;
            }
            case 34: {
                if (Size == 1) {
                    return 15;
                }
                return 15;
            }
            case 254: {
                if (Size == 1) {
                    return 0;
                }
                return 0;
            }
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    private void Epics_get_connect(EqAdr adr, String channel_name, EqData dataIn, EqData dataOut) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Epics_set_connect(EqAdr adr, String channel_name, EqData dataIn, EqData dataOut) {
        Channel channel = null;
        String err_msg = new String();
        if (context == null) {
            EqCall.createContext(adr);
        }
        try {
            channel = context.createChannel(channel_name);
            context.pendIO(0.2);
            switch (dataIn.type()) {
                case 3: 
                case 5: {
                    channel.put(dataIn.get_string_arg());
                    break;
                }
                case 8: {
                    channel.put((short)dataIn.get_int());
                    break;
                }
                case 115: {
                    short[] sh_buf = new short[dataIn.array_length()];
                    for (int i = 0; i < sh_buf.length; ++i) {
                        sh_buf[i] = (short)dataIn.get_int(i);
                    }
                    channel.put(sh_buf);
                    break;
                }
                case 1: {
                    channel.put(dataIn.get_int());
                    break;
                }
                case 105: {
                    int[] i_buf = new int[dataIn.array_length()];
                    for (int i = 0; i < i_buf.length; ++i) {
                        i_buf[i] = dataIn.get_int(i);
                    }
                    channel.put(i_buf);
                    break;
                }
                case 2: {
                    channel.put(dataIn.get_float());
                    break;
                }
                case 100: {
                    float[] f_buf = new float[dataIn.array_length()];
                    for (int i = 0; i < f_buf.length; ++i) {
                        f_buf[i] = dataIn.get_float(i);
                    }
                    channel.put(f_buf);
                    break;
                }
                case 6: {
                    channel.put(dataIn.get_double());
                    break;
                }
                case 110: {
                    double[] d_buf = new double[dataIn.array_length()];
                    for (int i = 0; i < d_buf.length; ++i) {
                        d_buf[i] = dataIn.get_double(i);
                    }
                    channel.put(d_buf);
                    break;
                }
                default: {
                    dataOut.error(101, "unspported data type");
                }
            }
            context.pendIO(0.2);
        }
        catch (CAException exp) {
            err_msg = exp.getMessage();
        }
        catch (TimeoutException exp) {
            err_msg = exp.getMessage();
        }
        catch (IllegalStateException exp) {
            err_msg = exp.getMessage();
        }
        finally {
            if (!err_msg.isEmpty()) {
                dataOut.error(106, "EPICS_ERROR: " + err_msg);
            }
            if (channel != null) {
                try {
                    channel.destroy();
                    context.flushIO();
                }
                catch (CAException ex) {
                    System.out.println(ex.getMessage());
                }
            }
        }
    }

    public static void Epics2Doocs(EqData dataOut, DBR dbr) {
        DBRType type = dbr.getType();
        int size = dbr.getCount();
        Object obj = dbr.getValue();
        if (type.isDOUBLE()) {
            double[] data = (double[])obj;
            if (size == 1) {
                dataOut.set_type(6);
                dataOut.set(data[0]);
            } else {
                dataOut.set_type(110);
                for (int i = 0; i < data.length; ++i) {
                    dataOut.set(data[i], i);
                }
            }
        } else if (type.isFLOAT()) {
            float[] data = (float[])obj;
            if (size == 1) {
                dataOut.set_type(2);
                dataOut.set(data[0]);
            } else {
                dataOut.set_type(100);
                for (int i = 0; i < data.length; ++i) {
                    dataOut.set(data[i], i);
                }
            }
        } else if (type.isSTRING()) {
            String[] str = (String[])obj;
            dataOut.set_type(3);
            dataOut.set(str[0]);
        } else if (type.isINT()) {
            int[] data = (int[])obj;
            if (size == 1) {
                dataOut.set_type(1);
                dataOut.set(data[0]);
            } else {
                dataOut.set_type(105);
                for (int i = 0; i < data.length; ++i) {
                    dataOut.set(data[i], i);
                }
            }
        } else if (type.isSHORT() || type.isENUM()) {
            short[] data = (short[])obj;
            if (size == 1) {
                dataOut.set_type(8);
                dataOut.set(data[0]);
            } else {
                dataOut.set_type(115);
                for (int i = 0; i < data.length; ++i) {
                    dataOut.set(data[i], i);
                }
            }
        } else if (type.isBYTE()) {
            dataOut.set_type(106);
            byte[] data = (byte[])dbr.getValue();
            for (int i = 0; i < data.length; ++i) {
                dataOut.set(data[i], i);
            }
        } else {
            dataOut.set_type(0);
            dataOut.error(101, "unspported type");
        }
    }

    public static void createContext(EqAdr adr) {
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        DefaultConfiguration conf = new DefaultConfiguration("myContext");
        context = new CAJContext();
        String epics_addr_list = System.getProperty("EPICS_CA_ADDR_LIST");
        if (adr.host().length() > 3) {
            epics_addr_list = adr.host();
        }
        if (epics_addr_list == null) {
            InputStream is = ClassLoader.getSystemResourceAsStream("JCALibrary.properties");
            if (is == null) {
                System.out.println("Unable to load default configuration located in 'JCALibrary.properties' resource: ");
            } else {
                try {
                    try {
                        context.configure(builder.build(is));
                    }
                    catch (SAXException ex) {
                        System.out.println("configuration error");
                    }
                    catch (IOException ex) {
                        System.out.println("configuration error");
                    }
                }
                catch (ConfigurationException ex) {
                    System.out.println("configuration error");
                }
            }
        } else {
            conf.setAttribute("addr_list", epics_addr_list);
            try {
                context.configure((Configuration)conf);
            }
            catch (ConfigurationException ex) {
                System.out.println("configuration error");
            }
        }
    }

    static {
        retryDelay = 30000L;
        debug = 0;
        TIMEOUT = 1500;
        context = null;
    }
}

