/*
 * Decompiled with CFR 0.152.
 */
package tangoatk.jddd.utils;

import DOOCSComponents.ShowException;
import editor.IAddrEditor;
import fr.esrf.tangoatk.widget.util.DeviceFinder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.security.AccessControlException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class TangoAddrEditor
extends JDialog
implements IAddrEditor {
    private DeviceFinder treeView;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JCheckBox protocol;
    private JCheckBox tango_host;
    private JCheckBox domain;
    private JCheckBox family;
    private JCheckBox member;
    private JCheckBox prop;
    private ButtonGroup group;
    private JScrollPane jScrollPane1;
    private String tangoHost = null;
    private JButton jButtonOK;
    private JButton jButtonCancel;
    private ActionListener al = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            String btext = ((JRadioButton)e.getSource()).getText();
            int browsing = 1;
            if (btext.equalsIgnoreCase("device")) {
                browsing = 0;
            }
            if (btext.equalsIgnoreCase("attribute")) {
                browsing = 1;
            }
            if (btext.equalsIgnoreCase("command")) {
                browsing = 2;
            }
            TangoAddrEditor.this.treeView = new DeviceFinder(browsing);
            TangoAddrEditor.this.jScrollPane1.setViewportView((Component)TangoAddrEditor.this.treeView);
        }
    };

    public TangoAddrEditor() {
        try {
            this.tangoHost = System.getProperty("TANGO_HOST", "null");
            System.out.println("TANGO_HOST = " + this.tangoHost);
            if (this.tangoHost == null || this.tangoHost.equalsIgnoreCase("null") || this.tangoHost.length() == 0) {
                this.setTangoHost();
            }
        }
        catch (AccessControlException ace) {
            new ShowException(null, "TangoAddrEditor", (Object)(ace + "\nTo solve this problem, " + "you have to modify your Java policy file as described here:" + "\nhttps://doc.desy.de/elog/servlet/XMLlist?file=/DOOCS-public/data/jddd/FAQ&xsl=/elogbook/xsl/wiki.xsl&picture=true#2008-09-30T09:11:23"));
            System.exit(0);
        }
        this.initComponents();
        String title = "Tango Attribute Chooser [" + this.tangoHost + "]";
        this.setTitle(title);
    }

    public String getAddr() {
        String[] temp = this.treeView.getSelectedNames();
        if (temp.length > 0) {
            temp = temp[0].split("/");
            StringBuffer buf = new StringBuffer("");
            if (this.protocol.isSelected()) {
                buf.append("tango:");
            }
            String th = "//" + this.tangoHost + "/";
            if (this.tango_host.isSelected()) {
                buf.append(th);
            }
            for (int i = 0; i < 4; ++i) {
                if (i == 0 && temp.length > 0 && this.domain.isSelected()) {
                    buf.append(temp[i]);
                }
                if (i == 1 && temp.length > 1 && this.family.isSelected()) {
                    buf.append(temp[i]);
                }
                if (i == 2 && temp.length > 2 && this.member.isSelected()) {
                    buf.append(temp[i]);
                }
                if (i == 3 && temp.length > 3 && this.prop.isSelected()) {
                    buf.append(temp[i]);
                }
                if (i >= 3) continue;
                buf.append("/");
            }
            return buf.toString();
        }
        return null;
    }

    public String getTextFieldAddr() {
        return this.getAddr();
    }

    public void setAddr(String addr) {
    }

    public void addMouseListener(MouseListener ml) {
        this.treeView.addMouseListener(ml);
    }

    public void addActionListener(ActionListener al) {
        this.jButtonCancel.addActionListener(al);
        this.jButtonOK.addActionListener(al);
    }

    private void initComponents() {
        this.getContentPane().removeAll();
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane1.setPreferredSize(new Dimension(300, 400));
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.treeView = new DeviceFinder(1);
        JLabel l = new JLabel("Browse for : ");
        this.jPanel2.add(l);
        this.group = new ButtonGroup();
        JRadioButton option = new JRadioButton("device", false);
        option.addActionListener(this.al);
        this.group.add(option);
        this.jPanel2.add(option);
        option = new JRadioButton("attribute", true);
        option.addActionListener(this.al);
        this.group.add(option);
        this.jPanel2.add(option);
        option = new JRadioButton("command", false);
        option.addActionListener(this.al);
        this.group.add(option);
        this.jPanel2.add(option);
        this.getContentPane().add((Component)this.jPanel2, "First");
        this.jPanel1.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.protocol = new JCheckBox("tango:", true);
        this.tango_host = new JCheckBox("TANGO_HOST", false);
        this.domain = new JCheckBox("domain", true);
        this.family = new JCheckBox("family", true);
        this.member = new JCheckBox("member", true);
        this.prop = new JCheckBox("prop", true);
        JLabel t = new JLabel("Choose name fields for selection : ");
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 4;
        c.insets = new Insets(10, 0, 5, 0);
        this.jPanel1.add((Component)t, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.jPanel1.add((Component)this.protocol, c);
        c.gridx = 1;
        c.gridy = 1;
        this.jPanel1.add((Component)this.tango_host, c);
        c.gridx = 0;
        c.gridy = 2;
        this.jPanel1.add((Component)this.domain, c);
        c.gridx = 1;
        c.gridy = 2;
        this.jPanel1.add((Component)this.family, c);
        c.gridx = 2;
        c.gridy = 2;
        this.jPanel1.add((Component)this.member, c);
        c.gridx = 3;
        c.gridy = 2;
        this.jPanel1.add((Component)this.prop, c);
        this.jScrollPane1.setViewportView((Component)this.treeView);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK.setText("OK");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        c.insets = new Insets(10, 10, 10, 10);
        c.ipadx = 10;
        c.gridx = 1;
        c.gridy = 3;
        this.jPanel1.add((Component)this.jButtonOK, c);
        this.jButtonCancel.setText("Cancel");
        c.gridx = 2;
        c.gridy = 3;
        this.jPanel1.add((Component)this.jButtonCancel, c);
        this.getContentPane().add((Component)this.jPanel1, "Last");
        this.pack();
    }

    private void setTangoHost() {
        String th = null;
        while (true) {
            String[] ths;
            if ((th = JOptionPane.showInputDialog(this, "\n\n\nYour Tango host variable is not defined yet\nYou have to specify a valid Tango host\nin the form hostname:port (ex gizmo:20000)\n\nPlease enter a valid Tango host:\n\n", "Jddd for Tango", 3)) == null || (ths = th.split(":")).length != 2) {
                continue;
            }
            try {
                Integer.parseInt(ths[1]);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            break;
        }
        this.tangoHost = th;
        System.setProperty("TANGO_HOST", this.tangoHost);
    }
}

