/*
 * Decompiled with CFR 0.152.
 */
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSPlugin;
import TangoComponents.ITangoComponent;
import TangoComponents.ITangoErrorHistory;
import editor.undo.SetProperty;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.widget.attribute.NumberImageViewer;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.event.MouseInputListener;
import tangoatk.jddd.utils.TangoErrorHistory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOOCSTangoNumberImageViewer
extends NumberImageViewer
implements ITangoComponent,
DOOCSPlugin {
    private String doocsToolTipText = null;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private String doocsAddress = null;
    private String fullDoocsAddress = null;
    private AttributeList list;
    private String valid_tango_address = null;
    private double refresh_rate = 1.0;
    private boolean toolbar = true;
    private boolean statusLine = true;
    private boolean gradient = true;
    private boolean bestFit = true;
    private String config_file = null;
    private String scaling = "automatic";
    private int zoom_val = 1;

    public DOOCSTangoNumberImageViewer() {
        this.setPreferredSize(new Dimension(400, 300));
        this.setSize(new Dimension(400, 300));
        this.list = new AttributeList();
    }

    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        if (bRun) {
            this.list.setRefreshInterval((int)(this.refresh_rate * 1000.0));
            this.list.startRefresher();
        } else {
            this.list.stopRefresher();
        }
    }

    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    public void setFullDoocsAddress(String address) {
        try {
            if (address != null) {
                if (this.valid_tango_address != null) {
                    this.list.remove(this.valid_tango_address);
                }
                this.setModel((INumberImage)this.list.add(address));
                this.valid_tango_address = address;
            }
        }
        catch (ConnectionException ex) {
            Logger.getLogger(DOOCSTangoNumberImageViewer.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.fullDoocsAddress = address;
    }

    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    public void setDoocsAddress(String address) {
        try {
            if (address != null) {
                if (this.valid_tango_address != null) {
                    this.list.remove(this.valid_tango_address);
                }
                this.setModel((INumberImage)this.list.add(address));
                this.valid_tango_address = address;
            }
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    public ImageIcon getIcon() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("icons/NumberImageViewer.gif"));
    }

    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    public void setDnDText(String str) {
    }

    public String getDnDText() {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }

    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL, "The full Tango attribute name"), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL, "Set the refresh rate for the widget in seconds"), new DOOCSParameter("scaling", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL, "The image scaling in % of the origninal image"), new DOOCSParameter("bestFit", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL, "Enable the best fit for image viewing"), new DOOCSParameter("toolbar", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL, "Enable the toolbar for the image viewer"), new DOOCSParameter("gradient", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL, "Enable the color gradient display for the image viewer"), new DOOCSParameter("statusLine", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL, "Enable the status line for the image viewer"), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE, "Tooltip")};
        return parameters;
    }

    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("scaling")) {
            String[] allowedValues = new String[]{"automatic", "800%", "400%", "200%", "100%", "50%", "25%", "12.5%"};
            return allowedValues;
        }
        String[] allowedValues = new String[]{"ill.ParameterName"};
        return allowedValues;
    }

    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSTangoNumberImageViewer ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct((String)this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds((Rectangle)this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct((String)this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSTangoNumberImageViewer>\n");
        return xmlStructure;
    }

    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setUpdateTime(Double.parseDouble(value));
        } else if (parameter.equalsIgnoreCase("scaling")) {
            this.setScaling(value);
        } else if (parameter.equalsIgnoreCase("bestFit")) {
            this.setBestFit(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("toolbar")) {
            this.setToolbar(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("gradient")) {
            this.setColorGradient(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("statusLine")) {
            this.setStatusLine(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds((String)value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize((String)value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSOval.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return this.getUpdateTime();
        }
        if (parameter.equalsIgnoreCase("scaling")) {
            return this.getScaling();
        }
        if (parameter.equalsIgnoreCase("bestFit")) {
            return this.getBestFit();
        }
        if (parameter.equalsIgnoreCase("toolbar")) {
            return this.getToolbar();
        }
        if (parameter.equalsIgnoreCase("gradient")) {
            return this.getColorGradient();
        }
        if (parameter.equalsIgnoreCase("statusLine")) {
            return this.getStatusLine();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds((Rectangle)this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize((Dimension)this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSOval.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    public void addTangoErrorListener(ITangoErrorHistory eh) {
        this.list.addErrorListener((IErrorListener)((TangoErrorHistory)eh).getErrorListener());
    }

    public void setUpdateTime(double up) {
        this.refresh_rate = up;
    }

    public double getUpdateTime() {
        return this.refresh_rate;
    }

    public void setScaling(String s) {
        this.scaling = s;
        if (this.scaling.equalsIgnoreCase("automatic")) {
            this.setAutoZoom(true);
            this.list.refresh();
            return;
        }
        if (this.scaling.equalsIgnoreCase("800%")) {
            this.zoom_val = 0;
        } else if (this.scaling.equalsIgnoreCase("400%")) {
            this.zoom_val = 1;
        } else if (this.scaling.equalsIgnoreCase("200%")) {
            this.zoom_val = 2;
        } else if (this.scaling.equalsIgnoreCase("100%")) {
            this.zoom_val = 3;
        } else if (this.scaling.equalsIgnoreCase("50%")) {
            this.zoom_val = 4;
        } else if (this.scaling.equalsIgnoreCase("25%")) {
            this.zoom_val = 5;
        } else if (this.scaling.equalsIgnoreCase("12.5%")) {
            this.zoom_val = 6;
        }
        this.setAutoZoom(false);
        this.setZoom(this.zoom_val);
        this.list.refresh();
    }

    public String getScaling() {
        return this.scaling;
    }

    public void setBestFit(boolean b) {
        this.bestFit = b;
        super.setBestFit(this.bestFit);
    }

    public boolean getBestFit() {
        return this.bestFit;
    }

    public void setToolbar(boolean tbar) {
        this.toolbar = tbar;
        this.setToolbarVisible(this.toolbar);
    }

    public boolean getToolbar() {
        return this.toolbar;
    }

    public void setColorGradient(boolean g) {
        this.gradient = g;
        this.setGradientVisible(this.gradient);
    }

    public boolean getColorGradient() {
        return this.gradient;
    }

    public void setStatusLine(boolean s) {
        this.statusLine = s;
        this.setStatusLineVisible(this.statusLine);
    }

    public boolean getStatusLine() {
        return this.statusLine;
    }
}

