/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.xmlUtils;

import de.desy.tine.server.logger.MsgLog;
import de.desy.tine.xmlUtils.AlarmCfg;
import de.desy.tine.xmlUtils.HistoryCfg;
import de.desy.tine.xmlUtils.TineConfigItem;
import de.desy.tine.xmlUtils.ValidatedFormat;
import de.desy.tine.xmlUtils.ValidatedInt;
import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyCfg
extends TineConfigItem {
    private String name = new String("");
    private LinkedList<String> devices = new LinkedList();
    private String egu = new String("");
    private String xEgu = new String("");
    private ValidatedInt max = new ValidatedInt();
    private ValidatedInt min = new ValidatedInt();
    private ValidatedInt xmax = new ValidatedInt();
    private ValidatedInt xmin = new ValidatedInt();
    private ValidatedInt id = new ValidatedInt();
    private String description = new String("");
    private ValidatedInt sizeIn = new ValidatedInt();
    private ValidatedInt dTypeIn = new ValidatedInt();
    private ValidatedInt sizeOut = new ValidatedInt();
    private ValidatedInt dTypeOut = new ValidatedInt();
    private ValidatedInt access = new ValidatedInt();
    private String dTagIn = new String("");
    private String dTagOut = new String("");
    private int dArrayTypeOut = 0;
    private String redirection = new String("");
    private AlarmCfg alarm = new AlarmCfg("ALARM");
    private HistoryCfg history = new HistoryCfg("HISTORY");

    public PropertyCfg(String name) {
        super(name);
    }

    public ValidatedInt getAccess() {
        return this.access;
    }

    public AlarmCfg getAlarm() {
        return this.alarm;
    }

    public ValidatedInt getDTypeIn() {
        return this.dTypeIn;
    }

    public ValidatedInt getDTypeOut() {
        return this.dTypeOut;
    }

    public String getDescription() {
        return this.description;
    }

    public LinkedList<String> getDevices() {
        return this.devices;
    }

    public String getEgu() {
        return this.egu;
    }

    public HistoryCfg getHistory() {
        return this.history;
    }

    public ValidatedInt getId() {
        return this.id;
    }

    public ValidatedInt getMax() {
        return this.max;
    }

    public ValidatedInt getMin() {
        return this.min;
    }

    public String getName() {
        return this.name;
    }

    public String getRedirection() {
        return this.redirection;
    }

    public ValidatedInt getSizeIn() {
        return this.sizeIn;
    }

    public ValidatedInt getSizeOut() {
        return this.sizeOut;
    }

    public String getXEgu() {
        return this.xEgu;
    }

    public ValidatedInt getXmax() {
        return this.xmax;
    }

    public ValidatedInt getXmin() {
        return this.xmin;
    }

    public void setAccess(ValidatedInt access) {
        this.access = access;
    }

    public void setAlarm(AlarmCfg alarm) {
        this.alarm = alarm;
    }

    public void setDTypeIn(ValidatedInt dTypeIn) {
        this.dTypeIn = dTypeIn;
    }

    public void setDTypeOut(ValidatedInt dTypeOut) {
        this.dTypeOut = dTypeOut;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDevices(LinkedList<String> devices) {
        this.devices = devices;
    }

    public void setEgu(String egu) {
        this.egu = egu;
    }

    public void setHistory(HistoryCfg history) {
        this.history = history;
    }

    public void setId(ValidatedInt id) {
        this.id = id;
    }

    public void setMax(ValidatedInt max) {
        this.max = max;
    }

    public void setMin(ValidatedInt min) {
        this.min = min;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRedirection(String redirection) {
        this.redirection = redirection;
    }

    public void setSizeIn(ValidatedInt sizeIn) {
        this.sizeIn = sizeIn;
    }

    public void setSizeOut(ValidatedInt sizeOut) {
        this.sizeOut = sizeOut;
    }

    public void setXEgu(String xEgu) {
        this.xEgu = xEgu;
    }

    public void setXmax(ValidatedInt xmax) {
        this.xmax = xmax;
    }

    public void setXmin(ValidatedInt xmin) {
        this.xmin = xmin;
    }

    @Override
    void dump(int margin) {
        String m = new String("");
        for (int i = 0; i < margin; ++i) {
            m = m + " ";
        }
        System.out.println(m + "Name = " + this.getName());
        System.out.println(m + "Device set");
        for (String s : this.devices) {
            System.out.println(m + "  " + s);
        }
        System.out.println(m + "Egu = " + this.getEgu());
        System.out.println(m + "Xegu = " + this.getXEgu());
        System.out.println(m + "Max = " + this.getMax());
        System.out.println(m + "Min = " + this.getMin());
        System.out.println(m + "xMax = " + this.getXmax());
        System.out.println(m + "xMin = " + this.getXmin());
        System.out.println(m + "Id = " + this.getId());
        System.out.println(m + "Description = " + this.getDescription());
        System.out.println(m + "SizeIn = " + this.getSizeIn());
        System.out.println(m + "DtypeIn = " + this.getDTypeIn());
        System.out.println(m + "SizeOut = " + this.getSizeOut());
        System.out.println(m + "DtypeOut = " + this.getDTypeOut());
        System.out.println(m + "Access = " + this.getAccess());
        System.out.println(m + "Redirection = " + this.getRedirection());
        System.out.println(m + "ALARM:");
        AlarmCfg ac = this.getAlarm();
        if (ac != null) {
            ac.dump(margin + 3);
        }
        System.out.println(m + "HISTORY:");
        HistoryCfg hc = this.getHistory();
        if (hc != null) {
            hc.dump(margin + 3);
        }
    }

    @Override
    void parse(Element root) {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            ValidatedFormat vf;
            Element childElement;
            Text textNode;
            Node child = children.item(i);
            if (!(child instanceof Element) || (textNode = (Text)(childElement = (Element)child).getFirstChild()) == null) continue;
            String text = textNode.getData().trim();
            if (childElement.getTagName().equalsIgnoreCase("NAME")) {
                this.setName(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("DEVICE_SET")) {
                this.devices.add(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("EGU")) {
                this.setEgu(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("XEGU")) {
                this.setXEgu(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("MAX")) {
                this.setMax(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("MIN")) {
                this.setMin(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("XMAX")) {
                this.setXmax(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("XMIN")) {
                this.setXmin(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("ID")) {
                this.setId(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("DESCRIPTION")) {
                this.setDescription(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("SIZE_IN")) {
                this.setSizeIn(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("DTYPE_IN")) {
                vf = ValidatedFormat.parse(text);
                this.setDTypeIn(vf.getFormat());
                this.setDTagIn(vf.getTag());
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("SIZE_OUT")) {
                this.setSizeOut(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("DTYPE_OUT")) {
                vf = ValidatedFormat.parse(text);
                this.setDTypeOut(vf.getFormat());
                this.setDTagOut(vf.getTag());
                this.setDArrayTypeOut(vf.getArrayType());
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("ACCESS")) {
                this.setAccess(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("REDIRECTION")) {
                this.setRedirection(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("ALARM")) {
                AlarmCfg ac = new AlarmCfg("ALARM");
                this.setAlarm(ac);
                ac.parse(childElement);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("HISTORY")) {
                HistoryCfg hc = new HistoryCfg("HISTORY");
                this.setHistory(hc);
                hc.parse(childElement);
                continue;
            }
            MsgLog.log("PropertyCfg", "-WARNING: unsupported tag: " + childElement.getTagName(), 136, null, 0);
        }
    }

    public int getDArrayTypeOut() {
        return this.dArrayTypeOut;
    }

    public void setDArrayTypeOut(int arrayTypeOut) {
        this.dArrayTypeOut = arrayTypeOut;
    }

    public String getDTagIn() {
        return this.dTagIn;
    }

    public void setDTagIn(String tagIn) {
        this.dTagIn = tagIn;
    }

    public String getDTagOut() {
        return this.dTagOut;
    }

    public void setDTagOut(String tagOut) {
        this.dTagOut = tagOut;
    }
}

