/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.xmlUtils;

import de.desy.tine.xmlUtils.TineConfigItem;
import de.desy.tine.xmlUtils.ValidatedFloat;
import de.desy.tine.xmlUtils.ValidatedInt;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AlarmCfg
extends TineConfigItem {
    private String deviceName = new String("");
    private ValidatedInt severity = new ValidatedInt();
    private ValidatedInt severityHigh = new ValidatedInt();
    private ValidatedInt severityLow = new ValidatedInt();
    private ValidatedInt severityWarnHigh = new ValidatedInt();
    private ValidatedInt severityWarnLow = new ValidatedInt();
    private ValidatedInt system = new ValidatedInt();
    private ValidatedInt valueMask = new ValidatedInt();
    private ValidatedInt valueNormal = new ValidatedInt();
    private ValidatedInt countThreshold = new ValidatedInt();
    private ValidatedFloat valueHigh = new ValidatedFloat();
    private ValidatedFloat valueLow = new ValidatedFloat();
    private ValidatedFloat valueWarnHigh = new ValidatedFloat();
    private ValidatedFloat valueWarnLow = new ValidatedFloat();
    private ValidatedInt code = new ValidatedInt();
    private ValidatedInt codeHigh = new ValidatedInt();
    private ValidatedInt codeLow = new ValidatedInt();
    private boolean normalIsAlarm = false;

    public boolean isNormalAlarm() {
        return this.normalIsAlarm;
    }

    public AlarmCfg(String name) {
        super(name);
    }

    public ValidatedInt getCountThreshold() {
        return this.countThreshold;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public ValidatedInt getSeverityHigh() {
        return this.severityHigh;
    }

    public ValidatedInt getSeverityLow() {
        return this.severityLow;
    }

    public ValidatedInt getSeverityWarnHigh() {
        return this.severityWarnHigh;
    }

    public ValidatedInt getSeverityWarnLow() {
        return this.severityWarnLow;
    }

    public ValidatedInt getSystem() {
        return this.system;
    }

    public ValidatedFloat getValueHigh() {
        return this.valueHigh;
    }

    public ValidatedFloat getValueLow() {
        return this.valueLow;
    }

    public ValidatedInt getValueMask() {
        return this.valueMask;
    }

    public ValidatedInt getValueNormal() {
        return this.valueNormal;
    }

    public ValidatedFloat getValueWarnHigh() {
        return this.valueWarnHigh;
    }

    public ValidatedFloat getValueWarnLow() {
        return this.valueWarnLow;
    }

    public void setCountThreshold(ValidatedInt countThreshold) {
        this.countThreshold = countThreshold;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public void setSeverityHigh(ValidatedInt severityHigh) {
        this.severityHigh = severityHigh;
    }

    public void setSeverityLow(ValidatedInt severityLow) {
        this.severityLow = severityLow;
    }

    public void setSeverityWarnHigh(ValidatedInt severityWarnHigh) {
        this.severityWarnHigh = severityWarnHigh;
    }

    public void setSeverityWarnLow(ValidatedInt severityWarnLow) {
        this.severityWarnLow = severityWarnLow;
    }

    public void setSystem(ValidatedInt system) {
        this.system = system;
    }

    public void setValueHigh(ValidatedFloat valueHigh) {
        this.valueHigh = valueHigh;
    }

    public void setValueLow(ValidatedFloat valueLow) {
        this.valueLow = valueLow;
    }

    public void setValueMask(ValidatedInt valueMask) {
        this.valueMask = valueMask;
    }

    public void setValueNormal(ValidatedInt valueNormal) {
        this.valueNormal = valueNormal;
    }

    public void setValueWarnHigh(ValidatedFloat valueWarnHigh) {
        this.valueWarnHigh = valueWarnHigh;
    }

    public void setValueWarnLow(ValidatedFloat valueWarnLow) {
        this.valueWarnLow = valueWarnLow;
    }

    void dump(int margin) {
        String m = new String("");
        for (int i = 0; i < margin; ++i) {
            m = m + " ";
        }
        System.out.println(m + "Device name = " + this.getDeviceName());
        System.out.println(m + "Severity (default) = " + this.getSeverity());
        System.out.println(m + "Severity high = " + this.getSeverityHigh());
        System.out.println(m + "Severity low = " + this.getSeverityLow());
        System.out.println(m + "Severity high warn = " + this.getSeverityWarnHigh());
        System.out.println(m + "Severity low warn = " + this.getSeverityWarnLow());
        System.out.println(m + "System = " + this.getSystem());
        System.out.println(m + "Value mask = " + this.getValueMask());
        System.out.println(m + "Value normal = " + this.getValueNormal());
        System.out.println(m + "Count threshold = " + this.getCountThreshold());
        System.out.println(m + "Value high = " + this.getValueHigh());
        System.out.println(m + "Value low = " + this.getValueLow());
        System.out.println(m + "Value high warn = " + this.getValueWarnHigh());
        System.out.println(m + "Value low warn = " + this.getValueWarnLow());
        System.out.println(m + "Code = " + this.getCode());
        System.out.println(m + "Code High = " + this.getCodeHigh());
        System.out.println(m + "Code Low = " + this.getCodeLow());
    }

    void parse(Element root) {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element childElement;
            Text textNode;
            Node child = children.item(i);
            if (!(child instanceof Element) || (textNode = (Text)(childElement = (Element)child).getFirstChild()) == null) continue;
            String text = textNode.getData().trim();
            if (childElement.getTagName().equalsIgnoreCase("DEVICE_NAME")) {
                this.setDeviceName(text);
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("SEVERITY")) {
                this.setSeverity(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("SEVERITY_HIGH")) {
                this.setSeverityHigh(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("SEVERITY_LOW")) {
                this.setSeverityLow(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("SEVERITY_HIGH_WARN")) {
                this.setSeverityWarnHigh(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("SEVERITY_LOW_WARN")) {
                this.setSeverityWarnLow(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("SYSTEM")) {
                this.setSystem(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("VALUE_MASK")) {
                this.setValueMask(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("VALUE_NORMAL")) {
                String vtext;
                if (text.startsWith("!")) {
                    vtext = text.substring(1);
                    this.normalIsAlarm = true;
                } else {
                    vtext = text;
                }
                this.setValueNormal(ValidatedInt.parse(vtext));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("COUNT_THRESHOLD")) {
                this.setCountThreshold(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("VALUE_HIGH")) {
                this.setValueHigh(ValidatedFloat.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("VALUE_LOW")) {
                this.setValueLow(ValidatedFloat.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("VALUE_HIGH_WARN")) {
                this.setValueWarnHigh(ValidatedFloat.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("VALUE_LOW_WARN")) {
                this.setValueWarnLow(ValidatedFloat.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("ALARM_CODE")) {
                this.setCode(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("ALARM_CODE_HIGH")) {
                this.setCodeHigh(ValidatedInt.parse(text));
                continue;
            }
            if (childElement.getTagName().equalsIgnoreCase("ALARM_CODE_LOW")) {
                this.setCodeLow(ValidatedInt.parse(text));
                continue;
            }
            System.out.println("-WARNING: unsupported tag: " + childElement.getTagName());
        }
    }

    public ValidatedInt getSeverity() {
        return this.severity;
    }

    public void setSeverity(ValidatedInt severity) {
        this.severity = severity;
    }

    public ValidatedInt getCode() {
        return this.code;
    }

    public ValidatedInt getCodeHigh() {
        return this.codeHigh;
    }

    public ValidatedInt getCodeLow() {
        return this.codeLow;
    }

    public void setCode(ValidatedInt code) {
        this.code = code;
    }

    public void setCodeHigh(ValidatedInt codeHigh) {
        this.codeHigh = codeHigh;
    }

    public void setCodeLow(ValidatedInt codeLow) {
        this.codeLow = codeLow;
    }
}

