/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.types;

import de.desy.tine.endianUtils.Swap;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class USTRING
implements TCompoundDataObject {
    public int ival;
    public float f1val;
    public float f2val;
    public int tm;
    public String str;
    public static final int sizeInBytes = 96;
    public static final short dFormat = 24;
    ByteArrayOutputStream dBuffer;
    public byte[] hByteArray;

    public double getDoubleValue() {
        return this.f1val;
    }

    public int getIntegerValue() {
        return this.ival;
    }

    public String toString() {
        return "[" + this.ival + ", " + this.f1val + ", " + this.f2val + ", " + this.tm + ", " + this.str.trim() + "]";
    }

    public void setValues(int newIValue, float newF1Value, float newF2Value, int newTMValue, String newString) {
        this.ival = newIValue;
        this.f1val = newF1Value;
        this.f2val = newF2Value;
        this.tm = newTMValue;
        this.str = newString;
    }

    public void setString(String newString) {
        this.str = newString;
    }

    public String getString() {
        return this.str;
    }

    public int getSizeInBytes() {
        return 96;
    }

    public short getFormat() {
        return 24;
    }

    public byte[] getByteArray() {
        return this.hByteArray;
    }

    public void setByteArray(byte[] byteArray) {
        this.hByteArray = byteArray;
    }

    public USTRING() {
        this.f1val = 0.0f;
        this.f2val = 0.0f;
        this.ival = 0;
        this.tm = 0;
        this.str = "";
    }

    public USTRING(float f1, String s) {
        this.f1val = f1;
        this.f2val = 0.0f;
        this.ival = 0;
        this.tm = 0;
        this.str = s;
    }

    public USTRING(float f1, float f2, String s) {
        this.f1val = f1;
        this.f2val = f2;
        this.ival = 0;
        this.tm = 0;
        this.str = s;
    }

    public USTRING(int i, String s) {
        this.f1val = 0.0f;
        this.f2val = 0.0f;
        this.ival = i;
        this.tm = 0;
        this.str = s;
    }

    public USTRING(int i, float f1, float f2, int tm, String s) {
        this.f1val = f1;
        this.f2val = f2;
        this.ival = i;
        this.tm = tm;
        this.str = s;
    }

    public USTRING(USTRING instance) {
        this.f1val = instance.f1val;
        this.f2val = instance.f2val;
        this.ival = instance.ival;
        this.tm = instance.tm;
        this.str = new String(instance.str);
    }

    public boolean equals(USTRING instance) {
        if (instance.ival != this.ival) {
            return false;
        }
        if (instance.f1val != this.f1val) {
            return false;
        }
        if (instance.f2val != this.f2val) {
            return false;
        }
        if (instance.tm != this.tm) {
            return false;
        }
        if (instance.str == null || this.str == null) {
            return false;
        }
        return instance.str.compareTo(this.str) == 0;
    }

    public byte[] toByteArray() {
        try {
            this.dBuffer = new ByteArrayOutputStream(96);
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            ds.writeInt(Swap.Long(this.ival));
            byte[] b = Swap.Float(this.f1val);
            ds.write(b, 0, 4);
            b = Swap.Float(this.f2val);
            ds.write(b, 0, 4);
            ds.writeInt(Swap.Long(this.tm));
            b = this.str.getBytes();
            int len = b.length;
            if (len < 80) {
                ds.write(b);
                b = new byte[80];
                ds.write(b, 0, 80 - len);
            } else {
                ds.write(b, 0, 80);
            }
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            this.ival = Swap.Long(ds.readInt());
            byte[] b = new byte[80];
            ds.read(b, 0, 4);
            this.f1val = Swap.Float(b);
            ds.read(b, 0, 4);
            this.f2val = Swap.Float(b);
            this.tm = Swap.Long(ds.readInt());
            ds.read(b, 0, 80);
            this.str = new String(b);
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.f1val);
        result = 31 * result + Float.floatToIntBits(this.f2val);
        result = 31 * result + this.ival;
        result = 31 * result + (this.str == null ? 0 : this.str.hashCode());
        result = 31 * result + this.tm;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        USTRING other = (USTRING)obj;
        return this.equals(other);
    }
}

