/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.types;

import de.desy.tine.endianUtils.Swap;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class FLTINTINT
implements TCompoundDataObject {
    public float f1val;
    public int i1val;
    public int i2val;
    public static final int sizeInBytes = 12;
    public static final short dFormat = 26;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(12);
    public byte[] hByteArray;

    public double getDoubleValue() {
        return this.f1val;
    }

    public int getIntegerValue() {
        return this.i1val;
    }

    public void setValues(float newFValue, int newI1Value, int newI2Value) {
        this.f1val = newFValue;
        this.i1val = newI1Value;
        this.i2val = newI2Value;
    }

    public int getSizeInBytes() {
        return 12;
    }

    public short getFormat() {
        return 26;
    }

    public void setByteArray(byte[] byteArray) {
        this.hByteArray = byteArray;
    }

    public byte[] getByteArray() {
        return this.hByteArray;
    }

    public FLTINTINT() {
        this.f1val = 0.0f;
        this.i1val = 0;
        this.i2val = 0;
    }

    public FLTINTINT(float f) {
        this.f1val = f;
        this.i1val = 0;
        this.i2val = 0;
    }

    public FLTINTINT(int i) {
        this.f1val = 0.0f;
        this.i1val = i;
        this.i2val = 0;
    }

    public FLTINTINT(float f1, int i1, int i2) {
        this.f1val = f1;
        this.i1val = i1;
        this.i2val = i2;
    }

    public FLTINTINT(FLTINTINT instance) {
        this.f1val = instance.f1val;
        this.i1val = instance.i1val;
        this.i2val = instance.i2val;
    }

    public String toString() {
        return "[" + this.f1val + ", " + this.i1val + ", " + this.i2val + "]";
    }

    public boolean equals(FLTINTINT instance) {
        if (instance.i1val != this.i1val) {
            return false;
        }
        if (instance.i2val != this.i2val) {
            return false;
        }
        return instance.f1val == this.f1val;
    }

    public byte[] toByteArray() {
        try {
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            byte[] b = Swap.Float(this.f1val);
            ds.write(b, 0, 4);
            ds.writeInt(Swap.Long(this.i1val));
            ds.writeInt(Swap.Long(this.i2val));
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            byte[] b = new byte[4];
            ds.read(b, 0, 4);
            this.f1val = Swap.Float(b);
            this.i1val = Swap.Long(ds.readInt());
            this.i2val = Swap.Long(ds.readInt());
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.f1val);
        result = 31 * result + this.i1val;
        result = 31 * result + this.i2val;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FLTINTINT other = (FLTINTINT)obj;
        return this.equals(other);
    }
}

