/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.logger;

import de.desy.tine.client.TLinkFactory;
import de.desy.tine.server.logger.DbgLog;
import java.util.ArrayList;

public class MsgLog {
    private static final int MAX_NUM_MESSAGES = 512;
    private static MsgEntry[] msgs = new MsgEntry[512];
    private static int msgptr = 0;
    private static MsgLog instance = new MsgLog();

    private MsgLog() {
        MsgLog.msgs[0] = new MsgEntry(System.currentTimeMillis(), "Message Log started");
    }

    public static void log(String message, int code) {
        if (message == null) {
            return;
        }
        msgptr = (msgptr + 1) % 512;
        MsgLog msgLog = instance;
        msgLog.getClass();
        MsgLog.msgs[MsgLog.msgptr] = msgLog.new MsgEntry(System.currentTimeMillis(), message, code, null);
    }

    public static void log(String source, String message, int code, Throwable exception, int debugLevel) {
        if (message == null) {
            return;
        }
        msgptr = (msgptr + 1) % 512;
        MsgLog msgLog = instance;
        msgLog.getClass();
        MsgLog.msgs[MsgLog.msgptr] = msgLog.new MsgEntry(System.currentTimeMillis(), message, code, exception);
        if (TLinkFactory.debugLevel >= debugLevel) {
            DbgLog.log(source, message);
        }
    }

    public static MsgEntry[] getMessages(long starttime) {
        int i = msgptr;
        ArrayList<MsgEntry> m = new ArrayList<MsgEntry>();
        for (int n = 0; n < 512 && msgs[i = (msgptr - n + 512) % 512] != null && msgs[i].time >= starttime; ++n) {
            m.add(msgs[i]);
        }
        return m.size() > 0 ? m.toArray(new MsgEntry[0]) : null;
    }

    public static MsgEntry[] getMessages(int depth) {
        int i = msgptr;
        ArrayList<MsgEntry> m = new ArrayList<MsgEntry>();
        for (int n = 0; n < 512 && n < depth && msgs[i = (msgptr - n + 512) % 512] != null; ++n) {
            m.add(msgs[i]);
        }
        return m.size() > 0 ? m.toArray(new MsgEntry[0]) : null;
    }

    public class MsgEntry {
        private long time;
        private int code;
        private String msg;
        private Throwable e;

        MsgEntry(long t, String m) {
            this.time = t;
            this.msg = m;
            this.code = 0;
        }

        MsgEntry(long t, String m, int c, Throwable x) {
            this.time = t;
            this.msg = m;
            this.code = c;
            this.e = x;
        }

        public int getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        public long getTime() {
            return this.time;
        }

        public Throwable getExecption() {
            return this.e;
        }
    }
}

