/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.devices;

import de.desy.tine.server.devices.TDevice;
import de.desy.tine.server.equipment.TEquipmentModule;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TDeviceList {
    private static final int TDeviceListCapacity = 256;
    private LinkedHashMap<String, TDevice> myDeviceData = new LinkedHashMap(256);
    private LinkedList<String> myDeviceNames = new LinkedList();
    private int lastRegisteredDevice = -1;
    private boolean propertyOriented = false;

    public void setPropertyOriented(boolean value) {
        this.propertyOriented = value;
    }

    public boolean isPropertyOriented() {
        return this.propertyOriented;
    }

    public int getLastRegisteredDevice() {
        return this.lastRegisteredDevice;
    }

    public int getNumberOfDevices() {
        return this.myDeviceNames.size();
    }

    public void refreshAlarms() {
        TDevice[] dlst = this.getDeviceList();
        if (dlst == null) {
            return;
        }
        for (int i = 0; i < dlst.length; ++i) {
            dlst[i].processAlarms();
        }
    }

    public void clearAlarms() {
        TDevice[] dlst = this.getDeviceList();
        if (dlst == null) {
            return;
        }
        for (int i = 0; i < dlst.length; ++i) {
            dlst[i].clearAlarms();
        }
    }

    public Set getDeviceSet() {
        return this.myDeviceData.entrySet();
    }

    public String[] getDeviceNameList() {
        return this.myDeviceNames.toArray(new String[0]);
    }

    public TDevice[] getDeviceList() {
        return this.myDeviceData.values().toArray(new TDevice[0]);
    }

    public LinkedList<String> getDeviceLinkedList() {
        return this.myDeviceNames;
    }

    public TDevice getDevice(String devName) {
        if (devName == null) {
            return null;
        }
        if (devName.startsWith("#")) {
            try {
                return this.getDevice(Integer.parseInt(devName.substring(1)));
            }
            catch (Exception e) {
                return null;
            }
        }
        String devNameUC = devName.toUpperCase();
        if (!this.myDeviceData.containsKey(devNameUC)) {
            return null;
        }
        return this.myDeviceData.get(devNameUC);
    }

    public TDevice getDevice(int devNumber) {
        if (devNumber < 0 || devNumber >= this.myDeviceNames.size()) {
            return null;
        }
        String devName = this.myDeviceNames.get(devNumber);
        return this.myDeviceData.get(devName.toUpperCase());
    }

    public void renameDevice(String oldName, String newName) {
        TDevice tdv = this.getDevice(oldName);
        if (tdv == null) {
            return;
        }
        tdv.setName(newName);
        int dv = tdv.devNumber;
        this.myDeviceData.remove(oldName.toUpperCase());
        this.myDeviceData.put(newName.toUpperCase(), tdv);
        this.myDeviceNames.set(dv, newName);
    }

    public void addDevice(String devName, int devNumber, TEquipmentModule eqm) {
        if (devNumber < 0) {
            return;
        }
        if (devNumber < this.myDeviceNames.size()) {
            this.myDeviceNames.set(devNumber, devName);
            return;
        }
        if (devNumber > this.lastRegisteredDevice + 1) {
            for (int i = this.lastRegisteredDevice + 1; i < devNumber; ++i) {
                this.myDeviceNames.add("#" + i);
            }
        }
        this.lastRegisteredDevice = devNumber;
        this.myDeviceData.put(devName.toUpperCase(), new TDevice(devName, devNumber, eqm));
        this.myDeviceNames.add(devName);
    }

    public void addDevice(String devName, TEquipmentModule eqm) {
        this.addDevice(devName, this.lastRegisteredDevice + 1, eqm);
    }

    public void addDevice(TDevice device) {
        if (device == null) {
            return;
        }
        this.myDeviceData.put(device.devName.toUpperCase(), device);
        this.myDeviceNames.add(device.devName);
    }

    public int getDeviceNumber(String devName) {
        if (devName.startsWith("#")) {
            try {
                return Integer.parseInt(devName.substring(1));
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        TDevice td = this.myDeviceData.get(devName.toUpperCase());
        if (td == null) {
            return -1;
        }
        return td.devNumber;
    }

    public int getNumberOfAlarms() {
        TDevice[] dlst = this.getDeviceList();
        if (dlst == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < dlst.length; ++i) {
            n += dlst[i].getNumberOfAlarms();
        }
        return n;
    }

    public int getMostRecentAlarmTimestamp(int[] nalarms, int index) {
        TDevice[] dlst = this.getDeviceList();
        if (dlst == null) {
            return 0;
        }
        int mrt = 0;
        int n = 0;
        for (int i = 0; i < dlst.length; ++i) {
            int ts = dlst[i].getMostRecentTimestamp();
            if (ts > mrt) {
                mrt = ts;
                n = 0;
            }
            if (ts != mrt) continue;
            n += dlst[i].getNumberOfAlarmsAtMostRecentTimestamp();
        }
        if (nalarms != null && nalarms.length > index) {
            nalarms[index] = n;
        }
        return mrt;
    }

    public int getHighestAlarmSeverity(int[] nalarms, int index) {
        TDevice[] dlst = this.getDeviceList();
        if (dlst == null) {
            return 0;
        }
        int hsv = 0;
        int n = 0;
        for (int i = 0; i < dlst.length; ++i) {
            int sv = dlst[i].getHighestAlarmSeverity();
            if (sv > hsv) {
                hsv = sv;
                n = 0;
            }
            if (sv != hsv) continue;
            n += dlst[i].getNumberOfAlarmsAtHighestSeverity();
        }
        if (nalarms != null && nalarms.length > index) {
            nalarms[index] = n;
        }
        return hsv;
    }
}

