/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.alarms;

import de.desy.tine.client.TLinkFactory;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.server.alarms.TAlarm;
import de.desy.tine.server.alarms.TAlarmDefinition;
import de.desy.tine.server.alarms.TAlarmDescriptor;
import de.desy.tine.server.alarms.TAlarmDynSet;
import de.desy.tine.server.equipment.TEquipmentModule;
import de.desy.tine.structUtils.TTaggedStructure;

public class TAlarmMessage
extends TTaggedStructure
implements Comparable {
    private char[] server = new char[32];
    private String serverString;
    private char[] device = new char[64];
    private String deviceString;
    private char[] alarmTag = new char[32];
    private String alarmTagString;
    private int[] alarmCode = new int[1];
    private int[] timestamp = new int[1];
    private int[] timestampUSec = new int[1];
    private int[] starttime = new int[1];
    private int[] starttimeUSec = new int[1];
    private int[] alarmMask = new int[1];
    private byte[] alarmData = new byte[64];
    private byte[] alarmDataFormat = new byte[1];
    private byte[] alarmDataArraySize = new byte[1];
    private TDataType tAlarmData;
    private byte[] severity = new byte[1];
    private byte[] descriptor = new byte[1];
    private short[] alarmSystem = new short[1];
    private byte[] reserved = new byte[2];
    public static final int sizeInBytes = 224;

    public int getAlarmCode() {
        return this.alarmCode[0];
    }

    public int getAlarmSeverity() {
        return this.severity[0];
    }

    public int getAlarmDescriptor() {
        return this.descriptor[0];
    }

    public String getAlarmDescriptorAsString() {
        return TAlarmDescriptor.toLongString(this.descriptor[0]);
    }

    public boolean isTransient() {
        return (this.descriptor[0] & 0x10) != 16;
    }

    public boolean isActive() {
        if ((this.descriptor[0] & 0x40) != 64) {
            return true;
        }
        return (this.descriptor[0] & 1) == 1;
    }

    public int getAlarmSystem() {
        return this.alarmSystem[0];
    }

    public long getTimeStamp() {
        return (long)this.timestamp[0] * 1000L + (long)(this.timestampUSec[0] / 1000);
    }

    public long getStartTime() {
        return (long)this.starttime[0] * 1000L + (long)(this.starttimeUSec[0] / 1000);
    }

    public int getAlarmMask() {
        return this.alarmMask[0];
    }

    public boolean hasData() {
        return this.alarmDataArraySize[0] > 0;
    }

    public TDataType getAlarmData() {
        if (this.tAlarmData == null) {
            int dsiz = this.alarmDataArraySize[0];
            short dfmt = this.alarmDataFormat[0];
            this.tAlarmData = new TDataType(dsiz, dfmt);
            if (dsiz > 0 && dfmt != 255) {
                if (dfmt == 4) {
                    int i;
                    for (i = 0; i < dsiz && this.alarmData[i] != 0; ++i) {
                    }
                    while (i < dsiz) {
                        this.alarmData[i++] = 0;
                    }
                }
                this.tAlarmData.pushBytes(this.alarmData);
                TLinkFactory.getInstance().fillinIncomingData(this.tAlarmData);
            }
        }
        return this.tAlarmData;
    }

    public String getServer() {
        if (this.serverString == null) {
            this.serverString = new String(this.server).trim();
        }
        return this.serverString;
    }

    public String getDevice() {
        if (this.deviceString == null) {
            this.deviceString = new String(this.device).trim();
        }
        return this.deviceString;
    }

    public String getAlarmTag() {
        if (this.alarmTagString == null) {
            this.alarmTagString = new String(this.alarmTag).trim();
        }
        return this.alarmTagString;
    }

    private void initStructDescription() {
        this.addField(this.server, "server");
        this.addField(this.device, "device");
        this.addField(this.alarmTag, "almTag");
        this.addField(this.alarmCode, "almCode");
        this.addField(this.timestamp, "timestamp");
        this.addField(this.timestampUSec, "timestampUSec");
        this.addField(this.starttime, "starttime");
        this.addField(this.starttimeUSec, "starttimeUSec");
        this.addField(this.alarmMask, "almMask");
        this.addField(this.alarmData, "almData");
        this.addField(this.alarmDataFormat, "almDataFormat");
        this.addField(this.alarmDataArraySize, "almDataArraySize");
        this.addField(this.severity, "severity");
        this.addField(this.descriptor, "descriptor");
        this.addField(this.alarmSystem, "almSystem");
        this.addField(this.reserved, "reserved");
        this.initDone();
    }

    public TAlarmMessage() {
        super("AMSr4");
        this.initStructDescription();
    }

    private void pushByteArray(byte[] barray) {
        for (int i = 0; i < 64; ++i) {
            this.alarmData[i] = 0;
        }
        if (barray == null) {
            return;
        }
        int len = Math.min(barray.length, 64);
        for (int i = 0; i < len; ++i) {
            this.alarmData[i] = barray[i];
        }
    }

    private void pushString(String s, char[] c) {
        if (s != null) {
            int len = s.length();
            if (len > c.length) {
                len = c.length;
            }
            s.getChars(0, len, c, 0);
        }
    }

    public TAlarmMessage(String srv, String dev, String tag, int code, int sev, TAlarmDynSet almDynSet, TDataType data) {
        super("AMSr4");
        this.initStructDescription();
        this.pushString(srv, this.server);
        this.pushString(dev == null ? "" : dev, this.device);
        this.pushString(tag, this.alarmTag);
        this.alarmCode[0] = code;
        this.severity[0] = (byte)sev;
        this.alarmSystem[0] = 0;
        if (data != null && data.dArrayLength > 0 && data.dFormat != 255) {
            this.alarmDataFormat[0] = (byte)data.dFormat;
            this.alarmDataArraySize[0] = (byte)data.dArrayLength;
            this.pushByteArray(data.getDataBuffer());
        }
        this.timestamp[0] = almDynSet.timestamp;
        this.timestampUSec[0] = almDynSet.timestampUSec;
        this.starttime[0] = almDynSet.starttime;
        this.starttimeUSec[0] = almDynSet.starttimeUSec;
        this.descriptor[0] = almDynSet.descriptor;
    }

    public TAlarmMessage(TEquipmentModule eqm, String dev, TAlarm alm) {
        super("AMSr4");
        this.initStructDescription();
        this.pushString(eqm.getExportName(), this.server);
        this.pushString(dev == null ? "" : dev, this.device);
        TAlarmDefinition adef = alm.getAlmDef();
        if (adef != null) {
            this.pushString(adef.getAlarmTag(), this.alarmTag);
            this.alarmMask[0] = adef.getAlarmMask();
            this.alarmDataFormat[0] = (byte)adef.getAlarmDataFormat();
            this.alarmDataArraySize[0] = (byte)adef.getAlarmDataArraySize();
            this.severity[0] = (byte)adef.getAlarmSeverity();
            this.alarmSystem[0] = (short)adef.getAlarmSystem();
        }
        this.alarmCode[0] = alm.getCode();
        this.timestamp[0] = alm.getTimeStamp();
        this.timestampUSec[0] = alm.getTimeStampUSec();
        this.starttime[0] = alm.getStarttime();
        this.starttimeUSec[0] = alm.getStarttimeUSec();
        this.pushByteArray(alm.getData());
        this.descriptor[0] = alm.getDescriptor();
    }

    public int compareTo(Object a) {
        if (a == null) {
            return -999;
        }
        if (a instanceof TAlarmMessage) {
            int dt = this.timestamp[0] - ((TAlarmMessage)a).timestamp[0];
            if (dt != 0) {
                return dt;
            }
            return this.timestampUSec[0] - ((TAlarmMessage)a).timestampUSec[0];
        }
        return -998;
    }

    public boolean isInstanceOf(TAlarmMessage reference) {
        if (reference == null) {
            return false;
        }
        if (reference.alarmCode[0] != this.alarmCode[0]) {
            return false;
        }
        if (reference.getDevice().compareToIgnoreCase(this.getDevice()) != 0) {
            return false;
        }
        if (reference.getServer().compareToIgnoreCase(this.getServer()) != 0) {
            return false;
        }
        if (reference.starttime[0] != this.starttime[0]) {
            return false;
        }
        return reference.starttimeUSec[0] == this.starttimeUSec[0];
    }
}

