/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.alarms;

import de.desy.tine.structUtils.TTaggedStructure;

public class TAlarmDefinition
extends TTaggedStructure {
    private char[] alarmTag = new char[32];
    private String alarmTagString;
    private int[] alarmCode = new int[1];
    private int[] alarmMask = new int[1];
    private short[] alarmSystem = new short[1];
    private short[] alarmSeverity = new short[1];
    private byte[] alarmDataFormat = new byte[1];
    private byte[] alarmDataArraySize = new byte[1];
    private byte[] reserved = new byte[2];
    private char[] alarmText = new char[64];
    private String alarmTextString;
    private char[] deviceText = new char[64];
    private String deviceTextString;
    private char[] dataText = new char[64];
    private String dataTextString;
    private char[] url = new char[128];
    private String urlString;
    private static boolean initialized = false;

    public int getAlarmCode() {
        return this.alarmCode[0];
    }

    public int getAlmCode() {
        return this.alarmCode[0];
    }

    public int getAlarmMask() {
        return this.alarmMask[0];
    }

    public int getAlarmSystem() {
        return this.alarmSystem[0];
    }

    public int getAlarmSeverity() {
        return this.alarmSeverity[0];
    }

    public int getAlarmDataFormat() {
        return this.alarmDataFormat[0];
    }

    public int getAlarmDataArraySize() {
        return this.alarmDataArraySize[0];
    }

    public String getAlarmTag() {
        if (this.alarmTagString == null) {
            this.alarmTagString = new String(this.alarmTag).trim();
        }
        return this.alarmTagString;
    }

    public String getAlarmText() {
        if (this.alarmTextString == null) {
            this.alarmTextString = new String(this.alarmText).trim();
        }
        return this.alarmTextString;
    }

    public String getAlmText() {
        return this.getAlarmText();
    }

    public String getDeviceText() {
        if (this.deviceTextString == null) {
            this.deviceTextString = new String(this.deviceText).trim();
        }
        return this.deviceTextString;
    }

    public String getDataText() {
        if (this.alarmDataArraySize[0] == 0) {
            this.dataTextString = new String("no data associated with alarm");
        }
        if (this.dataTextString == null) {
            this.dataTextString = new String(this.dataText).trim();
        }
        return this.dataTextString;
    }

    public String getUrl() {
        if (this.urlString == null) {
            this.urlString = new String(this.url).trim();
        }
        return this.urlString;
    }

    private void initStructDescription() {
        if (initialized) {
            // empty if block
        }
        this.addField(this.alarmTag, "almTag");
        this.addField(this.alarmCode, "almCode");
        this.addField(this.alarmMask, "almMask");
        this.addField(this.alarmSystem, "almSystem");
        this.addField(this.alarmSeverity, "almSeverity");
        this.addField(this.alarmDataFormat, "almDataFormat");
        this.addField(this.alarmDataArraySize, "almDataArraySize");
        this.addField(this.reserved, "reserved");
        this.addField(this.alarmText, "alarmText");
        this.addField(this.deviceText, "deviceText");
        this.addField(this.dataText, "dataText");
        this.addField(this.url, "url");
        this.initDone();
        initialized = true;
    }

    public TAlarmDefinition() {
        super("ADSr4");
        this.initStructDescription();
    }

    private void pushString(String s, char[] c) {
        if (s != null) {
            int len = s.length();
            if (len > c.length) {
                len = c.length;
            }
            s.getChars(0, len, c, 0);
            for (int i = len; i < c.length; ++i) {
                c[i] = '\u0000';
            }
        }
    }

    public TAlarmDefinition(String tag, String txt, String devTxt, int code, int severity, int system, int mask, short dataFormat, int dataSize, String dataTxt, String urlTxt) {
        super("ADSr4");
        this.initStructDescription();
        this.pushString(tag, this.alarmTag);
        this.pushString(txt, this.alarmText);
        this.pushString(devTxt, this.deviceText);
        this.setAlarmCode(code);
        this.setAlarmSeverity(severity);
        this.setAlarmSystem(system);
        this.setAlarmMask(mask);
        this.pushString(dataTxt, this.dataText);
        this.setAlarmDataFormat(dataFormat);
        this.setAlarmDataArraySize(dataSize);
        this.pushString(urlTxt, this.url);
    }

    public TAlarmDefinition(String tag, String txt, String devTxt, int code, int severity, int system) {
        super("ADSr4");
        this.initStructDescription();
        this.pushString(tag, this.alarmTag);
        this.pushString(txt, this.alarmText);
        this.pushString(devTxt, this.deviceText);
        this.setAlarmCode(code);
        this.setAlarmSeverity(severity);
        this.setAlarmSystem(system);
    }

    public void setAlarmCode(int almCode) {
        this.alarmCode[0] = almCode;
    }

    public void setAlarmDataArraySize(int almDataArraySize) {
        this.alarmDataArraySize[0] = (byte)almDataArraySize;
    }

    public void setAlarmDataFormat(int almDataFormat) {
        int bf = almDataFormat % 512;
        if (bf > 127) {
            bf = -256;
        }
        this.alarmDataFormat[0] = (byte)bf;
    }

    public void setAlarmMask(int almMask) {
        this.alarmMask[0] = almMask;
    }

    public void setAlarmSeverity(int almSeverity) {
        this.alarmSeverity[0] = (short)almSeverity;
    }

    public void setAlarmSystem(int almSystem) {
        this.alarmSystem[0] = (short)almSystem;
    }

    public void setAlarmTag(String tag) {
        this.pushString(tag, this.alarmTag);
    }

    public void setAlarmText(String alarmTxt) {
        this.pushString(alarmTxt, this.alarmText);
    }

    public void setDataText(String dataTxt) {
        this.pushString(dataTxt, this.dataText);
    }

    public void setDeviceText(String deviceTxt) {
        this.pushString(deviceTxt, this.deviceText);
    }

    public void setUrl(String urlTxt) {
        this.pushString(urlTxt, this.url);
    }
}

