/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.io;

import de.desy.tine.endianUtils.SwapUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TDataInputStream
extends FilterInputStream
implements DataInput {
    DataInputStream stream;

    public TDataInputStream(InputStream in) {
        super(in);
        this.stream = new DataInputStream(in);
    }

    public static String readUTF(DataInput in) throws IOException {
        return DataInputStream.readUTF(in);
    }

    public int available() throws IOException {
        return this.stream.available();
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public int read() throws IOException {
        return this.stream.read();
    }

    public int read(byte[] b) throws IOException {
        return this.stream.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    public boolean readBoolean() throws IOException {
        return this.stream.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.stream.readByte();
    }

    public char readChar() throws IOException {
        return (char)SwapUtil.swapShort((short)this.stream.readChar());
    }

    public double readDouble() throws IOException {
        return SwapUtil.swapDouble(this.stream.readLong());
    }

    public float readFloat() throws IOException {
        return SwapUtil.swapFloat(this.stream.readInt());
    }

    public void readFully(byte[] b) throws IOException {
        this.stream.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.stream.readFully(b, off, len);
    }

    public int readInt() throws IOException {
        return SwapUtil.swapInt(this.stream.readInt());
    }

    public String readLine() throws IOException {
        return this.stream.readLine();
    }

    public long readLong() throws IOException {
        return SwapUtil.swapLong(this.stream.readLong());
    }

    public short readShort() throws IOException {
        return SwapUtil.swapShort(this.stream.readShort());
    }

    public int readUnsignedByte() throws IOException {
        return this.stream.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return SwapUtil.swapInt(this.stream.readUnsignedShort());
    }

    public String readUTF() throws IOException {
        return this.stream.readUTF();
    }

    public void reset() throws IOException {
        this.stream.reset();
    }

    public long skip(long n) throws IOException {
        return this.stream.skip(n);
    }

    public int skipBytes(int n) throws IOException {
        return this.stream.skipBytes(n);
    }
}

