/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.headers;

import de.desy.tine.endianUtils.Swap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public final class TReqHdr {
    private String username = null;
    private short tineProtocol;
    private short numInPacket;
    public static final short hdrSizeInBytes = 22;
    private short totalSizeInBytes;
    private short msgSizeInBytes;
    ByteArrayOutputStream dBuffer;
    private byte[] bstr = new byte[16];

    public TReqHdr(String u, int protocolLevel) {
        this.username = u.toUpperCase();
        this.tineProtocol = (short)protocolLevel;
        this.numInPacket = 1;
        this.dBuffer = new ByteArrayOutputStream(22);
    }

    public String getUserName() {
        return this.username;
    }

    public short getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public short getMsgSizeInBytes() {
        return this.msgSizeInBytes;
    }

    public void setMsgSizeInBytes(short sizeInBytes) {
        this.msgSizeInBytes = sizeInBytes;
    }

    public byte[] toByteArray() {
        this.totalSizeInBytes = (short)(this.msgSizeInBytes + 22);
        try {
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            ds.writeShort(Swap.Short(this.totalSizeInBytes));
            Arrays.fill(this.bstr, (byte)0);
            byte[] tmp = this.username.getBytes();
            for (int i = 0; i < 16 && i < tmp.length; ++i) {
                this.bstr[i] = tmp[i];
            }
            ds.write(this.bstr, 0, 16);
            ds.writeShort(Swap.Short(this.tineProtocol));
            ds.writeShort(Swap.Short(this.numInPacket));
            ds.close();
            return this.dBuffer.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    void removeThisMethod(short msgsize) {
        this.msgSizeInBytes = msgsize;
        this.totalSizeInBytes = (short)(msgsize + 22);
        try {
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            ds.writeShort(Swap.Short(this.totalSizeInBytes));
            Arrays.fill(this.bstr, (byte)0);
            byte[] tmp = this.username.getBytes();
            for (int i = 0; i < 16 && i < tmp.length; ++i) {
                this.bstr[i] = tmp[i];
            }
            ds.write(this.bstr, 0, 16);
            ds.writeShort(Swap.Short(this.tineProtocol));
            ds.writeShort(Swap.Short(this.numInPacket));
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TReqHdr(byte[] data, int off, int len) {
        int bytesread = 0;
        try {
            ByteArrayInputStream dinBuffer = new ByteArrayInputStream(data, off, len);
            DataInputStream ds = new DataInputStream(dinBuffer);
            this.totalSizeInBytes = Swap.Short(ds.readShort());
            Arrays.fill(this.bstr, (byte)0);
            for (bytesread = 2; bytesread < 22; bytesread += 20) {
                ds.read(this.bstr, 0, 16);
                this.username = new String(this.bstr).trim();
                this.tineProtocol = Swap.Short(ds.readShort());
                this.numInPacket = Swap.Short(ds.readShort());
            }
            ds.close();
            dinBuffer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "User : " + this.username + "\nTotal size : " + this.totalSizeInBytes + "\nTotal number : " + this.numInPacket;
    }

    public short getProtocol() {
        return this.tineProtocol;
    }

    public short getTineProtocol() {
        return this.tineProtocol;
    }

    public void setTineProtocol(int protocolLevel) {
        this.tineProtocol = (short)protocolLevel;
    }
}

