/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.addrUtils;

import de.desy.tine.addrUtils.FECAddr;
import de.desy.tine.endianUtils.Swap;
import de.desy.tine.server.logger.MsgLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class SrvAddr {
    public String fecName;
    public String subSystem;
    public String expName;
    public String eqmName;
    public String eqmContext;
    public byte[] ipxNetwork = new byte[4];
    public byte[] ipxNode = new byte[6];
    public byte[] ipxImmediateAddress = new byte[6];
    public String ipAddr;
    public int portOffset;
    public byte[] ipHAddr = new byte[4];
    public int inetProtocol;
    public int tineProtocol;
    public static int sizeInBytes = 104 + FECAddr.sizeInBytes;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(sizeInBytes);
    private byte[] hByteArray;

    SrvAddr() {
    }

    public SrvAddr(FECAddr fecAddr) {
        this.fecName = fecAddr.fecName;
        this.ipAddr = fecAddr.ipAddr;
        this.portOffset = fecAddr.portOffset;
        if (fecAddr.ipHAddr[0] == 0 && fecAddr.ipHAddr[1] == 0 && fecAddr.ipHAddr[2] == 0 && fecAddr.ipHAddr[3] == 0) {
            try {
                InetAddress ia = InetAddress.getByName(this.ipAddr.trim());
                fecAddr.ipHAddr = ia.getAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        System.arraycopy(fecAddr.ipHAddr, 0, this.ipHAddr, 0, 4);
    }

    public SrvAddr(String fecName, String fecIP, int fecPort, String eqmName, String expName, String ctxName) {
        this.fecName = new String(fecName);
        this.eqmContext = new String(ctxName);
        this.expName = new String(expName);
        this.eqmName = new String(eqmName);
        this.ipAddr = new String(fecIP);
        this.portOffset = fecPort;
        this.inetProtocol = 8;
        this.tineProtocol = 6;
        try {
            InetAddress ia = InetAddress.getByName(this.ipAddr.trim());
            System.arraycopy(ia.getAddress(), 0, this.ipHAddr, 0, 4);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    private void pushStringToBytes(String s, byte[] b, int maxlen) {
        int len;
        if (s != null) {
            len = s.length();
            if (len > maxlen) {
                len = maxlen;
            }
            System.arraycopy(s.getBytes(), 0, b, 0, len);
        } else {
            len = 0;
        }
        for (int i = len; i < maxlen; ++i) {
            b[i] = 0;
        }
    }

    public byte[] toByteArray() {
        try {
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            byte[] bstr = new byte[64];
            this.pushStringToBytes(this.fecName, bstr, 16);
            ds.write(bstr, 0, 16);
            this.pushStringToBytes(this.subSystem, bstr, 16);
            ds.write(bstr, 0, 16);
            this.pushStringToBytes(this.expName, bstr, 32);
            ds.write(bstr, 0, 32);
            this.pushStringToBytes(this.eqmName, bstr, 8);
            ds.write(bstr, 0, 8);
            this.pushStringToBytes(this.eqmContext, bstr, 32);
            ds.write(bstr, 0, 32);
            this.pushStringToBytes(this.fecName, bstr, 16);
            ds.write(bstr, 0, 16);
            ds.write(this.ipxNetwork, 0, 4);
            ds.write(this.ipxNode, 0, 6);
            ds.write(this.ipxImmediateAddress, 0, 6);
            this.pushStringToBytes(this.ipAddr, bstr, 16);
            ds.write(bstr, 0, 16);
            ds.write(this.ipHAddr, 0, 4);
            ds.writeInt(Swap.Long(this.portOffset));
            ds.writeInt(Swap.Long(this.inetProtocol));
            ds.writeInt(Swap.Long(this.tineProtocol));
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("SrvAddr", "could not prepare byte stream", 66, e, 0);
            return null;
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            byte[] bstr = new byte[64];
            ds.read(bstr, 0, 16);
            this.fecName = new String(bstr, 0, 16).trim();
            ds.read(bstr, 0, 16);
            this.subSystem = new String(bstr, 0, 16).trim();
            ds.read(bstr, 0, 32);
            this.expName = new String(bstr, 0, 32).trim();
            ds.read(bstr, 0, 8);
            this.eqmName = new String(bstr, 0, 6).trim();
            ds.read(bstr, 0, 32);
            this.eqmContext = new String(bstr, 0, 16).trim();
            ds.read(bstr, 0, 16);
            this.fecName = new String(bstr, 0, 16).trim();
            ds.read(this.ipxNetwork, 0, 4);
            ds.read(this.ipxNode, 0, 6);
            ds.read(this.ipxImmediateAddress, 0, 6);
            ds.read(bstr, 0, 16);
            this.ipAddr = new String(bstr, 0, 16).trim();
            ds.read(this.ipHAddr, 0, 4);
            this.portOffset = Swap.Long(ds.readInt());
            this.inetProtocol = Swap.Long(ds.readInt());
            this.tineProtocol = Swap.Long(ds.readInt());
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("SrvAddr", "could not prepare byte stream", 66, e, 0);
        }
    }

    public String toString() {
        String msg = new String("Exp name : " + this.expName);
        msg = msg.concat("\nEqm name : " + this.eqmName);
        msg = msg.concat("\nContext  : " + this.eqmContext);
        msg = msg.concat("\nFEC name : " + this.fecName);
        msg = msg.concat("\nFEC ip   : " + this.ipAddr);
        msg = msg.concat("\nFEC portOffset : " + this.portOffset);
        msg = msg.concat("\ntine protocol : " + this.tineProtocol);
        return msg;
    }
}

