/*
 * Decompiled with CFR 0.152.
 */
package daq;

import daq.RunCtlTags;
import daq.chan_descriptions;
import daq.daq_xml_request;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class daq_xml_reply
extends DefaultHandler
implements RunCtlTags {
    boolean rootf;
    boolean statf;
    int conv_error;
    private int error;
    public daq_xml_request request;
    public int t_start_sec;
    public int t_stop_sec;
    public int files;
    public int fids;
    public int events;
    public int data_loc;
    public Vector<String> nf_chan_list;
    public Vector<String> nf_file_list;
    public Vector<String> file_list;
    public int avail;
    public int port;
    public String host;
    public String reason;
    public chan_descriptions chan_descr;

    public daq_xml_reply() {
        daq_xml_request daq_xml_request2 = new daq_xml_request();
        this.t_start_sec = -1;
        this.t_stop_sec = -1;
        this.files = 0;
        this.fids = 0;
        this.events = 0;
        this.data_loc = 0;
        this.file_list = null;
        this.nf_chan_list = null;
        this.nf_file_list = null;
        this.avail = -1;
        this.port = 0;
        this.host = null;
        this.reason = null;
        this.chan_descr = null;
    }

    public int add_channel(String string) {
        if (this.nf_chan_list == null) {
            this.nf_chan_list = new Vector();
        }
        this.nf_chan_list.add(string);
        return this.nf_chan_list.size();
    }

    public int add_file(String string) {
        if (this.nf_file_list == null) {
            this.nf_file_list = new Vector();
        }
        this.nf_file_list.add(string);
        return this.nf_file_list.size();
    }

    public int add_found_file(String string) {
        if (this.file_list == null) {
            this.file_list = new Vector();
        }
        this.file_list.add(string);
        return this.file_list.size();
    }

    public String get_xml_reply() {
        int n;
        String string = new String();
        StringBuffer stringBuffer = new StringBuffer(daq_reply_tags[0] + "\n");
        stringBuffer.append(this.request.get_xml_request());
        if (this.port != 0 && this.host != null) {
            stringBuffer.append(daq_reply_tags[1] + this.port + " " + "' host='" + this.host + "'/>" + "\n");
        }
        if (this.reason != null) {
            stringBuffer.append(daq_reply_tags[2] + this.reason + "'/>" + "\n");
        }
        stringBuffer.append(daq_reply_tags[3] + "\n");
        if (this.t_start_sec > 0) {
            stringBuffer.append(daq_reply_tags[4] + this.t_start_sec + "'/>" + "\n");
        }
        if (this.t_stop_sec > 0) {
            stringBuffer.append(daq_reply_tags[5] + this.t_stop_sec + "'/>" + "\n");
        }
        if (this.files != 0) {
            stringBuffer.append(daq_reply_tags[6] + this.files + "'/>" + "\n");
        }
        if (this.fids != 0) {
            stringBuffer.append(daq_reply_tags[7] + this.fids + "'/>" + "\n");
        }
        if (this.events != 0) {
            stringBuffer.append(daq_reply_tags[8] + this.events + "'/>" + "\n");
        }
        if (this.data_loc != 0) {
            stringBuffer.append(daq_reply_tags[9] + this.data_loc + "'/>" + "\n");
        }
        if (this.file_list != null) {
            for (n = 0; n < this.file_list.size(); ++n) {
                stringBuffer.append(daq_reply_tags[10] + this.file_list.elementAt(n) + "'/>" + "\n");
            }
        }
        if (this.nf_chan_list != null) {
            for (n = 0; n < this.nf_chan_list.size(); ++n) {
                stringBuffer.append(daq_reply_tags[11] + this.nf_chan_list.elementAt(n) + "'/>" + "\n");
            }
        }
        if (this.nf_file_list != null) {
            for (n = 0; n < this.nf_file_list.size(); ++n) {
                stringBuffer.append(daq_reply_tags[12] + this.nf_file_list.elementAt(n) + "'/>" + "\n");
            }
        }
        if (this.avail != -1) {
            stringBuffer.append(daq_reply_tags[13] + this.avail + "'/>" + "\n");
        }
        stringBuffer.append(daq_reply_tags[14] + "\n");
        stringBuffer.append(daq_reply_tags[15] + "\n");
        return stringBuffer.toString();
    }

    public String print_time_stamp(long l) {
        Date date = new Date();
        date.setTime(l * 1000L);
        String string = "yyyy-MM-dd";
        String string2 = "HH:mm:ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string2);
        return new String(simpleDateFormat.format(date) + "T" + simpleDateFormat2.format(date));
    }

    public void startDocument() throws SAXException {
        daq_xml_request daq_xml_request2 = new daq_xml_request();
        this.files = 0;
        this.fids = 0;
        this.events = 0;
        this.data_loc = 0;
        this.nf_chan_list = null;
        this.nf_file_list = null;
        this.avail = -1;
        this.port = 0;
        this.host = null;
        this.reason = null;
    }

    public void endDocument() throws SAXException {
        this.rootf = false;
    }

    public int get_time_in_sec(String string) {
        if (string != null) {
            String string2 = "yyyy-MM-dd_HH:mm:ss";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            String[] stringArray = string.split("T");
            String string3 = new String(stringArray[0] + "_" + stringArray[1]);
            try {
                Date date = simpleDateFormat.parse(string3);
                if (date != null) {
                    return (int)(date.getTime() / 1000L);
                }
                return -1;
            }
            catch (ParseException parseException) {
                System.out.println("Exception: " + parseException.toString());
            }
        }
        return -1;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase(daq_reply_tags_s[0])) {
            this.rootf = true;
            return;
        }
        if (string3.equalsIgnoreCase(daq_reply_tags_s[0])) {
            this.rootf = true;
            return;
        }
        if (this.rootf) {
            if (string3.equalsIgnoreCase(daq_reply_tags_s[3])) {
                this.statf = true;
                return;
            }
            if (string3.equalsIgnoreCase(daq_reply_tags_s[1])) {
                if (attributes.getValue("rep") != null) {
                    int n = this.get_int(attributes.getValue("rep"));
                    if (this.conv_error == 0) {
                        this.port = n;
                    }
                }
                this.host = attributes.getValue("host");
            } else if (string3.equalsIgnoreCase(daq_reply_tags_s[2])) {
                this.reason = attributes.getValue(daq_reply_attrs[2]);
            } else if (this.statf) {
                String string4;
                if (string3.equalsIgnoreCase(daq_reply_tags_s[5])) {
                    int n = this.get_int(attributes.getValue(daq_reply_attrs[5]));
                    if (this.conv_error == 0) {
                        this.t_stop_sec = n;
                    }
                } else if (string3.equalsIgnoreCase(daq_reply_tags_s[4])) {
                    int n = this.get_int(attributes.getValue(daq_reply_attrs[4]));
                    if (this.conv_error == 0) {
                        this.t_start_sec = n;
                    }
                } else if (string3.equalsIgnoreCase(daq_reply_tags_s[6])) {
                    int n = this.get_int(attributes.getValue(daq_reply_attrs[6]));
                    if (this.conv_error == 0) {
                        this.files = n;
                    }
                } else if (string3.equalsIgnoreCase(daq_reply_tags_s[7])) {
                    int n = this.get_int(attributes.getValue(daq_reply_attrs[7]));
                    if (this.conv_error == 0) {
                        this.fids = n;
                    }
                } else if (string3.equalsIgnoreCase(daq_reply_tags_s[8])) {
                    int n = this.get_int(attributes.getValue(daq_reply_attrs[8]));
                    if (this.conv_error == 0) {
                        this.events = n;
                    }
                } else if (string3.equalsIgnoreCase(daq_reply_tags_s[9])) {
                    int n = this.get_int(attributes.getValue(daq_reply_attrs[9]));
                    if (this.conv_error == 0) {
                        this.data_loc = n;
                    }
                } else if (string3.equalsIgnoreCase(daq_reply_tags_s[13])) {
                    int n = this.get_int(attributes.getValue(daq_reply_attrs[13]));
                    if (this.conv_error == 0) {
                        this.avail = n;
                    }
                } else if (string3.equalsIgnoreCase(daq_reply_tags_s[11])) {
                    String string5 = attributes.getValue(daq_reply_attrs[11]);
                    if (string5 != null) {
                        this.add_channel(string5);
                    }
                } else if (string3.equalsIgnoreCase(daq_reply_tags_s[12])) {
                    String string6 = attributes.getValue(daq_reply_attrs[12]);
                    if (string6 != null) {
                        this.add_file(string6);
                    }
                } else if (string3.equalsIgnoreCase(daq_reply_tags_s[10]) && (string4 = attributes.getValue(daq_reply_attrs[10])) != null) {
                    this.add_found_file(string4);
                }
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) {
    }

    public int get_int(String string) {
        if (string == null) {
            this.conv_error = -1;
            return -1;
        }
        this.conv_error = 0;
        if (string.endsWith("\n")) {
            string = string.substring(0, string.indexOf("\n"));
        } else if (string.startsWith("\n")) {
            string = string.substring(string.indexOf("\n"));
        }
        try {
            Integer n = new Integer(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            this.conv_error = -1;
            return -1;
        }
    }

    public float get_float(String string) {
        this.conv_error = 0;
        try {
            Float f = new Float(string);
            return f.floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            this.conv_error = -1;
            return -1.0f;
        }
    }

    public int parse_xml_reply(String string) {
        Object object;
        Object object2;
        CharSequence charSequence;
        Object object3;
        Object object4;
        String string2 = null;
        this.error = 0;
        if (string.indexOf("<") == -1) {
            System.out.println("parse_xml_request() Reading file: " + string);
            object4 = new File(string);
            if (((File)object4).exists() && ((File)object4).canRead()) {
                object3 = null;
                try {
                    object3 = new BufferedReader(new FileReader((File)object4));
                    charSequence = new StringBuffer();
                    object2 = new char[512];
                    try {
                        int n = 0;
                        while ((n = ((Reader)object3).read((char[])object2)) > -1) {
                            ((StringBuffer)charSequence).append((char[])object2, 0, n);
                        }
                    }
                    catch (IOException iOException) {
                        return -4;
                    }
                    string2 = new String(((StringBuffer)charSequence).toString());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return -5;
                }
                if (object3 != null) {
                    try {
                        ((BufferedReader)object3).close();
                    }
                    catch (IOException iOException) {
                        return -6;
                    }
                }
            }
        } else {
            string2 = new String(string);
        }
        if ((object4 = string2.substring(string2.indexOf(daq_request_tags[0]), string2.indexOf(daq_request_tags[15]) + daq_request_tags[15].length())) != null && ((String)object4).length() > 0) {
            this.request = new daq_xml_request();
            this.error = this.request.parse_xml_request((String)object4);
            if (this.error != 0) {
                System.out.println("Failed to parse request:");
                System.out.println((String)object4);
                return this.error;
            }
            string2 = string2.replaceFirst((String)object4, "");
        }
        object3 = new String("<" + TTF2_CHAN_DESCR_TAGS[0] + ">");
        charSequence = new String("</" + TTF2_CHAN_DESCR_TAGS[0] + ">");
        if (string2.indexOf((String)object3) != -1 && (object2 = (Object)string2.substring(string2.indexOf((String)object3), string2.indexOf((String)charSequence) + ((String)charSequence).length())) != null && ((String)object2).length() > 0) {
            this.chan_descr = new chan_descriptions((String)object2);
            this.error = this.chan_descr.parse_chan_descr();
            if (this.error != 0) {
                System.out.println("Failed to parse chan_descriptions:");
                System.out.println((String)object2);
                return this.error;
            }
            string2 = string2.replaceFirst((String)object2, "");
        }
        try {
            object = SAXParserFactory.newInstance();
            object2 = ((SAXParserFactory)object).newSAXParser();
        }
        catch (Exception exception) {
            System.err.println("error: Unable to instantiate parser ");
            this.error = -1;
            return this.error;
        }
        object = string2.lastIndexOf(0) != -1 ? string2.substring(0, string2.lastIndexOf(0)) : string2;
        StringReader stringReader = new StringReader((String)object);
        try {
            ((SAXParser)object2).parse(new InputSource(stringReader), (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            this.error = -1;
        }
        catch (IOException iOException) {
            this.error = -2;
        }
        return this.error;
    }

    public boolean copy(daq_xml_reply daq_xml_reply2) {
        if (this.request == null) {
            this.request = new daq_xml_request();
        }
        if (this.request.copy(daq_xml_reply2.request)) {
            return true;
        }
        this.t_start_sec = daq_xml_reply2.t_start_sec;
        this.t_stop_sec = daq_xml_reply2.t_stop_sec;
        this.files = daq_xml_reply2.files;
        this.fids = daq_xml_reply2.fids;
        this.events = daq_xml_reply2.events;
        this.data_loc = daq_xml_reply2.data_loc;
        this.nf_chan_list = daq_xml_reply2.nf_chan_list;
        this.nf_file_list = daq_xml_reply2.nf_file_list;
        this.file_list = daq_xml_reply2.file_list;
        this.avail = daq_xml_reply2.avail;
        this.port = daq_xml_reply2.port;
        this.host = daq_xml_reply2.host;
        this.reason = daq_xml_reply2.reason;
        this.chan_descr = daq_xml_reply2.chan_descr;
        return false;
    }

    public void print() {
        int n;
        System.out.println("DAQ XML REPLY");
        if (this.request != null) {
            this.request.print_xml_request();
        }
        if (this.port != 0 && this.host != null) {
            System.out.println("Port: " + this.port + " Host:" + this.host);
        }
        if (this.reason != null) {
            System.out.println("Comment: " + this.reason);
        }
        System.out.println("Statistics");
        if (this.t_start_sec > 0) {
            System.out.println("TStart: " + this.t_start_sec);
        }
        if (this.t_stop_sec > 0) {
            System.out.println("TStop: " + this.t_stop_sec);
        }
        if (this.files > 0) {
            System.out.println("Files: " + this.files);
        }
        if (this.fids > 0) {
            System.out.println("FIds: " + this.fids);
        }
        if (this.events > 0) {
            System.out.println("Files: " + this.events);
        }
        if (this.data_loc > 0) {
            System.out.println("Files: " + this.data_loc);
        }
        if (this.avail > 0) {
            System.out.println("Free Connections: " + this.avail);
        }
        if (this.file_list != null && this.file_list.size() != 0) {
            System.out.println("Files found");
            for (n = 0; n < this.file_list.size(); ++n) {
                if (this.file_list.elementAt(n) == null) continue;
                System.out.println("[" + n + "] " + this.file_list.elementAt(n));
            }
        }
        if (this.nf_chan_list != null && this.nf_chan_list.size() != 0) {
            System.out.println("Channels not found");
            for (n = 0; n < this.nf_chan_list.size(); ++n) {
                if (this.nf_chan_list.elementAt(n) == null) continue;
                System.out.println("[" + n + "] " + this.nf_chan_list.elementAt(n));
            }
        }
        if (this.nf_file_list != null && this.nf_file_list.size() != 0) {
            System.out.println("Files not found");
            for (n = 0; n < this.nf_file_list.size(); ++n) {
                if (this.nf_file_list.elementAt(n) == null) continue;
                System.out.println("[" + n + "] " + this.nf_file_list.elementAt(n));
            }
        }
        if (this.chan_descr != null) {
            this.chan_descr.print(-1);
        }
    }
}

