/*
 * Decompiled with CFR 0.152.
 */
package daq;

import daq.EventHeader;
import daq.RNG_RingBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;

public class DataLink {
    int retrs = 100;
    boolean no_delay = true;
    boolean owncntr = true;
    int eventn = 0;
    ServerSocket sock = null;
    Socket sockin = null;
    InputStream input = null;
    InetAddress receiver = null;
    InetAddress sender = null;
    int len = 0;
    int connected = 0;
    int setup = 0;
    int must_swap = 0;
    int receive_lock = 0;
    byte[] buffer = null;
    int size = 0;
    int lport = 0;
    EventHeader evhd;
    public static final int SUCCESS = 0;
    public static final int BAD_SOCKET = 1;
    public static final int UNKNOWN_HOST = 2;
    public static final int BAD_CONNECT = 3;
    public static final int BAD_CLOSE = 4;
    public static final int ALREADY_CONNECTED = 5;
    public static final int NOT_CONNECTED = 6;
    public static final int BAD_BIND = 7;
    public static final int BAD_LISTEN = 8;
    public static final int BAD_ACCEPT = 9;
    public static final int BAD_ALLOC = 10;
    public static final int CHECK_FAIL = 11;
    public static final int RECV_FAIL = 12;
    public static final int BAD_SEND = 13;
    public static final int ALREADY_SETUP = 14;
    public static final int NOT_SETUP = 15;
    public static final int BAD_RECV = 16;
    public static final int SENDER_IS_GONE = 17;
    public static final int PREAMBLE_FAIL = 18;
    public static final int SOMETHING_STRANGE = 19;
    public static final int RING_BUFFER_FULL = 20;
    public static final int RECEIVE_LOCK_SET = 21;
    public static final int RECEIVE_NO_DATA = 22;
    public static final int SEND_TIME_OUT = 23;
    public static final int NO_RCV_BUFFER = 24;
    public static final int NO_SPACE_IN_RB = 25;
    public static final int BAD_SEL_RCV = 26;
    public static final int BAD_SEL_SND = 27;
    public static final int TEMP_UNAVAIL = 28;
    public static final int BAD_SWAP = 29;
    public static final int RCV_NO_RESOURCE = 30;
    public static final int RECEIVER_RETR_NUM_DEF = 100;
    public static final int SENDER_RETR_NUM_DEF = 10;
    public static final int TTF2_DATA_LINK_PREABLME = 168496141;
    public static final int TTF2_DATA_LINK_PREABLME_SWAPPED = 218893066;
    public static final boolean RECEIVER_READ = false;
    public static final boolean RECEIVER_WRITE = true;
    public static final int NO_DATA_TRY = 200000;
    public static final int TTF2_DAQ_DLINK_PAUSE = -1;
    public static final int TTF2_DAQ_DLINK_STOP = -2;

    public static byte[] intToByteArray(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int n2 = (byArray.length - 1 - i) * 8;
            byArray[i] = (byte)(n >>> n2 & 0xFF);
        }
        return byArray;
    }

    public static int swap4(int n) {
        return n << 24 | n << 8 & 0xFF0000 | n >> 8 & 0xFF00 | n >> 24 & 0xFF;
    }

    public static void swap_bytes(byte[] byArray, int n) {
        byte[] byArray2 = new byte[2];
        if (byArray == null) {
            return;
        }
        int n2 = n;
        if (n2 == 0) {
            n2 = byArray.length;
        }
        int n3 = 0;
        while (n3 + 3 < n2) {
            byArray2[0] = byArray[n3];
            byArray2[1] = byArray[n3 + 1];
            byArray[n3] = byArray[n3 + 3];
            byArray[n3 + 1] = byArray[n3 + 2];
            byArray[n3 + 2] = byArray2[1];
            byArray[n3 + 3] = byArray2[0];
            n3 += 4;
        }
    }

    public int SocketSetup(int n) {
        if (this.setup != 0) {
            System.out.println("SocketSetup(): socket already setup.");
            return 14;
        }
        try {
            this.sock = new ServerSocket(n);
        }
        catch (IOException iOException) {
            System.out.println("SocketSetup(): bind failed " + iOException.getMessage());
            return 7;
        }
        this.lport = n;
        this.setup = 1;
        return 0;
    }

    public int SocketRelease() {
        if (this.setup == 0) {
            System.out.println("SocketRelease(): socket not setup. No ation taken.");
            return 15;
        }
        if (this.connected != 0) {
            this.Disconnect();
        }
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                System.out.println("SocketRelease(): close " + iOException.getMessage());
            }
            this.sock = null;
        }
        this.setup = 0;
        this.lport = 0;
        return 0;
    }

    public int Connect(String string, int n) {
        int n2;
        if (this.setup != 0) {
            System.out.println("SocketSetup(): socket already setup.");
            return 14;
        }
        if (this.connected != 0) {
            System.out.println("Connect(): Unable to connect.  Already connected.");
            return 5;
        }
        try {
            this.sockin = new Socket(string, n);
            this.input = this.sockin.getInputStream();
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Connect(h,p)" + unknownHostException.getMessage());
            return 2;
        }
        catch (IOException iOException) {
            System.out.println("Connect(h,p)" + iOException.getMessage());
            return 3;
        }
        this.connected = 1;
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; i += n2) {
            try {
                n2 = this.input.read(byArray, i, 4 - i);
                if (n2 >= 0) continue;
                System.out.println("Connect(h,p): failed to receive preamble");
                return 18;
            }
            catch (IOException iOException) {
                System.out.println("Connect(h,p): failed to receive preamble" + iOException.getMessage());
                return 16;
            }
        }
        int n3 = EventHeader.BytesToInt(byArray, 0);
        if (n3 == 168496141) {
            this.must_swap = 0;
        } else if (n3 == 218893066) {
            this.must_swap = 1;
        } else {
            System.out.println("Connect(h,p): Unrecognized byte pattern in preamble." + n3 + "(" + 168496141 + ", " + 218893066 + ")");
            return 19;
        }
        this.setup = 1;
        return 0;
    }

    public int Connect() {
        if (this.setup == 0) {
            System.out.println("Connect(): socket not setup.  No action taken.");
            return 15;
        }
        if (this.connected != 0) {
            System.out.println("Conenct(): Alrady accepted a connection. No action taken.");
            return 5;
        }
        try {
            this.sockin = this.sock.accept();
            this.input = this.sockin.getInputStream();
        }
        catch (IOException iOException) {
            System.out.println("Connect():  " + iOException.getMessage());
            return 9;
        }
        catch (SecurityException securityException) {
            System.out.println("Connect():  Security " + securityException.getMessage());
            return 9;
        }
        this.sender = this.sockin.getInetAddress();
        this.connected = 1;
        try {
            this.sockin.getOutputStream().write(DataLink.intToByteArray(168496141));
        }
        catch (IOException iOException) {
            System.out.println("Connect():  write " + iOException.getMessage());
            return 18;
        }
        if (this.no_delay) {
            try {
                this.sockin.setTcpNoDelay(this.no_delay);
            }
            catch (SocketException socketException) {
                System.out.println("DataLink::Connect(): failed to set NONBLOKCING mode " + socketException.getMessage());
                this.no_delay = false;
            }
        }
        if (!this.no_delay) {
            System.out.println("DataLink::Connect() BLOCKING mode will be used");
        } else {
            System.out.println("DataLink::Connect() NON BLOCKING mode will be used");
        }
        return 0;
    }

    public int Disconnect() {
        if (this.setup == 0) {
            System.out.println("Disconnect(): Not setup.  No action taken.");
            return 15;
        }
        if (this.connected == 0) {
            System.out.println("Disconnect(): There is no connection.  No action taken.");
            return 6;
        }
        if (this.sockin != null) {
            this.input = null;
            try {
                this.sockin.shutdownInput();
            }
            catch (IOException iOException) {
                System.out.println("Disconnect(): failed to shutdownInput " + iOException.getMessage());
            }
            try {
                this.sockin.shutdownOutput();
            }
            catch (IOException iOException) {
                System.out.println("Disconnect(): failed to shutdownOutput " + iOException.getMessage());
            }
            try {
                this.sockin.close();
            }
            catch (IOException iOException) {
                System.out.println("Disconnect(): failed to close socket " + iOException.getMessage());
            }
        } else {
            System.out.println("Disconnect(): sockin was not set .");
        }
        this.sockin = null;
        this.connected = 0;
        return 0;
    }

    public int ReceiveEvent(RNG_RingBuffer rNG_RingBuffer, int n) {
        int n2;
        int n3;
        int n4;
        if (this.connected == 0) {
            System.out.println("ReceiveEvent(): Not connected.  No action taken.");
            return 6;
        }
        if (this.receive_lock != 0) {
            System.out.println("ReceiveEvent(): Receive lock set.  Waiting for space in Ring Buffer.");
            return 21;
        }
        int n5 = 0;
        byte[] byArray = new byte[4];
        boolean bl = false;
        byArray[0] = 0;
        byArray[1] = 0;
        byArray[2] = 0;
        byArray[3] = 0;
        int n6 = 1000;
        if (n >= 0) {
            n6 = 1;
        }
        int n7 = 0;
        while (n5 < n6 && bl) {
            n7 = this.IfReady(false, n);
            if (n7 == 0) {
                for (n4 = 0; n4 < 4; ++n4) {
                    try {
                        n3 = this.input.read(byArray, n4, 1);
                        if (n3 < 0) {
                            System.out.println("ReceiveEvent() magic: read failed");
                            return 16;
                        }
                    }
                    catch (IOException iOException) {
                        System.out.println("ReceiveEvent() magic: read failed" + iOException.getMessage());
                        return 16;
                    }
                    if (n4 != 3) continue;
                    bl = true;
                }
                continue;
            }
            if (n7 == 22) {
                ++n5;
                continue;
            }
            System.out.println("Returning from IfReady()");
            return 16;
        }
        if (n5 >= n6) {
            return n7;
        }
        int n8 = 0;
        int n9 = this.must_swap != 0 ? DataLink.swap4(EventHeader.BytesToInt(byArray, 0)) : EventHeader.BytesToInt(byArray, 0);
        while (-1114130 != n9 && n8++ <= 200000) {
            for (n4 = 0; n4 < 3; ++n4) {
                byArray[n4] = byArray[n4 + 1];
            }
            try {
                n3 = this.input.read(byArray, 3, 1);
                if (n3 < 0) {
                    System.out.println("ReceiveEvent(while): read failed");
                    return 16;
                }
            }
            catch (IOException iOException) {
                System.out.println("ReceiveEvent(while): read failed " + iOException.getMessage());
                return 16;
            }
            if (this.must_swap != 0) {
                n9 = DataLink.swap4(EventHeader.BytesToInt(byArray, 0));
                continue;
            }
            n9 = EventHeader.BytesToInt(byArray, 0);
        }
        if (n8 > 200000) {
            return 22;
        }
        this.evhd = new EventHeader();
        n3 = 0;
        n4 = 0;
        int n10 = 4;
        n5 = 0;
        byte[] byArray2 = Arrays.copyOf(byArray, this.evhd.my_size);
        int n11 = 0;
        while (n10 < this.evhd.my_size && n5 < 1000) {
            n11 = this.IfReady(false, 0);
            if (n11 == 0) {
                try {
                    n3 = this.input.read(byArray2, n10, this.evhd.my_size - n10);
                    if (n3 < 0) {
                        System.out.println("ReceiveEvent(head): read failed");
                        return 16;
                    }
                    n10 += n3;
                    if (n3 == 0) {
                        ++n5;
                        continue;
                    }
                    n5 = 0;
                    continue;
                }
                catch (IOException iOException) {
                    System.out.println("ReceiveEvent(head): read failed " + iOException.getMessage());
                    return 16;
                }
            }
            ++n5;
        }
        if (n5 >= 1000) {
            System.out.println("ReceiveEvent(): EVENT header No data? " + n11);
            return n11;
        }
        n4 += n10;
        n10 = 0;
        if (this.must_swap != 0) {
            DataLink.swap_bytes(byArray2, byArray2.length);
        }
        if (this.evhd.fill(byArray2)) {
            return 19;
        }
        if (rNG_RingBuffer != null) {
            n2 = 0;
            if (rNG_RingBuffer.size() - rNG_RingBuffer.bytesUsed() < this.evhd.event_length) {
                n2 = 1;
            }
            try {
                this.sockin.getOutputStream().write(DataLink.intToByteArray(n2));
            }
            catch (IOException iOException) {
                System.out.println("ReceiveEvent(): Failed to send ack" + iOException.getMessage());
                return 13;
            }
            if (n2 != 0) {
                return 25;
            }
        }
        if (this.owncntr) {
            this.evhd.event_number = ++this.eventn;
        }
        if (this.buffer != null) {
            this.buffer = null;
            this.size = 0;
        }
        this.buffer = Arrays.copyOf(byArray2, this.evhd.event_length);
        this.size = this.evhd.event_length;
        if (this.buffer == null) {
            System.out.println("ReceiveEvent(): unable to allocate buffer");
            return 10;
        }
        n2 = this.evhd.my_size;
        int n12 = this.size - this.evhd.my_size;
        n5 = 0;
        while (n10 < n12) {
            n11 = this.IfReady(false, 0);
            if (n11 == 0) {
                try {
                    n3 = this.input.read(this.buffer, n10 + this.evhd.my_size, n12 - n10);
                    if (n3 < 0) {
                        System.out.println("ReceiveEvent(data): read failed");
                        return 16;
                    }
                    n10 += n3;
                    if (n3 == 0) {
                        ++n5;
                        continue;
                    }
                    n5 = 0;
                    continue;
                }
                catch (IOException iOException) {
                    System.out.println("ReceiveEvent(head): read failed " + iOException.getMessage());
                    return 16;
                }
            }
            ++n5;
        }
        if (n5 >= 1000) {
            System.out.println("ReceiveEvent() 2: NO Data EVENT ?: " + n11);
            return n11;
        }
        if ((n4 += n10) != this.size) {
            System.out.println("ReceiveEvent() Size received does not match size reported.");
            return 12;
        }
        n3 = this.SwapBuffer();
        if (n3 != 0) {
            System.out.println("ReceiveEvent() BAD SWAP");
        }
        return n3;
    }

    public int SendEvent(byte[] byArray, int n, int n2) {
        if (byArray == null || byArray.length == 0 || n == 0) {
            return 19;
        }
        System.out.println("SendEvent() Not implemented !!!!");
        return 0;
    }

    public int SetRetry(int n) {
        if (n <= 0) {
            return 19;
        }
        this.retrs = n;
        System.out.println("DataLink() SetRetry() retrs:" + this.retrs);
        return 0;
    }

    public int SendRequest(byte[] byArray, int n) {
        if (byArray == null || byArray.length == 0 || n == 0) {
            return 19;
        }
        if (this.connected == 0) {
            System.out.println("SendRequest(): Not connected.  No action taken.");
            return 6;
        }
        if (this.receive_lock != 0) {
            System.out.println("SendRequest(): Receive lock set.  Waiting for space in Ring Buffer.");
            return 21;
        }
        try {
            this.sockin.getOutputStream().write(byArray, 0, n);
        }
        catch (IOException iOException) {
            return 13;
        }
        return 0;
    }

    public int IfReady(boolean bl, int n) {
        int n2 = this.retrs;
        if (n > 0) {
            n2 = n;
        }
        block6: while (n2-- > 0) {
            int n3 = -1;
            try {
                n3 = this.input.available();
            }
            catch (IOException iOException) {
                String string = iOException.getMessage();
            }
            switch (n3) {
                case 0: {
                    if (--n2 > 0) continue block6;
                    return 22;
                }
                case -1: {
                    System.out.println("IfReady(): ERROR ");
                    if (bl) {
                        return 13;
                    }
                    return 16;
                }
            }
            return 0;
        }
        if (bl) {
            return 27;
        }
        return 26;
    }

    public int WriteBlockToRingBuffer(RNG_RingBuffer rNG_RingBuffer) {
        int n = 0;
        return n;
    }

    public boolean IsLinkActive() {
        return this.connected != 0;
    }

    public void set_own_cnt(boolean bl) {
        this.owncntr = bl;
    }

    public int get_event_type() {
        if (this.evhd.is_valid()) {
            return this.evhd.event_type;
        }
        return -1;
    }

    public int get_event_length() {
        if (this.evhd.is_valid()) {
            return this.evhd.event_length;
        }
        return 0;
    }

    public int get_event_number() {
        if (this.evhd.is_valid()) {
            return this.evhd.event_number;
        }
        return 0;
    }

    public EventHeader get_event_header() {
        return this.evhd;
    }

    public void SetNoDelay() {
        this.no_delay = true;
    }

    public void SetDelay() {
        this.no_delay = false;
    }

    public int GetLPort() {
        return this.lport;
    }

    boolean get_swap() {
        return false;
    }

    private int SwapBuffer() {
        int n = 0;
        return n;
    }
}

